CREATE DATABASE IF NOT EXISTS `zilllzus_wp579`;

USE `zilllzus_wp579`;

DROP TABLE IF EXISTS `wp33_commentmeta`;

CREATE TABLE `wp33_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;




DROP TABLE IF EXISTS `wp33_comments`;

CREATE TABLE `wp33_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `wp33_comments` VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2025-03-14 10:23:59","2025-03-14 10:23:59","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");



DROP TABLE IF EXISTS `wp33_links`;

CREATE TABLE `wp33_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;




DROP TABLE IF EXISTS `wp33_options`;

CREATE TABLE `wp33_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `wp33_options` VALUES("1","cron","a:6:{i:1741947839;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1741947893;a:4:{s:18:\"extendify_insights\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1741947894;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1742034239;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1742034293;a:1:{s:20:\"extendify_cache_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"every_month\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}","on");
INSERT INTO `wp33_options` VALUES("127","extendify_site_id","3c5c22a6-ce87-4a40-9065-44eddf84a57d","auto");
INSERT INTO `wp33_options` VALUES("128","extendify_insights_checkedin_once","2025-03-14 10:24:53","auto");
INSERT INTO `wp33_options` VALUES("2","siteurl","https://afridevcapital.com","on");
INSERT INTO `wp33_options` VALUES("3","home","https://afridevcapital.com","on");
INSERT INTO `wp33_options` VALUES("4","blogname","My Blog","on");
INSERT INTO `wp33_options` VALUES("5","blogdescription","My WordPress Blog","on");
INSERT INTO `wp33_options` VALUES("6","users_can_register","0","on");
INSERT INTO `wp33_options` VALUES("7","admin_email","admin@afridevcapital.com","on");
INSERT INTO `wp33_options` VALUES("8","start_of_week","1","on");
INSERT INTO `wp33_options` VALUES("9","use_balanceTags","0","on");
INSERT INTO `wp33_options` VALUES("10","use_smilies","1","on");
INSERT INTO `wp33_options` VALUES("11","require_name_email","1","on");
INSERT INTO `wp33_options` VALUES("12","comments_notify","1","on");
INSERT INTO `wp33_options` VALUES("13","posts_per_rss","10","on");
INSERT INTO `wp33_options` VALUES("14","rss_use_excerpt","0","on");
INSERT INTO `wp33_options` VALUES("15","mailserver_url","mail.example.com","on");
INSERT INTO `wp33_options` VALUES("16","mailserver_login","login@example.com","on");
INSERT INTO `wp33_options` VALUES("17","mailserver_pass","","on");
INSERT INTO `wp33_options` VALUES("18","mailserver_port","110","on");
INSERT INTO `wp33_options` VALUES("19","default_category","1","on");
INSERT INTO `wp33_options` VALUES("20","default_comment_status","open","on");
INSERT INTO `wp33_options` VALUES("21","default_ping_status","open","on");
INSERT INTO `wp33_options` VALUES("22","default_pingback_flag","1","on");
INSERT INTO `wp33_options` VALUES("23","posts_per_page","10","on");
INSERT INTO `wp33_options` VALUES("24","date_format","F j, Y","on");
INSERT INTO `wp33_options` VALUES("25","time_format","g:i a","on");
INSERT INTO `wp33_options` VALUES("26","links_updated_date_format","F j, Y g:i a","on");
INSERT INTO `wp33_options` VALUES("27","comment_moderation","0","on");
INSERT INTO `wp33_options` VALUES("28","moderation_notify","1","on");
INSERT INTO `wp33_options` VALUES("29","permalink_structure","","on");
INSERT INTO `wp33_options` VALUES("30","rewrite_rules","","on");
INSERT INTO `wp33_options` VALUES("31","hack_file","0","on");
INSERT INTO `wp33_options` VALUES("32","blog_charset","UTF-8","on");
INSERT INTO `wp33_options` VALUES("33","moderation_keys","","off");
INSERT INTO `wp33_options` VALUES("34","active_plugins","a:5:{i:0;s:23:\"extendify/extendify.php\";i:1;s:9:\"loginizer\";i:2;s:18:\"loginizer-security\";i:3;s:28:\"migrate-guru/migrateguru.php\";i:4;s:35:\"nc-extendify-lc/nc-extendify-lc.php\";}","on");
INSERT INTO `wp33_options` VALUES("35","category_base","","on");
INSERT INTO `wp33_options` VALUES("36","ping_sites","http://rpc.pingomatic.com/","on");
INSERT INTO `wp33_options` VALUES("37","comment_max_links","2","on");
INSERT INTO `wp33_options` VALUES("38","gmt_offset","0","on");
INSERT INTO `wp33_options` VALUES("39","default_email_category","1","on");
INSERT INTO `wp33_options` VALUES("40","recently_edited","","off");
INSERT INTO `wp33_options` VALUES("41","template","extendable","on");
INSERT INTO `wp33_options` VALUES("42","stylesheet","extendable","on");
INSERT INTO `wp33_options` VALUES("43","comment_registration","0","on");
INSERT INTO `wp33_options` VALUES("44","html_type","text/html","on");
INSERT INTO `wp33_options` VALUES("45","use_trackback","0","on");
INSERT INTO `wp33_options` VALUES("46","default_role","subscriber","on");
INSERT INTO `wp33_options` VALUES("47","db_version","58975","on");
INSERT INTO `wp33_options` VALUES("48","uploads_use_yearmonth_folders","1","on");
INSERT INTO `wp33_options` VALUES("49","upload_path","","on");
INSERT INTO `wp33_options` VALUES("50","blog_public","1","on");
INSERT INTO `wp33_options` VALUES("51","default_link_category","2","on");
INSERT INTO `wp33_options` VALUES("52","show_on_front","posts","on");
INSERT INTO `wp33_options` VALUES("53","tag_base","","on");
INSERT INTO `wp33_options` VALUES("54","show_avatars","1","on");
INSERT INTO `wp33_options` VALUES("55","avatar_rating","G","on");
INSERT INTO `wp33_options` VALUES("56","upload_url_path","","on");
INSERT INTO `wp33_options` VALUES("57","thumbnail_size_w","150","on");
INSERT INTO `wp33_options` VALUES("58","thumbnail_size_h","150","on");
INSERT INTO `wp33_options` VALUES("59","thumbnail_crop","1","on");
INSERT INTO `wp33_options` VALUES("60","medium_size_w","300","on");
INSERT INTO `wp33_options` VALUES("61","medium_size_h","300","on");
INSERT INTO `wp33_options` VALUES("62","avatar_default","mystery","on");
INSERT INTO `wp33_options` VALUES("63","large_size_w","1024","on");
INSERT INTO `wp33_options` VALUES("64","large_size_h","1024","on");
INSERT INTO `wp33_options` VALUES("65","image_default_link_type","none","on");
INSERT INTO `wp33_options` VALUES("66","image_default_size","","on");
INSERT INTO `wp33_options` VALUES("67","image_default_align","","on");
INSERT INTO `wp33_options` VALUES("68","close_comments_for_old_posts","0","on");
INSERT INTO `wp33_options` VALUES("69","close_comments_days_old","14","on");
INSERT INTO `wp33_options` VALUES("70","thread_comments","1","on");
INSERT INTO `wp33_options` VALUES("71","thread_comments_depth","5","on");
INSERT INTO `wp33_options` VALUES("72","page_comments","0","on");
INSERT INTO `wp33_options` VALUES("73","comments_per_page","50","on");
INSERT INTO `wp33_options` VALUES("74","default_comments_page","newest","on");
INSERT INTO `wp33_options` VALUES("75","comment_order","asc","on");
INSERT INTO `wp33_options` VALUES("76","sticky_posts","a:0:{}","on");
INSERT INTO `wp33_options` VALUES("77","widget_categories","a:0:{}","on");
INSERT INTO `wp33_options` VALUES("78","widget_text","a:0:{}","on");
INSERT INTO `wp33_options` VALUES("79","widget_rss","a:0:{}","on");
INSERT INTO `wp33_options` VALUES("80","uninstall_plugins","a:1:{s:28:\"migrate-guru/migrateguru.php\";a:2:{i:0;s:10:\"MGWPAction\";i:1;s:9:\"uninstall\";}}","off");
INSERT INTO `wp33_options` VALUES("81","timezone_string","","on");
INSERT INTO `wp33_options` VALUES("82","page_for_posts","0","on");
INSERT INTO `wp33_options` VALUES("83","page_on_front","0","on");
INSERT INTO `wp33_options` VALUES("84","default_post_format","0","on");
INSERT INTO `wp33_options` VALUES("85","link_manager_enabled","0","on");
INSERT INTO `wp33_options` VALUES("86","finished_splitting_shared_terms","1","on");
INSERT INTO `wp33_options` VALUES("87","site_icon","0","on");
INSERT INTO `wp33_options` VALUES("88","medium_large_size_w","768","on");
INSERT INTO `wp33_options` VALUES("89","medium_large_size_h","0","on");
INSERT INTO `wp33_options` VALUES("90","wp_page_for_privacy_policy","3","on");
INSERT INTO `wp33_options` VALUES("91","show_comments_cookies_opt_in","1","on");
INSERT INTO `wp33_options` VALUES("92","admin_email_lifespan","1757499839","on");
INSERT INTO `wp33_options` VALUES("93","disallowed_keys","","off");
INSERT INTO `wp33_options` VALUES("94","comment_previously_approved","1","on");
INSERT INTO `wp33_options` VALUES("95","auto_plugin_theme_update_emails","a:0:{}","off");
INSERT INTO `wp33_options` VALUES("96","auto_update_core_dev","enabled","on");
INSERT INTO `wp33_options` VALUES("97","auto_update_core_minor","enabled","on");
INSERT INTO `wp33_options` VALUES("98","auto_update_core_major","enabled","on");
INSERT INTO `wp33_options` VALUES("99","wp_force_deactivated_plugins","a:0:{}","on");
INSERT INTO `wp33_options` VALUES("100","wp_attachment_pages_enabled","0","on");
INSERT INTO `wp33_options` VALUES("101","initial_db_version","58975","on");
INSERT INTO `wp33_options` VALUES("102","wp33_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","on");
INSERT INTO `wp33_options` VALUES("103","fresh_site","1","off");
INSERT INTO `wp33_options` VALUES("104","user_count","1","off");
INSERT INTO `wp33_options` VALUES("105","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("106","sidebars_widgets","a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:13:\"array_version\";i:3;}","auto");
INSERT INTO `wp33_options` VALUES("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto");
INSERT INTO `wp33_options` VALUES("121","recovery_keys","a:0:{}","off");
INSERT INTO `wp33_options` VALUES("122","theme_mods_twentytwentyfive","a:1:{s:18:\"custom_css_post_id\";i:-1;}","auto");
INSERT INTO `wp33_options` VALUES("123","softaculous_pro_license","a:13:{s:7:\"license\";s:30:\"SOFTWP-33058-45177-34523-45930\";s:7:\"expires\";s:8:\"20250323\";s:4:\"type\";s:1:\"1\";s:8:\"type_txt\";s:7:\"Premium\";s:9:\"num_sites\";N;s:4:\"plan\";s:8:\"personal\";s:6:\"active\";i:1;s:10:\"licexpired\";N;s:4:\"thid\";N;s:6:\"status\";i:1;s:9:\"last_edit\";s:10:\"1741947846\";s:10:\"status_txt\";s:33:\"<font color=\"green\">Active</font>\";s:8:\"has_plid\";i:1;}","yes");
INSERT INTO `wp33_options` VALUES("124","extendify_partner_data","a:4:{s:15:\"foregroundColor\";s:7:\"#ffffff\";s:15:\"backgroundColor\";s:7:\"#19208f\";s:4:\"logo\";a:1:{i:0;a:1:{s:10:\"thumbnails\";a:1:{s:5:\"large\";a:1:{s:3:\"url\";s:56:\"https://assets.extendify.com/partner-logos/namecheap.png\";}}}}s:4:\"name\";s:9:\"Namecheap\";}","auto");
INSERT INTO `wp33_options` VALUES("125","_transient_timeout_extendify_partner_data","1744539893","off");
INSERT INTO `wp33_options` VALUES("126","_transient_extendify_partner_data","a:4:{s:15:\"foregroundColor\";s:7:\"#ffffff\";s:15:\"backgroundColor\";s:7:\"#19208f\";s:4:\"logo\";a:1:{i:0;a:1:{s:10:\"thumbnails\";a:1:{s:5:\"large\";a:1:{s:3:\"url\";s:56:\"https://assets.extendify.com/partner-logos/namecheap.png\";}}}}s:4:\"name\";s:9:\"Namecheap\";}","off");
INSERT INTO `wp33_options` VALUES("129","extendify_run_migrations","a:1:{s:6:\"1.14.2\";b:1;}","auto");
INSERT INTO `wp33_options` VALUES("130","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.7.2\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}","on");
INSERT INTO `wp33_options` VALUES("131","_site_transient_timeout_wp_theme_files_patterns-5e33bce5b4311496ea2343bbd577ff78","1741949693","off");
INSERT INTO `wp33_options` VALUES("132","_site_transient_wp_theme_files_patterns-5e33bce5b4311496ea2343bbd577ff78","a:2:{s:7:\"version\";s:6:\"2.0.17\";s:8:\"patterns\";a:19:{s:30:\"footer-call-to-action-dark.php\";a:4:{s:5:\"title\";s:27:\"Dark Footer, Call to Action\";s:4:\"slug\";s:37:\"extendable/footer-call-to-action-dark\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}}s:25:\"footer-call-to-action.php\";a:4:{s:5:\"title\";s:35:\"Footer with logo and two column nav\";s:4:\"slug\";s:35:\"extendable/footer-logo-desc-two-nav\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}}s:18:\"footer-default.php\";a:4:{s:5:\"title\";s:32:\"Footer (Logo, Copyright, Social)\";s:4:\"slug\";s:25:\"extendable/footer-default\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}}s:28:\"footer-logo-desc-two-nav.php\";a:4:{s:5:\"title\";s:22:\"Footer, Call to Action\";s:4:\"slug\";s:32:\"extendable/footer-call-to-action\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}}s:19:\"footer-logo-nav.php\";a:4:{s:5:\"title\";s:32:\"Footer, Logo and Navigation TEST\";s:4:\"slug\";s:26:\"extendable/footer-logo-nav\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}}s:38:\"footer-offset-heading-buttons-dark.php\";a:4:{s:5:\"title\";s:43:\"Dark Footer with offset heading and buttons\";s:4:\"slug\";s:45:\"extendable/footer-offset-heading-buttons-dark\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}}s:41:\"footer-offset-heading-buttons-primary.php\";a:4:{s:5:\"title\";s:38:\"Footer with offset heading and buttons\";s:4:\"slug\";s:48:\"extendable/footer-offset-heading-buttons-primary\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}}s:33:\"footer-offset-heading-buttons.php\";a:4:{s:5:\"title\";s:48:\"Footer with offset heading and buttons (Primary)\";s:4:\"slug\";s:40:\"extendable/footer-offset-heading-buttons\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}}s:15:\"general-cta.php\";a:4:{s:5:\"title\";s:14:\"Call to action\";s:4:\"slug\";s:22:\"extendable/general-cta\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:4:\"text\";}}s:23:\"general-three-boxes.php\";a:4:{s:5:\"title\";s:38:\"Featured Three boxes with text, image.\";s:4:\"slug\";s:30:\"extendable/general-three-boxes\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:7:\"columns\";}}s:18:\"header-default.php\";a:4:{s:5:\"title\";s:37:\"Header (Logo, Site Title, Navigation)\";s:4:\"slug\";s:25:\"extendable/header-default\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"header\";}}s:27:\"header-title-nav-button.php\";a:4:{s:5:\"title\";s:39:\"Header (Site Title, Navigation, Button)\";s:4:\"slug\";s:34:\"extendable/header-title-nav-button\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"header\";}}s:27:\"header-title-social-nav.php\";a:4:{s:5:\"title\";s:39:\"Header (Site Title, Social, Navigation)\";s:4:\"slug\";s:34:\"extendable/header-title-social-nav\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"header\";}}s:14:\"hidden-404.php\";a:4:{s:5:\"title\";s:18:\"404 error content.\";s:4:\"slug\";s:21:\"extendable/hidden-404\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:22:\"hidden-no-products.php\";a:4:{s:5:\"title\";s:11:\"No products\";s:4:\"slug\";s:29:\"extendable/hidden-no-products\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:21:\"hidden-no-results.php\";a:4:{s:5:\"title\";s:10:\"No results\";s:4:\"slug\";s:28:\"extendable/hidden-no-results\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:17:\"hidden-search.php\";a:4:{s:5:\"title\";s:6:\"Search\";s:4:\"slug\";s:24:\"extendable/hidden-search\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:31:\"hidden-woo-related-products.php\";a:4:{s:5:\"title\";s:16:\"Related-Products\";s:4:\"slug\";s:38:\"extendable/hidden-woo-related-products\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:15:\"posts-1-col.php\";a:5:{s:5:\"title\";s:23:\"List of posts, 1 column\";s:4:\"slug\";s:22:\"extendable/posts-1-col\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:5:\"query\";}s:10:\"blockTypes\";a:1:{i:0;s:10:\"core/query\";}}}}","off");
INSERT INTO `wp33_options` VALUES("133","_transient_doing_cron","1741948228.5215411186218261718750","on");
INSERT INTO `wp33_options` VALUES("135","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.7.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.7.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.7.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.7.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.2\";s:7:\"version\";s:5:\"6.7.2\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1741947894;s:15:\"version_checked\";s:5:\"6.7.2\";s:12:\"translations\";a:0:{}}","off");
INSERT INTO `wp33_options` VALUES("140","bvmgredirect","yes","off");
INSERT INTO `wp33_options` VALUES("141","bvActivateTime","1741947905","off");
INSERT INTO `wp33_options` VALUES("137","_site_transient_timeout_theme_roots","1741949695","off");
INSERT INTO `wp33_options` VALUES("138","_site_transient_theme_roots","a:4:{s:10:\"extendable\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}","off");
INSERT INTO `wp33_options` VALUES("139","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1741947895;s:7:\"checked\";a:4:{s:10:\"extendable\";s:6:\"2.0.17\";s:16:\"twentytwentyfive\";s:3:\"1.1\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:4:{s:10:\"extendable\";a:6:{s:5:\"theme\";s:10:\"extendable\";s:11:\"new_version\";s:6:\"2.0.17\";s:3:\"url\";s:40:\"https://wordpress.org/themes/extendable/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/extendable.2.0.17.zip\";s:8:\"requires\";s:3:\"6.3\";s:12:\"requires_php\";s:3:\"7.4\";}s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.1.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}","off");



DROP TABLE IF EXISTS `wp33_postmeta`;

CREATE TABLE `wp33_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `wp33_postmeta` VALUES("1","2","_wp_page_template","default");
INSERT INTO `wp33_postmeta` VALUES("2","3","_wp_page_template","default");



DROP TABLE IF EXISTS `wp33_posts`;

CREATE TABLE `wp33_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `wp33_posts` VALUES("1","1","2025-03-14 10:23:59","2025-03-14 10:23:59","<!-- wp:paragraph -->\n<p>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</p>\n<!-- /wp:paragraph -->","Hello world!","","publish","open","open","","hello-world","","","2025-03-14 10:23:59","2025-03-14 10:23:59","","0","https://afridevcapital.com/?p=1","0","post","","1");
INSERT INTO `wp33_posts` VALUES("2","1","2025-03-14 10:23:59","2025-03-14 10:23:59","<!-- wp:paragraph -->\n<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...or something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>As a new WordPress user, you should go to <a href=\"https://afridevcapital.com/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>\n<!-- /wp:paragraph -->","Sample Page","","publish","closed","open","","sample-page","","","2025-03-14 10:23:59","2025-03-14 10:23:59","","0","https://afridevcapital.com/?page_id=2","0","page","","0");
INSERT INTO `wp33_posts` VALUES("3","1","2025-03-14 10:23:59","2025-03-14 10:23:59","<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Who we are</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Our website address is: https://afridevcapital.com.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Comments</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Media</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Cookies</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Embedded content from other websites</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Who we share your data with</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you request a password reset, your IP address will be included in the reset email.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">How long we retain your data</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">What rights you have over your data</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Where your data is sent</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Visitor comments may be checked through an automated spam detection service.</p>\n<!-- /wp:paragraph -->\n","Privacy Policy","","draft","closed","open","","privacy-policy","","","2025-03-14 10:23:59","2025-03-14 10:23:59","","0","https://afridevcapital.com/?page_id=3","0","page","","0");



DROP TABLE IF EXISTS `wp33_term_relationships`;

CREATE TABLE `wp33_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `wp33_term_relationships` VALUES("1","1","0");



DROP TABLE IF EXISTS `wp33_term_taxonomy`;

CREATE TABLE `wp33_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `wp33_term_taxonomy` VALUES("1","1","category","","0","1");



DROP TABLE IF EXISTS `wp33_termmeta`;

CREATE TABLE `wp33_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;




DROP TABLE IF EXISTS `wp33_terms`;

CREATE TABLE `wp33_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `wp33_terms` VALUES("1","Uncategorized","uncategorized","0");



DROP TABLE IF EXISTS `wp33_usermeta`;

CREATE TABLE `wp33_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `wp33_usermeta` VALUES("1","1","nickname","qye14");
INSERT INTO `wp33_usermeta` VALUES("2","1","first_name","");
INSERT INTO `wp33_usermeta` VALUES("3","1","last_name","");
INSERT INTO `wp33_usermeta` VALUES("4","1","description","");
INSERT INTO `wp33_usermeta` VALUES("5","1","rich_editing","true");
INSERT INTO `wp33_usermeta` VALUES("6","1","syntax_highlighting","true");
INSERT INTO `wp33_usermeta` VALUES("7","1","comment_shortcuts","false");
INSERT INTO `wp33_usermeta` VALUES("8","1","admin_color","fresh");
INSERT INTO `wp33_usermeta` VALUES("9","1","use_ssl","0");
INSERT INTO `wp33_usermeta` VALUES("10","1","show_admin_bar_front","true");
INSERT INTO `wp33_usermeta` VALUES("11","1","locale","");
INSERT INTO `wp33_usermeta` VALUES("12","1","wp33_capabilities","a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp33_usermeta` VALUES("13","1","wp33_user_level","10");
INSERT INTO `wp33_usermeta` VALUES("14","1","dismissed_wp_pointers","");
INSERT INTO `wp33_usermeta` VALUES("15","1","show_welcome_panel","1");



DROP TABLE IF EXISTS `wp33_users`;

CREATE TABLE `wp33_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `wp33_users` VALUES("1","qye14","$P$BDbUXo5MYkuhL/jG.rk9JwO.cdgUpe.","qye14","admin@afridevcapital.com","https://afridevcapital.com","2025-03-14 10:23:59","","0","qye14");



DROP TABLE IF EXISTS `wp_commentmeta`;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




DROP TABLE IF EXISTS `wp_comments`;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_comments` VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2021-02-25 19:34:38","2021-02-25 19:34:38","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.","0","1","","comment","0","0");
INSERT INTO `wp_comments` VALUES("2","1","GDIZ","jxhubcbrexkq@gdiz.eu.org","https://www.gdiz.eu.org/","8.222.180.211","2023-08-06 06:20:32","2023-08-06 06:20:32","Your writing skills are amazing! I really love it! Can you review my website https://www.gdiz.eu.org and maybe you can share tour thought about mine?","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:95.0) Gecko/20100101 Firefox/95.0","comment","0","0");
INSERT INTO `wp_comments` VALUES("3","1","Madisont","Madison@gmail.com","https://zetds.seychellesyoga.com/jml","109.248.54.221","2024-01-23 10:58:15","2024-01-23 10:58:15","Shall we exchange links? My website https://zetds.seychellesyoga.com/jml","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("4","1","Debrat","Debra77N@gmail.com","https://zetds.seychellesyoga.com/info","46.8.22.113","2024-01-24 12:10:37","2024-01-24 12:10:37","Content for your website https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("5","1","Jessiet","JessiehY7@gmail.com","https://zetds.seychellesyoga.com/info","45.15.73.232","2024-01-24 18:37:14","2024-01-24 18:37:14","Web Development Wizards https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("6","1","Ameliat","AmeliaF8N@gmail.com","https://zetds.seychellesyoga.com/info","188.130.136.76","2024-01-25 00:05:03","2024-01-25 00:05:03","Can provide a link mass to your website https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("7","1","Lesleyt","LesleyMpW@gmail.com","https://zetds.seychellesyoga.com/info","213.226.101.109","2024-01-25 05:42:58","2024-01-25 05:42:58","Your site\'s position in the search results https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("8","1","Christinet","Christine6RB@gmail.com","https://zetds.seychellesyoga.com/info","92.119.193.66","2024-01-25 12:21:31","2024-01-25 12:21:31","Free analysis of your website https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("9","1","Lindat","LindaFOo@gmail.com","https://zetds.seychellesyoga.com/info","188.130.142.49","2024-01-25 14:39:44","2024-01-25 14:39:44","Content for your website https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("10","1","Dorothyt","DorothyBR9@gmail.com","https://zetds.seychellesyoga.com/info","188.130.143.234","2024-01-25 21:24:40","2024-01-25 21:24:40","Web Development Wizards https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("11","1","Jocelynt","JocelynEW7@gmail.com","https://zetds.seychellesyoga.com/info","188.130.128.120","2024-01-26 04:07:13","2024-01-26 04:07:13","Can provide a link mass to your website https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("12","1","Madisont","MadisonWVF@gmail.com","https://zetds.seychellesyoga.com/info","109.248.143.245","2024-01-26 10:51:46","2024-01-26 10:51:46","Your site\'s position in the search results https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("13","1","Estert","EsterXhY@gmail.com","https://zetds.seychellesyoga.com/info","46.8.23.193","2024-01-26 16:36:11","2024-01-26 16:36:11","Free analysis of your website https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("14","1","Selenat","Selenaht2@gmail.com","https://zetds.seychellesyoga.com/info","109.248.14.120","2024-01-26 22:30:53","2024-01-26 22:30:53","SEO Optimizers Team https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("15","1","Averyt","AveryIxG@gmail.com","https://zetds.seychellesyoga.com/info","188.130.220.157","2024-01-27 03:22:23","2024-01-27 03:22:23","I offer mutually beneficial cooperation https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("16","1","Sallyt","SallyJAt@gmail.com","https://zetds.seychellesyoga.com/info","46.8.154.94","2024-01-27 04:25:41","2024-01-27 04:25:41","I offer mutually beneficial cooperation https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("17","1","Cherilt","CherilnUA@gmail.com","https://zetds.seychellesyoga.com/info","46.8.23.154","2024-01-27 10:19:16","2024-01-27 10:19:16","Cool website. There is a suggestion https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("18","1","Ashleyt","AshleyMWB@gmail.com","https://zetds.seychellesyoga.com/info","46.8.57.120","2024-01-27 16:28:20","2024-01-27 16:28:20","I really liked your site. Do you mind https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("19","1","Katherinet","KatherineKGO@gmail.com","https://zetds.seychellesyoga.com/info","188.130.129.101","2024-01-27 22:31:03","2024-01-27 22:31:03","Here\'s what I can offer for the near future https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("20","1","Beatricet","BeatriceFy7@gmail.com","https://zetds.seychellesyoga.com/info","188.130.129.84","2024-01-28 04:27:58","2024-01-28 04:27:58","You will definitely like it https://zetds.seychellesyoga.com/info","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("21","1","Lucyt","LucyQcO@gmail.com","https://ztd.bardou.online/adm","46.8.192.109","2024-01-28 15:31:39","2024-01-28 15:31:39","Web Development Wizards https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("22","1","Teresat","Teresa9y1@gmail.com","https://ztd.bardou.online/adm","109.248.14.53","2024-01-28 21:36:49","2024-01-28 21:36:49","Can provide a link mass to your website https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("23","1","Zoet","ZoeKuz@gmail.com","https://ztd.bardou.online/adm","5.183.130.30","2024-01-29 09:55:56","2024-01-29 09:55:56","Free analysis of your website https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("24","1","Maggiet","Maggie4cW@gmail.com","https://ztd.bardou.online/adm","46.8.155.231","2024-01-29 16:06:23","2024-01-29 16:06:23","SEO Optimizers Team https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("25","1","Jennifert","Jenniferr57@gmail.com","https://ztd.bardou.online/adm","46.8.155.252","2024-01-29 17:02:31","2024-01-29 17:02:31","SEO Optimizers Team https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("26","1","Cherilt","CherilH3R@gmail.com","https://ztd.bardou.online/adm","109.248.14.151","2024-01-29 22:15:09","2024-01-29 22:15:09","I offer mutually beneficial cooperation https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("27","1","Barbarat","BarbaraTAm@gmail.com","https://ztd.bardou.online/adm","188.130.142.174","2024-01-30 16:47:09","2024-01-30 16:47:09","Here\'s what I can offer for the near future https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("28","1","Christinet","ChristinetUf@gmail.com","https://ztd.bardou.online/adm","109.248.14.178","2024-01-30 21:15:23","2024-01-30 21:15:23","Content for your website https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("29","1","Joant","JoanRXq@gmail.com","https://ztd.bardou.online/adm","95.182.127.19","2024-01-31 03:05:03","2024-01-31 03:05:03","Web Development Wizards https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("30","1","Annt","AnnLI8@gmail.com","https://ztd.bardou.online/adm","45.86.0.147","2024-01-31 08:55:42","2024-01-31 08:55:42","Can provide a link mass to your website https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("31","1","Heathert","Heather5bk@gmail.com","https://ztd.bardou.online/adm","46.8.15.203","2024-01-31 14:55:59","2024-01-31 14:55:59","Your site\'s position in the search results https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("32","1","Edisont","EdisonTSC@gmail.com","https://ztd.bardou.online/adm","45.87.252.18","2024-01-31 20:50:44","2024-01-31 20:50:44","Free analysis of your website https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("33","1","Christinet","Christineir4@gmail.com","https://ztd.bardou.online/adm","194.32.229.212","2024-02-01 02:38:15","2024-02-01 02:38:15","SEO Optimizers Team https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("34","1","Maggiet","Maggieuvb@gmail.com","https://ztd.bardou.online/adm","188.130.136.111","2024-02-01 08:20:45","2024-02-01 08:20:45","I offer mutually beneficial cooperation https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("35","1","Viviant","Vivian6KU@gmail.com","https://ztd.bardou.online/adm","188.130.142.113","2024-02-01 14:09:22","2024-02-01 14:09:22","Cool website. There is a suggestion https://ztd.bardou.online/adm","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("36","1","Valeryt","Valery8IG@gmail.com","http://myngirls.online/","188.130.143.235","2024-02-01 17:26:19","2024-02-01 17:26:19","Content for your website http://myngirls.online/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("37","1","Irenet","Irenen8X@gmail.com","http://myngirls.online/","188.130.137.217","2024-02-01 23:17:34","2024-02-01 23:17:34","Web Development Wizards http://myngirls.online/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("38","1","Paulat","PaulaSiH@gmail.com","http://myngirls.online/","109.248.14.105","2024-02-02 05:02:14","2024-02-02 05:02:14","Can provide a link mass to your website http://myngirls.online/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("39","1","Candyt","CandylRd@gmail.com","http://myngirls.online/","194.35.113.246","2024-02-02 10:47:46","2024-02-02 10:47:46","Your site\'s position in the search results http://myngirls.online/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("40","1","Lilliant","LillianPUQ@gmail.com","http://myngirls.online/","109.248.54.19","2024-02-03 00:34:53","2024-02-03 00:34:53","Free analysis of your website http://myngirls.online/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("41","1","Tinat","TinacU7@gmail.com","http://myngirls.online/","45.11.20.97","2024-02-03 14:17:33","2024-02-03 14:17:33","SEO Optimizers Team http://myngirls.online/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("42","1","Valeryt","ValerywuM@gmail.com","http://fertus.shop/info/","188.130.143.235","2024-02-04 09:36:03","2024-02-04 09:36:03","Content for your website http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("43","1","Irenet","IreneOKF@gmail.com","http://fertus.shop/info/","188.130.137.217","2024-02-04 17:27:37","2024-02-04 17:27:37","Web Development Wizards http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("44","1","Paulat","Paulag6N@gmail.com","http://fertus.shop/info/","109.248.14.105","2024-02-05 01:18:10","2024-02-05 01:18:10","Can provide a link mass to your website http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("45","1","Candyt","Candy0Oe@gmail.com","http://fertus.shop/info/","194.35.113.246","2024-02-05 09:07:24","2024-02-05 09:07:24","Your site\'s position in the search results http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("46","1","Lilliant","LillianKF4@gmail.com","http://fertus.shop/info/","109.248.54.19","2024-02-05 22:58:00","2024-02-05 22:58:00","Free analysis of your website http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("47","1","Tinat","TinaIlg@gmail.com","http://fertus.shop/info/","45.11.20.97","2024-02-06 12:47:07","2024-02-06 12:47:07","SEO Optimizers Team http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("48","1","Pamelat","PamelaMe7@gmail.com","http://fertus.shop/info/","185.181.246.16","2024-02-07 16:26:53","2024-02-07 16:26:53","Cool website. There is a suggestion http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("49","1","Britneyt","BritneySVW@gmail.com","http://fertus.shop/info/","188.130.218.214","2024-02-08 06:17:32","2024-02-08 06:17:32","I really liked your site. Do you mind http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("50","1","Leonat","LeonayYV@gmail.com","http://fertus.shop/info/","194.35.113.16","2024-02-08 20:06:58","2024-02-08 20:06:58","Here\'s what I can offer for the near future http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("51","1","Teresat","TeresaYtb@gmail.com","http://fertus.shop/info/","185.181.246.10","2024-02-09 09:52:16","2024-02-09 09:52:16","You will definitely like it http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("52","1","Gwent","Gwenfj9@gmail.com","http://fertus.shop/info/","188.130.185.165","2024-02-09 23:37:18","2024-02-09 23:37:18","The best prices from the best providers http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("53","1","Oliviat","OliviaCti@gmail.com","http://fertus.shop/info/","46.8.110.228","2024-02-10 13:20:55","2024-02-10 13:20:55","Additional earnings on your website http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("54","1","Beatricet","BeatriceWDQ@gmail.com","http://fertus.shop/info/","188.130.142.174","2024-02-11 03:03:43","2024-02-11 03:03:43","Analytics of your website http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("55","1","Laurat","Lauraoct@gmail.com","http://fertus.shop/info/","109.248.142.121","2024-02-11 16:48:28","2024-02-11 16:48:28","I would like to post an article http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("56","1","Susant","Susanaaa@gmail.com","http://fertus.shop/info/","46.8.10.21","2024-02-12 06:44:06","2024-02-12 06:44:06","How to contact the administrator on this issue http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("57","1","Gloriat","Gloriaaaa@gmail.com","http://fertus.shop/info/","109.248.205.242","2024-02-12 20:49:19","2024-02-12 20:49:19","Shall we exchange links? My website http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("58","1","Norat","Noraaaa@gmail.com","http://fertus.shop/info/","188.130.143.234","2024-02-13 10:43:14","2024-02-13 10:43:14","The offer is still valid. Details http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("59","1","Kellyt","Kellyaaa@gmail.com","http://fertus.shop/info/","46.8.111.18","2024-02-14 14:23:07","2024-02-14 14:23:07","Content for your website http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("60","1","Stacyt","Stacyaaa@gmail.com","http://fertus.shop/info/","45.86.1.151","2024-02-15 04:08:00","2024-02-15 04:08:00","Web Development Wizards http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("61","1","Gillt","Gillaaa@gmail.com","http://fertus.shop/info/","45.81.137.40","2024-02-15 17:45:02","2024-02-15 17:45:02","Can provide a link mass to your website http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("62","1","Irenet","Irene2tN@gmail.com","http://fertus.shop/info/","188.130.137.217","2024-02-17 00:11:19","2024-02-17 00:11:19","Web Development Wizards http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("63","1","Candyt","Candyaaa@gmail.com","http://fertus.shop/info/","194.35.113.246","2024-02-18 02:49:20","2024-02-18 02:49:20","Your site\'s position in the search results http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("64","1","Lilliant","Lillianaaa@gmail.com","http://fertus.shop/info/","109.248.54.19","2024-02-18 16:07:47","2024-02-18 16:07:47","Free analysis of your website http://fertus.shop/info/","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("65","1","Miranda3085","Miranda3085@gmail.com","","62.210.246.74","2024-02-27 11:29:02","2024-02-27 11:29:02","Ace of Base — шведская поп-группа, образованная в 1990 году. Их музыкальный стиль сочетает в себе элементы поп-музыки, дэнса и электроники. Группа стала популярной благодаря хитам \"All That She Wants\", \"The Sign\", \"Don\'t Turn Around\" и \"Beautiful Life\". Эти композиции не только покорили чарты во многих странах мира, но и остаются классикой жанра до сих пор. Ace of Base оставили неизгладимый след в истории поп-музыки, их мелодии до сих пор радуют слушателей по всему миру. <a href=\"https://mp3name.co\" rel=\"nofollow ugc\">Скачать музыку 2024</a> года и слушать онлайн бесплатно mp3.","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("66","1","Sandrat","SandraRc1@gmail.com","","119.110.72.74","2024-06-12 00:18:27","2024-06-12 00:18:27","What an insightful article! Your ability to break down complex topics into easily understandable points is truly commendable. I appreciate the thorough research and the engaging writing style that keeps readers hooked from start to finish. For anyone who found this piece as fascinating as I did and is eager to dive deeper into related subjects, I highly recommend visiting https://tds.rida.tokyo/com. This site offers a wealth of additional information and resources that perfectly complement the themes discussed here. Thank you for sharing your knowledge and providing such valuable content. I look forward to reading more of your work in the future!","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("67","1","Sandyt","patlik.gren@gmail.com","https://redlsoft.com/5c6ad32de41a8c33b279b8513f049780","87.251.79.133","2024-06-23 21:07:59","2024-06-23 21:07:59","Great article! I appreciate the clear and insightful perspective you’ve shared. It\'s fascinating to see how this topic is developing. For those interested in diving deeper, I found an excellent resource that expands on these ideas: check it out here. Looking forward to hearing others’ thoughts and continuing the discussion!","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("68","1","Agatat","patlik.gren@gmail.com","https://feedspot.com/5c6ad32de41a8c33b279b8513f049780","87.251.79.133","2024-07-02 08:18:59","2024-07-02 08:18:59","The analysis in this article was spot-on. The author\'s approach was both clear and engaging. I\'m curious to see how others feel about these ideas. What do you think?","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("69","1","Rachelt","patlik.gren@gmail.com","https://feedspot.com/5c6ad32de41a8c33b279b8513f049780","87.251.79.133","2024-07-03 03:19:42","2024-07-03 03:19:42","This article was a real eye-opener! The author\'s perspective on this topic is quite refreshing and thought-provoking. I\'m curious to see how others feel about the points made here. What are your thoughts?","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("70","1","Christian2686","Christian2686@gmail.com","","186.188.109.38","2025-04-21 17:11:45","2025-04-21 17:11:45","Awesome <a href=\"https://is.gd/tpjNyL\" rel=\"nofollow ugc\">https://is.gd/tpjNyL</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("71","1","MyBlog","","http://mnbdaa.com","185.36.81.36","2025-08-14 13:55:32","2025-08-14 13:55:32","<strong>itstitle</strong>\n\nexcerptsa","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36","trackback","0","0");
INSERT INTO `wp_comments` VALUES("72","1","1xbet_cqKt","czgzejgqjKt@luck-and-magic.site","https://1xbetapkegypt.com/","62.113.116.213","2025-09-05 10:54:47","2025-09-05 10:54:47","للاستمتاع بجميع الوظائف والمراهنات الرياضية، قم بما يلي <a href=\"https://1xbetapkegypt.com/\" / rel=\"nofollow ugc\">ون اكس</a> وقم بتثبيت التطبيق على جهازك. 
\nالممتازة لتطبيق 1xbet هو البث المباشر","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("73","1","888starz_vksn","wfxedwwugsn@cosmicbridge.site","https://888starz-uzbekistan.ru/","62.113.116.213","2025-09-17 16:49:18","2025-09-17 16:49:18","Mijozlar doimo yangi oʻyinlar va yangilanishlarga ega boʻlishadi. 
\n 
\nHar bir turdagi oʻyin oʻzining ajoyib grafikasi va hayajonli jarayoniga ega. 
\n 
\nYangi roʻyxatdan oʻtganlar uchun 100% depozit bonusini olish mumkin. 
\n 
\nMijozlar oʻzlariga qulay boʻlgan har qanday usulni tanlashlari mumkin. 
\n 
\n888starz <a href=\"888starz-uzbekistan.ru\" rel=\"nofollow ugc\">https://888starz-uzbekistan.ru/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0","comment","0","0");
INSERT INTO `wp_comments` VALUES("74","1","888starz_fopl","gzncryufipl@galaxygate.store","https://888starz2.ru/","89.110.99.186","2025-09-18 14:25:29","2025-09-18 14:25:29","888starz – известных онлайн-казино, широкий выбор азартных игр. это заведение. и интересные акции. 
\n 
\nИгроки в 888starz, предлагаемых на платформе. разработана и высококачественной графикой и увлекательным сюжетом. платформа предлагает и с настоящими дилерами, чувство реального казино. 
\n 
\nявляется. предлагает и вывода средств, что делает процесс. защищены, что конфиденциальность информации. 
\n 
\nо службе поддержки. В 888starz, которая готова помочь. с ними и развернутые ответы. Таким образом, 888starz. 
\n888 starz <a href=\"https://888starz2.ru/\" / rel=\"nofollow ugc\">888 starz</a>.","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0","comment","0","0");
INSERT INTO `wp_comments` VALUES("75","1","888starz_vrKr","bdduxxujaKr@nebulanexus.site","https://888starz-egypt-eg.com/","178.20.42.76","2025-09-21 05:52:01","2025-09-21 05:52:01","888starz هو منصة شهيرة في عالم القمار الإلكتروني. يتميز الموقع بتقديم العديد من أنواع الألعاب التي تلبي احتياجات جميع اللاعبين. تتضمن الألعاب المتاحة الرهانات الرياضية، وألعاب الكازينو. 
\n 
\nتتمتع 888starz بواجهة مستخدم سهلة الاستخدام. يمتلك المستخدمون القدرة على التنقل بين الأقسام بصورة سلسة. يساهم في جعل تجربة اللعب أكثر جاذبية. 
\n 
\nتوفر 888starz أيضًا مجموعة من المكافآت لجذب اللاعبين الجدد. يشمل ذلك مكافآت الترحيب والمكافآت الدورية. تعتبر هذه المكافآت آلية فعالة لجذب المزيد من اللاعبين. 
\n 
\nتعد الأمان من أبرز أولويات 888starz. تعتمد المنصة على تقنيات متطورة لضمان حماية معلومات اللاعبين. يحقق ذلك مستوى عالٍ من الأمان أثناء اللعب. 
\nstarz 888 <a href=\"http://www.888starz-egypt-eg.com/\" / rel=\"nofollow ugc\">https://888starz-egypt-eg.com/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("76","1","888starz_oomi","qjpgdnluwmi@888starz.tech","https://888starz-bet-casino.com/","88.210.35.166","2025-09-28 00:45:17","2025-09-28 00:45:17","888starz brings esports fans a wide range of betting opportunities. 
\ncasino 888starz <a href=\"http://www.888starz-bet-casino.com/es\" rel=\"nofollow ugc\">https://888starz-bet-casino.com/es/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("77","1","1win_pfmt","wagfwnrlmmt@casino-kent.pro","https://1win-app.bet","62.113.116.213","2025-10-03 04:19:23","2025-10-03 04:19:23","In conclusion, the 1win app is a comprehensive tool for sports enthusiasts and bettors alike.  
\n1win зеркало скачать <a href=\"https://1win-app.bet/ru/\" / rel=\"nofollow ugc\">https://1win-app.bet/ru/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0","comment","0","0");
INSERT INTO `wp_comments` VALUES("78","1","888starz_grkr","sztdvfwlrkr@skachat-melbet.info","https://888starz-egypts.com","178.20.42.76","2025-10-04 08:13:30","2025-10-04 08:13:30","تعزز هذه العروض من فرص اللاعبين في تحقيق الفوز وزيادة المتعة.  
\n888starz تحميل <a href=\"http://www.888starz-egypts.com/apk/\" / rel=\"nofollow ugc\">https://888starz-egypts.com/apk/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("79","1","888starz_szOt","vcjjowvgiOt@skachat-winline.pro","https://888starzuzs.com/","62.113.116.213","2025-10-08 00:49:28","2025-10-08 00:49:28","888starz  orqali  muvaffaqiyatni  mumkin.  o\'yinchilar uchun  taqdim etadi. 
\n ko\'plab janrlarda. o\'yin tajribasidan  mumkin. 
\n ko\'paytirishga  yordam beradi.  haqida joylashgan bloglar  mavjud. 
\neng yuqori darajadagi .  Qimor ixlosmandlarining. ushbu platformaga  mumkin. 
\n888 starz download <a href=\"https://888starzuzs.com/apk\" rel=\"nofollow ugc\">https://888starzuzs.com/apk/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("80","1","vykup_slPa","jpltjzrpaPa@888starz.tech","https://vykup-bityh-avto-posle-dtp.ru","88.210.35.166","2025-10-09 12:21:02","2025-10-09 12:21:02","Привлекательный способ удалить автомобилем – это обмен таких транспортных средств. Большинство автолюбители имеют дело с ремонта своего поврежденного автомобиля. Это времени и средств. 
\n 
\nКомпании, занимающиеся покупкой битых авто, разнообразные варианты продажи. содействуют. Порой условия радовали, и они продают свои авто. 
\n 
\nПеред тем услугами покупки, необходимо в этой области. Помимо, присутствует и другие преимущества, что к сотрудничеству. В рамках таких аргументов – бесплатная оценка технического состояния. 
\n 
\nОпытные специалисты анализируют и советуют наилучший решение. помогает, чтобы продать автомобиль быстро. Пользуйтесь услугам выкупа битых авто для того чтобы. 
\nпродать битый авто в москве <a href=\"vykup-bityh-avto-posle-dtp.ru\" rel=\"nofollow ugc\">https://vykup-bityh-avto-posle-dtp.ru/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("81","1","888starz_mvSn","yhmwdoownSn@ugaritopari.site","https://888starz-888stars.com","62.113.116.213","2025-10-12 02:10:07","2025-10-12 02:10:07","Whether you are a novice or an expert, you will find something to enjoy. 
\n888 starz ios <a href=\"http://www.888starz-888stars.com/pl/apk-ios/\" / rel=\"nofollow ugc\">https://888starz-888stars.com/pl/apk-ios/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("82","1","razdelhsor","wbszwxmrior@razdel-imushchestva6.ru","https://razdel-imushchestva6.ru","212.34.138.196","2025-10-14 08:10:50","2025-10-14 08:10:50","Получите профессиональную <a href=\"https://razdel-imushchestva6.ru\" rel=\"nofollow ugc\">решение суда о разделе имущества</a> услугами. 
\n 
\nЕсли диалог не дает результатов, возможно, придется рассматривать судебное разбирательство.","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("83","1","888starz_xrea","enkruclbjea@888starz.tech","https://888-starz-eg.com","88.210.35.166","2025-10-15 00:11:29","2025-10-15 00:11:29","تعتبر 888starz واحدة من أحدث المنصات المبتكرة في مجال الألعاب. تجمع هذه المنصة بين مختلف أنواع الألعاب مثل الرهانات الرياضية، ألعاب الكازينو، وغيرها. 
\nتهدف 888starz إلى توفير تجربة مستخدم فريدة وسلسة، مما يجعل العملية أكثر سلاسة. كما تدعم المنصة مختلف اللغات، مما يجعلها متاحة للجميع. 
\nتتبع 888starz معايير أمان عالية لضمان حماية معلومات اللاعبين. بالإضافة إلى ذلك، تقدم المنصة دعمًا فنيًا ممتازًا متاحًا على مدار الساعة. 
\nتتميز 888starz بعروض ومكافآت مغرية تجعل تجربة اللعب أكثر إثارة. تعتبر المكافآت التي تقدمها 888starz جزءًا أساسيًا من استراتيجيتها لجذب اللاعبين والحفاظ عليهم. 
\nموقع 888starz <a href=\"http://www.888-starz-eg.com/\" / rel=\"nofollow ugc\">https://888-starz-eg.com/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Avast/131.0.0.0","comment","0","0");
INSERT INTO `wp_comments` VALUES("84","1","kupit_ussi","etmlzawkesi@ugaritopari.site","https://kupit-uggi-moskva.ru/","62.113.116.213","2025-10-15 16:35:43","2025-10-15 16:35:43","На рынке есть множество известных брендов, предлагающих угги.  
\nкупить угги мужские <a href=\"https://www.uggiaustralia-msk.ru/collection/muzhskie-uggi/\" / rel=\"nofollow ugc\">https://uggiaustralia-msk.ru/collection/muzhskie-uggi/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 CCleaner/130.0.0.0","comment","0","0");
INSERT INTO `wp_comments` VALUES("85","1","minecraft_edel","eiautulgxel@ingushetdomaz.pro","https://minecraftbedrock-apk.com/","178.20.42.76","2025-10-18 11:49:37","2025-10-18 11:49:37","In the Bedrock Edition, the marketplace offers players the chance to buy skins, texture packs, and unique worlds. 
\ndownload minecraft terbaru <a href=\"minecraftbedrock-apk.com/downloading\" rel=\"nofollow ugc\">https://minecraftbedrock-apk.com/downloading/</a>","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36","comment","0","0");
INSERT INTO `wp_comments` VALUES("86","1","https___ko_cypn","sipojxjrtpn@konsultaciya-yurista22.ru","https://konsultaciya-yurista22.ru","212.34.138.196","2025-10-22 00:46:01","2025-10-22 00:46:01","Получите <a href=\"https://konsultaciya-yurista22.ru\" rel=\"nofollow ugc\">бесплатную консультацию юриста</a> прямо сейчас! 
\nпредставляет собой важный аспект. Непонимание юридических нюансов может негативно сказаться на жизни граждан.  
\n 
\nПервый важный аспект, о котором следует упомянуть, — это возможность получить юридическую поддержку. В настоящее время множество экспертов предоставляет консультации через интернет. Это упрощает процесс поиска помощи и делает его более доступным. 
\n 
\nСледующий важный момент — это выбор юриста. Надежный юрист должен иметь соответствующий опыт и образование. Люди часто игнорируют эти факторы, что может привести к неудачам. 
\n 
\nТретий аспект, который следует рассмотреть, — это стоимость юридических услуг. Цены могут варьироваться в зависимости от сложности дела и репутации юриста. Обсуждение условий и стоимости заранее крайне важно. 
\n 
\nНаконец, необходимо помнить об ответственности юриста. Важно понимать, что низкая квалификация может негативно сказаться на ваших интересах. Поэтому выбирайте юриста с умом, чтобы избежать проблем.","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36","comment","0","0");



DROP TABLE IF EXISTS `wp_e_events`;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




DROP TABLE IF EXISTS `wp_links`;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




DROP TABLE IF EXISTS `wp_litespeed_url`;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




DROP TABLE IF EXISTS `wp_litespeed_url_file`;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




DROP TABLE IF EXISTS `wp_options`;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=101708 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `wp_options` VALUES("1","siteurl","http://www.afridevcapital.com","yes");
INSERT INTO `wp_options` VALUES("2","home","http://www.afridevcapital.com","yes");
INSERT INTO `wp_options` VALUES("3","blogname","Afridev","yes");
INSERT INTO `wp_options` VALUES("4","blogdescription","...unlocking new values","yes");
INSERT INTO `wp_options` VALUES("5","users_can_register","0","yes");
INSERT INTO `wp_options` VALUES("6","admin_email","ayobamioke@gmail.com","yes");
INSERT INTO `wp_options` VALUES("7","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES("8","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES("9","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES("10","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES("11","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES("12","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO `wp_options` VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES("16","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES("17","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES("18","default_category","1","yes");
INSERT INTO `wp_options` VALUES("19","default_comment_status","open","yes");
INSERT INTO `wp_options` VALUES("20","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES("21","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES("22","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES("23","date_format","F j, Y","yes");
INSERT INTO `wp_options` VALUES("24","time_format","g:i a","yes");
INSERT INTO `wp_options` VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO `wp_options` VALUES("26","comment_moderation","0","yes");
INSERT INTO `wp_options` VALUES("27","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES("28","permalink_structure","/%postname%/","yes");
INSERT INTO `wp_options` VALUES("29","rewrite_rules","a:242:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:34:\"client/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"client/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"client/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"client/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"client/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"client/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"client/([^/]+)/embed/?$\";s:39:\"index.php?client=$matches[1]&embed=true\";s:27:\"client/([^/]+)/trackback/?$\";s:33:\"index.php?client=$matches[1]&tb=1\";s:35:\"client/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?client=$matches[1]&paged=$matches[2]\";s:42:\"client/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?client=$matches[1]&cpage=$matches[2]\";s:31:\"client/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?client=$matches[1]&page=$matches[2]\";s:23:\"client/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"client/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"client/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"client/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"client/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"client/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"client-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?client-types=$matches[1]&feed=$matches[2]\";s:48:\"client-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?client-types=$matches[1]&feed=$matches[2]\";s:29:\"client-types/([^/]+)/embed/?$\";s:45:\"index.php?client-types=$matches[1]&embed=true\";s:41:\"client-types/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?client-types=$matches[1]&paged=$matches[2]\";s:23:\"client-types/([^/]+)/?$\";s:34:\"index.php?client-types=$matches[1]\";s:33:\"offer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"offer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"offer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"offer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"offer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"offer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"offer/([^/]+)/embed/?$\";s:38:\"index.php?offer=$matches[1]&embed=true\";s:26:\"offer/([^/]+)/trackback/?$\";s:32:\"index.php?offer=$matches[1]&tb=1\";s:34:\"offer/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?offer=$matches[1]&paged=$matches[2]\";s:41:\"offer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?offer=$matches[1]&cpage=$matches[2]\";s:30:\"offer/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?offer=$matches[1]&page=$matches[2]\";s:22:\"offer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"offer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"offer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"offer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"offer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"offer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"offer-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?offer-types=$matches[1]&feed=$matches[2]\";s:47:\"offer-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?offer-types=$matches[1]&feed=$matches[2]\";s:28:\"offer-types/([^/]+)/embed/?$\";s:44:\"index.php?offer-types=$matches[1]&embed=true\";s:40:\"offer-types/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?offer-types=$matches[1]&paged=$matches[2]\";s:22:\"offer-types/([^/]+)/?$\";s:33:\"index.php?offer-types=$matches[1]\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"portfolio-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"portfolio-item/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:39:\"portfolio-item/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"portfolio-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"portfolio-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio-types=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?portfolio-types=$matches[1]&feed=$matches[2]\";s:32:\"portfolio-types/([^/]+)/embed/?$\";s:48:\"index.php?portfolio-types=$matches[1]&embed=true\";s:44:\"portfolio-types/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?portfolio-types=$matches[1]&paged=$matches[2]\";s:26:\"portfolio-types/([^/]+)/?$\";s:37:\"index.php?portfolio-types=$matches[1]\";s:33:\"slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"slide/([^/]+)/embed/?$\";s:38:\"index.php?slide=$matches[1]&embed=true\";s:26:\"slide/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:34:\"slide/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:41:\"slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:30:\"slide/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:22:\"slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"slide-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?slide-types=$matches[1]&feed=$matches[2]\";s:47:\"slide-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?slide-types=$matches[1]&feed=$matches[2]\";s:28:\"slide-types/([^/]+)/embed/?$\";s:44:\"index.php?slide-types=$matches[1]&embed=true\";s:40:\"slide-types/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?slide-types=$matches[1]&paged=$matches[2]\";s:22:\"slide-types/([^/]+)/?$\";s:33:\"index.php?slide-types=$matches[1]\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"testimonial-types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?testimonial-types=$matches[1]&feed=$matches[2]\";s:53:\"testimonial-types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?testimonial-types=$matches[1]&feed=$matches[2]\";s:34:\"testimonial-types/([^/]+)/embed/?$\";s:50:\"index.php?testimonial-types=$matches[1]&embed=true\";s:46:\"testimonial-types/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?testimonial-types=$matches[1]&paged=$matches[2]\";s:28:\"testimonial-types/([^/]+)/?$\";s:39:\"index.php?testimonial-types=$matches[1]\";s:34:\"layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"layout/([^/]+)/embed/?$\";s:39:\"index.php?layout=$matches[1]&embed=true\";s:27:\"layout/([^/]+)/trackback/?$\";s:33:\"index.php?layout=$matches[1]&tb=1\";s:35:\"layout/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?layout=$matches[1]&paged=$matches[2]\";s:42:\"layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?layout=$matches[1]&cpage=$matches[2]\";s:31:\"layout/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?layout=$matches[1]&page=$matches[2]\";s:23:\"layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"template-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"template-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"template-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"template-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"template-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"template-item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"template-item/([^/]+)/embed/?$\";s:41:\"index.php?template=$matches[1]&embed=true\";s:34:\"template-item/([^/]+)/trackback/?$\";s:35:\"index.php?template=$matches[1]&tb=1\";s:42:\"template-item/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?template=$matches[1]&paged=$matches[2]\";s:49:\"template-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?template=$matches[1]&cpage=$matches[2]\";s:38:\"template-item/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?template=$matches[1]&page=$matches[2]\";s:30:\"template-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"template-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"template-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"template-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"template-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"template-item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=2239&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}","yes");
INSERT INTO `wp_options` VALUES("30","hack_file","0","yes");
INSERT INTO `wp_options` VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES("32","moderation_keys","","no");
INSERT INTO `wp_options` VALUES("33","active_plugins","a:11:{i:0;s:27:\"cacheengine/cacheengine.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:33:\"duplicate-post/duplicate-post.php\";i:3;s:23:\"elementor/elementor.php\";i:4;s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";i:5;s:43:\"go-live-update-urls/go-live-update-urls.php\";i:6;s:28:\"migrate-guru/migrateguru.php\";i:7;s:35:\"one_images_user/one_images_user.php\";i:8;s:33:\"social-media-integrator/index.php\";i:9;s:53:\"velvet-blues-update-urls/velvet-blues-update-urls.php\";i:10;s:39:\"wp-file-manager/file_folder_manager.php\";}","yes");
INSERT INTO `wp_options` VALUES("34","category_base","","yes");
INSERT INTO `wp_options` VALUES("35","ping_sites","https://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES("36","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES("37","gmt_offset","0","yes");
INSERT INTO `wp_options` VALUES("38","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES("39","recently_edited","a:5:{i:0;s:72:\"/home/zilllzus/afridevcapital.com/wp-content/plugins/akismet/akismet.php\";i:1;s:75:\"/home/zilllzus/afridevcapital.com/wp-content/themes/betheme-child/style.css\";i:2;s:106:\"/home/firskwfy/public_html/afridev/wp-content/themes/twentytwentyone/template-parts/header/site-header.php\";i:3;s:79:\"/home/firskwfy/public_html/afridev/wp-content/themes/twentytwentyone/header.php\";i:4;s:78:\"/home/firskwfy/public_html/afridev/wp-content/themes/twentytwentyone/index.php\";}","no");
INSERT INTO `wp_options` VALUES("40","template","betheme","yes");
INSERT INTO `wp_options` VALUES("41","stylesheet","betheme-child","yes");
INSERT INTO `wp_options` VALUES("42","comment_registration","0","yes");
INSERT INTO `wp_options` VALUES("43","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES("44","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES("45","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES("46","db_version","60421","yes");
INSERT INTO `wp_options` VALUES("47","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES("48","upload_path","","yes");
INSERT INTO `wp_options` VALUES("49","blog_public","1","yes");
INSERT INTO `wp_options` VALUES("50","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES("51","show_on_front","page","yes");
INSERT INTO `wp_options` VALUES("52","tag_base","","yes");
INSERT INTO `wp_options` VALUES("53","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES("54","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES("55","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES("56","thumbnail_size_w","150","yes");
INSERT INTO `wp_options` VALUES("57","thumbnail_size_h","150","yes");
INSERT INTO `wp_options` VALUES("58","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES("59","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES("60","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES("61","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES("62","large_size_w","1024","yes");
INSERT INTO `wp_options` VALUES("63","large_size_h","1024","yes");
INSERT INTO `wp_options` VALUES("64","image_default_link_type","none","yes");
INSERT INTO `wp_options` VALUES("65","image_default_size","","yes");
INSERT INTO `wp_options` VALUES("66","image_default_align","","yes");
INSERT INTO `wp_options` VALUES("67","close_comments_for_old_posts","0","yes");
INSERT INTO `wp_options` VALUES("68","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES("69","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES("70","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES("71","page_comments","0","yes");
INSERT INTO `wp_options` VALUES("72","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES("73","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES("74","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES("75","sticky_posts","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("76","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("77","widget_text","a:2:{i:2;a:3:{s:5:\"title\";s:4:\"test\";s:4:\"text\";s:4:\"test\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("79","uninstall_plugins","a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:28:\"migrate-guru/migrateguru.php\";a:2:{i:0;s:10:\"MGWPAction\";i:1;s:9:\"uninstall\";}s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}","no");
INSERT INTO `wp_options` VALUES("80","timezone_string","","yes");
INSERT INTO `wp_options` VALUES("81","page_for_posts","0","yes");
INSERT INTO `wp_options` VALUES("82","page_on_front","2239","yes");
INSERT INTO `wp_options` VALUES("83","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES("84","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES("85","finished_splitting_shared_terms","1","yes");
INSERT INTO `wp_options` VALUES("86","site_icon","2927","yes");
INSERT INTO `wp_options` VALUES("87","medium_large_size_w","768","yes");
INSERT INTO `wp_options` VALUES("88","medium_large_size_h","0","yes");
INSERT INTO `wp_options` VALUES("89","wp_page_for_privacy_policy","3","yes");
INSERT INTO `wp_options` VALUES("90","show_comments_cookies_opt_in","1","yes");
INSERT INTO `wp_options` VALUES("91","admin_email_lifespan","1761362831","yes");
INSERT INTO `wp_options` VALUES("92","disallowed_keys","","no");
INSERT INTO `wp_options` VALUES("93","comment_previously_approved","1","yes");
INSERT INTO `wp_options` VALUES("94","auto_plugin_theme_update_emails","a:0:{}","no");
INSERT INTO `wp_options` VALUES("95","auto_update_core_dev","enabled","yes");
INSERT INTO `wp_options` VALUES("96","auto_update_core_minor","enabled","yes");
INSERT INTO `wp_options` VALUES("97","auto_update_core_major","enabled","yes");
INSERT INTO `wp_options` VALUES("98","initial_db_version","49752","yes");
INSERT INTO `wp_options` VALUES("99","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO `wp_options` VALUES("100","fresh_site","0","off");
INSERT INTO `wp_options` VALUES("101","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("102","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("103","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("104","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("105","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("106","sidebars_widgets","a:21:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:13:\"footer-area-1\";a:1:{i:0;s:13:\"custom_html-4\";}s:13:\"footer-area-2\";a:1:{i:0;s:13:\"custom_html-3\";}s:13:\"footer-area-3\";a:1:{i:0;s:13:\"custom_html-5\";}s:13:\"footer-area-4\";a:1:{i:0;s:13:\"custom_html-6\";}s:13:\"footer-area-5\";a:0:{}s:10:\"top-area-1\";a:1:{i:0;s:6:\"text-2\";}s:10:\"top-area-2\";a:0:{}s:10:\"top-area-3\";a:0:{}s:10:\"top-area-4\";a:0:{}s:10:\"mfn-search\";a:0:{}s:5:\"forum\";a:0:{}s:5:\"buddy\";a:0:{}s:6:\"events\";a:0:{}s:3:\"edd\";a:0:{}s:4:\"shop\";a:0:{}s:22:\"blog-cat-uncategorized\";a:0:{}s:22:\"portfolio-cat-branding\";a:0:{}s:20:\"portfolio-cat-design\";a:0:{}s:20:\"portfolio-cat-photos\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO `wp_options` VALUES("107","cron","a:10:{i:1761106470;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761115903;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761118479;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761149137;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761161678;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761161696;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761161697;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761334478;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761680518;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on");
INSERT INTO `wp_options` VALUES("108","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("109","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("114","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("115","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("116","widget_custom_html","a:5:{i:3;a:2:{s:5:\"title\";s:14:\"Practice Areas\";s:7:\"content\";s:576:\"<ul style=\"line-height: 32px;\">
\n<li><a href=\"http://www.afridevcapital.com/practice-areas/\">General Financial Advisory</a></li>
\n<li><a href=\"http://www.afridevcapital.com/practice-areas/\">Primary & Secondary Deals</a></li>
\n<li><a href=\"http://www.afridevcapital.com/practice-areas/\">Valuation</a></li>
\n<li><a href=\"http://www.afridevcapital.com/practice-areas/\">Business Planning</a></li>
\n<li><a href=\"http://www.afridevcapital.com/practice-areas/\">Fairness Opinion</a></li>
\n<li><a href=\"http://www.afridevcapital.com/practice-areas/\">Business Consulting</a></li>
\n</ul>\";}i:4;a:2:{s:5:\"title\";s:7:\"Company\";s:7:\"content\";s:481:\"<ul style=\"line-height: 32px;\">
\n<li><a href=\"http://www.afridevcapital.com/\">Home</a></li>
\n<li><a href=\"http://www.afridevcapital.com/about-us/\">About Us</a></li>
\n<li><a href=\"http://www.afridevcapital.com/practice-areas/\">Practice Areas</a></li>
\n<li><a href=\"http://www.afridevcapital.com/our-team/\">Our Team</a></li>
\n<li><a href=\"http://www.afridevcapital.com/portfolio/\">Portfolio</a></li>
\n<li><a href=\"http://www.afridevcapital.com/contact-us/\">Contact Us</a></li>
\n</ul>\";}i:5;a:2:{s:5:\"title\";s:12:\"Social Media\";s:7:\"content\";s:178:\"<ul style=\"line-height: 32px;\">
\n<li><a href=\"#\">Facebook</a></li>
\n<li><a href=\"#\">Instagram</a></li>
\n<li><a href=\"#\">LinkedIn</a></li>
\n<li><a href=\"#\">Twitter</a></li>
\n</ul>\";}i:6;a:2:{s:5:\"title\";s:10:\"Newsletter\";s:7:\"content\";s:134:\"<p>
\n	Join our newsletter and stay up to date with industry news, articles and more.
\n</p>
\n[contact-form-7 id=\"5\" title=\"Newsletter\"]\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("125","theme_mods_twentytwentyone","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1614282218;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}","no");
INSERT INTO `wp_options` VALUES("118","recovery_keys","a:0:{}","off");
INSERT INTO `wp_options` VALUES("4991","widget_block","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("148","current_theme","Betheme Child","yes");
INSERT INTO `wp_options` VALUES("149","theme_mods_betheme-child","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:5:{s:14:\"secondary-menu\";i:6;s:9:\"lang-menu\";i:6;s:11:\"social-menu\";i:6;s:18:\"social-menu-bottom\";i:6;s:9:\"main-menu\";i:8;}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:2926;}","yes");
INSERT INTO `wp_options` VALUES("150","theme_switched","","yes");
INSERT INTO `wp_options` VALUES("151","betheme","a:460:{s:8:\"last_tab\";s:7:\"general\";s:6:\"layout\";s:10:\"full-width\";s:10:\"grid-width\";s:4:\"1240\";s:5:\"style\";s:0:\"\";s:17:\"image-frame-style\";s:0:\"\";s:18:\"image-frame-border\";s:0:\"\";s:19:\"image-frame-caption\";s:0:\"\";s:11:\"img-page-bg\";s:71:\"http://www.afridevcapital.com/wp-content/uploads/2021/03/Afridev_Bg.png\";s:16:\"position-page-bg\";s:22:\"no-repeat;center top;;\";s:12:\"size-page-bg\";s:5:\"cover\";s:11:\"transparent\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:7:\"content\";s:7:\"content\";}s:11:\"favicon-img\";s:68:\"http://www.afridevcapital.com/wp-content/uploads/2021/03/favicon.png\";s:16:\"apple-touch-icon\";s:0:\"\";s:8:\"logo-img\";s:71:\"http://www.afridevcapital.com/wp-content/uploads/2021/03/Logo-White.png\";s:15:\"retina-logo-img\";s:0:\"\";s:15:\"sticky-logo-img\";s:0:\"\";s:22:\"sticky-retina-logo-img\";s:0:\"\";s:9:\"logo-link\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:4:\"link\";s:4:\"link\";}s:9:\"logo-text\";s:0:\"\";s:10:\"logo-width\";s:0:\"\";s:11:\"logo-height\";s:0:\"\";s:21:\"logo-vertical-padding\";s:0:\"\";s:19:\"logo-vertical-align\";s:0:\"\";s:13:\"logo-advanced\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:12:\"button-style\";s:0:\"\";s:12:\"color-button\";s:7:\"#ffffff\";s:17:\"background-button\";s:7:\"#007db8\";s:18:\"color-button-theme\";s:7:\"#ffffff\";s:19:\"color-action-button\";s:7:\"#747474\";s:24:\"background-action-button\";s:7:\"#f7f7f7\";s:18:\"button-font-family\";s:5:\"Arial\";s:11:\"button-font\";a:3:{s:4:\"size\";s:2:\"14\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:14:\"button-padding\";a:5:{s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"20\";s:8:\"isLinked\";s:1:\"0\";}s:19:\"button-border-width\";s:0:\"\";s:20:\"button-border-radius\";s:0:\"\";s:12:\"button-color\";a:2:{s:6:\"normal\";s:7:\"#626262\";s:5:\"hover\";s:7:\"#626262\";}s:17:\"button-background\";a:2:{s:6:\"normal\";s:7:\"#dbdddf\";s:5:\"hover\";s:7:\"#d3d3d3\";}s:19:\"button-border-color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:24:\"button-highlighted-color\";a:2:{s:6:\"normal\";s:7:\"#ffffff\";s:5:\"hover\";s:7:\"#ffffff\";}s:29:\"button-highlighted-background\";a:2:{s:6:\"normal\";s:7:\"#0095eb\";s:5:\"hover\";s:7:\"#007cc3\";}s:31:\"button-highlighted-border-color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:19:\"button-action-color\";a:2:{s:6:\"normal\";s:7:\"#626262\";s:5:\"hover\";s:7:\"#626262\";}s:24:\"button-action-background\";a:2:{s:6:\"normal\";s:7:\"#dbdddf\";s:5:\"hover\";s:7:\"#d3d3d3\";}s:26:\"button-action-border-color\";a:2:{s:6:\"normal\";s:0:\"\";s:5:\"hover\";s:0:\"\";}s:19:\"slider-blog-timeout\";s:1:\"0\";s:22:\"slider-clients-timeout\";s:1:\"0\";s:20:\"slider-offer-timeout\";s:1:\"0\";s:24:\"slider-portfolio-timeout\";s:1:\"0\";s:19:\"slider-shop-timeout\";s:1:\"0\";s:21:\"slider-slider-timeout\";s:1:\"0\";s:27:\"slider-testimonials-timeout\";s:4:\"5000\";s:20:\"layout-boxed-padding\";s:0:\"\";s:18:\"builder-visibility\";s:0:\"\";s:13:\"display-order\";s:1:\"0\";s:22:\"content-remove-padding\";s:1:\"0\";s:8:\"no-hover\";s:0:\"\";s:19:\"google-maps-api-key\";s:0:\"\";s:11:\"table-hover\";s:0:\"\";s:23:\"math-animations-disable\";s:1:\"0\";s:14:\"layout-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:17:\"post-type-disable\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"theme-disable\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:10:\"static-css\";s:1:\"0\";s:15:\"builder-storage\";s:6:\"encode\";s:16:\"slider-shortcode\";s:0:\"\";s:12:\"table_prefix\";s:11:\"base_prefix\";s:8:\"hook-top\";s:0:\"\";s:19:\"hook-content-before\";s:0:\"\";s:18:\"hook-content-after\";s:0:\"\";s:11:\"hook-bottom\";s:0:\"\";s:12:\"header-style\";s:11:\"transparent\";s:9:\"header-fw\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:10:\"full-width\";s:10:\"full-width\";}s:13:\"header-height\";s:1:\"0\";s:28:\"minimalist-header-deprecated\";s:1:\"0\";s:16:\"img-subheader-bg\";s:0:\"\";s:24:\"img-subheader-attachment\";s:22:\"no-repeat;center top;;\";s:17:\"size-subheader-bg\";s:4:\"auto\";s:14:\"top-bar-bg-img\";s:0:\"\";s:19:\"top-bar-bg-position\";s:20:\"no-repeat;left top;;\";s:13:\"sticky-header\";s:1:\"1\";s:19:\"sticky-header-style\";s:4:\"dark\";s:15:\"subheader-style\";s:11:\"both-center\";s:9:\"subheader\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:17:\"subheader-padding\";s:7:\"120px 0\";s:19:\"subheader-title-tag\";s:2:\"h1\";s:15:\"subheader-image\";s:70:\"http://www.afridevcapital.com/wp-content/uploads/2021/03/header-bg.jpg\";s:18:\"subheader-position\";s:22:\"no-repeat;center top;;\";s:14:\"subheader-size\";s:5:\"cover\";s:21:\"subheader-transparent\";s:3:\"100\";s:18:\"subheader-advanced\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:18:\"top-bar-right-hide\";s:1:\"1\";s:19:\"header-action-title\";s:0:\"\";s:18:\"header-action-link\";s:0:\"\";s:20:\"header-action-target\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"header-search\";s:1:\"0\";s:11:\"header-wpml\";s:4:\"hide\";s:19:\"header-wpml-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"header-banner\";s:0:\"\";s:11:\"sliding-top\";s:1:\"0\";s:16:\"sliding-top-icon\";s:19:\"icon-down-open-mini\";s:10:\"menu-style\";s:10:\"link-color\";s:12:\"menu-options\";a:2:{s:9:\"post-meta\";s:1:\"1\";s:11:\"align-right\";s:11:\"align-right\";}s:21:\"menu-creative-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:15:\"menu-mega-style\";s:0:\"\";s:10:\"action-bar\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"header-slogan\";s:0:\"\";s:12:\"header-phone\";s:0:\"\";s:14:\"header-phone-2\";s:0:\"\";s:12:\"header-email\";s:0:\"\";s:14:\"sidebar-sticky\";s:1:\"0\";s:13:\"sidebar-width\";s:2:\"23\";s:13:\"sidebar-lines\";s:0:\"\";s:18:\"single-page-layout\";s:0:\"\";s:19:\"single-page-sidebar\";s:0:\"\";s:20:\"single-page-sidebar2\";s:0:\"\";s:13:\"single-layout\";s:0:\"\";s:14:\"single-sidebar\";s:0:\"\";s:15:\"single-sidebar2\";s:0:\"\";s:23:\"single-portfolio-layout\";s:0:\"\";s:24:\"single-portfolio-sidebar\";s:0:\"\";s:25:\"single-portfolio-sidebar2\";s:0:\"\";s:13:\"prev-next-nav\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:15:\"prev-next-style\";s:0:\"\";s:22:\"prev-next-sticky-style\";s:0:\"\";s:5:\"share\";s:1:\"1\";s:11:\"share-style\";s:0:\"\";s:19:\"pagination-show-all\";s:1:\"1\";s:4:\"love\";s:1:\"1\";s:22:\"featured-image-caption\";s:0:\"\";s:13:\"related-style\";s:0:\"\";s:13:\"title-heading\";s:1:\"1\";s:10:\"blog-posts\";s:1:\"4\";s:11:\"blog-layout\";s:7:\"classic\";s:12:\"blog-columns\";s:1:\"3\";s:14:\"blog-title-tag\";s:1:\"2\";s:11:\"blog-images\";s:0:\"\";s:15:\"blog-full-width\";s:1:\"0\";s:9:\"blog-page\";s:0:\"\";s:12:\"blog-orderby\";s:4:\"date\";s:10:\"blog-order\";s:3:\"ASC\";s:16:\"exclude-category\";s:0:\"\";s:14:\"excerpt-length\";s:2:\"26\";s:9:\"blog-meta\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:14:\"blog-load-more\";s:1:\"0\";s:12:\"blog-filters\";s:1:\"1\";s:12:\"blog-isotope\";s:1:\"0\";s:10:\"blog-title\";s:1:\"1\";s:16:\"blog-single-zoom\";s:1:\"1\";s:11:\"blog-author\";s:1:\"1\";s:13:\"blog-comments\";s:1:\"1\";s:18:\"blog-single-layout\";s:0:\"\";s:16:\"blog-single-menu\";s:1:\"0\";s:12:\"blog-related\";s:1:\"3\";s:20:\"blog-related-columns\";s:1:\"3\";s:19:\"blog-related-images\";s:0:\"\";s:20:\"single-intro-padding\";s:0:\"\";s:15:\"portfolio-posts\";s:2:\"15\";s:16:\"portfolio-layout\";s:13:\"masonry-hover\";s:17:\"portfolio-columns\";s:1:\"3\";s:20:\"portfolio-full-width\";s:1:\"1\";s:14:\"portfolio-page\";s:0:\"\";s:17:\"portfolio-orderby\";s:4:\"date\";s:15:\"portfolio-order\";s:4:\"DESC\";s:18:\"portfolio-external\";s:0:\"\";s:21:\"portfolio-hover-title\";s:1:\"0\";s:14:\"portfolio-meta\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:19:\"portfolio-load-more\";s:1:\"1\";s:17:\"portfolio-filters\";s:1:\"1\";s:17:\"portfolio-isotope\";s:1:\"1\";s:22:\"portfolio-single-title\";s:1:\"0\";s:17:\"portfolio-related\";s:1:\"1\";s:25:\"portfolio-related-columns\";s:0:\"\";s:18:\"portfolio-comments\";s:1:\"0\";s:23:\"portfolio-single-layout\";s:0:\"\";s:21:\"portfolio-single-menu\";s:1:\"0\";s:14:\"portfolio-slug\";s:14:\"portfolio-item\";s:13:\"portfolio-tax\";s:15:\"portfolio-types\";s:13:\"shop-products\";s:2:\"12\";s:11:\"shop-layout\";s:4:\"grid\";s:14:\"shop-catalogue\";s:1:\"0\";s:11:\"shop-images\";s:0:\"\";s:11:\"shop-button\";s:1:\"0\";s:12:\"shop-excerpt\";s:1:\"0\";s:12:\"shop-sidebar\";s:0:\"\";s:11:\"shop-slider\";s:0:\"\";s:12:\"shop-soldout\";s:0:\"\";s:18:\"shop-product-style\";s:0:\"\";s:17:\"shop-single-image\";s:0:\"\";s:18:\"shop-product-title\";s:0:\"\";s:12:\"shop-related\";s:1:\"1\";s:9:\"shop-cart\";s:11:\"icon-basket\";s:29:\"featured-blog-portfolio-width\";s:0:\"\";s:30:\"featured-blog-portfolio-height\";s:0:\"\";s:28:\"featured-blog-portfolio-crop\";s:4:\"crop\";s:21:\"featured-single-width\";s:0:\"\";s:22:\"featured-single-height\";s:0:\"\";s:20:\"featured-single-crop\";s:4:\"crop\";s:13:\"page-comments\";s:1:\"0\";s:13:\"error404-icon\";s:17:\"icon-traffic-cone\";s:13:\"error404-page\";s:0:\"\";s:12:\"construction\";s:1:\"0\";s:18:\"construction-title\";s:11:\"Coming Soon\";s:17:\"construction-text\";s:0:\"\";s:17:\"construction-date\";s:19:\"12/30/2014 12:00:00\";s:19:\"construction-offset\";s:1:\"0\";s:20:\"construction-contact\";s:0:\"\";s:17:\"construction-page\";s:0:\"\";s:13:\"footer-layout\";s:0:\"\";s:12:\"footer-style\";s:0:\"\";s:14:\"footer-padding\";s:0:\"\";s:14:\"footer-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:13:\"footer-bg-img\";s:0:\"\";s:22:\"footer-bg-img-position\";s:22:\"no-repeat;center top;;\";s:18:\"footer-bg-img-size\";s:4:\"auto\";s:21:\"footer-call-to-action\";s:0:\"\";s:11:\"footer-copy\";s:54:\"© 2021 Afridev Capital Partners. All Rights Reserved.\";s:11:\"footer-hide\";s:6:\"center\";s:12:\"back-top-top\";s:4:\"hide\";s:18:\"popup-contact-form\";s:0:\"\";s:23:\"popup-contact-form-icon\";s:14:\"icon-mail-line\";s:10:\"responsive\";s:1:\"1\";s:17:\"mobile-grid-width\";s:0:\"\";s:20:\"font-size-responsive\";s:1:\"1\";s:15:\"responsive-zoom\";s:1:\"0\";s:19:\"responsive-boxed2fw\";s:1:\"0\";s:13:\"no-section-bg\";s:0:\"\";s:19:\"responsive-parallax\";s:1:\"0\";s:23:\"builder-section-padding\";s:0:\"\";s:19:\"builder-wrap-moveup\";s:0:\"\";s:12:\"footer-align\";s:0:\"\";s:19:\"responsive-logo-img\";s:0:\"\";s:26:\"responsive-retina-logo-img\";s:0:\"\";s:26:\"responsive-sticky-logo-img\";s:0:\"\";s:33:\"responsive-sticky-retina-logo-img\";s:0:\"\";s:24:\"responsive-header-tablet\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:24:\"responsive-header-mobile\";a:3:{s:9:\"post-meta\";s:1:\"1\";s:7:\"minimal\";s:7:\"minimal\";s:6:\"sticky\";s:6:\"sticky\";}s:20:\"mobile-header-height\";s:0:\"\";s:24:\"mobile-subheader-padding\";s:0:\"\";s:25:\"responsive-header-minimal\";s:5:\"mr-ll\";s:18:\"responsive-top-bar\";s:4:\"hide\";s:19:\"mobile-menu-initial\";s:4:\"1240\";s:11:\"mobile-menu\";s:1:\"0\";s:22:\"responsive-mobile-menu\";s:10:\"side-slide\";s:27:\"responsive-side-slide-width\";s:0:\"\";s:21:\"responsive-side-slide\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:16:\"header-menu-text\";s:0:\"\";s:25:\"header-menu-mobile-sticky\";s:1:\"0\";s:16:\"google-analytics\";s:0:\"\";s:14:\"facebook-pixel\";s:0:\"\";s:18:\"google-remarketing\";s:0:\"\";s:7:\"mfn-seo\";s:1:\"1\";s:16:\"meta-description\";s:45:\"BePainter | Best WordPress theme for painters\";s:13:\"meta-keywords\";s:0:\"\";s:16:\"mfn-seo-og-image\";s:0:\"\";s:13:\"seo-fb-app-id\";s:0:\"\";s:19:\"mfn-seo-schema-type\";s:1:\"0\";s:11:\"social-attr\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:12:\"social-skype\";s:0:\"\";s:15:\"social-whatsapp\";s:0:\"\";s:15:\"social-facebook\";s:0:\"\";s:14:\"social-twitter\";s:0:\"\";s:12:\"social-vimeo\";s:0:\"\";s:14:\"social-youtube\";s:0:\"\";s:13:\"social-flickr\";s:0:\"\";s:15:\"social-linkedin\";s:0:\"\";s:16:\"social-pinterest\";s:0:\"\";s:15:\"social-dribbble\";s:0:\"\";s:16:\"social-instagram\";s:0:\"\";s:15:\"social-snapchat\";s:0:\"\";s:14:\"social-behance\";s:0:\"\";s:13:\"social-tumblr\";s:0:\"\";s:18:\"social-tripadvisor\";s:0:\"\";s:16:\"social-vkontakte\";s:0:\"\";s:13:\"social-viadeo\";s:0:\"\";s:11:\"social-xing\";s:0:\"\";s:18:\"social-custom-icon\";s:0:\"\";s:18:\"social-custom-link\";s:0:\"\";s:19:\"social-custom-title\";s:0:\"\";s:10:\"social-rss\";s:1:\"0\";s:9:\"cf7-error\";s:0:\"\";s:8:\"parallax\";s:6:\"enllax\";s:19:\"prettyphoto-options\";a:1:{s:9:\"post-meta\";s:1:\"1\";}s:18:\"sc-gallery-disable\";s:1:\"0\";s:10:\"plugin-rev\";s:0:\"\";s:13:\"plugin-visual\";s:0:\"\";s:12:\"plugin-layer\";s:0:\"\";s:4:\"skin\";s:6:\"custom\";s:9:\"color-one\";s:7:\"#2991D6\";s:15:\"background-html\";s:7:\"#FCFCFC\";s:15:\"background-body\";s:7:\"#FCFCFC\";s:17:\"background-header\";s:7:\"#000119\";s:19:\"background-top-left\";s:7:\"#001021\";s:21:\"background-top-middle\";s:7:\"#e3e3e3\";s:20:\"background-top-right\";s:7:\"#eeee22\";s:17:\"color-top-right-a\";s:7:\"#444444\";s:14:\"border-top-bar\";s:0:\"\";s:17:\"background-search\";s:7:\"#d67c39\";s:20:\"background-subheader\";s:7:\"#000000\";s:15:\"color-subheader\";s:7:\"#ffffff\";s:12:\"color-menu-a\";s:7:\"#ffffff\";s:19:\"color-menu-a-active\";s:7:\"#007db8\";s:24:\"background-menu-a-active\";s:7:\"#F2F2F2\";s:18:\"background-submenu\";s:7:\"#F2F2F2\";s:15:\"color-submenu-a\";s:7:\"#5f5f5f\";s:21:\"color-submenu-a-hover\";s:7:\"#2e2e2e\";s:26:\"color-menu-responsive-icon\";s:7:\"#007db8\";s:31:\"background-menu-responsive-icon\";s:0:\"\";s:23:\"background-overlay-menu\";s:7:\"#d67c39\";s:25:\"background-overlay-menu-a\";s:7:\"#ffffff\";s:32:\"background-overlay-menu-a-active\";s:7:\"#B1DCFB\";s:17:\"border-menu-plain\";s:7:\"#F2F2F2\";s:20:\"background-side-menu\";s:7:\"#001021\";s:17:\"color-side-menu-a\";s:7:\"#ffffff\";s:23:\"color-side-menu-a-hover\";s:7:\"#007db8\";s:21:\"background-action-bar\";s:7:\"#2C2C2C\";s:16:\"color-action-bar\";s:7:\"#bbbbbb\";s:18:\"color-action-bar-a\";s:7:\"#0095eb\";s:24:\"color-action-bar-a-hover\";s:7:\"#007cc3\";s:23:\"color-action-bar-social\";s:7:\"#bbbbbb\";s:29:\"color-action-bar-social-hover\";s:7:\"#FFFFFF\";s:28:\"mobile-background-action-bar\";s:7:\"#FFFFFF\";s:23:\"mobile-color-action-bar\";s:7:\"#222222\";s:25:\"mobile-color-action-bar-a\";s:7:\"#0095eb\";s:31:\"mobile-color-action-bar-a-hover\";s:7:\"#007cc3\";s:30:\"mobile-color-action-bar-social\";s:7:\"#bbbbbb\";s:36:\"mobile-color-action-bar-social-hover\";s:7:\"#777777\";s:11:\"color-theme\";s:7:\"#007db8\";s:10:\"color-text\";s:7:\"#8c8c8c\";s:15:\"color-selection\";s:7:\"#0095eb\";s:7:\"color-a\";s:7:\"#d67c39\";s:13:\"color-a-hover\";s:7:\"#bd6625\";s:16:\"color-fancy-link\";s:7:\"#656B6F\";s:21:\"background-fancy-link\";s:7:\"#d67c39\";s:22:\"color-fancy-link-hover\";s:7:\"#d67c39\";s:27:\"background-fancy-link-hover\";s:7:\"#bd6625\";s:17:\"border-imageframe\";s:7:\"#f8f8f8\";s:26:\"background-imageframe-link\";s:7:\"#d67c39\";s:21:\"color-imageframe-link\";s:7:\"#ffffff\";s:21:\"color-imageframe-mask\";s:7:\"#ffffff\";s:20:\"background-highlight\";s:7:\"#d67c39\";s:8:\"color-hr\";s:7:\"#000000\";s:10:\"color-list\";s:7:\"#737E86\";s:10:\"color-note\";s:7:\"#a8a8a8\";s:28:\"background-highlight-section\";s:7:\"#d67c39\";s:18:\"color-footer-theme\";s:7:\"#532809\";s:17:\"background-footer\";s:7:\"#000000\";s:12:\"color-footer\";s:7:\"#9e9e9e\";s:20:\"color-footer-heading\";s:7:\"#ffffff\";s:17:\"color-footer-note\";s:7:\"#a8a8a8\";s:16:\"border-copyright\";s:21:\"rgba(255,255,255,0.1)\";s:14:\"color-footer-a\";s:7:\"#9e9e9e\";s:20:\"color-footer-a-hover\";s:7:\"#007db8\";s:19:\"color-footer-social\";s:7:\"#65666C\";s:25:\"color-footer-social-hover\";s:7:\"#FFFFFF\";s:22:\"color-footer-backtotop\";s:7:\"#65666C\";s:27:\"background-footer-backtotop\";s:0:\"\";s:23:\"color-sliding-top-theme\";s:7:\"#d67c39\";s:22:\"background-sliding-top\";s:7:\"#545454\";s:17:\"color-sliding-top\";s:7:\"#cccccc\";s:19:\"color-sliding-top-a\";s:7:\"#d67c39\";s:25:\"color-sliding-top-a-hover\";s:7:\"#bd6625\";s:25:\"color-sliding-top-heading\";s:7:\"#ffffff\";s:22:\"color-sliding-top-note\";s:7:\"#a8a8a8\";s:8:\"color-h1\";s:7:\"#210e01\";s:8:\"color-h2\";s:7:\"#532809\";s:8:\"color-h3\";s:7:\"#532809\";s:8:\"color-h4\";s:7:\"#9e6033\";s:8:\"color-h5\";s:7:\"#737373\";s:8:\"color-h6\";s:7:\"#532809\";s:15:\"color-tab-title\";s:7:\"#d67c39\";s:16:\"color-blockquote\";s:7:\"#444444\";s:21:\"background-getintouch\";s:7:\"#d67c39\";s:17:\"color-contentlink\";s:7:\"#d67c39\";s:13:\"color-counter\";s:7:\"#d67c39\";s:13:\"color-iconbar\";s:7:\"#d67c39\";s:13:\"color-iconbox\";s:7:\"#d67c39\";s:15:\"color-list-icon\";s:7:\"#d67c39\";s:19:\"color-pricing-price\";s:7:\"#d67c39\";s:27:\"background-pricing-featured\";s:7:\"#d67c39\";s:22:\"background-progressbar\";s:7:\"#d67c39\";s:22:\"color-quickfact-number\";s:7:\"#d67c39\";s:27:\"background-slidingbox-title\";s:7:\"#d67c39\";s:27:\"background-trailer-subtitle\";s:7:\"#d67c39\";s:10:\"color-form\";s:7:\"#626262\";s:15:\"background-form\";s:7:\"#FFFFFF\";s:11:\"border-form\";s:7:\"#EBEBEB\";s:22:\"color-form-placeholder\";s:7:\"#929292\";s:16:\"color-form-focus\";s:7:\"#1982c2\";s:21:\"background-form-focus\";s:7:\"#e9f5fc\";s:17:\"border-form-focus\";s:7:\"#d5e5ee\";s:28:\"color-form-placeholder-focus\";s:7:\"#929292\";s:17:\"form-border-width\";s:0:\"\";s:18:\"form-border-radius\";s:0:\"\";s:16:\"form-transparent\";s:0:\"\";s:12:\"font-content\";s:5:\"Rubik\";s:9:\"font-menu\";s:5:\"Rubik\";s:10:\"font-title\";s:18:\"Cormorant Garamond\";s:13:\"font-headings\";s:18:\"Cormorant Garamond\";s:19:\"font-headings-small\";s:5:\"Rubik\";s:15:\"font-blockquote\";s:5:\"Rubik\";s:15:\"font-decorative\";s:5:\"Rubik\";s:11:\"font-weight\";a:9:{s:9:\"post-meta\";s:1:\"1\";i:300;s:3:\"300\";s:9:\"300italic\";s:9:\"300italic\";i:400;s:3:\"400\";s:9:\"400italic\";s:9:\"400italic\";i:600;s:3:\"600\";s:9:\"600italic\";s:9:\"600italic\";i:700;s:3:\"700\";s:9:\"700italic\";s:9:\"700italic\";}s:11:\"font-subset\";s:0:\"\";s:17:\"font-size-content\";a:4:{s:4:\"size\";s:2:\"14\";s:11:\"line_height\";s:2:\"21\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:13:\"font-size-big\";a:4:{s:4:\"size\";s:2:\"16\";s:11:\"line_height\";s:2:\"28\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:14:\"font-size-menu\";a:3:{s:4:\"size\";s:2:\"17\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:15:\"font-size-title\";a:4:{s:4:\"size\";s:2:\"45\";s:11:\"line_height\";s:2:\"55\";s:12:\"weight_style\";s:3:\"500\";s:14:\"letter_spacing\";s:1:\"0\";}s:12:\"font-size-h1\";a:4:{s:4:\"size\";s:2:\"64\";s:11:\"line_height\";s:2:\"64\";s:12:\"weight_style\";s:3:\"600\";s:14:\"letter_spacing\";s:1:\"0\";}s:12:\"font-size-h2\";a:4:{s:4:\"size\";s:2:\"42\";s:11:\"line_height\";s:2:\"42\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:12:\"font-size-h3\";a:4:{s:4:\"size\";s:2:\"34\";s:11:\"line_height\";s:2:\"36\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:12:\"font-size-h4\";a:4:{s:4:\"size\";s:2:\"22\";s:11:\"line_height\";s:2:\"28\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:12:\"font-size-h5\";a:4:{s:4:\"size\";s:2:\"18\";s:11:\"line_height\";s:2:\"22\";s:12:\"weight_style\";s:3:\"300\";s:14:\"letter_spacing\";s:1:\"0\";}s:12:\"font-size-h6\";a:4:{s:4:\"size\";s:2:\"14\";s:11:\"line_height\";s:2:\"19\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:22:\"font-size-single-intro\";a:4:{s:4:\"size\";s:2:\"70\";s:11:\"line_height\";s:2:\"70\";s:12:\"weight_style\";s:3:\"400\";s:14:\"letter_spacing\";s:1:\"0\";}s:11:\"font-custom\";s:0:\"\";s:16:\"font-custom-woff\";s:0:\"\";s:15:\"font-custom-ttf\";s:0:\"\";s:12:\"font-custom2\";s:0:\"\";s:17:\"font-custom2-woff\";s:0:\"\";s:16:\"font-custom2-ttf\";s:0:\"\";s:9:\"translate\";s:1:\"1\";s:28:\"translate-search-placeholder\";s:17:\"Enter your search\";s:24:\"translate-search-results\";s:18:\"results found for:\";s:14:\"translate-home\";s:4:\"Home\";s:14:\"translate-prev\";s:9:\"Prev page\";s:14:\"translate-next\";s:9:\"Next page\";s:19:\"translate-load-more\";s:9:\"Load more\";s:17:\"translate-wpml-no\";s:39:\"No translations available for this page\";s:15:\"translate-share\";s:0:\"\";s:16:\"translate-before\";s:0:\"\";s:15:\"translate-after\";s:0:\"\";s:14:\"translate-days\";s:4:\"days\";s:15:\"translate-hours\";s:5:\"hours\";s:17:\"translate-minutes\";s:7:\"minutes\";s:17:\"translate-seconds\";s:7:\"seconds\";s:16:\"translate-filter\";s:9:\"Filter by\";s:14:\"translate-tags\";s:4:\"Tags\";s:17:\"translate-authors\";s:7:\"Authors\";s:13:\"translate-all\";s:8:\"Show all\";s:18:\"translate-item-all\";s:3:\"All\";s:19:\"translate-published\";s:12:\"Published by\";s:12:\"translate-at\";s:2:\"at\";s:20:\"translate-categories\";s:10:\"Categories\";s:18:\"translate-readmore\";s:9:\"Read more\";s:14:\"translate-like\";s:15:\"Do you like it?\";s:17:\"translate-related\";s:13:\"Related posts\";s:16:\"translate-client\";s:6:\"Client\";s:14:\"translate-date\";s:4:\"Date\";s:17:\"translate-website\";s:7:\"Website\";s:14:\"translate-view\";s:12:\"View website\";s:14:\"translate-task\";s:4:\"Task\";s:22:\"translate-commented-on\";s:0:\"\";s:19:\"translate-404-title\";s:18:\"Ooops... Error 404\";s:22:\"translate-404-subtitle\";s:62:\"We are sorry, but the page you are looking for does not exist.\";s:18:\"translate-404-text\";s:45:\"Please check entered address and try again or\";s:17:\"translate-404-btn\";s:14:\"go to homepage\";s:22:\"translate-search-title\";s:0:\"\";s:25:\"translate-search-subtitle\";s:0:\"\";s:10:\"custom-css\";s:1407:\".p-areas-small {
\n    font-family: \'Rubik\';
\n    display: block;
\n    font-size: 16px;
\n    line-height: 30px;
\n    font-weight: 400;
\n    margin-top: 30px;
\n}
\n.testimonials_slider .button_icon i {
\n    color: #fff !important;
\n}
\n.heartbeat:hover {
\n	-webkit-animation: heartbeat 2s ease-in-out 1 both;
\n	        animation: heartbeat 2s ease-in-out 1 both;
\n}
\n
\n@keyframes heartbeat {
\n  from {
\n    -webkit-transform: scale(1);
\n            transform: scale(1);
\n    -webkit-transform-origin: center center;
\n            transform-origin: center center;
\n    -webkit-animation-timing-function: ease-out;
\n            animation-timing-function: ease-out;
\n  }
\n  10% {
\n    -webkit-transform: scale(0.91);
\n            transform: scale(0.91);
\n    -webkit-animation-timing-function: ease-in;
\n            animation-timing-function: ease-in;
\n  }
\n  17% {
\n    -webkit-transform: scale(0.98);
\n            transform: scale(0.98);
\n    -webkit-animation-timing-function: ease-out;
\n            animation-timing-function: ease-out;
\n  }
\n  33% {
\n    -webkit-transform: scale(0.87);
\n            transform: scale(0.87);
\n    -webkit-animation-timing-function: ease-in;
\n            animation-timing-function: ease-in;
\n  }
\n  45% {
\n    -webkit-transform: scale(1);
\n            transform: scale(1);
\n    -webkit-animation-timing-function: ease-out;
\n            animation-timing-function: ease-out;
\n  }
\n}\";s:9:\"custom-js\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("271","revslider-stable-version","4.2.0","yes");
INSERT INTO `wp_options` VALUES("272","revslider-notices","a:3:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:546:\"<div style=\"display: block; background: #fff;text-align: center; height: 250px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 960px; height: 250px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"https://sliderrevolution.com/wp-content/uploads/2021/07/adminpremiumvid4.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6511-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.9.9\";s:4:\"text\";s:556:\"<div style=\"display: block; background: #fff;text-align: center; \nheight: 300px;\"><a \nhref=\"https://www.sliderrevolution.com/slider-revolution-visual-editor-version-6-6/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=update66\"\n target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: \ncover; background-size: cover; opacity: 1; width: 920px; height: 300px; \ndisplay: inline-block;\" muted loop autoplay \npreload=\"auto\"><source src=\"//updates.themepunch.tools//banners/rs60/update66videobanner2.mp4\" type=\"video/mp4\"></video></a></div>\n\";s:4:\"code\";s:8:\"TPRSV663\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:556:\"<div style=\"display: block; background: #fff;text-align: center; \nheight: 300px;\"><a \nhref=\"https://www.sliderrevolution.com/slider-revolution-visual-editor-version-6-6/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=update66\"\n target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: \ncover; background-size: cover; opacity: 1; width: 920px; height: 300px; \ndisplay: inline-block;\" muted loop autoplay \npreload=\"auto\"><source src=\"//updates.themepunch.tools//banners/rs60/update66videobanner2.mp4\" type=\"video/mp4\"></video></a></div>\n\";s:4:\"code\";s:8:\"TPRSV668\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}","yes");
INSERT INTO `wp_options` VALUES("1316","revslider-additions","O:8:\"stdClass\":1:{s:7:\"selling\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("1317","rs-addons-counter","4","yes");
INSERT INTO `wp_options` VALUES("268","https_detection_errors","a:0:{}","off");
INSERT INTO `wp_options` VALUES("147","finished_updating_comment_type","1","yes");
INSERT INTO `wp_options` VALUES("9455","db_upgraded","","on");
INSERT INTO `wp_options` VALUES("317","elementor_log","a:28:{s:32:\"5a9f6af92bc2e305f41fc167e65c89d0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-03-12 16:54:48\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.1\";s:2:\"to\";s:5:\"3.1.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-03-12 16:54:48\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.1\";s:2:\"to\";s:5:\"3.1.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2cc3fadf832176ee6086ee0cb2692535\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2021-03-19 03:36:50\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:21:\"Undefined index: data\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-03-19 03:36:50\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:21:\"Undefined index: data\";s:4:\"file\";s:99:\"/home/firskwfy/public_html/afridev/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:4:\"line\";i:171;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:99:\"/home/firskwfy/public_html/afridev/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:7:\"\0*\0line\";i:171;}s:32:\"186ec33fd4fe1473291991d27811af4e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"0b79b57fbbcb6f5e732d9ab6578535c7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"a9d57e398ab3fe2be2f94b0387204da8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"fe0487dd89046879739d4cd8c5173879\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"Elementor/Upgrades - _v_3_2_0_migrate_breakpoints_to_new_system Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"Elementor/Upgrades - _v_3_2_0_migrate_breakpoints_to_new_system Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"cb2387a239d4583a60bf99c887de7edc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:72:\"Elementor/Upgrades - _v_3_2_0_migrate_breakpoints_to_new_system Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:72:\"Elementor/Upgrades - _v_3_2_0_migrate_breakpoints_to_new_system Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"32286bba6382ff3e3fdce1c7992e5274\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:81:\"Elementor/Upgrades - _v_3_4_8_fix_font_awesome_default_value_from_1_to_yes Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:81:\"Elementor/Upgrades - _v_3_4_8_fix_font_awesome_default_value_from_1_to_yes Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"d801ec87865c44de54082267f94d15f6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:83:\"Elementor/Upgrades - _v_3_4_8_fix_font_awesome_default_value_from_1_to_yes Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:83:\"Elementor/Upgrades - _v_3_4_8_fix_font_awesome_default_value_from_1_to_yes Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"fcfabbe5b7caac735c6d61a89c2193b2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:64:\"Elementor/Upgrades - _v_3_5_0_remove_old_elementor_scheme Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:64:\"Elementor/Upgrades - _v_3_5_0_remove_old_elementor_scheme Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"c6d0435d1a9f04d94a6587deeface477\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:66:\"Elementor/Upgrades - _v_3_5_0_remove_old_elementor_scheme Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:66:\"Elementor/Upgrades - _v_3_5_0_remove_old_elementor_scheme Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"4fe8a62f7ae804f20b27d29661ca3e9c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:63:\"Elementor/Upgrades - _v_3_8_0_fix_php8_image_custom_size Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:63:\"Elementor/Upgrades - _v_3_8_0_fix_php8_image_custom_size Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"bf8a84d2ef85d753900c8e0c6cda5730\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:65:\"Elementor/Upgrades - _v_3_8_0_fix_php8_image_custom_size Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:65:\"Elementor/Upgrades - _v_3_8_0_fix_php8_image_custom_size Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"5ed17e8012fd0476e1e2b9ef6b8df402\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:6:\"3.11.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:6:\"3.11.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b41e27b8c115893b64f208794f1e47c7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-03-24 19:09:09\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:6:\"3.11.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-03-24 19:09:09\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:5:\"3.1.4\";s:2:\"to\";s:6:\"3.11.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"fef097cefb12f315a687bf6d40523f7d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-04-28 07:33:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-04-28 07:33:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"d09acd8d311517d2cdc48941bf8c58a5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-04-28 07:33:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-04-28 07:33:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"cba60b5baf964b60430d8775fb33e602\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-04-28 07:33:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-04-28 07:33:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c99486869bd0f84a3c7933db0cd89911\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-04-28 07:33:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.11.5\";s:2:\"to\";s:6:\"3.12.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-04-28 07:33:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.11.5\";s:2:\"to\";s:6:\"3.12.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"144094ee4ddd5d9e5f3425c5be1937bb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-04-28 07:33:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.11.5\";s:2:\"to\";s:6:\"3.12.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-04-28 07:33:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.11.5\";s:2:\"to\";s:6:\"3.12.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d3e8f5e68ef5df6235f76497d685518e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-16 16:05:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-16 16:05:37\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"1c4aa7919f680d654d3b909a00bccd9f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-16 16:05:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-16 16:05:37\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"3408dd6d6459790342f6aa1c8964c73d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-16 16:05:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-16 16:05:37\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"5c8883e05a9819d37bca324f8e22cc57\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-16 16:05:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-16 16:05:37\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2e7c6d2a7a4c07dd4335c1f055bc789a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-16 16:05:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-16 16:05:37\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"98fb3ede8be6bb3c52d891d74f65ba3d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-16 16:05:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-16 16:05:38\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.12.2\";s:2:\"to\";s:6:\"3.13.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"82952d85ee39aacbcaf61849da819747\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2023-12-04 09:52:19\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2023-12-04 09:52:19\";i:1;s:19:\"2023-12-04 09:56:30\";i:2;s:19:\"2023-12-04 19:07:34\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:51:\"Trying to access array offset on value of type null\";s:4:\"file\";s:95:\"/home/zilllzus/afridevcapital.com/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:1576;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:95:\"/home/zilllzus/afridevcapital.com/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:1576;}s:32:\"780d24dc506bdce3ada8389b622f6a11\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2023-12-04 10:09:45\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:74:\"Cannot read properties of null (reading &#039;getBoundingClientRect&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-12-04 10:09:45\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1701684585\";s:7:\"message\";s:64:\"Cannot read properties of null (reading \'getBoundingClientRect\')\";s:3:\"url\";s:93:\"http://www.afridevcapital.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.13.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1097282\";}s:7:\"\0*\0file\";s:93:\"http://www.afridevcapital.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.13.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:7:\"1097282\";}}","no");
INSERT INTO `wp_options` VALUES("296","_elementor_installed_time","1615567914","yes");
INSERT INTO `wp_options` VALUES("297","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","off");
INSERT INTO `wp_options` VALUES("79241","elementor_checklist","{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}","auto");
INSERT INTO `wp_options` VALUES("86063","_elementor_element_cache_unique_id","fd1f76245f71bfdc72442ed61c88df68","auto");
INSERT INTO `wp_options` VALUES("12120","WPLANG","","yes");
INSERT INTO `wp_options` VALUES("12121","new_admin_email","ayobamioke@gmail.com","yes");
INSERT INTO `wp_options` VALUES("12122","adminhash","a:2:{s:4:\"hash\";s:32:\"17e824b20238fadce2220d73a4c84d70\";s:8:\"newemail\";s:20:\"ayobamioke@gmail.com\";}","off");
INSERT INTO `wp_options` VALUES("220","elementor_active_kit","2250","yes");
INSERT INTO `wp_options` VALUES("269","revslider-connection","1","yes");
INSERT INTO `wp_options` VALUES("270","revslider-latest-version","6.6.16","yes");
INSERT INTO `wp_options` VALUES("217","elementor_version","3.13.2","yes");
INSERT INTO `wp_options` VALUES("218","elementor_install_history","a:5:{s:5:\"3.1.1\";i:1614286032;s:5:\"3.1.4\";i:1615568088;s:6:\"3.11.5\";i:1679684949;s:6:\"3.12.2\";i:1682667193;s:6:\"3.13.2\";i:1684253137;}","yes");
INSERT INTO `wp_options` VALUES("153","wpcf7","a:2:{s:7:\"version\";s:5:\"6.1.2\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1614282289;s:7:\"version\";s:3:\"5.4\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}","yes");
INSERT INTO `wp_options` VALUES("154","revslider-update-check-short","1694229743","yes");
INSERT INTO `wp_options` VALUES("155","revslider-templates-check","1694229743","yes");
INSERT INTO `wp_options` VALUES("160","revslider-library-check","1694229743","yes");
INSERT INTO `wp_options` VALUES("161","rs-library","a:3:{s:4:\"hash\";s:32:\"0fbedf953c0042911e0f27a364cf4227\";s:7:\"objects\";a:179:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}","no");
INSERT INTO `wp_options` VALUES("162","revslider_checktables","1","yes");
INSERT INTO `wp_options` VALUES("163","rs_tables_created","1","yes");
INSERT INTO `wp_options` VALUES("164","revslider_table_version","1.0.8","yes");
INSERT INTO `wp_options` VALUES("165","revslider-global-settings","{\"version\":\"6.2.0\",\"permission\":\"admin\",\"includeids\":\"\",\"script\":{\"footer\":false,\"defer\":false,\"full\":false},\"fonturl\":\"\",\"size\":{\"desktop\":1240,\"notebook\":1024,\"tablet\":778,\"mobile\":480}}","yes");
INSERT INTO `wp_options` VALUES("166","revslider_update_version","6.2.0","yes");
INSERT INTO `wp_options` VALUES("167","widget_rev-slider-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("168","recently_activated","a:0:{}","off");
INSERT INTO `wp_options` VALUES("169","duplicate_post_copytitle","1","yes");
INSERT INTO `wp_options` VALUES("170","duplicate_post_copydate","0","yes");
INSERT INTO `wp_options` VALUES("171","duplicate_post_copystatus","0","yes");
INSERT INTO `wp_options` VALUES("172","duplicate_post_copyslug","0","yes");
INSERT INTO `wp_options` VALUES("173","duplicate_post_copyexcerpt","1","yes");
INSERT INTO `wp_options` VALUES("174","duplicate_post_copycontent","1","yes");
INSERT INTO `wp_options` VALUES("175","duplicate_post_copythumbnail","1","yes");
INSERT INTO `wp_options` VALUES("176","duplicate_post_copytemplate","1","yes");
INSERT INTO `wp_options` VALUES("177","duplicate_post_copyformat","1","yes");
INSERT INTO `wp_options` VALUES("178","duplicate_post_copyauthor","0","yes");
INSERT INTO `wp_options` VALUES("179","duplicate_post_copypassword","0","yes");
INSERT INTO `wp_options` VALUES("180","duplicate_post_copyattachments","0","yes");
INSERT INTO `wp_options` VALUES("181","duplicate_post_copychildren","0","yes");
INSERT INTO `wp_options` VALUES("182","duplicate_post_copycomments","0","yes");
INSERT INTO `wp_options` VALUES("183","duplicate_post_copymenuorder","1","yes");
INSERT INTO `wp_options` VALUES("184","duplicate_post_taxonomies_blacklist","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("185","duplicate_post_blacklist","","yes");
INSERT INTO `wp_options` VALUES("186","duplicate_post_types_enabled","a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}","yes");
INSERT INTO `wp_options` VALUES("187","duplicate_post_show_original_column","0","yes");
INSERT INTO `wp_options` VALUES("188","duplicate_post_show_original_in_post_states","0","yes");
INSERT INTO `wp_options` VALUES("189","duplicate_post_show_original_meta_box","0","yes");
INSERT INTO `wp_options` VALUES("190","duplicate_post_show_link","a:3:{s:9:\"new_draft\";s:1:\"1\";s:5:\"clone\";s:1:\"1\";s:17:\"rewrite_republish\";s:1:\"1\";}","yes");
INSERT INTO `wp_options` VALUES("191","duplicate_post_show_link_in","a:4:{s:3:\"row\";s:1:\"1\";s:8:\"adminbar\";s:1:\"1\";s:9:\"submitbox\";s:1:\"1\";s:11:\"bulkactions\";s:1:\"1\";}","yes");
INSERT INTO `wp_options` VALUES("192","duplicate_post_show_notice","0","no");
INSERT INTO `wp_options` VALUES("56642","duplicate_post_version","4.5","auto");
INSERT INTO `wp_options` VALUES("194","category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("195","client-types_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("196","offer-types_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("197","portfolio-types_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("198","slide-types_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("199","testimonial-types_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("265","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"ayobamioke@gmail.com\";s:7:\"version\";s:5:\"6.8.3\";s:9:\"timestamp\";i:1759260941;}","off");
INSERT INTO `wp_options` VALUES("273","revslider-dashboard","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("274","revslider-addons","O:8:\"stdClass\":25:{s:25:\"revslider-particles-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:1:\"7\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2020-08-13\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"20\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2020-08-11\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"15\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2020-10-17\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:1:\"3\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"5.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2020-06-18\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"21\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2020-05-05\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"23\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2020-06-14\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"13\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2020-05-05\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"10\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2020-05-08\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:1:\"4\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2020-01-30\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"19\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"17\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2020-10-07\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:69:\"//updates.themepunch.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"22\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2020-07-16\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:1:\"5\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"1.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2020-02-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"14\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:69:\"//updates.themepunch.tools/revslider/addons/images/polyfold-addon.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"304\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/reload-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"303\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch.tools/revslider/addons/images/related-posts-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:1:\"6\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:65:\"//updates.themepunch.tools/revslider/addons/images/snow-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:1:\"2\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/wp-gallery-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"302\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2020-01-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:67:\"//updates.themepunch.tools/revslider/addons/images/backup-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:1:\"1\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2022-01-01\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch.tools/revslider/addons/images/404-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:1:\"9\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:69:\"//updates.themepunch.tools/revslider/addons/images/adjacent-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"11\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:66:\"//updates.themepunch.tools/revslider/addons/images/login-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"12\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"16\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/revslider/addons/images/weather-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"18\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/revslider/addons/images/duotone-addon.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}}","yes");
INSERT INTO `wp_options` VALUES("298","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off");
INSERT INTO `wp_options` VALUES("1318","revslider-library-hash","dae3de1eb57eeeee008b70e9a23844b5","yes");
INSERT INTO `wp_options` VALUES("544","elementor_allow_tracking","no","yes");
INSERT INTO `wp_options` VALUES("545","elementor_tracker_notice","1","yes");
INSERT INTO `wp_options` VALUES("354","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:1:{i:0;i:7;}}","off");
INSERT INTO `wp_options` VALUES("414","elementor_controls_usage","a:1:{s:7:\"wp-page\";a:12:{s:7:\"heading\";a:2:{s:5:\"count\";i:55;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:13:\"section_title\";a:3:{s:5:\"title\";i:55;s:11:\"header_size\";i:45;s:5:\"align\";i:23;}}s:5:\"style\";a:1:{s:19:\"section_title_style\";a:9:{s:11:\"title_color\";i:36;s:21:\"typography_typography\";i:55;s:22:\"typography_font_family\";i:55;s:20:\"typography_font_size\";i:55;s:22:\"typography_font_weight\";i:55;s:22:\"typography_line_height\";i:41;s:27:\"typography_font_size_mobile\";i:33;s:29:\"typography_line_height_mobile\";i:18;s:25:\"typography_text_transform\";i:1;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:5:{s:8:\"_padding\";i:12;s:15:\"_padding_tablet\";i:12;s:15:\"_padding_mobile\";i:13;s:7:\"_margin\";i:6;s:14:\"_margin_mobile\";i:6;}}}}s:6:\"column\";a:2:{s:5:\"count\";i:117;s:8:\"controls\";a:3:{s:6:\"layout\";a:1:{s:6:\"layout\";a:4:{s:12:\"_inline_size\";i:117;s:19:\"_inline_size_tablet\";i:16;s:16:\"content_position\";i:3;s:12:\"align_mobile\";i:1;}}s:5:\"style\";a:2:{s:13:\"section_style\";a:6:{s:21:\"background_background\";i:10;s:16:\"background_color\";i:1;s:16:\"background_image\";i:3;s:19:\"background_position\";i:3;s:17:\"background_repeat\";i:3;s:15:\"background_size\";i:3;}s:14:\"section_border\";a:2:{s:26:\"box_shadow_box_shadow_type\";i:1;s:21:\"box_shadow_box_shadow\";i:1;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:4:{s:11:\"css_classes\";i:6;s:13:\"margin_mobile\";i:1;s:6:\"margin\";i:3;s:7:\"padding\";i:3;}s:15:\"section_effects\";a:1:{s:9:\"animation\";i:1;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:80;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:10:{s:6:\"layout\";i:3;s:6:\"height\";i:1;s:12:\"height_inner\";i:12;s:3:\"gap\";i:15;s:19:\"custom_height_inner\";i:12;s:26:\"custom_height_inner_mobile\";i:12;s:16:\"content_position\";i:12;s:13:\"custom_height\";i:10;s:15:\"column_position\";i:9;s:20:\"custom_height_tablet\";i:1;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:28;}}s:5:\"style\";a:3:{s:18:\"section_background\";a:6:{s:21:\"background_background\";i:22;s:16:\"background_color\";i:19;s:16:\"background_image\";i:5;s:17:\"background_repeat\";i:4;s:15:\"background_size\";i:4;s:28:\"background_slideshow_gallery\";i:1;}s:26:\"section_background_overlay\";a:3:{s:29:\"background_overlay_background\";i:17;s:24:\"background_overlay_color\";i:5;s:26:\"background_overlay_opacity\";i:5;}s:14:\"section_border\";a:4:{s:13:\"border_border\";i:12;s:13:\"border_radius\";i:12;s:26:\"box_shadow_box_shadow_type\";i:12;s:21:\"box_shadow_box_shadow\";i:12;}}s:8:\"advanced\";a:2:{s:16:\"section_advanced\";a:6:{s:6:\"margin\";i:24;s:7:\"padding\";i:17;s:14:\"padding_tablet\";i:10;s:11:\"css_classes\";i:12;s:13:\"margin_mobile\";i:4;s:14:\"padding_mobile\";i:2;}s:19:\"_section_responsive\";a:1:{s:20:\"reverse_order_mobile\";i:2;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:17;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:17;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:8:{s:5:\"align\";i:3;s:10:\"text_color\";i:17;s:21:\"typography_typography\";i:17;s:22:\"typography_font_family\";i:17;s:20:\"typography_font_size\";i:17;s:22:\"typography_font_weight\";i:17;s:22:\"typography_line_height\";i:17;s:27:\"typography_font_size_mobile\";i:14;}}}}s:12:\"social-icons\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:19:\"section_social_icon\";a:3:{s:16:\"social_icon_list\";i:5;s:5:\"shape\";i:5;s:5:\"align\";i:1;}}s:5:\"style\";a:1:{s:20:\"section_social_style\";a:2:{s:10:\"icon_color\";i:5;s:18:\"icon_primary_color\";i:5;}}}}s:5:\"image\";a:2:{s:5:\"count\";i:14;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:13:\"section_image\";a:1:{s:5:\"image\";i:14;}}s:5:\"style\";a:1:{s:19:\"section_style_image\";a:1:{s:19:\"image_border_radius\";i:12;}}}}s:9:\"shortcode\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:17:\"section_shortcode\";a:1:{s:9:\"shortcode\";i:1;}}}}s:4:\"html\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:13:\"section_title\";a:1:{s:4:\"html\";i:1;}}}}s:6:\"button\";a:2:{s:5:\"count\";i:13;s:8:\"controls\";a:3:{s:7:\"content\";a:1:{s:14:\"section_button\";a:6:{s:4:\"text\";i:13;s:4:\"link\";i:13;s:5:\"align\";i:12;s:12:\"align_tablet\";i:10;s:4:\"size\";i:10;s:12:\"align_mobile\";i:9;}}s:5:\"style\";a:1:{s:13:\"section_style\";a:6:{s:21:\"typography_typography\";i:13;s:22:\"typography_font_family\";i:13;s:22:\"typography_font_weight\";i:13;s:16:\"background_color\";i:13;s:11:\"hover_color\";i:10;s:29:\"button_background_hover_color\";i:10;}}s:8:\"advanced\";a:1:{s:14:\"_section_style\";a:1:{s:7:\"_margin\";i:3;}}}}s:16:\"mfn_testimonials\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:16:\"advanced_section\";a:1:{s:11:\"hide_photos\";i:1;}}}}s:6:\"spacer\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_spacer\";a:1:{s:5:\"space\";i:1;}}}}s:4:\"icon\";a:2:{s:5:\"count\";i:14;s:8:\"controls\";a:2:{s:7:\"content\";a:1:{s:12:\"section_icon\";a:3:{s:13:\"selected_icon\";i:14;s:5:\"align\";i:14;s:12:\"align_mobile\";i:14;}}s:5:\"style\";a:1:{s:18:\"section_style_icon\";a:1:{s:13:\"primary_color\";i:14;}}}}}}","no");
INSERT INTO `wp_options` VALUES("968","revslider_server_refresh","1621881718","yes");
INSERT INTO `wp_options` VALUES("1315","revslider-update-hash","6ab9bd589c16250f6d5cf4ed7d8f3c6e","yes");
INSERT INTO `wp_options` VALUES("967","revslider_servers","a:7:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:22:\"themepunch-ext-b.tools\";i:4;s:22:\"themepunch-ext-b.tools\";i:5;s:22:\"themepunch-ext-b.tools\";i:6;s:16:\"themepunch.tools\";}","yes");
INSERT INTO `wp_options` VALUES("1319","revslider-templates-hash","b34e16da992470421084a8b82c104a98","yes");
INSERT INTO `wp_options` VALUES("1320","rs-templates-counter","0","no");
INSERT INTO `wp_options` VALUES("4997","secret_key","|Nr6zd5AywR!Dr/-=zlF,Svul 4JC-B<u0|/h?}OHSQmgW}H?A]Eny^Y&#;gIWmg","no");
INSERT INTO `wp_options` VALUES("15990","widget_widget_mfn_recent_comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("15991","widget_widget_mfn_flickr","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("15992","widget_widget_mfn_login","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("15993","widget_widget_mfn_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("15994","widget_widget_mfn_recent_posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("15995","widget_widget_mfn_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("15988","user_count","2","off");
INSERT INTO `wp_options` VALUES("9454","wp_force_deactivated_plugins","a:0:{}","off");
INSERT INTO `wp_options` VALUES("23631","rs-templates-new","","no");
INSERT INTO `wp_options` VALUES("23798","recovery_mode_email_last_sent","1701682155","yes");
INSERT INTO `wp_options` VALUES("16303","elementor_safe_mode_allowed_plugins","a:1:{s:9:\"elementor\";s:23:\"elementor/elementor.php\";}","yes");
INSERT INTO `wp_options` VALUES("16304","elementor_safe_mode_created_mu_dir","1","yes");
INSERT INTO `wp_options` VALUES("16305","elementor_safe_mode_token","e458cb6b8e7779c1750349e9ce11d38a933a161d6c8f8634d156a1d2a545b3b5","yes");
INSERT INTO `wp_options` VALUES("16306","elementor_safe_mode","yes","yes");
INSERT INTO `wp_options` VALUES("16309","theme_mods_elementor-safe","a:1:{s:18:\"custom_css_post_id\";i:-1;}","no");
INSERT INTO `wp_options` VALUES("19490","elementor_1_elementor_updater_batch_3043ad3feb649ca4b1076c1c0606","a:1:{i:0;a:1:{s:8:\"callback\";a:2:{i:0;s:31:\"Elementor\\Core\\Upgrade\\Upgrades\";i:1;s:16:\"_on_each_version\";}}}","no");
INSERT INTO `wp_options` VALUES("19504","_elementor_global_css","a:6:{s:4:\"time\";i:1684255914;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}","yes");
INSERT INTO `wp_options` VALUES("19495","site_logo","2926","yes");
INSERT INTO `wp_options` VALUES("23804","wp_attachment_pages_enabled","1","yes");
INSERT INTO `wp_options` VALUES("17533","auto_update_plugins","a:1:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";}","no");
INSERT INTO `wp_options` VALUES("17538","elementor_events_db_version","1.0.0","no");
INSERT INTO `wp_options` VALUES("17544","elementor_scheme_color","a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}","yes");
INSERT INTO `wp_options` VALUES("17545","elementor_scheme_typography","a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}","yes");
INSERT INTO `wp_options` VALUES("17546","elementor_scheme_color-picker","a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}","yes");
INSERT INTO `wp_options` VALUES("23632","rs-templates","a:1:{s:9:\"templates\";b:0;}","no");
INSERT INTO `wp_options` VALUES("56185","bvmgredirect","no","off");
INSERT INTO `wp_options` VALUES("56186","bvActivateTime","1741947924","off");
INSERT INTO `wp_options` VALUES("56188","bvLastRecvTime","1741948035","off");
INSERT INTO `wp_options` VALUES("56189","bvAccountsList","a:1:{s:32:\"7e962b92c973a97366c5d71d525548a3\";a:7:{s:6:\"secret\";s:32:\"6ae52e3fe58198b27661cb7cac0d0256\";s:11:\"account_gid\";s:8:\"uJBJD4eP\";s:14:\"lastbackuptime\";i:1741948016;s:11:\"migrateguru\";b:1;s:12:\"account_type\";s:11:\"migrateguru\";s:3:\"url\";s:29:\"http://www.afridevcapital.com\";s:5:\"email\";s:28:\"nchost_t******@namecheap.com\";}}","off");
INSERT INTO `wp_options` VALUES("56203","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"8c7d46a72d7d4591fc1dd9485bedb304\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on");
INSERT INTO `wp_options` VALUES("56204","litespeed.conf.__activation","-1","auto");
INSERT INTO `wp_options` VALUES("56205","litespeed.cloud._summary","{\"curr_request.ver_check\":0,\"last_request.ver_check\":1760838383,\"news.utime\":1742836322,\"curr_request.news\":0,\"last_request.news\":1742836322}","auto");
INSERT INTO `wp_options` VALUES("56207","litespeed.conf.hash","pHIJI17gzT0zyUSPeik1zTgILusLKbVJ","auto");
INSERT INTO `wp_options` VALUES("56208","litespeed.conf.auto_upgrade","","auto");
INSERT INTO `wp_options` VALUES("56209","litespeed.conf.api_key","","auto");
INSERT INTO `wp_options` VALUES("56210","litespeed.conf.server_ip","","auto");
INSERT INTO `wp_options` VALUES("56211","litespeed.conf.guest","","auto");
INSERT INTO `wp_options` VALUES("56212","litespeed.conf.guest_optm","","auto");
INSERT INTO `wp_options` VALUES("56213","litespeed.conf.news","1","auto");
INSERT INTO `wp_options` VALUES("56214","litespeed.conf.guest_uas","[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"spider\",\"PTST\",\"HeadlessChrome\"]","auto");
INSERT INTO `wp_options` VALUES("56215","litespeed.conf.guest_ips","[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]","auto");
INSERT INTO `wp_options` VALUES("56216","litespeed.conf.cache","1","auto");
INSERT INTO `wp_options` VALUES("56217","litespeed.conf.cache-priv","1","auto");
INSERT INTO `wp_options` VALUES("56218","litespeed.conf.cache-commenter","1","auto");
INSERT INTO `wp_options` VALUES("56219","litespeed.conf.cache-rest","1","auto");
INSERT INTO `wp_options` VALUES("56220","litespeed.conf.cache-page_login","1","auto");
INSERT INTO `wp_options` VALUES("56221","litespeed.conf.cache-resources","1","auto");
INSERT INTO `wp_options` VALUES("56222","litespeed.conf.cache-mobile","","auto");
INSERT INTO `wp_options` VALUES("56223","litespeed.conf.cache-mobile_rules","[\"Mobile\",\"Android\",\"Silk\\/\",\"Kindle\",\"BlackBerry\",\"Opera Mini\",\"Opera Mobi\"]","auto");
INSERT INTO `wp_options` VALUES("56224","litespeed.conf.cache-browser","","auto");
INSERT INTO `wp_options` VALUES("56225","litespeed.conf.cache-exc_useragents","[]","auto");
INSERT INTO `wp_options` VALUES("56226","litespeed.conf.cache-exc_cookies","[]","auto");
INSERT INTO `wp_options` VALUES("56227","litespeed.conf.cache-exc_qs","[]","auto");
INSERT INTO `wp_options` VALUES("56228","litespeed.conf.cache-exc_cat","[]","auto");
INSERT INTO `wp_options` VALUES("56229","litespeed.conf.cache-exc_tag","[]","auto");
INSERT INTO `wp_options` VALUES("56230","litespeed.conf.cache-force_uri","[]","auto");
INSERT INTO `wp_options` VALUES("56231","litespeed.conf.cache-force_pub_uri","[]","auto");
INSERT INTO `wp_options` VALUES("56232","litespeed.conf.cache-priv_uri","[]","auto");
INSERT INTO `wp_options` VALUES("56233","litespeed.conf.cache-exc","[]","auto");
INSERT INTO `wp_options` VALUES("56234","litespeed.conf.cache-exc_roles","[]","auto");
INSERT INTO `wp_options` VALUES("56235","litespeed.conf.cache-drop_qs","[\"fbclid\",\"gclid\",\"utm*\",\"_ga\"]","auto");
INSERT INTO `wp_options` VALUES("56236","litespeed.conf.cache-ttl_pub","604800","auto");
INSERT INTO `wp_options` VALUES("56237","litespeed.conf.cache-ttl_priv","1800","auto");
INSERT INTO `wp_options` VALUES("56238","litespeed.conf.cache-ttl_frontpage","604800","auto");
INSERT INTO `wp_options` VALUES("56239","litespeed.conf.cache-ttl_feed","604800","auto");
INSERT INTO `wp_options` VALUES("56240","litespeed.conf.cache-ttl_rest","604800","auto");
INSERT INTO `wp_options` VALUES("56241","litespeed.conf.cache-ttl_browser","31557600","auto");
INSERT INTO `wp_options` VALUES("56242","litespeed.conf.cache-ttl_status","[\"404 3600\",\"500 600\"]","auto");
INSERT INTO `wp_options` VALUES("56243","litespeed.conf.cache-login_cookie","","auto");
INSERT INTO `wp_options` VALUES("56244","litespeed.conf.cache-ajax_ttl","[]","auto");
INSERT INTO `wp_options` VALUES("56245","litespeed.conf.cache-vary_cookies","[]","auto");
INSERT INTO `wp_options` VALUES("56246","litespeed.conf.cache-vary_group","[]","auto");
INSERT INTO `wp_options` VALUES("56247","litespeed.conf.purge-upgrade","1","auto");
INSERT INTO `wp_options` VALUES("56248","litespeed.conf.purge-stale","","auto");
INSERT INTO `wp_options` VALUES("56249","litespeed.conf.purge-post_all","","auto");
INSERT INTO `wp_options` VALUES("56250","litespeed.conf.purge-post_f","1","auto");
INSERT INTO `wp_options` VALUES("56251","litespeed.conf.purge-post_h","1","auto");
INSERT INTO `wp_options` VALUES("56252","litespeed.conf.purge-post_p","1","auto");
INSERT INTO `wp_options` VALUES("56253","litespeed.conf.purge-post_pwrp","1","auto");
INSERT INTO `wp_options` VALUES("56254","litespeed.conf.purge-post_a","1","auto");
INSERT INTO `wp_options` VALUES("56255","litespeed.conf.purge-post_y","","auto");
INSERT INTO `wp_options` VALUES("56256","litespeed.conf.purge-post_m","1","auto");
INSERT INTO `wp_options` VALUES("56257","litespeed.conf.purge-post_d","","auto");
INSERT INTO `wp_options` VALUES("56258","litespeed.conf.purge-post_t","1","auto");
INSERT INTO `wp_options` VALUES("56259","litespeed.conf.purge-post_pt","1","auto");
INSERT INTO `wp_options` VALUES("56260","litespeed.conf.purge-timed_urls","[]","auto");
INSERT INTO `wp_options` VALUES("56261","litespeed.conf.purge-timed_urls_time","","auto");
INSERT INTO `wp_options` VALUES("56262","litespeed.conf.purge-hook_all","[\"switch_theme\",\"wp_create_nav_menu\",\"wp_update_nav_menu\",\"wp_delete_nav_menu\",\"create_term\",\"edit_terms\",\"delete_term\",\"add_link\",\"edit_link\",\"delete_link\"]","auto");
INSERT INTO `wp_options` VALUES("56263","litespeed.conf.esi","","auto");
INSERT INTO `wp_options` VALUES("56264","litespeed.conf.esi-cache_admbar","1","auto");
INSERT INTO `wp_options` VALUES("56265","litespeed.conf.esi-cache_commform","1","auto");
INSERT INTO `wp_options` VALUES("56266","litespeed.conf.esi-nonce","[\"stats_nonce\",\"subscribe_nonce\"]","auto");
INSERT INTO `wp_options` VALUES("56267","litespeed.conf.util-instant_click","","auto");
INSERT INTO `wp_options` VALUES("56268","litespeed.conf.util-no_https_vary","","auto");
INSERT INTO `wp_options` VALUES("56269","litespeed.conf.debug-disable_all","","auto");
INSERT INTO `wp_options` VALUES("56270","litespeed.conf.debug","","auto");
INSERT INTO `wp_options` VALUES("56271","litespeed.conf.debug-ips","[\"127.0.0.1\"]","auto");
INSERT INTO `wp_options` VALUES("56272","litespeed.conf.debug-level","","auto");
INSERT INTO `wp_options` VALUES("56273","litespeed.conf.debug-filesize","3","auto");
INSERT INTO `wp_options` VALUES("56274","litespeed.conf.debug-collapse_qs","","auto");
INSERT INTO `wp_options` VALUES("56275","litespeed.conf.debug-inc","[]","auto");
INSERT INTO `wp_options` VALUES("56276","litespeed.conf.debug-exc","[]","auto");
INSERT INTO `wp_options` VALUES("56277","litespeed.conf.debug-exc_strings","[]","auto");
INSERT INTO `wp_options` VALUES("56278","litespeed.conf.db_optm-revisions_max","0","auto");
INSERT INTO `wp_options` VALUES("56279","litespeed.conf.db_optm-revisions_age","0","auto");
INSERT INTO `wp_options` VALUES("56280","litespeed.conf.optm-css_min","","auto");
INSERT INTO `wp_options` VALUES("56281","litespeed.conf.optm-css_comb","","auto");
INSERT INTO `wp_options` VALUES("56282","litespeed.conf.optm-css_comb_ext_inl","1","auto");
INSERT INTO `wp_options` VALUES("56283","litespeed.conf.optm-ucss","","auto");
INSERT INTO `wp_options` VALUES("56284","litespeed.conf.optm-ucss_inline","","auto");
INSERT INTO `wp_options` VALUES("56285","litespeed.conf.optm-ucss_whitelist","[]","auto");
INSERT INTO `wp_options` VALUES("56286","litespeed.conf.optm-ucss_file_exc_inline","[]","auto");
INSERT INTO `wp_options` VALUES("56287","litespeed.conf.optm-ucss_exc","[]","auto");
INSERT INTO `wp_options` VALUES("56288","litespeed.conf.optm-css_exc","[]","auto");
INSERT INTO `wp_options` VALUES("56289","litespeed.conf.optm-js_min","","auto");
INSERT INTO `wp_options` VALUES("56290","litespeed.conf.optm-js_comb","","auto");
INSERT INTO `wp_options` VALUES("56291","litespeed.conf.optm-js_comb_ext_inl","1","auto");
INSERT INTO `wp_options` VALUES("56292","litespeed.conf.optm-js_delay_inc","[]","auto");
INSERT INTO `wp_options` VALUES("56293","litespeed.conf.optm-js_exc","[\"jquery.js\",\"jquery.min.js\"]","auto");
INSERT INTO `wp_options` VALUES("56294","litespeed.conf.optm-html_min","","auto");
INSERT INTO `wp_options` VALUES("56295","litespeed.conf.optm-html_lazy","[]","auto");
INSERT INTO `wp_options` VALUES("56296","litespeed.conf.optm-html_skip_comment","[]","auto");
INSERT INTO `wp_options` VALUES("56297","litespeed.conf.optm-qs_rm","","auto");
INSERT INTO `wp_options` VALUES("56298","litespeed.conf.optm-ggfonts_rm","","auto");
INSERT INTO `wp_options` VALUES("56299","litespeed.conf.optm-css_async","","auto");
INSERT INTO `wp_options` VALUES("56300","litespeed.conf.optm-ccss_per_url","","auto");
INSERT INTO `wp_options` VALUES("56301","litespeed.conf.optm-ccss_sep_posttype","[\"page\"]","auto");
INSERT INTO `wp_options` VALUES("56302","litespeed.conf.optm-ccss_sep_uri","[]","auto");
INSERT INTO `wp_options` VALUES("56303","litespeed.conf.optm-css_async_inline","1","auto");
INSERT INTO `wp_options` VALUES("56304","litespeed.conf.optm-css_font_display","","auto");
INSERT INTO `wp_options` VALUES("56305","litespeed.conf.optm-js_defer","","auto");
INSERT INTO `wp_options` VALUES("56306","litespeed.conf.optm-emoji_rm","","auto");
INSERT INTO `wp_options` VALUES("56307","litespeed.conf.optm-noscript_rm","","auto");
INSERT INTO `wp_options` VALUES("56308","litespeed.conf.optm-ggfonts_async","","auto");
INSERT INTO `wp_options` VALUES("56309","litespeed.conf.optm-exc_roles","[]","auto");
INSERT INTO `wp_options` VALUES("56310","litespeed.conf.optm-ccss_con","","auto");
INSERT INTO `wp_options` VALUES("56311","litespeed.conf.optm-js_defer_exc","[\"jquery.js\",\"jquery.min.js\",\"gtm.js\",\"analytics.js\"]","auto");
INSERT INTO `wp_options` VALUES("56312","litespeed.conf.optm-gm_js_exc","[]","auto");
INSERT INTO `wp_options` VALUES("56313","litespeed.conf.optm-dns_prefetch","[]","auto");
INSERT INTO `wp_options` VALUES("56314","litespeed.conf.optm-dns_prefetch_ctrl","","auto");
INSERT INTO `wp_options` VALUES("56315","litespeed.conf.optm-dns_preconnect","[]","auto");
INSERT INTO `wp_options` VALUES("56316","litespeed.conf.optm-exc","[]","auto");
INSERT INTO `wp_options` VALUES("56317","litespeed.conf.optm-guest_only","1","auto");
INSERT INTO `wp_options` VALUES("56318","litespeed.conf.object","","auto");
INSERT INTO `wp_options` VALUES("56319","litespeed.conf.object-kind","","auto");
INSERT INTO `wp_options` VALUES("56320","litespeed.conf.object-host","localhost","auto");
INSERT INTO `wp_options` VALUES("56321","litespeed.conf.object-port","11211","auto");
INSERT INTO `wp_options` VALUES("56322","litespeed.conf.object-life","360","auto");
INSERT INTO `wp_options` VALUES("56323","litespeed.conf.object-persistent","1","auto");
INSERT INTO `wp_options` VALUES("56324","litespeed.conf.object-admin","1","auto");
INSERT INTO `wp_options` VALUES("56325","litespeed.conf.object-transients","1","auto");
INSERT INTO `wp_options` VALUES("56326","litespeed.conf.object-db_id","0","auto");
INSERT INTO `wp_options` VALUES("56327","litespeed.conf.object-user","","auto");
INSERT INTO `wp_options` VALUES("56328","litespeed.conf.object-pswd","","auto");
INSERT INTO `wp_options` VALUES("56329","litespeed.conf.object-global_groups","[\"users\",\"userlogins\",\"useremail\",\"userslugs\",\"usermeta\",\"user_meta\",\"site-transient\",\"site-options\",\"site-lookup\",\"site-details\",\"blog-lookup\",\"blog-details\",\"blog-id-cache\",\"rss\",\"global-posts\",\"global-cache-test\"]","auto");
INSERT INTO `wp_options` VALUES("56330","litespeed.conf.object-non_persistent_groups","[\"comment\",\"counts\",\"plugins\",\"wc_session_id\"]","auto");
INSERT INTO `wp_options` VALUES("56331","litespeed.conf.discuss-avatar_cache","","auto");
INSERT INTO `wp_options` VALUES("56332","litespeed.conf.discuss-avatar_cron","","auto");
INSERT INTO `wp_options` VALUES("56333","litespeed.conf.discuss-avatar_cache_ttl","604800","auto");
INSERT INTO `wp_options` VALUES("56334","litespeed.conf.optm-localize","","auto");
INSERT INTO `wp_options` VALUES("56335","litespeed.conf.optm-localize_domains","[\"### Popular scripts ###\",\"https:\\/\\/platform.twitter.com\\/widgets.js\",\"https:\\/\\/connect.facebook.net\\/en_US\\/fbevents.js\"]","auto");
INSERT INTO `wp_options` VALUES("56336","litespeed.conf.media-lazy","","auto");
INSERT INTO `wp_options` VALUES("56337","litespeed.conf.media-lazy_placeholder","","auto");
INSERT INTO `wp_options` VALUES("56338","litespeed.conf.media-placeholder_resp","","auto");
INSERT INTO `wp_options` VALUES("56339","litespeed.conf.media-placeholder_resp_color","#cfd4db","auto");
INSERT INTO `wp_options` VALUES("56340","litespeed.conf.media-placeholder_resp_svg","<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" style=\"fill:{color};fill-opacity: 0.1;\"/></svg>","auto");
INSERT INTO `wp_options` VALUES("56341","litespeed.conf.media-lqip","","auto");
INSERT INTO `wp_options` VALUES("56342","litespeed.conf.media-lqip_qual","4","auto");
INSERT INTO `wp_options` VALUES("56343","litespeed.conf.media-lqip_min_w","150","auto");
INSERT INTO `wp_options` VALUES("56344","litespeed.conf.media-lqip_min_h","150","auto");
INSERT INTO `wp_options` VALUES("56345","litespeed.conf.media-placeholder_resp_async","1","auto");
INSERT INTO `wp_options` VALUES("56346","litespeed.conf.media-iframe_lazy","","auto");
INSERT INTO `wp_options` VALUES("56347","litespeed.conf.media-add_missing_sizes","","auto");
INSERT INTO `wp_options` VALUES("56348","litespeed.conf.media-lazy_exc","[]","auto");
INSERT INTO `wp_options` VALUES("56349","litespeed.conf.media-lazy_cls_exc","[\"wmu-preview-img\"]","auto");
INSERT INTO `wp_options` VALUES("56350","litespeed.conf.media-lazy_parent_cls_exc","[]","auto");
INSERT INTO `wp_options` VALUES("56351","litespeed.conf.media-iframe_lazy_cls_exc","[]","auto");
INSERT INTO `wp_options` VALUES("56352","litespeed.conf.media-iframe_lazy_parent_cls_exc","[]","auto");
INSERT INTO `wp_options` VALUES("56353","litespeed.conf.media-lazy_uri_exc","[]","auto");
INSERT INTO `wp_options` VALUES("56354","litespeed.conf.media-lqip_exc","[]","auto");
INSERT INTO `wp_options` VALUES("56355","litespeed.conf.media-vpi","","auto");
INSERT INTO `wp_options` VALUES("56356","litespeed.conf.media-vpi_cron","","auto");
INSERT INTO `wp_options` VALUES("56357","litespeed.conf.img_optm-auto","","auto");
INSERT INTO `wp_options` VALUES("56358","litespeed.conf.img_optm-cron","1","auto");
INSERT INTO `wp_options` VALUES("56359","litespeed.conf.img_optm-ori","1","auto");
INSERT INTO `wp_options` VALUES("56360","litespeed.conf.img_optm-rm_bkup","","auto");
INSERT INTO `wp_options` VALUES("56361","litespeed.conf.img_optm-webp","","auto");
INSERT INTO `wp_options` VALUES("56362","litespeed.conf.img_optm-lossless","","auto");
INSERT INTO `wp_options` VALUES("56363","litespeed.conf.img_optm-exif","1","auto");
INSERT INTO `wp_options` VALUES("56364","litespeed.conf.img_optm-webp_attr","[\"img.src\",\"div.data-thumb\",\"img.data-src\",\"img.data-lazyload\",\"div.data-large_image\",\"img.retina_logo_url\",\"div.data-parallax-image\",\"div.data-vc-parallax-image\",\"video.poster\"]","auto");
INSERT INTO `wp_options` VALUES("56365","litespeed.conf.img_optm-webp_replace_srcset","","auto");
INSERT INTO `wp_options` VALUES("56366","litespeed.conf.img_optm-jpg_quality","82","auto");
INSERT INTO `wp_options` VALUES("56367","litespeed.conf.crawler","","auto");
INSERT INTO `wp_options` VALUES("56368","litespeed.conf.crawler-usleep","500","auto");
INSERT INTO `wp_options` VALUES("56369","litespeed.conf.crawler-run_duration","400","auto");
INSERT INTO `wp_options` VALUES("56370","litespeed.conf.crawler-run_interval","600","auto");
INSERT INTO `wp_options` VALUES("56371","litespeed.conf.crawler-crawl_interval","302400","auto");
INSERT INTO `wp_options` VALUES("56372","litespeed.conf.crawler-threads","3","auto");
INSERT INTO `wp_options` VALUES("56373","litespeed.conf.crawler-timeout","30","auto");
INSERT INTO `wp_options` VALUES("56374","litespeed.conf.crawler-load_limit","1","auto");
INSERT INTO `wp_options` VALUES("56375","litespeed.conf.crawler-sitemap","","auto");
INSERT INTO `wp_options` VALUES("56376","litespeed.conf.crawler-drop_domain","1","auto");
INSERT INTO `wp_options` VALUES("56377","litespeed.conf.crawler-map_timeout","120","auto");
INSERT INTO `wp_options` VALUES("56378","litespeed.conf.crawler-roles","[]","auto");
INSERT INTO `wp_options` VALUES("56379","litespeed.conf.crawler-cookies","[]","auto");
INSERT INTO `wp_options` VALUES("56380","litespeed.conf.misc-heartbeat_front","","auto");
INSERT INTO `wp_options` VALUES("56381","litespeed.conf.misc-heartbeat_front_ttl","60","auto");
INSERT INTO `wp_options` VALUES("56382","litespeed.conf.misc-heartbeat_back","","auto");
INSERT INTO `wp_options` VALUES("56383","litespeed.conf.misc-heartbeat_back_ttl","60","auto");
INSERT INTO `wp_options` VALUES("56384","litespeed.conf.misc-heartbeat_editor","","auto");
INSERT INTO `wp_options` VALUES("56385","litespeed.conf.misc-heartbeat_editor_ttl","15","auto");
INSERT INTO `wp_options` VALUES("56386","litespeed.conf.cdn","","auto");
INSERT INTO `wp_options` VALUES("56387","litespeed.conf.cdn-ori","[]","auto");
INSERT INTO `wp_options` VALUES("56388","litespeed.conf.cdn-ori_dir","[\"wp-content\",\"wp-includes\"]","auto");
INSERT INTO `wp_options` VALUES("56389","litespeed.conf.cdn-exc","[]","auto");
INSERT INTO `wp_options` VALUES("56390","litespeed.conf.cdn-quic","","auto");
INSERT INTO `wp_options` VALUES("56391","litespeed.conf.cdn-cloudflare","","auto");
INSERT INTO `wp_options` VALUES("56392","litespeed.conf.cdn-cloudflare_email","","auto");
INSERT INTO `wp_options` VALUES("56393","litespeed.conf.cdn-cloudflare_key","","auto");
INSERT INTO `wp_options` VALUES("56394","litespeed.conf.cdn-cloudflare_name","","auto");
INSERT INTO `wp_options` VALUES("56395","litespeed.conf.cdn-cloudflare_zone","","auto");
INSERT INTO `wp_options` VALUES("56396","litespeed.conf.cdn-mapping","[{\"url\":\"\",\"inc_img\":\"1\",\"inc_css\":\"1\",\"inc_js\":\"1\",\"filetype\":[\".aac\",\".css\",\".eot\",\".gif\",\".jpeg\",\".jpg\",\".js\",\".less\",\".mp3\",\".mp4\",\".ogg\",\".otf\",\".pdf\",\".png\",\".svg\",\".ttf\",\".webp\",\".woff\",\".woff2\"]}]","auto");
INSERT INTO `wp_options` VALUES("56397","litespeed.conf.cdn-attr","[\".src\",\".data-src\",\".href\",\".poster\",\"source.srcset\"]","auto");
INSERT INTO `wp_options` VALUES("56398","litespeed.conf.qc-token","","auto");
INSERT INTO `wp_options` VALUES("56399","litespeed.conf.qc-nameservers","","auto");
INSERT INTO `wp_options` VALUES("56400","litespeed.purge.queue","X-LiteSpeed-Purge: public,*","auto");
INSERT INTO `wp_options` VALUES("56401","litespeed.purge.queue2","-1","auto");
INSERT INTO `wp_options` VALUES("58593","litespeed.optimize.timestamp_purge_css","1760838383","auto");
INSERT INTO `wp_options` VALUES("101624","_site_transient_timeout_theme_roots","1761084113","off");
INSERT INTO `wp_options` VALUES("101625","_site_transient_theme_roots","a:11:{s:13:\"betheme-child\";s:7:\"/themes\";s:7:\"betheme\";s:7:\"/themes\";s:10:\"extendable\";s:7:\"/themes\";s:14:\"twentynineteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}","off");
INSERT INTO `wp_options` VALUES("56411","_transient_health-check-site-status-result","{\"good\":17,\"recommended\":5,\"critical\":1}","on");
INSERT INTO `wp_options` VALUES("56837","litespeed.gui.lscwp_whm_install","-1","auto");
INSERT INTO `wp_options` VALUES("56675","_elementor_local_google_fonts","a:4:{s:17:\"cormorantgaramond\";a:2:{s:3:\"url\";s:97:\"http://www.afridevcapital.com/wp-content/uploads/elementor/google-fonts/css/cormorantgaramond.css\";s:7:\"version\";i:1742283209;}s:5:\"rubik\";a:2:{s:3:\"url\";s:85:\"http://www.afridevcapital.com/wp-content/uploads/elementor/google-fonts/css/rubik.css\";s:7:\"version\";i:1742283217;}s:6:\"roboto\";a:2:{s:3:\"url\";s:86:\"http://www.afridevcapital.com/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1742283232;}s:8:\"worksans\";a:2:{s:3:\"url\";s:88:\"http://www.afridevcapital.com/wp-content/uploads/elementor/google-fonts/css/worksans.css\";s:7:\"version\";i:1742318735;}}","auto");
INSERT INTO `wp_options` VALUES("60392","elementor_connect_site_key","9c7b538dd305caa64692180c13253cb4","auto");
INSERT INTO `wp_options` VALUES("56839","litespeed.gui._summary","{\"new_version\":1742919439,\"score\":1743524239}","auto");
INSERT INTO `wp_options` VALUES("56639","elementor_landing_pages_activation","0","auto");
INSERT INTO `wp_options` VALUES("56838","litespeed.gui.dismiss","-1","auto");
INSERT INTO `wp_options` VALUES("60952","litespeed.conf.qc-cname","","auto");
INSERT INTO `wp_options` VALUES("56840","litespeed.data.upgrading","-1","auto");
INSERT INTO `wp_options` VALUES("56841","litespeed.admin_display.messages","[\"<div class=\\\"litespeed_icon notice notice-success is-dismissible\\\"><p>Purged all caches successfully.<\\/p><\\/div>\"]","auto");
INSERT INTO `wp_options` VALUES("56842","_site_transient_wp_plugin_dependencies_plugin_data","a:0:{}","off");
INSERT INTO `wp_options` VALUES("60492","mk_te_settings_options","a:5:{s:7:\"e_d_t_e\";s:3:\"yes\";s:17:\"code_editor_theme\";s:6:\"cobalt\";s:9:\"e_w_d_t_e\";s:3:\"yes\";s:7:\"e_d_p_e\";s:3:\"yes\";s:9:\"e_w_d_p_e\";s:3:\"yes\";}","auto");
INSERT INTO `wp_options` VALUES("101703","_site_transient_timeout_wp_theme_files_patterns-4634c10e7a7b41519dcdcd02a197509d","1761105588","off");
INSERT INTO `wp_options` VALUES("101701","_site_transient_timeout_wp_theme_files_patterns-ef0c069c9ede75be2822699cba0df1af","1761105588","off");
INSERT INTO `wp_options` VALUES("101704","_site_transient_wp_theme_files_patterns-4634c10e7a7b41519dcdcd02a197509d","a:2:{s:7:\"version\";s:6:\"21.9.7\";s:8:\"patterns\";a:0:{}}","off");
INSERT INTO `wp_options` VALUES("101677","_site_transient_timeout_betheme_update","1761107233","off");
INSERT INTO `wp_options` VALUES("101678","_site_transient_betheme_update","28.1.10","off");
INSERT INTO `wp_options` VALUES("101702","_site_transient_wp_theme_files_patterns-ef0c069c9ede75be2822699cba0df1af","a:2:{s:7:\"version\";s:5:\"1.6.2\";s:8:\"patterns\";a:0:{}}","off");
INSERT INTO `wp_options` VALUES("101686","_site_transient_timeout_browser_2204ee63bef2f351470a66ffe1bb020e","1761708433","off");
INSERT INTO `wp_options` VALUES("101687","_site_transient_browser_2204ee63bef2f351470a66ffe1bb020e","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"141.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off");
INSERT INTO `wp_options` VALUES("101683","_site_transient_timeout_betheme_plugins","1761107232","off");
INSERT INTO `wp_options` VALUES("96898","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.8.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.8.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1761082314;s:15:\"version_checked\";s:5:\"6.8.3\";s:12:\"translations\";a:0:{}}","off");
INSERT INTO `wp_options` VALUES("101684","_site_transient_betheme_plugins","a:4:{i:0;a:5:{s:4:\"name\";s:12:\"Layer Slider\";s:4:\"slug\";s:11:\"LayerSlider\";s:8:\"required\";b:0;s:7:\"version\";s:6:\"7.15.1\";s:6:\"source\";s:67:\"https://api.muffingroup.com/plugins/download.php?plugin=LayerSlider\";}i:1;a:5:{s:4:\"name\";s:17:\"Slider Revolution\";s:4:\"slug\";s:9:\"revslider\";s:8:\"required\";b:0;s:7:\"version\";s:6:\"6.7.38\";s:6:\"source\";s:65:\"https://api.muffingroup.com/plugins/download.php?plugin=revslider\";}i:2;a:5:{s:4:\"name\";s:21:\"WPBakery Page Builder\";s:4:\"slug\";s:11:\"js_composer\";s:8:\"required\";b:0;s:7:\"version\";s:3:\"8.7\";s:6:\"source\";s:67:\"https://api.muffingroup.com/plugins/download.php?plugin=js_composer\";}i:3;a:5:{s:4:\"name\";s:8:\"BeCustom\";s:4:\"slug\";s:8:\"becustom\";s:8:\"required\";b:0;s:7:\"version\";s:5:\"1.2.3\";s:6:\"source\";s:64:\"https://api.muffingroup.com/plugins/download.php?plugin=becustom\";}}","off");
INSERT INTO `wp_options` VALUES("101622","_site_transient_timeout_browser_87532f5c229247f5166d216fad1d829f","1761687090","off");
INSERT INTO `wp_options` VALUES("101623","_site_transient_browser_87532f5c229247f5166d216fad1d829f","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"90.0.4430.85\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off");
INSERT INTO `wp_options` VALUES("101670","_transient_timeout_elementor_remote_info_api_data_3.32.4","1761144366","off");
INSERT INTO `wp_options` VALUES("101671","_transient_elementor_remote_info_api_data_3.32.4","a:4:{s:9:\"timestamp\";s:10:\"1761098219\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}","off");
INSERT INTO `wp_options` VALUES("66660","litespeed.conf.optm-ccss_whitelist","[]","auto");
INSERT INTO `wp_options` VALUES("64133","fm_key","l7YR5FIdiOJpohxrewNUkKE36","auto");
INSERT INTO `wp_options` VALUES("64136","filemanager_email_verified_1","yes","auto");
INSERT INTO `wp_options` VALUES("101685","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1761103633;s:8:\"response\";a:3:{s:23:\"elementor/elementor.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.32.5\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:27:\"uyrttge/protect-uploads.php\";O:8:\"stdClass\":15:{s:2:\"id\";s:29:\"w.org/plugins/protect-uploads\";s:4:\"slug\";s:15:\"protect-uploads\";s:6:\"plugin\";s:27:\"uyrttge/protect-uploads.php\";s:11:\"new_version\";s:3:\"0.4\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/protect-uploads/\";s:7:\"package\";s:54:\"https://downloads.w.org/plugin/protect-uploads.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/protect-uploads/assets/icon-256x256.png?rev=2779778\";s:2:\"1x\";s:68:\"https://ps.w.org/protect-uploads/assets/icon-128x128.png?rev=2779778\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/protect-uploads/assets/banner-1544x500.png?rev=2779778\";s:2:\"1x\";s:70:\"https://ps.w.org/protect-uploads/assets/banner-772x250.png?rev=2779778\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";b:0;s:6:\"tested\";s:6:\"6.0.11\";s:12:\"requires_php\";b:0;s:16:\"requires_plugins\";a:0:{}s:10:\"autoupdate\";b:1;s:14:\"upgrade_notice\";s:76:\"Version 0.4 contains security fixes and is highly recommended for all users.\";}s:27:\"xoedghe/protect-uploads.php\";O:8:\"stdClass\":15:{s:2:\"id\";s:29:\"w.org/plugins/protect-uploads\";s:4:\"slug\";s:15:\"protect-uploads\";s:6:\"plugin\";s:27:\"xoedghe/protect-uploads.php\";s:11:\"new_version\";s:3:\"0.4\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/protect-uploads/\";s:7:\"package\";s:54:\"https://downloads.w.org/plugin/protect-uploads.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/protect-uploads/assets/icon-256x256.png?rev=2779778\";s:2:\"1x\";s:68:\"https://ps.w.org/protect-uploads/assets/icon-128x128.png?rev=2779778\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/protect-uploads/assets/banner-1544x500.png?rev=2779778\";s:2:\"1x\";s:70:\"https://ps.w.org/protect-uploads/assets/banner-772x250.png?rev=2779778\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";b:0;s:6:\"tested\";s:6:\"6.0.11\";s:12:\"requires_php\";b:0;s:16:\"requires_plugins\";a:0:{}s:10:\"autoupdate\";b:1;s:14:\"upgrade_notice\";s:76:\"Version 0.4 contains security fixes and is highly recommended for all users.\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:13:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.5.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"6.1.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.1.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";}s:23:\"extendify/extendify.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/extendify\";s:4:\"slug\";s:9:\"extendify\";s:6:\"plugin\";s:23:\"extendify/extendify.php\";s:11:\"new_version\";s:5:\"2.1.1\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/extendify/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/extendify.2.1.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/extendify/assets/icon-256x256.png?rev=2653704\";s:2:\"1x\";s:62:\"https://ps.w.org/extendify/assets/icon-128x128.png?rev=2653704\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/extendify/assets/banner-1544x500.png?rev=2653704\";s:2:\"1x\";s:64:\"https://ps.w.org/extendify/assets/banner-772x250.png?rev=2653704\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:41:\"w.org/plugins/force-regenerate-thumbnails\";s:4:\"slug\";s:27:\"force-regenerate-thumbnails\";s:6:\"plugin\";s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";s:11:\"new_version\";s:5:\"2.2.2\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/force-regenerate-thumbnails/\";s:7:\"package\";s:76:\"https://downloads.wordpress.org/plugin/force-regenerate-thumbnails.2.2.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/force-regenerate-thumbnails/assets/icon-256x256.jpg?rev=2816275\";s:2:\"1x\";s:80:\"https://ps.w.org/force-regenerate-thumbnails/assets/icon-128x128.jpg?rev=2816275\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:83:\"https://ps.w.org/force-regenerate-thumbnails/assets/banner-1544x500.jpg?rev=2816275\";s:2:\"1x\";s:82:\"https://ps.w.org/force-regenerate-thumbnails/assets/banner-772x250.jpg?rev=2816275\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}s:43:\"go-live-update-urls/go-live-update-urls.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:33:\"w.org/plugins/go-live-update-urls\";s:4:\"slug\";s:19:\"go-live-update-urls\";s:6:\"plugin\";s:43:\"go-live-update-urls/go-live-update-urls.php\";s:11:\"new_version\";s:5:\"7.0.6\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/go-live-update-urls/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/go-live-update-urls.7.0.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/go-live-update-urls/assets/icon-256x256.png?rev=1811295\";s:2:\"1x\";s:72:\"https://ps.w.org/go-live-update-urls/assets/icon-128x128.png?rev=1811295\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/go-live-update-urls/assets/banner-1544x500.png?rev=1811295\";s:2:\"1x\";s:74:\"https://ps.w.org/go-live-update-urls/assets/banner-772x250.png?rev=1811295\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"6.2.0\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:35:\"litespeed-cache/litespeed-cache.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/litespeed-cache\";s:4:\"slug\";s:15:\"litespeed-cache\";s:6:\"plugin\";s:35:\"litespeed-cache/litespeed-cache.php\";s:11:\"new_version\";s:5:\"7.6.2\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/litespeed-cache/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/litespeed-cache.7.6.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-256x256.png?rev=2554181\";s:2:\"1x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-128x128.png?rev=2554181\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/litespeed-cache/assets/banner-1544x500.png?rev=2554181\";s:2:\"1x\";s:70:\"https://ps.w.org/litespeed-cache/assets/banner-772x250.png?rev=2554181\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:23:\"loginizer/loginizer.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/loginizer\";s:4:\"slug\";s:9:\"loginizer\";s:6:\"plugin\";s:23:\"loginizer/loginizer.php\";s:11:\"new_version\";s:5:\"2.0.3\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/loginizer/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/loginizer.2.0.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/loginizer/assets/icon-256x256.png?rev=1381093\";s:2:\"1x\";s:62:\"https://ps.w.org/loginizer/assets/icon-128x128.png?rev=1381093\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/loginizer/assets/banner-1544x500.png?rev=3131676\";s:2:\"1x\";s:64:\"https://ps.w.org/loginizer/assets/banner-772x250.png?rev=3131676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.0\";}s:28:\"migrate-guru/migrateguru.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/migrate-guru\";s:4:\"slug\";s:12:\"migrate-guru\";s:6:\"plugin\";s:28:\"migrate-guru/migrateguru.php\";s:11:\"new_version\";s:4:\"5.88\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/migrate-guru/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/migrate-guru.5.88.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/migrate-guru/assets/icon-256x256.png?rev=1721728\";s:2:\"1x\";s:65:\"https://ps.w.org/migrate-guru/assets/icon-128x128.png?rev=1721728\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/migrate-guru/assets/banner-1544x500.png?rev=1710812\";s:2:\"1x\";s:67:\"https://ps.w.org/migrate-guru/assets/banner-772x250.png?rev=2161189\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:7:\"9.5.2.3\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/really-simple-ssl.9.5.2.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:29:\"theme-editor/theme_editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/theme-editor\";s:4:\"slug\";s:12:\"theme-editor\";s:6:\"plugin\";s:29:\"theme-editor/theme_editor.php\";s:11:\"new_version\";s:3:\"3.1\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/theme-editor/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/theme-editor.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/theme-editor/assets/icon-128x128.png?rev=1644634\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/theme-editor/assets/banner-772x250.jpg?rev=1644636\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.4\";}s:39:\"wp-file-manager/file_folder_manager.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/wp-file-manager\";s:4:\"slug\";s:15:\"wp-file-manager\";s:6:\"plugin\";s:39:\"wp-file-manager/file_folder_manager.php\";s:11:\"new_version\";s:5:\"8.0.2\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/wp-file-manager/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wp-file-manager.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/wp-file-manager/assets/icon-128x128.png?rev=2491299\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:70:\"https://ps.w.org/wp-file-manager/assets/banner-772x250.jpg?rev=2491299\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:33:\"duplicate-post/duplicate-post.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-post\";s:4:\"slug\";s:14:\"duplicate-post\";s:6:\"plugin\";s:33:\"duplicate-post/duplicate-post.php\";s:11:\"new_version\";s:3:\"4.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-post/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicate-post.4.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-256x256.png?rev=2336666\";s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-128x128.png?rev=2336666\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/duplicate-post/assets/banner-1544x500.png?rev=2336666\";s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-post/assets/banner-772x250.png?rev=2336666\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}}s:7:\"checked\";a:23:{s:19:\"akismet/akismet.php\";s:3:\"5.5\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"6.1.2\";s:23:\"elementor/elementor.php\";s:6:\"3.32.4\";s:23:\"extendify/extendify.php\";s:5:\"2.1.1\";s:59:\"force-regenerate-thumbnails/force-regenerate-thumbnails.php\";s:5:\"2.2.2\";s:43:\"go-live-update-urls/go-live-update-urls.php\";s:5:\"7.0.6\";s:9:\"hello.php\";s:5:\"1.7.2\";s:35:\"litespeed-cache/litespeed-cache.php\";s:5:\"7.6.2\";s:23:\"loginizer/loginizer.php\";s:5:\"2.0.3\";s:41:\"loginizer-security/loginizer-security.php\";s:5:\"1.9.8\";s:28:\"migrate-guru/migrateguru.php\";s:4:\"5.88\";s:35:\"one_images_user/one_images_user.php\";s:0:\"\";s:27:\"uyrttge/protect-uploads.php\";s:3:\"0.3\";s:27:\"xoedghe/protect-uploads.php\";s:3:\"0.3\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:7:\"9.5.2.3\";s:35:\"nc-extendify-lc/nc-extendify-lc.php\";s:5:\"1.0.0\";s:27:\"dis_revslider/revslider.php\";s:7:\"5.3.1.5\";s:33:\"social-media-integrator/index.php\";s:5:\"1.8.7\";s:29:\"theme-editor/theme_editor.php\";s:3:\"3.1\";s:53:\"velvet-blues-update-urls/velvet-blues-update-urls.php\";s:6:\"3.2.10\";s:27:\"cacheengine/cacheengine.php\";s:5:\"1.4.8\";s:39:\"wp-file-manager/file_folder_manager.php\";s:5:\"8.0.2\";s:33:\"duplicate-post/duplicate-post.php\";s:3:\"4.5\";}}","off");
INSERT INTO `wp_options` VALUES("100724","_site_transient_timeout_php_check_38979a08dcd71638878b7b4419751271","1761335344","off");
INSERT INTO `wp_options` VALUES("100725","_site_transient_php_check_38979a08dcd71638878b7b4419751271","a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:0;s:13:\"is_acceptable\";b:0;}","off");
INSERT INTO `wp_options` VALUES("101217","_site_transient_timeout_browser_14d58a1ba286f087d9736249ec785314","1761534842","off");
INSERT INTO `wp_options` VALUES("101218","_site_transient_browser_14d58a1ba286f087d9736249ec785314","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"114.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off");
INSERT INTO `wp_options` VALUES("90286","litespeed.conf.media-auto_rescale_ori","","auto");
INSERT INTO `wp_options` VALUES("90287","litespeed.conf.debug-disable_tmp","0","auto");
INSERT INTO `wp_options` VALUES("101690","_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3","1761146837","off");
INSERT INTO `wp_options` VALUES("101691","can_compress_scripts","1","on");
INSERT INTO `wp_options` VALUES("101692","_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 20:04:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-beta1-61042\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"WordPress 6.8.3 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Sep 2025 19:31:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"WordPress 6.8.3 is now available! This is a security release that features two fixes. Because this is a security release, it is recommended that you update your sites immediately. You can download WordPress 6.8.3 from WordPress.org, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4937:\"\n<p><strong>WordPress 6.8.3 is now available!</strong></p>\n\n\n\n<p>This is a security release that features two fixes.</p>\n\n\n\n<p>Because this is a security release,<strong> it is recommended that you update your sites immediately</strong>.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.3.zip\">download WordPress 6.8.3 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The next major release will be <a href=\"https://make.wordpress.org/core/6-9/\">version 6.9</a>, which is planned for December 2nd, 2025.<br>For more information on WordPress 6.8.3, please visit the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-8-3/\">version page on the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Security updates included in this release</h2>\n\n\n\n<p>The security team would like to thank the following people for <a href=\"https://hackerone.com/wordpress?type=team\">responsibly reporting vulnerabilities</a>, and allowing them to be fixed in this release:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>A data exposure issue where authenticated users could access some restricted content. Independently reported by <a href=\"https://hackerone.com/mnelson4\">Mike Nelson</a>, <a href=\"https://hackerone.com/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, and <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>.</li>\n\n\n\n<li>A cross-site scripting (XSS) vulnerability requiring an authenticated user role that affects the nav menus. Reported by <a href=\"https://x.com/Savphill\">Phill Savage</a>.</li>\n</ul>\n\n\n\n<p>As a courtesy, these fixes have also been made available to all branches eligible to receive security fixes (currently through 4.7). As a reminder, <strong>only the most recent version of WordPress is actively supported</strong>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>.</p>\n\n\n\n<p>In addition to the security researchers and release squad members mentioned above, WordPress 6.8.3 would not have been possible without the contributions of the following people:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/hurayraiit\">Abu Hurayra</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/andraganescu%20\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ehtis\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phillsav\">Phill</a>, <a href=\"https://profiles.wordpress.org/noisysocks\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://app.slack.com/client/T024MFP4J/C02RQBWTW\">#core</a> Slack channel. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/tutorials/faq-for-new-contributors/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p>Props to <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a> for reviewing.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Portland Welcomes WordCamp US 2025: A Community Gathering\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Aug 2025 03:03:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19074\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery. WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement. Matt Mullenweg, WordPress Cofounder [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:66040:\"\n\n\n<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20311a7&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20311a7\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19080\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19080\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20314bb&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20314bb\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19081\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19081\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2031769&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2031769\" class=\"wp-block-image size-large wp-lightbox-container\"><img decoding=\"async\" width=\"1707\" height=\"2560\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19087\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1\" alt=\"\" class=\"wp-image-19087\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?w=1707&amp;ssl=1 1707w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=768%2C1152&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1024%2C1536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1365%2C2048&amp;ssl=1 1365w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2031a49&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2031a49\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19084\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19084\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2031ce9&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2031ce9\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19082\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19082\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2031f8d&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2031f8d\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19085\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19085\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d203224c&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d203224c\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19086\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19086\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20324ef&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20324ef\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19090\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19090\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20327a6&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20327a6\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19089\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19089\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2032a2a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2032a2a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19092\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19092\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2032ccc&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2032ccc\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19088\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19088\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2032f6e&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2032f6e\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19091\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19091\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d203322b&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d203322b\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19083\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19083\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Amy Sample Ward &quot;The Tech That Comes Next&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/RKnM75GFZxw?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, <a href=\"https://youtu.be/PGvh7fCOUk0\">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href=\"https://youtu.be/F4NEPcwGRCI\">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a>. Panelists <a href=\"https://youtu.be/ARqM9U0ESvo\">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href=\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US - Danny Sullivan &quot;How (and why!) Google Search Keeps Evolving&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/ZF_sxLdfTbY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href=\"https://youtu.be/v_0O6dQ4Q4E\">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19103\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href=\"https://youtu.be/vBjNqdacbh4\">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href=\"https://youtu.be/O7FPiFpRI3o\">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href=\"https://youtu.be/ORnJTpjA-4w\">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Ma.tt Mullenweg &quot;Keynote Address &amp; Q&amp;A&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/45HRzzc0waU?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href=\"https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00\">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2033cf9&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2033cf9\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19112\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19112\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2033fbf&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2033fbf\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19124\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19124\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2034299&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2034299\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19122\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19122\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2034539&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2034539\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19107\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19107\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20347e0&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20347e0\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"675\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19108\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1\" alt=\"\" class=\"wp-image-19108\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=300%2C198&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=768%2C506&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1536%2C1012&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?w=1764&amp;ssl=1 1764w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2034a74&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2034a74\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19113\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19113\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2034d22&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2034d22\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"433\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19106\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1\" alt=\"\" class=\"wp-image-19106\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1024%2C433&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=300%2C127&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=768%2C325&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1536%2C650&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=2048%2C866&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2034fdf&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2034fdf\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19110\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19110\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20352a2&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20352a2\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19119\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19119\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2035538&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2035538\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19133\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19133\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia 2026</a>&nbsp; in Mumbai, India, <a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe 2026</a>&nbsp; in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19074\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Portland, Are You Ready? The WCUS 2025 Schedule Has Arrived!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2025/08/portland-are-you-ready-the-wcus-2025-schedule-has-arrived/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Aug 2025 20:03:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"WCUS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19004\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:402:\"We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5698:\"\n<p>We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the future of WordPress.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader.png?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19026\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p class=\"has-text-align-center\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-blue-1-background-color has-background wp-element-button\" href=\"https://us.wordcamp.org/2025/schedule/\">View The Schedule</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day — Connect, Collaborate, and Give Back</h2>\n\n\n\n<p>Kicking off the week on Tuesday, August 26 is Contributor Day, it is your chance to roll up your sleeves and make a direct impact on WordPress. Whether you’re a seasoned developer, creative designer, translator, marketer, or simply passionate about open source, there’s a place for you to get involved. Join WordPress teams working on real projects, share your skills, and connect with people across the global community. Contributor Day is also a fantastic place for hiring managers or business owners to meet emerging talent and see contributors in action. Lunch is provided, and both in-person and select remote participation options are available. If you’ve ever wanted to help shape the future of WordPress, this is your moment!<br></p>\n\n\n\n<p>Read more: <a href=\"https://us.wordcamp.org/2025/schedule/#contributor-day\">Start planning your Contributor Day activities &gt;&gt;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day — See WordPress in Action</h2>\n\n\n\n<p>Showcase Day on Wednesday, August 27, shines a spotlight on what&#8217;s possible with WordPress. Get inspired by live demos, case studies, and actionable presentations from experts and innovators using WordPress in creative and impactful ways. You’ll see how changemakers, nonprofits, publishers, and agencies use WordPress to solve real-world problems, build new products, and drive the web forward. Highlights include hands-on workshops, technical talks, and practical sessions covering everything from design systems to modern AI. It’s a full day dedicated to celebrating the talent, creativity, and innovation of the WordPress community.</p>\n\n\n\n<p>Read more: <a href=\"https://us.wordcamp.org/2025/schedule/#showcase-day\">See where these inspirational showcases take you &gt;&gt;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Conference Days — Learn, Connect, and Level Up</h2>\n\n\n\n<p>The main event days for Thursday and Friday, August 28-29, feature a robust mix of technical deep-dives, product masterclasses, and sessions designed for all experience levels. Whether you’re a developer, designer, business owner, or just starting out, you’ll find plenty to explore—from future-focused discussions on AI and performance to hands-on workshops and networking events that bring the community together.</p>\n\n\n\n<p><strong>Keynote Highlights:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Amy Sample Ward, CEO of NTEN:</strong> The Tech That Comes Next: How Changemakers, Philanthropists, and Technologists Can Build an Equitable World. Featured Wednesday, August 27.</li>\n\n\n\n<li><strong>Danny Sullivan, from Google Search</strong>: Industry leader, featured Thursday, August 28.</li>\n\n\n\n<li><strong>Matt Mullenweg, Co-founder of WordPress:</strong> Featured Friday, August 29.</li>\n\n\n\n<li>More keynotes announcing soon!</li>\n</ul>\n\n\n\n<p>With dozens of sessions across multiple tracks, plus workshops and networking opportunities, WordCamp US is set to be an unforgettable experience. Don’t miss your chance to connect, share ideas, and help shape the future of the web.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-blue-1-background-color has-background wp-element-button\" href=\"https://us.wordcamp.org/2025/schedule/\">View The Schedule</a></div>\n</div>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19004\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Maintenance Releases for WordPress branches 4.7 to 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wordpress.org/news/2025/08/maintenance-releases-for-wordpress-branches-4-7-to-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Aug 2025 19:11:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18997\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"Following on from the WordPress 6.8.2 maintenance release last month, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2119:\"\n<p>Following on from <a href=\"https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/\">the WordPress 6.8.2 maintenance release last month</a>, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on <a href=\"https://core.trac.wordpress.org/ticket/62811\">the Core Trac ticket</a>.</p>\n\n\n\n<p>A new maintenance release for each branch from 4.7 to 6.7 is now available. If you have sites on these branches and they support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The latest and only supported version of WordPress remains as 6.8.2. This is being done as a courtesy for sites still running older versions of WordPress. You can <a href=\"https://wordpress.org/wordpress-6.8.2.zip\">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/peterwilsoncc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>peterwilsoncc</a>, <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a>, <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a>, and <a href=\'https://profiles.wordpress.org/johnbillion/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>johnbillion</a> for backporting and releasing this update.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18997\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.8.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Jul 2025 15:41:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18903\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"WordPress 6.8.2 is now available! This minor release includes fixes for 20 Core tickets and 15 Block Editor issues. For a full list of bug fixes, please refer to the release candidate announcement. WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025. If you have sites that support [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10720:\"\n<h2 class=\"wp-block-heading\">WordPress 6.8.2 is now available!</h2>\n\n\n\n<p>This minor release includes fixes for <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.8.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">20 Core tickets</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/70557\">15 Block Editor issues</a>. For a full list of bug fixes, please refer to the <a href=\"https://make.wordpress.org/core/2025/07/08/wordpress-6-8-2-rc1-is-now-available/\">release candidate announcement.</a></p>\n\n\n\n<p>WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.2.zip\">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-8-2\">visit the HelpHub version page</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Dropping security updates for WordPress versions 4.1 through 4.6</h2>\n\n\n\n<p>This is not directly related to the 6.8.2 maintenance release, but <a href=\"https://wordpress.org/news/2025/06/dropping-security-updates-for-wordpress-versions-4-1-through-4-6/\">branches 4.1 to 4.6 had their final release today</a>. These branches won&#8217;t receive any security update anymore.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>WordPress 6.8.2 was led by <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a>.</p>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/sergeybiryukov/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sergeybiryukov</a>, <a href=\'https://profiles.wordpress.org/mamaduka/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mamaduka</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> and <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a> for their help on specific release tasks.</p>\n\n\n\n<p>WordPress 6.8.2 would not have been possible without the contributions of the following 96 people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-medium has-white-color has-midnight-gradient-background has-text-color has-background has-link-color has-normal-font-size wp-elements-2ad7deb15a87fd29427f001e4c18a1ac\"><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/alexstine\">Alex Stine</a>, <a href=\"https://profiles.wordpress.org/anatolbroder\">Anatol Broder</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/ankitkumarshah\">Ankit Kumar Shah</a>, <a href=\"https://profiles.wordpress.org/annezazu\">annezazu</a>, <a href=\"https://profiles.wordpress.org/azharderaiya\">Azhar Deraiya</a>, <a href=\"https://profiles.wordpress.org/benjamingosset\">Benjamin Gosset</a>, <a href=\"https://profiles.wordpress.org/bhubbard\">Brandon Hubbard</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brhodes\">brhodes</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/czarate\">Chris Zarate</a>, <a href=\"https://profiles.wordpress.org/courane01\">Courtney Robertson</a>, <a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/darshitrajyaguru97\">Darshit Rajyaguru</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhruvang21\">Dhruvang21</a>, <a href=\"https://profiles.wordpress.org/dilipbheda\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/divinenephron\">divinenephron</a>, <a href=\"https://profiles.wordpress.org/dustintechsmith\">dustintechsmith</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/im3dabasia1\">Eshaan Dabasiya</a>, <a href=\"https://profiles.wordpress.org/estelaris\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/faisalahammad\">Faisal Ahammad</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/guddu1315\">Gaurang Dabhi</a>, <a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gernberg\">gernberg</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/harshgajipara\">Harsh Gajipara</a>, <a href=\"https://profiles.wordpress.org/helgatheviking\">HelgaTheViking</a>, <a href=\"https://profiles.wordpress.org/abcd95\">Himanshu Pathak</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/JeffPaul\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/luminuu\">Jessica Lyschik</a>, <a href=\"https://profiles.wordpress.org/jigarpanchal\">Jigar Panchal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/mindctrl\">John Parris</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/kausaralm\">Kausar Alam</a>, <a href=\"https://profiles.wordpress.org/kishanjasani\">Kishan Jasani</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/pfefferle\">Matthias Pfefferle</a>, <a href=\"https://profiles.wordpress.org/megane9988\">megane9988</a>, <a href=\"https://profiles.wordpress.org/mosescursor\">Moses Cursor Ssebunya</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/mwillman1991\">mwillman1991</a>, <a href=\"https://profiles.wordpress.org/bugnumber9\">Nazar Hotsa</a>, <a href=\"https://profiles.wordpress.org/nidhidhandhukiya\">nidhidhandhukiya</a>, <a href=\"https://profiles.wordpress.org/nikunj8866\">Nikunj Hatkar</a>, <a href=\"https://profiles.wordpress.org/oferlaor\">oferlaor</a>, <a href=\"https://profiles.wordpress.org/oglekler\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/paulstanos\">paulstanos</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/puggan\">puggan</a>, <a href=\"https://profiles.wordpress.org/ravigadhiyawp\">Ravi Gadhiya</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rollybueno\">Rolly Bueno</a>, <a href=\"https://profiles.wordpress.org/room34\">room34</a>, <a href=\"https://profiles.wordpress.org/sainathpoojary\">Sainath Poojary</a>, <a href=\"https://profiles.wordpress.org/sajjad67\">Sajjad Hossain Sagor</a>, <a href=\"https://profiles.wordpress.org/Sam_a\">sam_a</a>, <a href=\"https://profiles.wordpress.org/sandeepdahiya\">Sandeep Dahiya</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shanemuir\">Shane Muirhead</a>, <a href=\"https://profiles.wordpress.org/siliconforks\">siliconforks</a>, <a href=\"https://profiles.wordpress.org/sirlouen\">SirLouen</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/sukhendu2002\">Sukhendu Sekhar Guria</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/TobiasBg\">Tobias Bäthge</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/ugyensupport\">Ugyen Dorji</a>, <a href=\"https://profiles.wordpress.org/uxl\">uxl</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>, <a href=\"https://profiles.wordpress.org/getsyash\">Yash B</a>, <a href=\"https://profiles.wordpress.org/yogeshbhutkar\">Yogesh Bhutkar</a>, and <a href=\"https://profiles.wordpress.org/zunaid321\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation on Slack, in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\">#6-8-release-leads</a> channels. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thanks to <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a> and <a href=\'https://profiles.wordpress.org/zunaid321/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>zunaid321</a> for proofreading.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Celebrating Kim Parsell: 2025 WordCamp US Scholarship Applications Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wordpress.org/news/2025/07/kim-parsell-2025-wcus-scholarship-applications-open/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Jul 2025 18:57:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18911\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"The WordPress Foundation is pleased to announce the return of the Kim Parsell Memorial Scholarship for WordCamp US 2025. Applications are being accepted until July 25, 2025. Remembering Kim Parsell Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6224:\"\n<p>The WordPress Foundation is pleased to announce the return of the <strong>Kim Parsell Memorial Scholarship</strong> for WordCamp US 2025. Applications are being accepted until <strong>July 25, 2025</strong>.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"604\" height=\"370\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=604%2C370&#038;ssl=1\" alt=\"\" class=\"wp-image-18912\" style=\"border-width:25px;border-radius:40px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?w=604&amp;ssl=1 604w, https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=300%2C184&amp;ssl=1 300w\" sizes=\"auto, (max-width: 604px) 100vw, 604px\" /></figure>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-6cbf45de wp-block-group-is-layout-constrained\" style=\"margin-top:48px;margin-bottom:48px;padding-top:24px;padding-bottom:24px\">\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:2%\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:96%\">\n<h2 class=\"wp-block-heading\">Remembering Kim Parsell</h2>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:40%\">\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"400\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=400%2C400&#038;ssl=1\" alt=\"\" class=\"wp-image-18956\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?w=400&amp;ssl=1 400w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=150%2C150&amp;ssl=1 150w\" sizes=\"auto, (max-width: 400px) 100vw, 400px\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:60%\">\n<p>Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, both online and in person. Each year at WordCamp US, the WordPress Foundation celebrates Kim’s legacy by supporting contributors who share her commitment and enthusiasm. The Kim Parsell Memorial Scholarship aims to make it easier for deserving community members to attend WordCamp US, reflecting Kim’s belief in making WordPress accessible and inclusive for all.</p>\n</div>\n</div>\n\n\n\n<p style=\"padding-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10)\">If you’re unfamiliar with Kim’s story or her invaluable role in the community, we encourage you to <a href=\"https://us.wordcamp.org/2019/memories-of-kim-parsell/\">read these heartfelt tributes</a> collected from friends and colleagues.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:2%\"></div>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Scholarship Eligibility</h2>\n\n\n\n<p>This year, a single scholarship will be awarded. To qualify, applicants must:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Identify as a woman</li>\n\n\n\n<li>Be actively involved as a contributor to WordPress</li>\n\n\n\n<li>Have never attended WordCamp US before</li>\n\n\n\n<li>Demonstrate a need for financial support to attend the event</li>\n</ul>\n\n\n\n<p>If you meet these qualifications, we invite you to apply before the July 25 deadline. All applicants will be notified of the decision by August 7, 2025.</p>\n\n\n\n<p>For additional information, visit the <a href=\"https://wordpressfoundation.org/projects/kim-parsell-memorial-scholarship/\">Kim Parsell Memorial Scholarship page</a> hosted by the WordPress Foundation.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><strong>Ready to Apply?</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://wordcampcentral.survey.fm/wcus-2025-kim-parsell-scholarship-application\">Submit Your Application Today</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"333\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=500%2C333&#038;ssl=1\" alt=\"\" class=\"wp-image-18917\" style=\"border-width:25px;border-radius:40px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?w=500&amp;ssl=1 500w, https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=300%2C200&amp;ssl=1 300w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Join the Celebration</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Tickets for WordCamp US 2025 are now available—secure yours soon!</li>\n\n\n\n<li>Volunteer applications are open until July 11, 2025</li>\n\n\n\n<li>Interested in supporting the event? Explore our <a>sponsorship opportunities</a></li>\n</ul>\n\n\n\n<p>Help us spread the word about this opportunity and make WordCamp US 2025 even more special.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18911\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Introducing WordPress Credits: A New Contribution Internship Program for University Students\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Jul 2025 16:56:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"WordPress Credits\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18913\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Isotta Peira\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4712:\"\n<p>The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in open source projects. This new program is designed to bridge that gap, nurturing future contributors and ensuring WordPress remains innovative, inclusive, and sustainable for years to come.</p>\n\n\n\n<p>The <a href=\"https://gamma.app/docs/EN-WordPress-Credits-vz0k2vr1ulg91qq?mode=doc\">pilot program</a>, developed in partnership with the University of Pisa, was announced on stage at WordCamp Europe 2025 by Matt Mullenweg and Mary Hubbard. Since then, it has attracted interest from students across various fields of study, including humanities, computer science, and communication. Companies in the WordPress ecosystem have also expressed support and interest in contributing to the project. In response to the growing interest from both community members and academic institutions, we are now inviting more universities to join the initiative.</p>\n\n\n\n<p>Open to students from all fields of study, the program blends structured onboarding with a personalized contribution project. Activities are adapted to each student’s degree program and familiarity with WordPress, aiming to develop transferable skills, academic-related competencies, and active participation in the WordPress community. Internship durations may vary depending on the university or educational institution. Some may align with academic semesters (typically 3–4 months), while others, like the University of Pisa, allow students to sign up year-round with a requirement to complete a set number of contribution hours (e.g. 150 hours). Flexible arrangements can be discussed to meet the specific requirements of each institution.</p>\n\n\n\n<p>Foundational Training includes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>An introduction to open source principles and the WordPress Foundation</li>\n\n\n\n<li>Getting familiar with community tools (Slack, Make blogs, Learn platform, GitHub)</li>\n\n\n\n<li>Setting up a personal WordPress site and publishing content</li>\n</ul>\n\n\n\n<p>Each student will choose a contribution area and design their own personal project within that area. Examples of possible projects include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Translating interfaces or documentation</li>\n\n\n\n<li>Creating multilingual subtitles for educational videos</li>\n\n\n\n<li>Contributing code or performing testing</li>\n\n\n\n<li>Supporting product development or design</li>\n\n\n\n<li>Writing or editing content</li>\n\n\n\n<li>Assisting with community event organization</li>\n\n\n\n<li>Developing training materials for Learn WordPress</li>\n\n\n\n<li>Creating open source tools</li>\n\n\n\n<li>And much more…<br></li>\n</ul>\n\n\n\n<p>Interns are guided by an experienced mentor specific to their chosen area and supported by a dedicated WordPress Foundation contact person throughout the program. All student contributions, whether code, translations, documentation, or educational materials, will be publicly visible and integrated into official WordPress projects and resources, directly benefiting the wider community.</p>\n\n\n\n<p><strong>Interested universities and educational institutions</strong> interested in participating can reach out by filling <a href=\"https://airtable.com/appIzQKfwTn5dyPVp/shrYvY0CDNIkILIre\">the interest form</a>.</p>\n\n\n\n<p>We also invite companies in the WordPress ecosystem to support this initiative by sponsoring mentors who will guide and empower the next generation of contributors, or by providing tools and resources that help students succeed in their contribution journey.&nbsp;</p>\n\n\n\n<p><strong>If your company is interested in getting involved</strong>, please visit the <a href=\"https://make.wordpress.org/handbook/wordpress-credits-contribution-internship-program/get-involved-company-guide/\">Company Guide</a> to learn more and <a href=\"https://airtable.com/appIzQKfwTn5dyPVp/shrKDkjeUdw8Fof34\">fill out the form</a> to join the program.</p>\n\n\n\n<p><em>By welcoming students, mentors, sponsors, and volunteers into this initiative, we are building a stronger and more connected WordPress community. Each person who takes part, whether they guide a student, share their experiences, provide sponsorship, or simply help spread the word, helps ensure that open source remains vibrant and accessible for all. Together, we are not just supporting individual contributors; we are shaping the future of WordPress and open source itself.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18913\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordCamp US 2025: See You in Portland, Oregon!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wordpress.org/news/2025/06/wordcamp-us-2025-see-you-in-portland-oregon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Jun 2025 18:14:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"WCUS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18884\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"WordCamp US 2025 is heading to vibrant Portland, Oregon, from August 26–29, 2025! Join fellow open source enthusiasts, developers, designers, and WordPress professionals from across the United States and around the world for four days of learning, networking, and collaboration at the Oregon Convention Center. Nestled in the Pacific Northwest, Portland is famous for its [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8274:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18885\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>WordCamp US 2025 is heading to vibrant Portland, Oregon, from August 26–29, 2025! Join fellow open source enthusiasts, developers, designers, and WordPress professionals from across the United States and around the world for four days of learning, networking, and collaboration at the Oregon Convention Center.</p>\n\n\n\n<p>Nestled in the Pacific Northwest, Portland is famous for its creative spirit, lush green spaces, and riverside trails, making it an inspiring backdrop for this year’s WordCamp. Whether building your first site or leading a digital agency, WordCamp US offers something for everyone, all set against the city’s stunning natural scenery.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://us.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">What to Expect</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Contributor Day: August 26</h3>\n\n\n\n<p>Kick off your WordCamp US experience by giving back. Contributor Day welcomes all skill levels to collaborate on teams that help make WordPress better, from code to community to documentation. You can make a difference to the project, and build new friendships or rekindle old ones, perhaps even while enjoying views of Portland’s skyline and tree-lined streets.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Main Conference: August 27–29</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Showcase Day &#8211; August 27</h4>\n\n\n\n<p>As part of the main conference, day one will give us a look at project showcases, discover innovative uses of WordPress, see how people push the platform’s boundaries, and get inspired to try something new.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Session Days + Expo Hall &#8211; August 28-29</h4>\n\n\n\n<p>Experience another two days filled with inspiring keynotes, practical sessions, and deep dives into the latest trends in web development, design, content, accessibility, and more. Hear from some of the brightest minds in the WordPress ecosystem and explore topics that get to the heart of what makes WordPress unique. Also, take some time to explore the main floors of WCUS, like the Sponsors Hall.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Networking and Community</h3>\n\n\n\n<p>Meet WordPress friends new and old, exchange ideas with community leaders, and collaborate with people who share your passion for open source. Enjoy daily lunches and a memorable social event, all included with your ticket. Stroll along the Willamette River or explore nearby parks in between sessions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Venue &amp; Accommodations</h3>\n\n\n\n<p>This year, we’re gathering at the Oregon Convention Center in the heart of Portland—a city known for its vibrant neighborhoods and abundant green spaces. We’ve secured a special hotel block right across the street at the Hyatt Regency Portland for convenient, comfortable lodging during your stay.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f3e2.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></strong> <strong>Oregon Convention Center<br></strong>777 NE Martin Luther King Jr Blvd<br>Portland, OR 97232<br></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f6cf.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Hyatt Regency Portland</strong><br>375 NE Holladay Street<br>Portland, OR 97232<br><a href=\"https://www.hyatt.com/en-US/group-booking/PDXRP/G-CAMP\">Book your room!</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Registration and Tickets</h2>\n\n\n\n<p>Registration officially kicked off last month. Secure your spot early; tickets are selling quickly.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://us.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Ready to Plan Your WordCamp US Experience?</h2>\n\n\n\n<p>Keep checking the <a href=\"https://us.wordcamp.org/2025/\">WordCamp US site</a> for travel tips, to book accommodations, and to watch for the whole event schedule—coming soon! While here, why not plan to take in some of Portland’s scenic hiking trails, bike-friendly streets, or local food scene?</p>\n\n\n\n<p>Stay tuned for updates and announcements on <a href=\"https://make.wordpress.org/marketing/handbook/social-media/\">WordPress social media channels</a>, and join the conversation.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help Us Spread the Word!</h3>\n\n\n\n<p>Whether attending in person or following along online, share your experience and help welcome others to the WordPress community. Use the #WCUS and #WordPress hashtags and tell your story on social!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18898\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Portland is calling—see you at WordCamp US 2025! <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f332.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"Dropping security updates for WordPress versions 4.1 through 4.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wordpress.org/news/2025/06/dropping-security-updates-for-wordpress-versions-4-1-through-4-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2025 15:26:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18872\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:331:\"As of July 2025, the WordPress Security Team will no longer provide security updates for WordPress versions 4.1 through 4.6. These versions were first released nine or more years ago and over 99% of WordPress installations run a more recent version. The chances this will affect your site, or sites, is very small. If you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3132:\"\n<p>As of July 2025, the WordPress Security Team will no longer provide security updates for WordPress versions 4.1 through 4.6.</p>\n\n\n\n<p>These versions were first released nine or more years ago and over 99% of WordPress installations run a more recent version. The chances this will affect your site, or sites, is very small.</p>\n\n\n\n<p>If you are unsure if you are running an up-to-date version of WordPress, please log in to your site’s dashboard. Out of date versions will display a notice that looks like this:</p>\n\n\n\n<figure class=\"wp-block-image size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1048\" height=\"122\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=1048%2C122&#038;ssl=1\" alt=\"Dashboard notice: &quot;WordPress 6.8.1 is available! Please update now.&quot;\" class=\"has-border-color has-luminous-vivid-amber-border-color wp-image-18873\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?w=1048&amp;ssl=1 1048w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=300%2C35&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=1024%2C119&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=768%2C89&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>The version you are running is displayed in the bottom of the “At a Glance” section of the dashboard.</p>\n\n\n\n<figure class=\"wp-block-image size-large has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"281\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1024%2C281&#038;ssl=1\" alt=\"At a glance widget showing a site running WordPress 4.1.41\" class=\"has-border-color has-cyan-bluish-gray-border-color wp-image-18875\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1024%2C281&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=300%2C82&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=768%2C211&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1536%2C421&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?w=1798&amp;ssl=1 1798w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>As a reminder, the only <em>actively</em> supported version of WordPress is the most recent one. Security updates are only backported to older branches as a courtesy.</p>\n\n\n\n<p>The Make WordPress Security blog has further details about <a href=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\" data-type=\"link\" data-id=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\">the process to end support</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18872\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WCEU 2025: A Community Celebration in the Swiss Sun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wordpress.org/news/2025/06/wceu-2025-a-community-celebration-in-the-swiss-sun/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Jun 2025 19:19:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"WCEU\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18776\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:362:\"Over 1,723 attendees from 84 countries gathered at the Messe and Congress Center Basel in Switzerland, and 20,353 more joined online for WordCamp Europe 2025. I’m personally very excited&#8230; There’s so much I want to do. I think there’s a clear pathway to 7.0 and beyond. Matt Mullenweg, WordPress Cofounder The flagship WordPress event kicked [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:61400:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18837\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\"><em>Photo by Nilo Velez</em></figcaption></figure>\n\n\n\n<p>Over 1,723 attendees from 84 countries gathered at the Messe and Congress Center Basel in Switzerland, and 20,353 more joined online for WordCamp Europe 2025.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>I’m personally very excited&#8230; There’s so much I want to do. I think there’s a clear pathway to 7.0 and beyond.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The flagship WordPress event kicked off in Basel, Switzerland, with a dedicated Contributor Day. It was followed by two days of engaging talks, panels, hands-on workshops, and vibrant community connections. WordPress Cofounder Matt Mullenweg and Executive Director Mary Hubbard joined a diverse lineup of speakers and panelists, sharing insights in the heart of one of Europe’s most charming cities.</p>\n\n\n\n<p>Set against the backdrop of Basel’s historic streets and Rhine-side views, the sponsor hall buzzed with activity as companies from across the WordPress ecosystem showcased their latest innovations, offered live demos, and connected with attendees. Each day, participants refueled with a range of local and international cuisine — from Swiss specialties to global favorites — making mealtime a lively space for networking, collaboration, and sparking new ideas.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Basel</h2>\n\n\n\n<p>WordCamp Europe has long been one of the most anticipated WordPress events of the year — a space where community, creativity, and collaboration thrive. This year in Basel, the conference delivered an exciting and diverse program that reached every corner of the WordPress ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> &#8211; Across two full days, the conference featured informative talks, captivating keynotes, and dynamic discussions exploring WordPress and the broader web.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> &#8211; The stage welcomed 52 speakers from 23 countries across five continents, each bringing unique insights and global perspectives.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> &#8211; The schedule included 45 sessions and four hands-on workshops across three tracks, covering:\n<ul class=\"wp-block-list\">\n<li>Accessibility and key policy updates like the European Accessibility Act and the Cyber Resilience Act</li>\n\n\n\n<li>The evolving role of Artificial Intelligence in the open web</li>\n\n\n\n<li>Cutting-edge web design, development best practices, SEO, and content strategy</li>\n\n\n\n<li>Real-world case studies and showcases from across the community</li>\n</ul>\n</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> &#8211; Interactive workshops allowed attendees to roll up their sleeves and develop practical skills in a collaborative setting.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> &#8211; Whether developer, designer, content creator, or entrepreneur, every attendee found space to connect, learn, and grow within a vibrant and welcoming community.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day</h2>\n\n\n\n<p>WordCamp Europe began with a vibrant Contributor Day that brought together 640 contributors—including many first-timers—to collaborate, share knowledge, and support the WordPress project. Guided by 33 dedicated table leads, with 21 teams, attendees of all experience levels came together to exchange ideas, solve real challenges, and make meaningful contributions to open source. From accessibility improvements to theme development and translation efforts, every table played a part in moving WordPress forward.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-3 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d204ee25&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d204ee25\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18798\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18798\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d204f0f5&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d204f0f5\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18799\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18799\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d204f399&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d204f399\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18800\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18800\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d204f63c&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d204f63c\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18801\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18801\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Roan de Vries</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d204f8ea&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d204f8ea\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18802\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18802\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d204fb76&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d204fb76\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18803\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18803\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d204fde5&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d204fde5\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18804\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18804\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d205007f&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d205007f\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18805\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18805\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Levente András Tóth</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20502f5&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20502f5\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18806\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18806\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20505a9&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20505a9\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18807\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18807\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Levente András Tóth</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2050836&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2050836\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18808\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18808\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Sebastián Echeverri Jaramillo</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2050ad8&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2050ad8\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18809\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18809\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2050d8d&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2050d8d\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18810\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18810\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n</figure>\n\n\n\n<p>Contributor Day at WordCamp Europe 2025 brought together a mix of first-time and returning contributors across a wide range of teams, from Core and Accessibility to Polyglots, Training, and Community. Attendees tackled everything from onboarding and ticket triage to translating strings, improving documentation, and enhancing tools and workflows. Development-focused teams explored performance and testing improvements and worked through live coding exercises. Meanwhile, accessibility testers, support volunteers, and photo moderators contributed to efforts that directly impact users around the world.</p>\n\n\n\n<p>In parallel, teams like Marketing, Meta, Hosting, and Sustainability focused on future-facing initiatives—from promoting WordPress through the Showcase and social media campaigns to refining infrastructure, increasing accessibility, and preparing for long-term project growth. Whether contributing to plugins, themes, documentation, or new contributor experiences, participants reinforced the values that power the WordPress project: collaboration, inclusivity, and openness. The day served as a reminder that WordPress is not just software—it’s a community built by and for everyone.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Tomorrow Starts with WordPress</h2>\n\n\n\n<p>The first full day of WordCamp Europe 2025 brought the community together to celebrate the power of open source collaboration and innovation. Opening remarks from both global and local event leads reflected on the journey of WordCamp Europe—from its beginnings in 2013 in Leiden, Netherlands, to the vibrant event in Basel today. This full-circle moment underscored the growth of the WordPress community, united by a shared commitment to an open web.</p>\n\n\n\n<p>The day launched into an inspiring program with the keynote session, <em>WordPress Without Borders – The Fight for Digital Freedom</em>, delivered by Noel Tock. Drawing from his experiences—including time on the frontlines in Ukraine—Tock illustrated how open source supports global resilience and serves as a digital human right. His message called on contributors to see their work as part of something greater, offering a compelling and forward-looking vision to energize and unify the WordPress community.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordPress without Borders — The Fight for Digital Freedom | Noel Tock\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/tb_A-ABehnY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, the program unfolded across multiple tracks—each one sparking new conversations and insights. One standout session highlighted social entrepreneurship in Bulgaria, where WordPress is helping grassroots organizations drive change in education, journalism, and social justice. Petya Raykovska shared how nonprofits like Teenovator and the Bulgarian Fund for Women are using WordPress to amplify their work and strengthen their communities.</p>\n\n\n\n<p>Designers and developers explored ways to improve workflows and collaboration. In <em>Bridging Design and Development</em>, attendees learned how Figma Design Systems can connect design and development through shared structures mapped to block themes. Real-world examples, like the Novus Media Newspaper Design System, demonstrated how scalable, consistent design can power multi-brand platforms.</p>\n\n\n\n<p>Workshops played a key role throughout the day, including the interactive <em>Block Developer Cookbook: WCEU 2025 Edition</em>, where attendees worked through community-voted code recipes featuring the latest WordPress APIs. Sessions also dove into emerging technologies, such as <em>Automating WordPress Setup with Modern AI Tools</em>, which showcased how WP-CLI, scripting, and AI can accelerate project setup and reduce repetitive tasks.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18817\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\"><em>Photo by Marc Wieland</em></figcaption></figure>\n\n\n\n<p>Day Two of WordCamp Europe 2025 opened with a focus on the evolving role of the WordPress community in a rapidly changing digital world. Sessions explored how contributors—from local meetup organizers to global advocates—play a vital part in shaping WordPress’s future. Talks on inclusivity, such as <em>Over the Rainbow</em>, encouraged attendees to consider how individual actions can help build a more welcoming, representative open source ecosystem. Throughout the morning, the spirit of collaboration and shared purpose remained front and center.</p>\n\n\n\n<p>As the day progressed, attention turned to the tools and technologies pushing WordPress forward. From sessions on scaling multilingual sites and managing observability to hands-on workshops, developers explored new ways to streamline workflows and enhance performance. Highlights included <em>WordPress Gems for Devs</em>, which introduced the Interactivity API through live coding, and <em>Client-side Web AI Agents</em>, a look at cutting-edge browser-based AI that unlocks new possibilities for web experiences. These talks reflected the platform’s growing capacity to adapt to emerging trends while staying true to its open foundations.</p>\n\n\n\n<p>The afternoon brought a blend of practical guidance and inspiring stories across tracks. A case study on accessibility from Switzerland showed how thoughtful design can benefit all users, while a session on brand-building for women entrepreneurs highlighted the creative and economic opportunities WordPress enables. With topics spanning content strategy, business growth, regulatory readiness, and more, the second day of WCEU 2025 affirmed the strength of the WordPress ecosystem—not only as a technology platform, but as a global movement fueled by people, purpose, and possibility.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Fireside Chat</h2>\n\n\n\n<p>As the final day drew to a close, Matt and Mary shared some thoughts on EU regulation (Open Web Alliance), AI, and the introduction of the WordPress AI team, and then answered questions from the audience.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"Fireside chat with Q&amp;A | Mary Hubbard and Matt Mullenweg\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/mzJwYejWUbY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>A heartfelt thank you to the dedicated organizers who brought WordCamp Europe 2025 to life in Basel, the speakers who shared their insights, the attendees who joined us in person, and those who followed along from afar. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-4 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20514b7&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20514b7\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18827\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18827\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d205176a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d205176a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18825\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18825\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Chris Clarke</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2051a15&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2051a15\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18824\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18824\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2051ca4&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2051ca4\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18823\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18823\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2051f53&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2051f53\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"684\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18822\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=1024%2C684&#038;ssl=1\" alt=\"\" class=\"wp-image-18822\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=1024%2C684&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=768%2C513&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Maksym Kaharlytskyi</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20521cd&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20521cd\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"799\" height=\"533\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18821\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?resize=799%2C533&#038;ssl=1\" alt=\"\" class=\"wp-image-18821\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?w=799&amp;ssl=1 799w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?resize=768%2C512&amp;ssl=1 768w\" sizes=\"auto, (max-width: 799px) 100vw, 799px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Chris Clarke</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d20524a6&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d20524a6\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18820\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18820\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Atsushi Ando</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2052781&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2052781\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18819\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18819\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2052a79&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2052a79\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18829\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18829\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68f84d2052d03&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68f84d2052d03\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"682\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18859\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=1024%2C682&#038;ssl=1\" alt=\"\" class=\"wp-image-18859\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=1024%2C682&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=1536%2C1023&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the final major WordPress events in 2025: <a href=\"https://us.wordcamp.org/2025/\">WordCamp US</a> (Portland, Oregon, USA). Then join us in <a href=\"https://europe.wordcamp.org/2026/\">Kraków, Poland for WordCamp Europe 2026</a>! Also, if you want to get involved with WCEU, the call for organisers is already open for 2026. </p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18776\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 22 Oct 2025 03:27:17 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 30 Sep 2025 20:04:41 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1741948238;s:21:\"cache_expiration_time\";i:1761146837;s:23:\"__cache_expiration_time\";i:1761146837;}","off");
INSERT INTO `wp_options` VALUES("101260","_pre_user_id","2","auto");
INSERT INTO `wp_options` VALUES("101261","theme_dc_aluma_tools","1","auto");
INSERT INTO `wp_options` VALUES("101262","theme_aluma_times","1","auto");
INSERT INTO `wp_options` VALUES("76581","litespeed.conf.cdn-cloudflare_clear","","auto");
INSERT INTO `wp_options` VALUES("92758","litespeed.conf.img_optm-sizes_skipped","[]","auto");
INSERT INTO `wp_options` VALUES("101688","_site_transient_timeout_community-events-3fdd55566f15f018f99c497ad41bb86c","1761146837","off");
INSERT INTO `wp_options` VALUES("101689","_site_transient_community-events-3fdd55566f15f018f99c497ad41bb86c","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"198.181.46.0\";}s:6:\"events\";a:5:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:66:\"*IN PERSON* WordPress Pasadena Meetup, October 29th @ Foundr Space\";s:3:\"url\";s:59:\"https://www.meetup.com/wordpress-pasadena/events/311428119/\";s:6:\"meetup\";s:11:\"WP Pasadena\";s:10:\"meetup_url\";s:42:\"https://www.meetup.com/wordpress-pasadena/\";s:4:\"date\";s:19:\"2025-10-29 19:00:00\";s:8:\"end_date\";s:19:\"2025-10-29 21:00:00\";s:20:\"start_unix_timestamp\";i:1761789600;s:18:\"end_unix_timestamp\";i:1761796800;s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Pasadena , CA, USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:34.147404;s:9:\"longitude\";d:-118.14906;}}i:1;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:37:\"#IEWP Monthly Meetup (General Meetup)\";s:3:\"url\";s:55:\"https://www.meetup.com/inlandempirewp/events/311561825/\";s:6:\"meetup\";s:36:\"Inland Empire WordPress Meetup Group\";s:10:\"meetup_url\";s:38:\"https://www.meetup.com/inlandempirewp/\";s:4:\"date\";s:19:\"2025-11-04 19:00:00\";s:8:\"end_date\";s:19:\"2025-11-04 21:00:00\";s:20:\"start_unix_timestamp\";i:1762311600;s:18:\"end_unix_timestamp\";i:1762318800;s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Riverside, CA, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:33.981945;s:9:\"longitude\";d:-117.3694;}}i:2;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:66:\"How to Plan a Local WordCamp or WordPress Event (in Santa Clarita)\";s:3:\"url\";s:53:\"https://www.meetup.com/wordpressscv/events/311372954/\";s:6:\"meetup\";s:30:\"WordPress Santa Clarita Valley\";s:10:\"meetup_url\";s:36:\"https://www.meetup.com/wordpressscv/\";s:4:\"date\";s:19:\"2025-11-05 16:00:00\";s:8:\"end_date\";s:19:\"2025-11-05 17:00:00\";s:20:\"start_unix_timestamp\";i:1762387200;s:18:\"end_unix_timestamp\";i:1762390800;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:34.49;s:9:\"longitude\";d:-118.43;}}i:3;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:41:\"VIRTUAL WordPress Developer Night - #IEWP\";s:3:\"url\";s:55:\"https://www.meetup.com/inlandempirewp/events/310267165/\";s:6:\"meetup\";s:36:\"Inland Empire WordPress Meetup Group\";s:10:\"meetup_url\";s:38:\"https://www.meetup.com/inlandempirewp/\";s:4:\"date\";s:19:\"2025-11-11 19:00:00\";s:8:\"end_date\";s:19:\"2025-11-11 21:00:00\";s:20:\"start_unix_timestamp\";i:1762916400;s:18:\"end_unix_timestamp\";i:1762923600;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:33.99;s:9:\"longitude\";d:-117.37;}}i:4;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:59:\"Site Studio and the Basics of WordPress Local/Testing Tools\";s:3:\"url\";s:53:\"https://www.meetup.com/wordpressscv/events/311372970/\";s:6:\"meetup\";s:30:\"WordPress Santa Clarita Valley\";s:10:\"meetup_url\";s:36:\"https://www.meetup.com/wordpressscv/\";s:4:\"date\";s:19:\"2025-11-12 16:00:00\";s:8:\"end_date\";s:19:\"2025-11-12 17:30:00\";s:20:\"start_unix_timestamp\";i:1762992000;s:18:\"end_unix_timestamp\";i:1762997400;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:34.49;s:9:\"longitude\";d:-118.43;}}}}","off");
INSERT INTO `wp_options` VALUES("100990","litespeed.conf._version","7.6.2","auto");
INSERT INTO `wp_options` VALUES("101519","wp_calendar_block_has_published_posts","1","auto");
INSERT INTO `wp_options` VALUES("92356","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1761082337;s:7:\"checked\";a:11:{s:13:\"betheme-child\";s:5:\"1.6.2\";s:7:\"betheme\";s:6:\"21.9.7\";s:10:\"extendable\";s:6:\"2.0.29\";s:14:\"twentynineteen\";s:3:\"3.1\";s:15:\"twentyseventeen\";s:3:\"3.9\";s:13:\"twentysixteen\";s:3:\"3.6\";s:16:\"twentytwentyfive\";s:3:\"1.3\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:15:\"twentytwentyone\";s:3:\"2.6\";s:17:\"twentytwentythree\";s:3:\"1.6\";s:15:\"twentytwentytwo\";s:3:\"2.0\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:9:{s:10:\"extendable\";a:6:{s:5:\"theme\";s:10:\"extendable\";s:11:\"new_version\";s:6:\"2.0.29\";s:3:\"url\";s:40:\"https://wordpress.org/themes/extendable/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/extendable.2.0.29.zip\";s:8:\"requires\";s:3:\"6.6\";s:12:\"requires_php\";s:3:\"7.4\";}s:14:\"twentynineteen\";a:6:{s:5:\"theme\";s:14:\"twentynineteen\";s:11:\"new_version\";s:3:\"3.1\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentynineteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentynineteen.3.1.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentyseventeen\";a:6:{s:5:\"theme\";s:15:\"twentyseventeen\";s:11:\"new_version\";s:3:\"3.9\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentyseventeen/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentyseventeen.3.9.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:13:\"twentysixteen\";a:6:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"3.6\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.3.6.zip\";s:8:\"requires\";s:3:\"4.4\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.3.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"2.6\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.2.6.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.2.0.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}","off");
INSERT INTO `wp_options` VALUES("101693","_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1761146837","off");
INSERT INTO `wp_options` VALUES("101694","_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1761103637","off");
INSERT INTO `wp_options` VALUES("101695","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1761146838","off");
INSERT INTO `wp_options` VALUES("101696","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:112:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: #190 – Seth Rubenstein on Block Composability in WordPress’ Future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=200244\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/podcast/190-seth-rubenstein-on-block-composability-in-wordpress-future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59361:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, block composability, what it is and how it&#8217;s shaping WordPress&#8217;s future.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Seth Rubenstein. Seth is the head engineer at the Pew Research Center, where he leads a team of developers managing the organization&#8217;s WordPress based publishing platform for its news site. Passionate about open source, Seth ensures that everything his team builds not only meets the Pew Research Center&#8217;s needs, but also benefits the wider community. By actively contributing to the Gutenberg project, he strives to share their solutions, always asking how their work can be given back to help others in the WordPress ecosystem.</p>\n\n\n\n<p>Seth shares fascinating stories from the work he&#8217;s been doing recently. He breaks down what block composability means, the ability to build modular, reusable, and even interactive blocks that work seamlessly together, empowering both developers and end users to create sophisticated web applications within the familiar WordPress block editor.</p>\n\n\n\n<p>The conversation gets into some of WordPress&#8217;s newest, and most promising, features including the Block Bindings API, Block Bits, which is still very much in development, and the Interactivity API. Seth explains how these tools open a world of possibilities, like building interactive quizzes, dynamically updating content, or even prefetching data, all using blocks, without having to rely on custom React front ends, or heavy server side processing.</p>\n\n\n\n<p>Seth also talks about the path forward for democratizing these advanced capabilities, discussing current limitations, the potential for new UI tools, and what&#8217;s still missing in the quest for truly responsive device contextual blocks.</p>\n\n\n\n<p>Throughout the episode, Seth makes a compelling case for why now is a golden opportunity for developers and plugin builders to start experimenting, get involved, and shape the next evolution of WordPress as a cutting edge web application platform.</p>\n\n\n\n<p>Whether you&#8217;re a developer curious about the future of Gutenberg, or an editor dreaming of more drag and drop web app power, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Seth Rubenstein.</p>\n\n\n\n<p>I am joined on the podcast by Seth Rubenstein. How are you doing, Seth?</p>\n\n\n\n<p>[00:03:40] <strong>Seth Rubenstein:</strong> Very good. How about you?</p>\n\n\n\n<p>[00:03:41] <strong>Nathan Wrigley:</strong> Yeah, good. Nice to have you back.</p>\n\n\n\n<p>[00:03:42] <strong>Seth Rubenstein:</strong> Yeah, second time.</p>\n\n\n\n<p>[00:03:43] <strong>Nathan Wrigley:</strong> This doesn&#8217;t happen too many times. I&#8217;ve got to be perfectly honest with you, the audience, I&#8217;ve already said this to Seth. Each time I come to WordCamp US, I&#8217;m always confounded by how remarkably clever people are, and the depth of the content is sometimes beyond me. I think this is one of those examples.</p>\n\n\n\n<p>I think there&#8217;s a high chance that you are going to have to shepherd me. There&#8217;s probably going to be a lot of editing, when I pause and you explain what you are talking about. So let&#8217;s get into it. First of all, tell us a little bit about you, where you work, what you do in the WordPress space.</p>\n\n\n\n<p>[00:04:10] <strong>Seth Rubenstein:</strong> Sure. So I work for Pew Research Center. I&#8217;m the head of engineering there. I manage a team of four other developers, and I like to tell people that we work with and on WordPress every day.</p>\n\n\n\n<p>We manage a publishing platform for a small news site in the US, Pew Research, but we also contribute to Gutenberg. Everything that we do, everything that we build day in and day out, we try to do from a perspective of how can we open source this? How can we contribute this back to Gutenberg in some way? What can we build to fulfill our needs that would also fulfill other people&#8217;s needs?</p>\n\n\n\n<p>[00:04:39] <strong>Nathan Wrigley:</strong> You said a small organisation, the Pew Research Center. I don&#8217;t actually know what they do.</p>\n\n\n\n<p>[00:04:44] <strong>Seth Rubenstein:</strong> We are a nonprofit, call ourselves a fact tank. What we do is we survey the American public on a variety of issues. Where are they on things like abortion, or religion, or crime, or the economy, or the use of AI, whatever. And we like to kind of say we hold up a mirror to the American public to tell them what they believe back to them.</p>\n\n\n\n<p>[00:05:04] <strong>Nathan Wrigley:</strong> And so is the WordPress website that you have with them, is that a mechanism to distribute that data back to the public?</p>\n\n\n\n<p>[00:05:09] <strong>Seth Rubenstein:</strong> Yes, yes.</p>\n\n\n\n<p>[00:05:10] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s interesting. So it&#8217;s a data heavy industry that you are dealing with.</p>\n\n\n\n<p>[00:05:13] <strong>Seth Rubenstein:</strong> It is. It is. We&#8217;re very, a kind of academic research institution, but we publish in kind of a news oriented way.</p>\n\n\n\n<p>[00:05:21] <strong>Nathan Wrigley:</strong> Okay. So we figured out a little bit about you, however you are here at WordCamp US to do a presentation. I actually don&#8217;t know if you&#8217;ve done it</p>\n\n\n\n<p>[00:05:28] <strong>Seth Rubenstein:</strong> I have, yeah. I did it the other day.</p>\n\n\n\n<p>[00:05:29] <strong>Nathan Wrigley:</strong> How did it go?</p>\n\n\n\n<p>[00:05:29] <strong>Seth Rubenstein:</strong> It went okay. I had a problem with my speaker notes, so I had to ad lib a good bit of it. So it might not be as coherent, or clear as it should have been.</p>\n\n\n\n<p>[00:05:41] <strong>Nathan Wrigley:</strong> Well we&#8217;re here to fix that. You can ad lib all you like here. So it was called, and forgive the pronunciation if I get this wrong, Block Composability: The Past and The Future. I&#8217;m actually just going to read the blurb into the record. And I&#8217;ll also make sure that there&#8217;s a link in the show notes to the page at the WordCamp US website where you can find out about the content. And also if by the time this comes out a WordPress TV episode with your presentation has landed, then I&#8217;ll mention that as well.</p>\n\n\n\n<p>Gutenberg excels at crafting beautiful static content, but what if you could empower anyone to build dynamic, interactive web experiences directly within the Block Editor? This session dives into block composability, a powerful concept that enables the creation of rich, interactive content using blocks, making advanced web development accessible to even less technically inclined users, which begs the question, what is block composability?</p>\n\n\n\n<p>[00:06:31] <strong>Seth Rubenstein:</strong> Block composability, I guess let&#8217;s define composability first. Composability in computer science and in software development is the idea that you can create and assemble web applications with reusable components in a modular way. That&#8217;s really all that means.</p>\n\n\n\n<p>If you&#8217;ve ever used React, if you&#8217;ve ever written in React, it means React Component, really. It&#8217;s a self-contained modular unit that can act on its own, but when plugged in with other units, it becomes something new, or extend its functionality or changes its functionality in some way.</p>\n\n\n\n<p>[00:07:01] <strong>Nathan Wrigley:</strong> When Gutenberg dropped, I had this notion that we were going to see mini apps inside of a block. So for example, I had this notion that right off the bat, so I&#8217;m going back to 2018 or something, when Gutenberg was still a, so prior to when it was in Core, let&#8217;s go with that. And I had this notion that you would drop in, let&#8217;s say a real estate block, and that block would encapsulate all the information about this particular house. And you would drop in the block and it would ask you a bunch of questions about the house and out would come a house custom post type, if you like.</p>\n\n\n\n<p>However, what happened was we got paragraph blocks, and we got an image block, and we got these fairly, well, useful, but they do one thing. They do a paragraph. They do an image, and that seems to be kind of where it ended. Are you trying to draw a line in the sand where it&#8217;s possible to go beyond that simple, does one thing, paragraph, image, to more the, we have a real estate block with loads of different facets and capabilities?</p>\n\n\n\n<p>[00:07:57] <strong>Seth Rubenstein:</strong> That&#8217;s right, yeah. I think where we&#8217;re at now is we&#8217;ve reached a point where the block editor, Gutenberg, in both its block editor and site editor kind of flavors, is you can build web applications. Blocks can do something now. They&#8217;re not just presenting text or an image and they&#8217;re kind of static and, you know, maybe you can style them differently from one post to another, but now they can actually do something.</p>\n\n\n\n<p>And more importantly, they can communicate with one another. You know, one block is adjacent to another. It can tell that block what to do when you click on it. If it&#8217;s inside of it, it can change its functionality accordingly. So you might imagine, we have a quiz builder. That&#8217;s actually one of our, probably our most technical product.</p>\n\n\n\n<p>And the way it works is there&#8217;s a results block where you can build out your results page for your quiz, but if you were to drop in a special block for, we have a special quiz that does scoring a very specific way, well, it changes the scoring functionality in the quiz builder. It doesn&#8217;t overwrite that. If you take that block out, the scoring functionality returns back to normal.</p>\n\n\n\n<p>So now we&#8217;re at a point where it&#8217;s very much possible to build web applications in the block editor with blocks.</p>\n\n\n\n<p>[00:09:00] <strong>Nathan Wrigley:</strong> So this little quiz block that you&#8217;ve described, if I was using, so ignore the developer experience and everything that you have built, the technicalities of all that. If I was somebody that was working for the Pew Research Center and I was, I don&#8217;t know, an editor and I needed to create a quiz, would that be my process? I drop in the quiz block, and boom, I have a quiz.</p>\n\n\n\n<p>[00:09:20] <strong>Seth Rubenstein:</strong> It&#8217;s really simple. You would go into, we do kind of store it all in a nice post type. So there&#8217;s a quiz post type. And then you open that up, you say, I want to go make a new quiz. And by default, there&#8217;s a quiz, we call it the quiz controller block that&#8217;s there first. And we have a few templated things in there for you. So like a start page and a question, an answer, and all of those things are block. So a question is a block, and inside of that question goes the answers for that question. That&#8217;s a block.</p>\n\n\n\n<p>Go further than that, we also have these kind of bindings. So you drop an answer in, well, there&#8217;s text for the answer, right? What if you want an image in there? What if you want a chart? What if you want a video? What if you want some other interactive piece of content to be corresponding to that answer? Well, you can drop that in too. And you can kind of freely move all these things within an answer, while still having that text bound to the answer block.</p>\n\n\n\n<p>So it&#8217;s a highly technical product, but for the editors, for the designers, it is literally just drag, drop, drag, drop, drag, drop. Create a page, create a question, type in your answer.</p>\n\n\n\n<p>[00:10:16] <strong>Nathan Wrigley:</strong> So in the world of 2018 that I alluded to a moment ago when the block editor launched, it feels like there were big missing pieces that prevented what you&#8217;ve just described. And maybe they&#8217;re APIs. I think possibly in some scenarios they are. What are the bits more recently, I don&#8217;t even know if it&#8217;s more recently in all honesty, but what are the bits that have enabled the features that you&#8217;ve just described?</p>\n\n\n\n<p>[00:10:38] <strong>Seth Rubenstein:</strong> Sure. So I think it&#8217;s funny that you bring back to 2018 because we built Quiz Builder in 2019. I think I&#8217;ll go on the record here and say, I think it might be the first kind of product in Gutenberg that was drag and drop building web applications. So I think we kind of pushed really early on the idea of composability inside of Gutenberg.</p>\n\n\n\n<p>And I see it as, there are kind of three waves in Gutenberg. First was, okay, Gutenberg is a CSS generator. That&#8217;s how I first kind of imagined it. You&#8217;re creating content and you have a style system and that outputs some CSS for your site.</p>\n\n\n\n<p>And then we got, I think the kind of HTML part of that a few years later. With the site editor and the theming inside of the block editor and things like that.</p>\n\n\n\n<p>And now we&#8217;ve gotten to the JavaScript part of Gutenberg. Where WordPress has the Inactivity API. And so this is a WordPress native JavaScript framework, so blocks can do something on the front end. And I think that is really the key innovation that&#8217;s really opened this up in just the last 12, 16 months.</p>\n\n\n\n<p>[00:11:35] <strong>Nathan Wrigley:</strong> Are there any APIs that have enabled you to short circuit? So again, in 2018, I would imagine there was quite a lot of heavy lifting that you needed to do order to pull that off, to innovate in that way. Are there any things which have fallen, I think quite recently actually, that have enabled it to be more available to developers who don&#8217;t have the time available that you did?</p>\n\n\n\n<p>[00:11:56] <strong>Seth Rubenstein:</strong> Yeah, I mean, so in 2019 when we did this, you know, all we really had was this ability to kind of scaffolded out these quizzes. The were pretty static in their layout. You drop a question and there were the answers in there, and you could type them in and that was it. No images inside the quiz, nothing like that.</p>\n\n\n\n<p>Now, thanks to things like block bindings, block bits, which we can go into in a little bit.</p>\n\n\n\n<p>[00:12:18] <strong>Nathan Wrigley:</strong> Yeah, we&#8217;d need to I think.</p>\n\n\n\n<p>[00:12:19] <strong>Seth Rubenstein:</strong> And the Interactivity API, you know, it is, everything is less static. Everything is less set in stone now. With things like the HTML Tag Processor, you can say, oh, this answer has this flag on it so we&#8217;re going to change out some of the HTML in it, in kind of real time before it gets to the front end for users. That just really wasn&#8217;t possible before, without a lot of work. It wasn&#8217;t very performant.</p>\n\n\n\n<p>Now all those things are in place for developers to really tap into. And the documentation and examples are there too, because that was the problem before, I think, is that a lot of people had to figure out how to do this, and now there are real world examples out there.</p>\n\n\n\n<p>[00:12:52] <strong>Nathan Wrigley:</strong> So you mentioned, quickly skirted over three things there. So there was Block Bits, Block Bindings, which I think the full title would be Block Bindings API, and the Interactivity API, which I think is like a child of the HTML API. I&#8217;m not entirely sure about that, but.</p>\n\n\n\n<p>[00:13:07] <strong>Seth Rubenstein:</strong> It utilises the HTML components.</p>\n\n\n\n<p>[00:13:10] <strong>Nathan Wrigley:</strong> Okay. Let&#8217;s just go through what those three things are in whatever order suits the purposes of this podcast best, because I don&#8217;t know which one you&#8217;d start on.</p>\n\n\n\n<p>[00:13:16] <strong>Seth Rubenstein:</strong> Let&#8217;s start with Block Bindings API. I would actually imagine a good number of people are familiar with this. This has come up a lot in the last year in the Gutenberg project. What that really lets you do is use Core blocks more effectively.</p>\n\n\n\n<p>For example, before, if you wanted to have a button and you wanted to do a very specific thing and look a very specific way, well, good luck. You had to make your own button. Sure there was the Core button and you could style it to some degree, but what it did was it went to a link.</p>\n\n\n\n<p>Now with things like Block Bindings, you can say, okay, well, I have my Core button and I&#8217;m going to style it however I want, but the interior text, you know, what it says, what it does, well, that can be done kind of programmatically on the backend. That&#8217;s where the Block Bindings API comes in. It lets you use Core blocks and change them, well, not Core blocks, any blocks, really, and change them to fit your needs.</p>\n\n\n\n<p>[00:14:07] <strong>Nathan Wrigley:</strong> Can you give us a concrete example of that? So you&#8217;ve just talked about the button, you mentioned a sort of, I was struggling to grasp what you were meaning about changing the text programmatically. How would you do that? What would be an example?</p>\n\n\n\n<p>[00:14:18] <strong>Seth Rubenstein:</strong> Let me give you an example of that, Core paragraph. Very useful with block bindings. And I mentioned answers. So we have this answer block, right? And before it just had a text field in it. You would type in the answer and that was it. That was all you saw. And that meant that you couldn&#8217;t do anything inside of the answer. You couldn&#8217;t provide any other content inside there, because that would then get rolled up as the answer.</p>\n\n\n\n<p>So now with Block Bindings, what we have is we have this core paragraph binding that you can drop into the answer, and it is a text field still. You can type into it. It&#8217;s storing that on the answer block and then you can put other stuff inside the answer block because we&#8217;re not reading what&#8217;s in there as the content.</p>\n\n\n\n<p>What that meant for us is that we didn&#8217;t have to go make another block called answer text. We have hundreds of these kind of scenarios in our system where, yeah, we need a very specific use case, and it&#8217;s usually just some text, right, somewhere. Why would I make another block that&#8217;s just a paragraph block, really?</p>\n\n\n\n<p>So bindings, it makes blocks way more extensible. So one block can perform multiple functions if you need it to.</p>\n\n\n\n<p>[00:15:19] <strong>Nathan Wrigley:</strong> So my takeaway from that, it may be ignorant, it kind of adds a layer where you can add more features into any block, Core or otherwise. So in the example of paragraph, it&#8217;s like paragraph plus. It&#8217;s extended paragraph if you like, and you then get to decide. And that is the binding bit. You bind things to the block.</p>\n\n\n\n<p>[00:15:39] <strong>Seth Rubenstein:</strong> You bind attributes in a block.</p>\n\n\n\n<p>[00:15:40] <strong>Nathan Wrigley:</strong> Attributes.</p>\n\n\n\n<p>[00:15:41] <strong>Seth Rubenstein:</strong> That&#8217;s what it really effectively comes down to, is you bind attributes. So you could say that the text, the content attribute, in Core paragraph, well, that&#8217;s not coming from whatever you typed in there. It&#8217;s coming from some other programmatic interface somewhere in your system, your plugin, whatever.</p>\n\n\n\n<p>So that lets you use Core paragraph as a layout element, put it wherever you&#8217;d like, but then what&#8217;s inside of it, and perhaps even what happens when you click on it, well, that&#8217;s decided elsewhere.</p>\n\n\n\n<p>What&#8217;s nice about that is it lessens the number of controls that you need to present to the end user, to the designer, to the editor. For them, they just drop the block in there. The plugin handles the bindings. The plugin handles, okay, the text for this paragraph inside this answer should come from here. They don&#8217;t have to think about all that. So it&#8217;s less settings for them actually. It&#8217;s more just drop blocks in.</p>\n\n\n\n<p>[00:16:27] <strong>Nathan Wrigley:</strong> You are very much in the weeds of all this, so I suspect the fact that you&#8217;ve done this and done this over and over again renders it fairly straightforward. How available is this? Is the documentation there?</p>\n\n\n\n<p>[00:16:38] <strong>Seth Rubenstein:</strong> Oh yeah. The documentation is there. The WordPress Dev Blog has a number of tutorials on Block Bindings. And I think once you get started with it, it&#8217;s extremely easy to work with really.</p>\n\n\n\n<p>[00:16:47] <strong>Nathan Wrigley:</strong> Okay, so that was Block Bindings. Next one was Block Bits. Now I&#8217;ve only heard this phrase a couple of times, so you&#8217;re going to have to go 101 on this.</p>\n\n\n\n<p>[00:16:54] <strong>Seth Rubenstein:</strong> Sure. So Block Bits is, this is an API that is very much in development. It&#8217;s a concept more than anything else right now. So with Block Bindings, we can kind of take over a whole paragraph block and change it all out. Well, what if you just need to change one word inside that paragraph? That&#8217;s where Block Bits comes into being.</p>\n\n\n\n<p>So this could be you have typed out your sentence, and maybe there&#8217;s a name in the sentence. And you need to change that name dynamically based on whatever the user&#8217;s choosing in this front end interface. Well, Block Bits, you just select the text, you go to the toolbar, you say, I&#8217;m going to bind, quote unquote, this to this thing.</p>\n\n\n\n<p>And Block Bits, the concept is, okay, we&#8217;re going to look inside of a block, down to a bit, maybe just a character and do something with that. Change it, make it a button, whatever. That&#8217;s really all it is. It&#8217;s a fancy name for taking Block Bindings to the next level, which is kind of inside a string of text.</p>\n\n\n\n<p>[00:17:50] <strong>Nathan Wrigley:</strong> Okay. So it is, again, forgive me if I&#8217;ve parsed it incorrectly, but a Block Bit is a binding inside of some other thing. So in the example you gave, swap out this string for a different string, or it could be swap out this image dynamically for a different image, or, I don&#8217;t know, insert a dollar sign here instead of a pound sign or.</p>\n\n\n\n<p>[00:18:15] <strong>Seth Rubenstein:</strong> Well beyond that, beyond just the switching things out, the other kind of powerful part of the concept, and that&#8217;s where I think the API part is really still in development, and this will take a little bit further is, one of the examples used in the Gutenberg project is things like ISBN numbers.</p>\n\n\n\n<p>So you can imagine that, you know, maybe you&#8217;re running some sort of library like site, you type in an ISBN number. Well, what you want to happen on the front end is maybe a little bit more complex than that. So you type in your ISBN number and the block bit could see that that is an ISBN formatted number, and maybe on the front end it becomes a link with a little popup that goes to the Library of Congress, point to that thing, right?</p>\n\n\n\n<p>So it&#8217;s very analogous to Block Bindings, but it&#8217;s very much very specific small string inside of a larger string. So they give it as sub block bindings. Maybe that&#8217;s even a better term for it. Maybe that&#8217;s what would be called in the future. But I really think of it as sub block binding.</p>\n\n\n\n<p>[00:19:10] <strong>Nathan Wrigley:</strong> And presumably then you can just chain these together inside, well, let&#8217;s go with a paragraph. You could just have a one sentence just full of these block bits. So one followed by another, followed by another. Okay, that&#8217;s really interesting. So you could have a whole sentence, for example, just made up of bits from all over the place.</p>\n\n\n\n<p>[00:19:28] <strong>Seth Rubenstein:</strong> Well, and you could imagine that, beyond just like pulling information, it could be really useful when what we&#8217;re using it for currently is templating, right? So you want this string, this sentence to have these parameters. Maybe it&#8217;s got the format of your post type, and then maybe it&#8217;s got the title in there, and then maybe the date. But maybe that&#8217;s all on one line and not three different blocks.</p>\n\n\n\n<p>One of the things that drives me crazy right now is, let&#8217;s say I want to do a post date, post type, kind of above the post title. I insert a row block, and then I insert my date block, and then I insert my meta block. That&#8217;s like a lot of divs, that&#8217;s a lot of markup for that. It&#8217;s like, why isn&#8217;t that just one paragraph line with that bit of information in there? That&#8217;s where block bits comes into play.</p>\n\n\n\n<p>[00:20:08] <strong>Nathan Wrigley:</strong> So it feels like, again, forgive me, it feels like the kind of thing that we would&#8217;ve used custom fields for in past. And we would&#8217;ve had, I don&#8217;t know, dozens of custom fields, each containing their own discreet bit of data, and we would&#8217;ve had to have figured out a way to drop those into this paragraph. Now this is all handled natively.</p>\n\n\n\n<p>[00:20:25] <strong>Seth Rubenstein:</strong> Yeah, and visually in the editor.</p>\n\n\n\n<p>[00:20:26] <strong>Nathan Wrigley:</strong> Visually in the editor. And so it could be anything. It could be markup, it could be text, it could be an image, it could be, I don&#8217;t know, XML, anything you like. That&#8217;s really powerful.</p>\n\n\n\n<p>[00:20:36] <strong>Seth Rubenstein:</strong> It&#8217;s exciting. It&#8217;s very powerful, and it&#8217;s the API that I am most looking forward to seeing completed. I think it will really, without getting too technical, you go a little bit further, Block Bits, Block Bindings. These things I think are kind of critical for responsive blocks. If we&#8217;re going to change attributes at kind of a micro level based on certain conditions, like those are the kind of frameworks that we need to be able to do that.</p>\n\n\n\n<p>So beyond just like the content and templating stuff, there are deep technical reasons that these APIs continue to be developed out.</p>\n\n\n\n<p>[00:21:07] <strong>Nathan Wrigley:</strong> Okay, I think I&#8217;ve grasped what that is. Just running the clock back a couple of minutes, you imply, no, I think you said that this is in development more so than Block Bindings. So the block bits is ready to use.</p>\n\n\n\n<p>[00:21:20] <strong>Seth Rubenstein:</strong> No. There&#8217;s very much in a conceptual phase, and I think there&#8217;s a lot of other technologies that need to be finished out. There are work on the HTML APIs, even though they&#8217;re really well advanced now over the last couple years, there&#8217;s more work being done on those. I think those things are kind of blockers to keep pushing forward with the Block Bits. But you can start doing Block Bits today. And I do go over that in the presentation.</p>\n\n\n\n<p>What it really comes down to, fundamentally today is, it&#8217;s a rich text custom format, which you can do today. You can go in and make your own kind of custom formats inside the rich text component. You know, that might be bold or italic, a custom format. So it&#8217;s really simple as like, okay, well, I have a custom format that adds a class name to something, and then the HTML tag processor, I look for that class name and I change it out. Bingo, bango. So simple.</p>\n\n\n\n<p>But of course, like I said, Block Bits is much bigger than that. There&#8217;s an idea of kind of like a library of bits and, you know, you can plug it into different data sources and post meta and this and that and the other thing. But right now at least, you can start to experiment with this idea, with templating and kind of getting dynamic bits of content into a string.</p>\n\n\n\n<p>[00:22:28] <strong>Nathan Wrigley:</strong> This feels very much to me, like the kind of thing that needs more eyeballs.</p>\n\n\n\n<p>[00:22:31] <strong>Seth Rubenstein:</strong> It does.</p>\n\n\n\n<p>[00:22:31] <strong>Nathan Wrigley:</strong> It&#8217;s one of those things where you let loose a thousand developers and suddenly some curious thing that nobody thought of occurred and it was like, oh, it does that.</p>\n\n\n\n<p>[00:22:40] <strong>Seth Rubenstein:</strong> Yeah. I really want to get people to experiment with this concept further, because I think we need to push it further because it&#8217;s just so powerful.</p>\n\n\n\n<p>[00:22:48] <strong>Nathan Wrigley:</strong> Yeah, really interesting. Okay, so we did Block Bits. We did Block Bindings. I think the final one that we mentioned was the Interactivity API.</p>\n\n\n\n<p>[00:22:55] <strong>Seth Rubenstein:</strong> Yeah. So the Interactivity API, that is about, it&#8217;s probably about two years old, I think, at this point. I won&#8217;t go into all the history of that, but it is effectively a WordPress native, Preact framework. It&#8217;s really easy to work with. You kind of just write basic HTML and the JavaScript is very easy to get into.</p>\n\n\n\n<p>And what that allows you to do is really add interactions at an atomic level to blocks. You can write all sorts of functions. So you might imagine you have a form block, and it has an on submit action. Not every form does the same thing, right? So maybe you have another block, could be send to Firebase. You drop that in there and it changes, it can actually hoist up its own on submit function into that blocks interactivity. And so it makes it really easy to kind of swap JavaScript functionality in and out, and extend functionality across all your blocks.</p>\n\n\n\n<p>[00:23:47] <strong>Nathan Wrigley:</strong> So it, I guess the easiest way that I parse this was it enables you to have things doing things to other things. That was profound. Things doing things to other things in the same interface.</p>\n\n\n\n<p>[00:23:59] <strong>Seth Rubenstein:</strong> Yeah.</p>\n\n\n\n<p>[00:23:59] <strong>Nathan Wrigley:</strong> You click a button and, I don&#8217;t know, the cart increments by one or something like that. So this kind of thing that really, in the year 2025, given that we&#8217;ve had mobile phones in our hands for decades, this sort of stuff feels like it should have been in websites for decades, but it wasn&#8217;t.</p>\n\n\n\n<p>[00:24:12] <strong>Seth Rubenstein:</strong> Yeah. And the other exciting thing about it is it&#8217;s not just about telling blocks what to do. I find it very interesting that it can communicate data across blocks. So I&#8217;ll come back to Quiz Builder as a really good example. We just rebuilt that with all of these things, Block Bits, Block Bindings, Interactivity API. That just got completely revamped in the last couple months. Before that, what we were doing is we were building out a custom React front end for every single quiz.</p>\n\n\n\n<p>So the users would go in, they would drag and drop, you know, build up these quizzes. And then on top of that, we were recreating all that for a new front end interface. And we had all this service side processing to kind of build up a data model for the quiz and then score the quiz, and we made a performant as we could be, but it wasn&#8217;t.</p>\n\n\n\n<p>[00:24:55] <strong>Nathan Wrigley:</strong> It&#8217;s a lot.</p>\n\n\n\n<p>[00:24:55] <strong>Seth Rubenstein:</strong> Yeah, it&#8217;s a lot. And it&#8217;s a lot of like duplicative work and you&#8217;re like, what for? With this, it&#8217;s now the Interactivity API. Those blocks actually, you know, the answer block just hoists its answer into this larger data model using the Interactivity API.</p>\n\n\n\n<p>So now all that happens client side. So now all these things that we were doing server side, we can do client side with the Interactivity API, and that saves us money, that saves us performance. It yields a better experience for the end user.</p>\n\n\n\n<p>[00:25:19] <strong>Nathan Wrigley:</strong> So over the last 10 minutes or so, we kind of atomised these three things, Block Bits, Block Bindings, Interactivity. We kind of talked about them as separate things, which I guess they are. But from your experience, I&#8217;m guessing that they work in concert really well. In other words, if you understand, if you get into the weeds of those three things, and maybe some other things, you prize open capabilities in WordPress which are pretty profound.</p>\n\n\n\n<p>[00:25:43] <strong>Seth Rubenstein:</strong> Yeah, well, obviously one of the things that I love most about WordPress is it&#8217;s flexibility. Let&#8217;s use Block Bits as an example. This kind of pseudo block bits I&#8217;ve just described, where you register a custom format and then you use the HTML Tag Processor to switch that out. Well, the way that we&#8217;re switching it out is using the Interactivity API.</p>\n\n\n\n<p>So all we do is we say, okay, we look for that class name, we use the HTML Tag Processor, and we add the Interactivity API bits that we need to it. We just say, well, the text value should be this, state dot button text, right? That&#8217;s really easy. But you could do it with block context too.</p>\n\n\n\n<p>So there are all these tools in WordPress, all these different APIs related to blocks that once you start to connect them together, you get composability. I mean, that&#8217;s what it really comes down to. This ability for developers to build blocks that can be, one, reusable, that&#8217;s really important concept for composability, two, stand on their own, right? A button block should do something if it&#8217;s on its own. It should go to a link or something. But if that button block is dropped into another block, it&#8217;s nestable, well its configuration changes. Now it submits for the form, right? It doesn&#8217;t go to a link.</p>\n\n\n\n<p>We&#8217;re at this place where just, there&#8217;s all these tools available to you when you start plugging them all together, really powerful stuff happens.</p>\n\n\n\n<p>[00:26:53] <strong>Nathan Wrigley:</strong> Yeah. And I guess it&#8217;s like anything, once you&#8217;ve made those connections in your own head and done the hard work to understand them all, suddenly ideas begin occurring to you that maybe in a podcast like this, you get to the very edge of that, but you don&#8217;t get into the weeds of that. But once you&#8217;ve peeled it back and understood it, suddenly, aha, I didn&#8217;t realise WordPress could do all of this.</p>\n\n\n\n<p>One of the things that I&#8217;m curious about, because I&#8217;m no developer, I kind of have a desire for this stuff to become available to non-developers. And at the minute it feels like you would really need to be a developer to build this stuff. Obviously you can surface it in a way that a non-developer can access. So your quiz, for example, I&#8217;m guessing I could interact with that almost immediately and understand it. Would there be any utility in building a UI for this so that these kind of things can be accessed?</p>\n\n\n\n<p>[00:27:36] <strong>Seth Rubenstein:</strong> I think so. We have our own UI for this. We have an Interactivity API panel that we actually have on all of our blocks that have interactivity enabled. And what it does is it does allow us some interesting things for end users that they don&#8217;t have to know about.</p>\n\n\n\n<p>So one of those things is you can drop a block into a block that supports interactivity. And the panel shows you all the blocks in the hierarchy that you can connect to. And so you might say, okay, well I want to connect to this, and then I want to pull this action from that interactivity store for this block.</p>\n\n\n\n<p>So now we&#8217;ve enabled it so that it&#8217;s not the developers making all the Interactivity API connections. You know, this does this when it&#8217;s in this block. Actually, you can go in there and decide that for yourself if you want.</p>\n\n\n\n<p>Now obviously that does still require a developer to hook that all up, but what you already see today with Block Bindings is a very similar panel. When you go use a Block Binding today, there&#8217;s a little panel called attributes. You click it, it shows you all the attributes you can connect up to a binding. That&#8217;s part of Gutenberg and WordPress Core right now.</p>\n\n\n\n<p>So I think that interface is already there, and I think as more Block Bindings and plugins start to utilise that, the interface is already there for really people to kind of make these interactivity connections themselves.</p>\n\n\n\n<p>[00:28:50] <strong>Nathan Wrigley:</strong> I suppose I&#8217;m kind of thinking back to the day when WordPress shipped for the first time, custom post types. I presume lots of people made use of them. It might be analogous to where we are at now with this, you know, people who are experienced can use it. But then somebody, some bright spark, came up with the idea of a custom post type plugin with a UI, and this way of just making it visually appealing and straightforward.</p>\n\n\n\n<p>And when you were talking about this sort of, it felt almost like a flow chart that you were building there, where you&#8217;ve got, here&#8217;s the options, just sort of clicking on them with a mouse and dragging it so this feature now goes to this feature, and I&#8217;m binding this to this, that&#8217;s what I was imagining. You know, something really straightforward. Drop dead simple, non developery.</p>\n\n\n\n<p>[00:29:29] <strong>Seth Rubenstein:</strong> Well, I will give a plug for my friends at Automattic. Part of my session was also sharing a product that we&#8217;ve built called Remote Pivot Table, which lets you kind of make really quick pivot tables out of Google Sheets so the data&#8217;s not living inside of WordPress, so that our researchers can really quickly update these data sets, and we don&#8217;t have to do a thing to get the updates. Well, that&#8217;s built on Automattic&#8217;s new Remote Data Blocks. And it actually does exactly what you&#8217;re saying.</p>\n\n\n\n<p>You go in there, you tell it what your data sources are. Airtable, Google Sheets, Shopify, Custom HTTP endpoints if you want, and it will go create the blocks for you. It will create the bindings for you, and it&#8217;ll create the interface for you so that you can select, okay, well, when I&#8217;m building out my interface, you know, this text goes to this binding. It should pull from this value from that Google sheet. So that&#8217;s actually already out in the wild right now.</p>\n\n\n\n<p>[00:30:18] <strong>Nathan Wrigley:</strong> What was it called?</p>\n\n\n\n<p>[00:30:18] <strong>Seth Rubenstein:</strong> Remote Data Blocks.</p>\n\n\n\n<p>[00:30:19] <strong>Nathan Wrigley:</strong> Okay.</p>\n\n\n\n<p>[00:30:20] <strong>Seth Rubenstein:</strong> It&#8217;s on the WordPress plugin repo. I think they just published it this week.</p>\n\n\n\n<p>[00:30:23] <strong>Nathan Wrigley:</strong> I&#8217;ll remember to put that into the show notes. I will dig that out and make sure that that gets into the show notes.</p>\n\n\n\n<p>Yeah, I kind of feel like, even if we were to build the perfect UI, I still feel for most people this may end up being the domain of, get the developer to do it.</p>\n\n\n\n<p>[00:30:38] <strong>Seth Rubenstein:</strong> Yeah, it is very much in the domain of the developer. These are all developer APIs for them to build out tools for others. And I think ultimately what these APIs allow is for developers to make products that are easier to use for the end user. Like I said, less settings, less controls, less all these sidebar panels and stuff, and more just, you drag and drop the block in and in the background, through the Interactivity API, through Block Bindings, through Block Bits, you&#8217;re configuring how that application should work. So it&#8217;s more of just drag and drop for the end user.</p>\n\n\n\n<p>[00:31:09] <strong>Nathan Wrigley:</strong> The features exist, you&#8217;d need to sort of go and figure out how to make it work. I guess we&#8217;ve got all these Block Bindings, we&#8217;ve got all these Block Bits, we&#8217;ve got this enormous complexity that we could get into. How performant is all of this?</p>\n\n\n\n<p>[00:31:22] <strong>Seth Rubenstein:</strong> Extremely.</p>\n\n\n\n<p>[00:31:23] <strong>Nathan Wrigley:</strong> So my fear is you just get carried away and you bind everything to every other thing, and where a bit is available, you make a Block Bit. I can&#8217;t summon up an example, but you get the point. You just get totally carried away. The performance, I would assume there is some hit, but it sounds like not so much.</p>\n\n\n\n<p>[00:31:40] <strong>Seth Rubenstein:</strong> I don&#8217;t think so. I think the performance is actually better for a lot of these things. All of our Interactivity API projects, like technical performance is substantially better than if we had just built out a React frontend ourself.</p>\n\n\n\n<p>Because think about the weight of that. I mean, React is pretty heavy, one. Preact on the other hand, which the Interactivity API is built on is very lightweight. But additionally you have this, I guess the other element which we really kind of haven&#8217;t defined is the HTML Tag Processor. That is what underpins all of these things, all of these APIs, even the Interactivity API, even though that&#8217;s JavaScript,</p>\n\n\n\n<p>When you are writing in the Interactivity API, you can write state and context and all these values in HTML, the HTML tag processor that&#8217;s reading that, that&#8217;s processing it. And it does it so extremely fast. You know, if you&#8217;ve worked with a PHP DOM document, it&#8217;s slow, it&#8217;s very bad. This is not that. This is extraordinarily fast.</p>\n\n\n\n<p>In addition, on the technical performance, when you&#8217;re using the Interactivity API, you get speed on the front end as well, because what you can do is you can pre hydrate information into your JavaScript application before it even loads, on the server side, which is really exciting.</p>\n\n\n\n<p>You can see this today actually. Core query, the query loop, and the pagination. Those use an Interactivity API. When you hover over the two or the next page, what&#8217;s happening is there&#8217;s an Interactivity API function for prefetch. So you&#8217;re prefetching the next page of results. So for the user, boom. They click on it, boom. The results are already there. You go a little bit, further, you can cache that information. So now the user has pre fetched the next page and they&#8217;ve cached it for the next person to come to this page. That just really wasn&#8217;t possible before.</p>\n\n\n\n<p>[00:33:18] <strong>Nathan Wrigley:</strong> No. Is that kind of leaning into sort of core browser technologies as well?</p>\n\n\n\n<p>[00:33:22] <strong>Seth Rubenstein:</strong> Oh yes.</p>\n\n\n\n<p>[00:33:22] <strong>Nathan Wrigley:</strong> Yeah, I&#8217;m just thinking of things like.</p>\n\n\n\n<p>[00:33:25] <strong>Seth Rubenstein:</strong> Well, the prefetch thing is part of the browser technology. I&#8217;ll give you an example. We have this very large religious census we do every decade called the Religious Landscape Study. It&#8217;s extremely complex database with a lot of querying, and a lot of SQL logic. If we were to, you go to a page on this database and there&#8217;s maybe like 12 charts. Well, if we were to load all those 12 charts on page load, like it would take a couple minutes to load the page. The site would probably crash.</p>\n\n\n\n<p>But what we do is, as a user hovers over a chart before they click on it, we prefetch, it and we cache it. So for them, they click it, it&#8217;s instantaneous. But also we&#8217;ve now done the extra work of waiting for the next person, that&#8217;s already waiting there ready for the next person. I cannot state how important this innovation has been for the performance of our site and the Interactivity API.</p>\n\n\n\n<p>[00:34:12] <strong>Nathan Wrigley:</strong> That is actually fairly profound, isn&#8217;t it? Yeah. Sometimes when you are explaining these things, the penny kind of half drops. And then a moment later, the penny drops fully and that one&#8217;s just hit. That&#8217;s actually really profound, isn&#8217;t it? Especially on a high traffic site where you don&#8217;t really want to be doing that thing a thousand times a second, just do it once, more or less.</p>\n\n\n\n<p>[00:34:34] <strong>Seth Rubenstein:</strong> I have a philosophy of if I can offload it to the end user, I&#8217;m going to. You know, I&#8217;m going to use your computer if I can.</p>\n\n\n\n<p>[00:34:41] <strong>Nathan Wrigley:</strong> That&#8217;s fascinating. Okay, so pivot slightly. Do you think there&#8217;s a opportunity here? I expect there&#8217;s a bunch of developers listening to this who either haven&#8217;t experienced this before, haven&#8217;t played with it, and are thinking, okay, I want to wrap a UI around that. I want to build a plugin to make this stuff available. We kind of alluded to this a minute ago. Do you think that there is an opportunity there for developers to kind of neaten this interface up?</p>\n\n\n\n<p>[00:35:02] <strong>Seth Rubenstein:</strong> Oh, yeah. Oh, yeah, absolutely. I would be very excited to see where the future of this lands for the WordPress ecosystem. You think of plugins like Advanced Custom Fields and what that did for WordPress, right? It was obviously possible to register post meta and all this stuff before, but what a hassle. It just was. And it really opened up WordPress as a content management system in a way that no other plugin had really done before.</p>\n\n\n\n<p>So some very smart person, some enterprising person out there, there is an opportunity here to kind of build out something that would do that for the Interactivity API and empower less technically inclined people and maybe just not technical people at all to use this.</p>\n\n\n\n<p>[00:35:39] <strong>Nathan Wrigley:</strong> Yeah. Because despite the fact that you&#8217;ve explained it really clearly, and I&#8217;ve got a grip on it, I suspect that I wouldn&#8217;t want to go through all of the weeds to connect all of those pieces. And I don&#8217;t want to open up a code editor. I want everything to be point, click, type, inside of WordPress, in a really straightforward, well-designed, beautifully thought through interface. Kind of like gold rush territory I think. Maybe there&#8217;s an opportunity here for someone, maybe multiple people.</p>\n\n\n\n<p>Yeah, and it&#8217;s what you said before about these kind of custom post type plugins, there&#8217;s many of them and I think without them, nobody would&#8217;ve been using custom post types, well, not nobody, but a tiny proportion of the people would&#8217;ve started to use them. And I feel the same a bit here. I feel like the things that you&#8217;ve described, they&#8217;re fabulous, technically, conceptually brilliant, but if somebody was to come up with a UI that made them not just conceptually brilliant, but drop dead easy to use, we&#8217;ve got something really incredible.</p>\n\n\n\n<p>[00:36:35] <strong>Seth Rubenstein:</strong> Yeah, absolutely. Yeah, I mean, look, when I first started in WordPress, I didn&#8217;t know how to do custom fields, custom post types. You know, ACF helped me out there. And I do them all by hand now, right? I register all my post types and my post meta by hand. But those sort of plugins that make it easier for, well, not even if you&#8217;re less technically inclined, you&#8217;re busy, you don&#8217;t have the time to learn all these new APIs, it really does help out adoption down the road.</p>\n\n\n\n<p>[00:37:00] <strong>Nathan Wrigley:</strong> And also you can imagine scenarios where people build out pre-configured versions of a thing. So that you might have templates for, I&#8217;m struggling to conceptualise that but, you know, you download this plugin, whatever it may be, and they&#8217;ve pre-configured useful scenarios that are repeatable. And you just, okay, click a button, that gets me 90% of what I want to do and then I go from there, kind of thing. Yeah, that&#8217;s interesting.</p>\n\n\n\n<p>In terms of the bits and pieces that you&#8217;ve described, is there anything which you think might be missing? I know that&#8217;s a difficult question to answer because I&#8217;m asking you to stare into a crystal ball and come up with the future. But is there any kind of concept in here that you&#8217;ve thought, you know what, it&#8217;d be really handy to have that?</p>\n\n\n\n<p>[00:37:37] <strong>Seth Rubenstein:</strong> I think it&#8217;s responsive. Responsive blocks, responsive attributes.</p>\n\n\n\n<p>[00:37:41] <strong>Nathan Wrigley:</strong> Describe what that is because in my head, as soon as I hear responsive, I think viewport width.</p>\n\n\n\n<p>[00:37:45] <strong>Seth Rubenstein:</strong> Yeah, and I think that&#8217;s exactly what I&#8217;m talking about. You know, I think all of the APIs are here. All the bits are in place to make that happen, the work just needs to be done. There&#8217;s actually a function in the Gutenberg source code for, I think it&#8217;s called update attribute on screen size or something like that, where you can kind of, desktop, tablet, mobile changes attribute to match for that viewport size.</p>\n\n\n\n<p>I think this has been the Achilles heel for Gutenberg. It&#8217;s the constant complaint that I hear out of people. And I think that is really the missing link, the, last thing that would really make Gutenberg perfect.</p>\n\n\n\n<p>[00:38:19] <strong>Nathan Wrigley:</strong> So scenarios where you could literally change anything based upon, I don&#8217;t know, we&#8217;re on a tablet now, so what we had on a desktop is no longer appropriate. Again, I&#8217;m struggling to conceptualise what that might be, but again, the same on mobile.</p>\n\n\n\n<p>[00:38:32] <strong>Seth Rubenstein:</strong> I&#8217;ll give you a good example. We have our own grid block, columns block. We made our own grid block because we do this responsive attribute stuff. You might have three columns that are x width on desktop, and then on tablet, well, you might want that middle column actually to move to the first position to be 100% width, right? That&#8217;s a really easy example, but doing that right now is next impossible without having a developer build out that system for you. That&#8217;s just one thing I can think of, but there are a myriad of instances like that.</p>\n\n\n\n<p>[00:39:01] <strong>Nathan Wrigley:</strong> Yeah, the domino fell a bit there. I understand what you mean. So yeah, it could be width, it could be background colour, it could be font size or content, anything.</p>\n\n\n\n<p>[00:39:09] <strong>Seth Rubenstein:</strong> A number of things, yeah. Well, it could be also in the Interactivity API. It could be that, you know, on tablet, actually I want, when you click on this thing, I want it to do something else entirely.</p>\n\n\n\n<p>[00:39:16] <strong>Nathan Wrigley:</strong> The button does a different thing.</p>\n\n\n\n<p>[00:39:17] <strong>Seth Rubenstein:</strong> Yeah.</p>\n\n\n\n<p>[00:39:17] <strong>Nathan Wrigley:</strong> Yeah, okay. That&#8217;s really interesting.</p>\n\n\n\n<p>[00:39:18] <strong>Seth Rubenstein:</strong> Well, I&#8217;ll give you another example. We do that. Well, not to that degree, but Core social links. We wrap that in another block called Navigator Share Link. So when you&#8217;re on mobile and you click on the Facebook button, we&#8217;re not taking you to the Facebook share little window. We just open up the little native browser share thing. You just send it off to your app or whatever, friends, your iMessage, whatever you want to do.</p>\n\n\n\n<p>So I think that kind of device contextuality is one area where there&#8217;s not a lot of guidance or APIs or anything, and that is kind of entirely on the developers to figure out themselves. But I think that&#8217;s probably what&#8217;s missing most from Gutenberg, is that kind of idea of screen or device contextuality.</p>\n\n\n\n<p>[00:40:01] <strong>Nathan Wrigley:</strong> I just think this is all so fascinating. Essentially, during the last 40 minutes or so, you&#8217;ve prized open, I think a really different future for WordPress than I had previously thought. I knew all these things existed. I hadn&#8217;t really connected the dots. And it feels to me as if suddenly you go from building a bunch of websites to anything. Literally anything. If it&#8217;s possible to put in a browser.</p>\n\n\n\n<p>[00:40:27] <strong>Seth Rubenstein:</strong> It&#8217;s a web application framework.</p>\n\n\n\n<p>[00:40:28] <strong>Nathan Wrigley:</strong> Right. There you go. Yeah. A web application. Build anything inside of WordPress, which is not something that I was all that familiar with. Gosh, the future is bright.</p>\n\n\n\n<p>[00:40:37] <strong>Seth Rubenstein:</strong> I mean, we have blocks where people are, you know, drag and drop them together and they&#8217;re building out little calculators. You know, one of our more popular content types is like, put in your income and where you live, and then we&#8217;ll tell you some information about you, you know, about your area or whatever. That&#8217;s a web application. That&#8217;s not a blog post. That&#8217;s not content. That&#8217;s a web application that someone just drag and drop built.</p>\n\n\n\n<p>Yeah, we&#8217;re at a place, you know, the content management stuff of WordPress, man, that&#8217;s rock hard. That&#8217;s settled. Now we&#8217;re going into another era, a new direction where WordPress is this web development framework, first and foremost. For you, the developer, but also your end users to build web applications with, inside of.</p>\n\n\n\n<p>[00:41:19] <strong>Nathan Wrigley:</strong> Yeah, absolutely fascinating. So my intuition that I alluded to at the beginning of this podcast, in 2018 or whatever it is, that promise has now become reality. The year 2025, we got there. And now it just needs a bunch of developers, hopefully, dear listener, if you&#8217;re listening to this, get on board and try to figure this out and make it straightforward so people like me can use it.</p>\n\n\n\n<p>Seth, I think that&#8217;s probably the sweet spot to end it. That&#8217;s a very optimistic future you&#8217;ve painted there. Where do we find you, if somebody&#8217;s listening? I would imagine that there&#8217;s a bunch of people listening to this thinking, I need to speak to Seth.</p>\n\n\n\n<p>[00:41:51] <strong>Seth Rubenstein:</strong> You can find me at sethrubenstein.info. And you can find me on Twitter or Bluesky. Please find me on Bluesky, though, I hate Twitter.</p>\n\n\n\n<p>[00:41:57] <strong>Nathan Wrigley:</strong> We will drop the links into the show notes. So if you head to wptavern.com, search for the episode with Seth Rubenstein, that&#8217;s S-T-E-I-N, search for that and then the links will be there for Seth&#8217;s socials, plus anything to do with the talk that we&#8217;ve been mentioning as well. Seth Rubenstein, thank you so much for chatting to me today.</p>\n\n\n\n<p>[00:42:15] <strong>Seth Rubenstein:</strong> Thank you for having me.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://sethrubenstein.info\">Seth Rubenstein</a>.</p>\n\n\n\n<p>Seth is the head of engineering at the Pew Research Center, where he leads a team of developers managing the organisation’s WordPress-based publishing platform for its news site. Passionate about open source, Seth ensures that everything his team builds not only meets the Pew Research Center’s needs, but also benefits the wider community. By actively contributing to the Gutenberg project, he strives to share their solutions, always asking how their work can be given back to help others in the WordPress ecosystem.</p>\n\n\n\n<p>Seth shares fascinating stories from the work h   e’s recently been doing. He breaks down what block composability really means, the ability to build modular, reusable, and even interactive blocks that work seamlessly together, empowering both developers and end users to create sophisticated web applications within the familiar WordPress block editor.</p>\n\n\n\n<p>The conversation gets into some of WordPress’s newest and most promising features, including the Block Bindings API, Block Bits (still very much in development), and the Interactivity API. Seth explains how these tools open a world of possibilities, like building interactive quizzes, dynamically updating content, or even prefetching data, all using blocks, without having to rely on custom React front-ends or heavy server-side processing.</p>\n\n\n\n<p>Seth also talks about the path forward for democratising these advanced capabilities, discussing current limitations, the potential for new UI tools, and what’s still missing in the quest for truly responsive, device-contextual blocks.</p>\n\n\n\n<p>Throughout the episode, Seth makes a compelling case for why now is a golden opportunity for developers and plugin builders to start experimenting, get involved, and shape the next evolution of WordPress as a cutting-edge web application platform.</p>\n\n\n\n<p>Whether you’re a developer curious about the future of Gutenberg or an editor dreaming of more drag-and-drop web app power, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://www.pewresearch.org\"> Pew Research Center</a></p>\n\n\n\n<p>Seth and Max Schmeling&#8217;s presentation at WordCamp US 2025 &#8211;  <a href=\"https://us.wordcamp.org/2025/session/block-composability-the-past-and-the-future/\">Block Composability: The Past and The Future</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/\">Interactivity API</a></p>\n\n\n\n<p>Block Bits &#8211; <a href=\"https://make.wordpress.org/core/2024/06/08/proposal-bits-as-dynamic-tokens/\">Proposal: Bits as dynamic tokens</a></p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/reference-guides/block-api/\">Block Bindings API</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/03/07/introducing-the-html-api-in-wordpress-6-2/\">HTML API</a></p>\n\n\n\n<p><a href=\"https://preactjs.com\"> Preact framework</a></p>\n\n\n\n<p><a href=\"https://github.com/Automattic/remote-data-blocks\"> Automattic&#8217;s new Remote Data Blocks</a></p>\n\n\n\n<p><a href=\"https://www.pewresearch.org/religious-landscape-study/\"> Religious Landscape Study</a></p>\n\n\n\n<p><a href=\"https://sethrubenstein.info\">Seth&#8217;s website</a></p>\n\n\n\n<p><a href=\"https://bsky.app/profile/sethrubenstein.info\">Seth on Bluesky</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Open Channels FM: Transforming Website Analytics for WordPress Users with a Privacy-First Approach\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111275\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://openchannels.fm/transforming-website-analytics-for-wordpress-users-with-a-privacy-first-approach/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:222:\"In this episode, Adam chats with the creators of Independent Analytics, a WordPress plugin focusing on user-friendly, privacy-oriented website stats. They highlight its benefits over Google Analytics and upcoming features.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Oct 2025 12:45:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Open Channels FM: From Identica to ActivityPub: How Open Social Protocols Are Shaping the Future of the Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110909\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://openchannels.fm/from-identica-to-activitypub-how-open-social-protocols-are-shaping-the-webs-future/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:262:\"The Fediverse, shaped by pioneers like Evan Prodromou, evolved from Identica to ActivityPub, fostering decentralization and user control. It contrasts corporate social networks by promoting openness, privacy, and collaborative development for online communities.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Oct 2025 09:03:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt: Simplify\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://ma.tt/2025/10/simplify/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:826:\"<p>I have some &#8220;grand theories&#8221; of software engineering: I think there are two tribes of engineers that complexify things or simplify things, and they are in eternal conflict. </p>\n\n\n\n<p><strong>Complexify:</strong> <a href=\"https://jamstack.org/\">Jamstack</a>, headless, Contentstack, Contentful, <a href=\"https://www.acquia.com/blog/what-digital-experience-platform-dxp\">DXP</a>, <a href=\"https://business.adobe.com/blog/basics/digital-asset-management\">DAM</a>, micro-services. </p>\n\n\n\n<p><strong>Simplify:</strong> WordPress, Simplenote, Day One, <a href=\"https://en.wikipedia.org/wiki/Djbdns\">djbdns</a>, <a href=\"https://sqlite.org/\">SQLite</a>. </p>\n\n\n\n<p>Not enough engineers have studied under the code of <a href=\"https://en.wikipedia.org/wiki/Daniel_J._Bernstein\">Daniel J. Bernstein</a>.</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Oct 2025 04:59:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Make No Little Plans\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150274\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ma.tt/2025/10/make-no-little-plans/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:928:\"<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Make no little plans. They have no magic to stir men’s blood and probably themselves will not be realized. Make big plans; aim high in hope and work, remembering that a noble, logical diagram once recorded will never die, but long after we are gone will be a living thing, asserting itself with ever-growing insistency. Remember that our sons and grandsons are going to do things that would stagger us. Let your watchword be order and your beacon beauty. Think big.</p>\n</blockquote>\n\n\n\n<p>— <a href=\"http://en.wikipedia.org/wiki/Daniel_Burnham\">Daniel Burnham</a>, Chicago architect (1864–1912) (Hat tip: <a href=\"https://intenseminimalism.com/2010/make-no-little-plans/\">Erin</a>, and the <a href=\"https://summit.co/make-no-small-plans\">Summit folks</a>.) (It&#8217;s an old quote but update in your head to include the ladies too.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 19 Oct 2025 20:19:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Matt: Albumin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150261\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2025/10/albumin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1026:\"<p>Since reading the <a href=\"https://fourhourworkweek.com/\">Four Hour Workweek</a> and <a href=\"https://tim.blog/\">Tim Ferriss</a> I&#8217;ve been a bit of a bio-hacker, always trying weird and new stuff. Today was a new one! I did therapeutic plasma exchange (TPE), also known as plasmapheresis, which supposedly gives you all the <a href=\"https://en.wikipedia.org/wiki/Young_blood_transfusion\">benefits of parabiosis</a> without, you know, needing to be a vampire or <a href=\"https://www.youtube.com/watch?v=hBA0AH-LSbo\">having a blood boy</a>. So with the awesome folks at <a href=\"https://extension.health/\">Extension Health</a> I had my blood filtered and put back in, which took a few hours. My plasma <a href=\"https://x.com/bryan_johnson/status/1845950287032492378\">was not as clear as Bryan Johnson&#8217;s</a>, with 41 years of microplastics and mold and who knows what else in there. The process took a few hours, and afterward I got some chicken on rice from a Halal cart on Broadway so maybe it all evens out.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 19 Oct 2025 00:42:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"Gutenberg Times: Abilities API, Block Accessibility Check, Gutenberg Framework, AI creating Blocks and themes—Weekend Edition 345\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42268\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:20610:\"<p>Hi there, </p>\n\n\n\n<p>A release party is coming up on <strong>Tuesday, October 21, at 15:00 UTC for WordPress 6.9 Beta 1.</strong> It&#8217;s the first time for this release squad. Good luck! </p>\n\n\n\n<p>Will you start testing WordPress 6.9 next week?  You can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester plugin</a> by <strong>Andy Fragen</strong> and install it on your test site. I am using <a href=\"https://developer.wordpress.com/studio/\">WordPress Studio</a> on my computer for systematic testing and prep work for the <em>Source of Truth</em> post to come out in a few weeks.</p>\n\n\n\n<p>The WordPress Test team already published a few pre-beta calls for testing, you can work through, and they are preparing a comprehensive post for all of WordPress 6.9 testing for next week. </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>Help test changes to template management</strong></a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\"><strong>Call for Testing: Ability to Hide Blocks</strong></a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\"><strong>Call for Testing: Accordion Block</strong></a> </li>\n</ul>\n\n\n\n<p>WordPress 6.9 is a big focus of my work now. As always, I&#8217;ll keep you updated. </p>\n\n\n\n<p>Have a fantastic weekend! </p>\n\n\n\n<p>Yours, <img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n<p>PS:  On Monday, October 20th, I will be on the 353rd episode of <a href=\"https://wpbuilds.com/news-archive/\"><strong>This week in WordPress</strong></a> show together with Michelle Frechette, Tim Nash, and the brilliant host Nathan Wrigley. <a href=\"https://wpbuilds.com/live/\">You can join us live! </a><img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f4fa.png\" style=\"height: 1em;\" /></p>\n\n\n\n<p>PPS: This week, I celebrated the <a href=\"https://icodeforapurpose.com/five-year-anniversary-of-the-gutenberg-nightly/\">five-year anniversary of Gutenberg Nightly. </a><img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f389.png\" style=\"height: 1em;\" /> </p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n</section>\n\n\n<div class=\"wp-block-spacer\" style=\"height: 21px;\"></div>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owner</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/abilities-api-block-accessibility-check-gutenberg-framework-ai-creating-blocks-and-themes-weekend-edition-345/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Yesterday, <strong>Matt Mullenweg</strong> talked briefly at <strong>WordCamp Canada</strong>, gave a demo, and then answered questions from the  the audience. The wizards behind the scenes already posted the recording of the session to YouTube. <a href=\"https://www.youtube.com/watch?v=RL-XccK30sY\"><strong>WordCamp Canada 2025—Ma.tt Mullenweg &#8220;Town Hall/AMA&#8221;</strong></a>. If you rather read about the talk on Mullenweg&#8217;s blog, <a href=\"https://ma.tt/2025/10/wordcamp-canada/\">WordCamp Canada Talk</a>. He also added the Q &amp; A transcript as well. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\">Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9</a> with Beth Soderberg of <a href=\"https://bethink.studio/\">Bethink Studio</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 122 with Beth Soderberg\" class=\"wp-image-42236\" height=\"193\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-11-at-12.32.48.png?resize=652%2C193&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>If you are listening via Spotify, please leave a comment. If you listen via other podcast apps, please leave a review. It&#8217;ll help with the distribution.</em></p>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owner</h2>\n\n\n\n<p>In his video <a href=\"https://www.youtube.com/watch?v=iCtjWwWi5sQ\"><strong>AI Builds WordPress Blocks</strong></a> , <strong>Jamie Marsland</strong> introduced <em><a href=\"https://telex.automattic.ai/\">Automattic Telex</a></em> and showed off about ten blocks he and other people built with it, like animated text, a countdown counter, and mermaid diagram and more. Check it out; it&#8217;s not only amazing, it borders on voodoo or magic. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Tammie Lister</strong> continues her October Challenge on the <strong>Blocktober.fun</strong> site. The latest blocks are <a href=\"https://blocktober.fun/flip-card/\">Flip Card</a>, <a href=\"https://blocktober.fun/emoji-voting/\">Emoji Voting</a>, <a href=\"https://blocktober.fun/highlighter/\">Highlighter</a>, <a href=\"https://blocktober.fun/story-generator/\">Story Generator,</a>  <a href=\"https://blocktober.fun/watermark/\">Watermark</a> and <a href=\"https://blocktober.fun/make-the-logo-bigger/\">Make the logo bigger</a>. You not only can try them all out on Telex and remix them with your own ideas. Lister also shares here elaborate prompts you can study and learn how to skill up your AI work. </p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-42310\" height=\"460\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-18-at-14.04.11.png?resize=652%2C460&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Troy Chaplin</strong> released <strong><a href=\"https://wordpress.org/plugins/block-accessibility-checks/\">Block Accessibility Check v2.2</a></strong>! It introduces Heading structure validation,  alt-text pattern detection and provides an upgraded URL checks with real TLD validation + dev environment support&#8221;Along with the new release comes a <a href=\"https://blockaccessibilitychecks.com/\">new dedicated website</a> featuring improved docs, feature overviews, and developer API guide&#8221;. Chaplin wrote. The site is focused to assist content creators and developers alike. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Anne Katzeff</strong> shared how she created <a href=\"https://www.askdesign.biz/blog/2025/10/overlapping-columns-with-the-media-text-block/#google_vignette\"><strong>overlapping Columns with the Media &amp; Text Block</strong></a> and little Additional CSS. The step-by-step instructions show you how you can build some dynamic layouts with the core block features. </p>\n\n\n\n<figure class=\"wp-block-image\"><img alt=\"\" src=\"blob:https://gutenbergtimes.com/44a2bf47-9c14-481b-bbe1-29e1c6fe25d0\" /></figure>\n\n\n\n<p><strong>Katzeff</strong> also posted a video of her process on YouTube. <a href=\"https://www.youtube.com/watch?v=kNwkwlwKB4I\"><strong>Overlapping Columns With the Media &amp; Text Block</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Michael Manuel</strong>, WordPress VIP, posted a four-part series of short video: <a href=\"https://wpvip.com/blog/behind-the-build-modernize-publishing/\"><strong>Behind the Build: How Christianity Today Modernized its Publishing Experience</strong></a> and how the team of <em>WebDevStudios</em> helped transform editorial workflows, infrastructure, and content operations for one of America’s most trusted media brands.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Part 1: <strong>Editorial empowerment &amp; workflow efficiency</strong></li>\n\n\n\n<li>Part 2: <strong>Performance &amp; platform modernization</strong></li>\n\n\n\n<li>Part 3: <strong>Homepage &amp; design system overhaul</strong></li>\n\n\n\n<li>Part 4: <strong>Content migration &amp; CMS modernization</strong></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Brad Salomons</strong>, 8r4d Consulting, Ltd, created the <a href=\"https://wordpress.org/plugins/panoramic-slider-block/\"><strong>Panoramic Slider Block</strong></a> to scratch an itch. With this block you can post your Pano photos from your phone camera as it provides horizontal sliding controls.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Brad Salomons - screenshot of the Panoramic Slider Block in the editor. \" class=\"wp-image-42308\" height=\"312\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/screenshot-1-1.png?resize=652%2C312&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>On the WordPress Developer Blog, <strong>Nick Diego </strong>published a Snippet on <a href=\"https://developer.wordpress.org/news/snippets/how-to-add-custom-blocks-to-navigation-menus/\"><strong>How to add custom blocks to navigation menus</strong></a>. It shows how to use  the <code>blocks.registerBlockType</code> filter to extend the navigation block’s <code>allowedBlocks</code> array.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Elliott Richmond</strong> demonstrated <a href=\"https://www.youtube.com/watch?v=6sgJNNm5EOU\"><strong>how to create a block theme using Claude Code</strong></a> on YouTube. He built a theme from scratch with Claude Code, providing clear structure and Markdown tips for the AI tool. You&#8217;ll discover how to set up a CLAUDE.md file for AI-assisted theme development and how Claude works with the WordPress Block Theme structure.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The earlier years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><br /><strong><a href=\"https://x.com/muhsinlk\">Muhammad Muhsin</a> </strong>senior engineer at Fueled gave a talk on <a href=\"https://wordsesh.com/speakers/muhammad-muhsin\">Building a Web App with the Gutenberg Framework at WordSesh</a> earlier this year. <a href=\"https://wordpress.org/gutenberg-framework/\">What is Gutenberg as a Framework?</a> It&#8217;s a way to use the block editor in a JavaScript application outside of WordPress. Muhsin &#8220;built CareerVision.io using Gutenberg outside WordPress—a standalone React framework for block-based apps&#8221;. You can watch the <a href=\"https://www.youtube.com/watch?v=0JXbtZWA3zI\">presentation on YouTube</a> now.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> was the <a href=\"https://www.youtube.com/watch?v=T7kLXWvywww\"><strong>Pro WordPress Developer Watches AI Build a Custom Block… and is Blown Away!</strong></a> He put <a href=\"https://telex.automattic.ai/\">Automattic&#8217;s Telex</a> to the test,  to build a live audio visualizer block inspired by the classic iTunes music visualizer. The AI writes the React code, handles audio input, and even makes the block respond to live microphone sound, all in about 15 minutes. It’s an impressive look at how Telex could reshape the way developers build custom blocks for WordPress. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>JuanMa Garrido</strong>, developer advocate at Automattic,  livestreamed his ongoing discovery of the <a href=\"https://www.youtube.com/watch?v=m19VM2yIbHU\"><strong>Abilities API</strong></a>.  He explored how to register custom abilities, expose them to AI models, and understand how this fits into WordPress’ broader AI architecture alongside the MCP Adapter and PHP AI API. The recording is now available on YouTube.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Photo by MRFE MRFE on <a href=\"https://www.pexels.com/photo/vibrant-geometric-abstract-3d-blocks-design-34268918/\">Pexels.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 22:14:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: WordCamp Canada Talk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150251\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2025/10/wordcamp-canada/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:46239:\"<p>Howdy and bonjour! First, thank you so much, merci beaucoup, for having me at your WordCamp. I love the spirit of local communities gathering and helping each other learn and grow together. I wasn&#8217;t actually planning to speak or even do a Q &amp; A; I was just going to attend this WordCamp. But since the organizers have given me a bit of your time, I will try to make the best of it. </p>\n\n\n\n<p>I love Canada. I first came here for <a href=\"https://en.wikipedia.org/wiki/Northern_Voice\">the Northern Voice conference</a> in 2006. Was anyone at that one? I think Dave Winer was actually there. It was a pretty awesome one. What&#8217;s that?</p>\n\n\n\n<p>[Here I think Dave said he wasn’t at that one, but a different conference, but can’t remember.]</p>\n\n\n\n<p>Well, that&#8217;s why we blog. My memory is not that good. [laughs] By the way, I think this week is your anniversary, right? </p>\n\n\n\n<p><strong>Dave Winer:</strong> It was actually a couple of weeks ago—31 years.</p>\n\n\n\n<p><strong>MM: </strong>Oh, wow. Thirty-one years. Round of applause! I think why I thought it was your anniversary is that on my blog’s related posts, it showed a post from 2014 that was congratulating you on your 20th because I think <em>The Register</em> or someone did a nice article. </p>\n\n\n\n<p>So yeah, I&#8217;ve since been back dozens of times, including several summers in Montreal, at the jazz festival there—they also do <a href=\"https://haitienfolie.com/\">Le Festival Haïti en Folie</a>, and <a href=\"https://montreal.hahaha.com/home/\">Just For Laughs</a>—and a few times here in Ottawa, where I&#8217;m on the board of a cybersecurity company called Field Effect. We might even have some Field Effect people here—oh, hi! Thanks for coming. </p>\n\n\n\n<p>Let me give a little update on what I’ve been up to. My life’s mission is to democratize publishing, commerce, and messaging. So I have some projects in each of those areas. In publishing, my main work is WordPress, the core software available to everyone. We host it on <a href=\"http://wordpress.com\">WordPress.com</a> and <a href=\"https://pressable.com/\">Pressable</a>, and allow others to host it with <a href=\"https://wpcloud.com/\">WP Cloud</a>—a cool product—and we use <a href=\"https://jetpack.com/\">Jetpack</a> to bring all the best cloud features to every WordPress, wherever it is running. And, of course, running the main community hubs at <a href=\"http://wordpress.org\">WordPress.org</a>, <a href=\"http://wordpress.tv\">WordPress.tv</a>, WordCamps, <a href=\"http://wordpress.net\">WordPress.net</a>, which probably some of y&#8217;all haven&#8217;t heard of, et cetera, et cetera. </p>\n\n\n\n<p>On the social side of publishing, I have <a href=\"https://tumblr.com/\">Tumblr</a>, which is a microblogging social network, but right now it&#8217;s on a different technical stack. I need to switch it over to WordPress, but it&#8217;s a big lift. It&#8217;s over 500 million blogs, actually, and as a business, it&#8217;s costing so much more to run than it generates in revenue. We&#8217;ve had to prioritize other projects to make it sustainable. It&#8217;s probably my biggest failure or missed opportunity right now, but we&#8217;re still working on it. </p>\n\n\n\n<p>I&#8217;m really excited about the personal publishing side of our products: <a href=\"https://dayoneapp.com\">Day One</a> and <a href=\"https://developer.wordpress.com/studio/\">WordPress.com Studio</a> and <a href=\"https://wordpress.org/playground/\">WordPress Playground</a>. Day One is a fully encrypted, shared, and synchronized blogging and journaling app that runs on every device and on the web. You can also have shared encrypted journals with others. It uses the same encryption as one password. It&#8217;s the first place I go to draft an idea—for example, to write this talk. Its editor is not as good as Gutenberg yet, but it&#8217;s pretty decent at allowing multimodal input—which means you can record voice notes, draw things, etc.—and capturing it all. It&#8217;s mostly replaced Evernote, Simplenote, and even private P2s for me. It has some fun features, like when you make a new entry it records, the location, what music you&#8217;re listening to on Apple Music, how many steps you&#8217;ve taken, the weather. Honestly, some features that would be nice to get into WordPress, at least as a plugin. Right now, I just copy and paste it in the WC admin or the Jetpack app if I want to publish something; that could also be made smoother in the future. </p>\n\n\n\n<p>So WordPress.com Studio is built on an open source project called Playground that we created to allow you to spin up WordPress in a WASM container in about 30 seconds, right inside your browser. Who’s tried Playground or Studio? It&#8217;s kind of wild, right? You know how hard it&#8217;s been to set up servers and databases and everything like that, and so to see a WordPress virtual machine spin up in like 30 seconds just blows my mind. There&#8217;s so much you can do with it. It&#8217;s the most sci-fi thing happening inside of WordPress right now, and we&#8217;ve just barely begun to take advantage of the massive technical and architectural shift it allows. For example, my colleague <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella</a> builds an iOS app called <a href=\"https://wordpress.org/playground/wordpress-for-native-ios-apps/\">Blocknotes</a>. It’s a lot like Simplenote, but it uses a Gutenberg editor, and it&#8217;s entirely a WordPress playground instance—the entire iOS app. </p>\n\n\n\n<p>Part of the evolution of WordPress has been going from a blogging system to a CMS to a full development platform. So what Dave talked about yesterday, and now that you can build entire mobile apps—which, by the way, can run on every platform, cross-platform, and run the same thing on the web—it&#8217;s kind of like a promise from back in the day of Java or other things, React, Native. It&#8217;s now very possible with this WordPress WASM stuff. WASM stands for <a href=\"https://webassembly.org/\">web assembly</a>. </p>\n\n\n\n<p>The main distractions and things holding back WordPress right now are the legal attacks from WP Engine and Silver Lake—I  can&#8217;t comment on that, but stay tuned for some major updates soon. </p>\n\n\n\n<p>I forgot to put this in my post—WooCommerce! On the commerce side, there&#8217;s, of course, WooCommerce, which is very, very exciting. You can think of it like an open-source Shopify, our enablers here in Ottawa. It now processes over $30 billion of GMV (gross merchant volume) per year, and you can customize it to do pretty much anything: subscriptions, digital, physical goods, everything. And of course, it&#8217;s fully open source and built on WordPress. It&#8217;s actually a WordPress plugin, so pretty exciting. WooCommerce is now on about 8% of all websites in the world—WordPress is 40, so it&#8217;s running on about a quarter of all WordPress sites. It&#8217;s been a big part of the growth of WordPress, actually, the past few years. </p>\n\n\n\n<p>In messaging, we have this product called Beeper. Anyone tried out Beeper yet? We got a Beeper super-user here, actually, in Robert. So Beeper basically takes all the different messaging apps—WhatsApp, Telegram, Instagram DMs, LinkedIn DMs, did you ever check those?—and it brings it all into one app, one interface, kind of like a Superhuman for messaging, and gives you cool features across all of them. Now this is obviously a pretty hard technical challenge, because we have to reverse engineer all the different networks for everything. But check it out, it&#8217;s a pretty fun little app. It&#8217;s, free for up to a couple accounts, and paid after that. </p>\n\n\n\n<p>There&#8217;s also an open source component of that as well. We&#8217;re going to make it easier for people to build bridges and connections to different networks, because there&#8217;s a lot that we don&#8217;t support yet that we get demand for, like <a href=\"https://kakaotalk.en.softonic.com/mac\">KakaoTalk</a> in Asia. People also want to do dating apps, which I guess have messaging platforms. So it’d be pretty fun to have everything all in one. </p>\n\n\n\n<p>I&#8217;ve been in the public a lot, doing lots of talks and actually blogging every single day now for 28 days, which will be 29 when we all hit the publish button at the end of this! So I&#8217;ve been blogging a lot. It&#8217;s a lot to keep up with. Actually been going every day since <a href=\"https://us.wordcamp.org/2025/\">WordCamp US</a>, with one missed day in there. I got very, very inspired at WordCamp US. It was a fantastic event. I got to hang out a lot and go to a bunch of sessions, and it inspired me to blog a lot more. If you run Jetpack, there&#8217;s actually a pretty cool feature where the notifications will tell you what kind of streak you&#8217;re on. So whenever I post, I get this nice little notification, like 28 days. And it has little easter eggs when you get certain number of days in a row, which is fun. So I&#8217;m gonna have to add some of this to the post later—I riffed a little bit. We&#8217;ll get the recording. So now that this is all done, we can push the publish button together. </p>\n\n\n\n<p>This is a cool device called a Daylight computer. So cool. It’s from a startup I&#8217;m invested in through <a href=\"https://audrey.co/\">Audrey Capital</a> and Automattic. Think of it like a cross between a Kindle and an iPad. It works in the daylight, hence the name—it doesn&#8217;t emit any blue light. It&#8217;s great for kids. You can order it on <a href=\"http://daylightcomputer.com\">DaylightComputer.com</a>. It runs Android, so it&#8217;s super hackable. You can have apps like Beeper, Day One, WordPress, Jetpack, WooCommerce on it. Very, very neat device. I actually have WP Admin loaded right here; you can see you can scroll like super, super fast. Soon the wifi is going to work—it&#8217;s a wifi-only device. </p>\n\n\n\n<p>Later I&#8217;ll update this post with an mp3 recording enclosed an RSS in honor of Dave Winer, who spoke here, who invented podcasting and RSS. And actually, if you go way back in my RSS feeds, I have some mp3 enclosures from 2004 and 2005, some very funny early podcasts. Also, whenever they post this video to WordPress TV or YouTube, I&#8217;ll share that too, and I&#8217;ll add some links. Thank you. Merci beaucoup! If you want to follow more. Please check out my blog at <a href=\"https://ma.tt\">ma.tt</a>. No WWW, no .com. Just ma.tt. I cross post to ma.tt on Bluesky and Mastodon and on Tumblr, Instagram and Twitter/X at @photomatt. </p>\n\n\n\n<p>And now we&#8217;re going to push the button together. Y&#8217;all ready? Murphy willing, are you ready to publish? think I need to add a category and stuff, but I&#8217;ll do that later.</p>\n\n\n\n<span id=\"more-150251\"></span>\n\n\n\n<p><strong>Q: </strong>Hi, I’m Michelle Frechette, and I drove up from Rochester, New York on Wednesday, so it&#8217;s good to be here. [Applause] I love that our open source extends beyond just publishing websites and words, and that we have, for now several years, the photo directory, which is available to people—and we are closing in on 30,000 published photos, which I think is phenomenal. </p>\n\n\n\n<p><strong>MM: </strong>And all of those are, I think, <a href=\"https://creativecommons.org/public-domain/cc0/\">CC0</a>, Creative Commons Zero-licensed. So it&#8217;s compatible with GPL, embedded in WordPress themes. You can use it on your site. It&#8217;s very cool.</p>\n\n\n\n<p><strong>Q: </strong>Yeah, you don&#8217;t have to give attribution to anybody. You can just use the photos that are there, which I think is good. What are we going to do so that more people know that it exists, besides the 10,000 people who have submitted photos, because I think it&#8217;s still, it&#8217;s it&#8217;s growing. It&#8217;s huge. There&#8217;s a million beautiful there&#8217;s almost 30,000 beautiful photos in there, but I don&#8217;t think enough people know that it exists yet. So how can we get the word out, to get more people to use it?</p>\n\n\n\n<p><strong>MM: </strong>Well, I think first we should ask questions about it at WordCamps. </p>\n\n\n\n<p><strong>Q: </strong>I&#8217;m on it. </p>\n\n\n\n<p><strong>MM: </strong>So check. We&#8217;re actually just kind of on like a Version One of that whole idea. So in my mind, for things that we should do, is 1: I think we need to better integrate finding those photos in the media library, because right now, it&#8217;s kind of like you have to click a few buttons to get to it. 2: I would like, for every single WP admin when you upload a photo, for you to be able to set the licensing to it. And if it is licensed as CC0, we can submit it to the directory. And of course, the directory has some extra rules, right? Some of these rules, I think we might be able to re-examine now. So for example, right now, in the directory, we don&#8217;t allow anything that shows someone&#8217;s face, right? And the reason for this is, even if something&#8217;s CC0-licensed, to have someone&#8217;s face, you need a model release form. There&#8217;s different laws for that in different countries and things like that make sense, right? You wouldn&#8217;t want someone to take your photo at a WordCamp, and now they think it&#8217;s CC0, and you start seeing them running ads for, you know, some sort of new medicine or Viagra or something; it could be very embarrassing. However, when AI creates a face, there&#8217;s no such restrictions there. So something that we could actually start to do, because right now I think we have some anti-AI rules in the photo directory, I think we should probably start to look at evolving that. So, for example, you can take a picture of me right now, change my face with AI to a face that has never existed, and that could be CC0-licensed and anyone in the world could use it. So I think there&#8217;s some possibilities there. </p>\n\n\n\n<p>Because right now, the laws for AI-generated stuff vary from country to country. I think right now in America, it can&#8217;t be copywritten, at least in the same way. At least if it&#8217;s fully created; when a human starts to modify it, it can be. Sometimes I&#8217;m not familiar with the laws here yet, but I&#8217;m sure I&#8217;ll look them up later. So I think that would be a pretty interesting way to open it up right now, because in theory, we should have way more than 30,000 photos. Actually, I have 30,000 photos on my site, which are mostly GPL-licensed. So how can we—yeah, I do need to submit them. Some of them are already in WordPress Core. So remember <a href=\"https://wordpress.org/themes/twentyten/\">the Twenty Ten theme</a>, which has like the little sheep. People really love those sheep. So all those photos I GPL-licensed a long time ago—in my copious free time, yes. </p>\n\n\n\n<p>So I think those are some of the ideas for it. And also think about another project we do that people aren&#8217;t as familiar with, Openverse search. Has anyone used Openverse yet? It&#8217;s pretty cool. So actually, Creative Commons, the nonprofit, used to have a search engine that indexed the entire web and would allow you to find different types of Creative Commons content, including that requires attribution or other things. The foundation actually was shutting this down, and we took it over, and we now run it on WordPress.org We renamed it to Openverse instead of Creative Commons, but they still index the entire web, including audio files, video files, images, all sorts of stuff. So it&#8217;s a very, very cool project. It is embedded in WP Admin a bit, but again, we probably should combine that with a photo search and other things. </p>\n\n\n\n<p>I also think there&#8217;s some opportunities to use AI analysis of all the photos to give a better semantic understanding and a better search that we currently offer, which right now is typically monollingual, I don&#8217;t think it translates well into the, you know, 60-plus languages that WordPress supports, and it&#8217;s manual tagging. So there might be things to do, like a more automated understanding, which, of course, gets better over time. You know, we started to incorporate some of the AI models like Gemini and other things on WordPress.org to make us way more efficient on things like plug-in submissions and some code scanning. I actually think we&#8217;re very much in chapter one of where this is going to be. It can sort of massively [grow]—because WordPress.org relies on volunteers, basically. Some people are sponsored, but most are not. And we&#8217;re over 60,000 plugins now, or 10,000 themes, and actually, the rate of plugin submission, I think, has basically doubled since last year, and the team has gotten it down where before they had a six-month queue, they&#8217;ve got it down to basically under a week. So you know, we can definitely automate more and more and more and be vastly more efficient and support way more developers and more users, way more everything, and probably improve the code quality. So that&#8217;s another thing I&#8217;m pretty excited about. </p>\n\n\n\n<p><strong>Q: </strong>I love it. <a href=\"http://wordpress.org/photos\">WordPress.org/photos</a>, if you want to look at it. </p>\n\n\n\n<p><strong>MM: </strong>Thank you, Michelle! </p>\n\n\n\n<p><strong>Q: </strong>Hey, Matt. Courtney Robertson. Kind of related to Michelle&#8217;s question: This week, I saw <a href=\"https://iconick.io/\">Nick Hamze</a> recounting how when you go to submit a theme, the image that&#8217;s in the preview for the theme, if it is AI-generated that that&#8217;s getting rejected and the nuances Dion dug into—Dion is one of our long time core commiters, core leads, etc, in the project. A hidden gem. If you haven&#8217;t encountered Dion yet, please find Dion and meet him. So Nick is learning the legal ramifications of having an AI-generated image as part of the theme directory, like what we have to do in the theme directory. Because if the image that&#8217;s in the theme is generated by AI, there&#8217;s a lot of legal stuff about, can we do it? Can we not? And we would all like to just be like, “Yeah, whatever. Move on.” But then there&#8217;s some other ramifications. Is that on your radar? I know we&#8217;ve looked at criteria of what could go into the theme repo and some of those deals.  I don&#8217;t know if. I mean, once we get into legal stuff, that&#8217;s maybe beyond you and I.</p>\n\n\n\n<p><strong>MM: </strong>Well, unfortunately, I&#8217;m getting really good at legal stuff. [Laughter] It wasn&#8217;t on my roadmap for the past year or two, but yeah. So this is very much an evolving area, and the laws from country to country do vary a lot. However, there&#8217;s also some common sense things you can apply, and I think that there is a sort of rapidly—we&#8217;re not putting the genie back in the bottle with AI stuff. One,  just the companies; like, OpenAI is just too big to fail now. The entire economy and growth is based on these systems. The infrastructure buildouts, massive data centers, everything. It&#8217;s kind of incredible. Not to mention the usage, like it&#8217;s really transforming translation, code, so much. </p>\n\n\n\n<p>Now, WordPress.org, particularly, because a lot of this is volunteers, those folks aren&#8217;t comfortable making big policy decisions like this that could have ramifications. They already put a lot on the line. I kind of shield everyone from a legal point of view and everything like that, but in theory, people could go after them, and we have had instances where some of these folks can get oppressed by someone who gets something rejected, or banned from the forums for spamming or stuff like that. So we do try to provide some shelter. </p>\n\n\n\n<p>Now, on this issue, in particular, Nick is someone I talk to almost every day. He&#8217;s doing some very, very cool stuff across WordPress and some innovative things with themes. I like that he pushes the boundaries. So for example, right now, the theme directory is fairly conservative in for example, with the intention that we want the demo to look like the theme when you install it, or we don&#8217;t want it to rely on a plugin. And part of the intention there is that for WordPress, we want you to be able to switch between themes really easily. So one of the beauties of it is that you can take your entire blog site, click a button, and you have a brand new design. Now themes, as they start to incorporate more advanced functionality—which is pretty cool—those sorts of things aren&#8217;t allowed. In fact, one of my favorite examples of something that was in the theme directory a long time ago and is not allowed on the current guidelines, that I think we&#8217;ve made an exception, is the Command Line theme. Has anyone seen this? You load it up, it&#8217;s like a blinking terminal, and you interact with it by typing in commands, like “list,” “post,” and you can type “help,” and it gives you all the things. This is so cool! By the way, I don&#8217;t think it complies with, like, any of our standards. [laughter] Like accessibility, it probably breaks some rules there, all sorts of things. </p>\n\n\n\n<p>So I think part of it is, you know, how can we move? And I think Nick even did a post about this, like rules versus guardrails. So I think part of the way we can do this is as a marketplace. Right now, there&#8217;s certain things that we don&#8217;t allow, and in fact, those rules creep up and get bigger every time, right? Because each sub-team comes in and says, “Oh, I need my rules to be requirements.” Actually, accessibility is a great, great example of that. Now, I think what&#8217;s interesting in a marketplace is we can move these things from being rules to being like tags. So for example, if you were a university, you only want to see themes that were WCAG 2.0 or higher compliant—which are by the way, some pretty strict requirements that don&#8217;t apply to many websites, for good reasons, but that was a requirement. You should be able to do that as a search. Or if you want to see themes that are orange, or all these sorts of things: I feel like those should just be tags in the marketplace, and use the rating system as well to open up what we can host, but then give better tools for people to search and choose what they want. </p>\n\n\n\n<p><strong>Q: </strong>Thanks. Just a shout out. Please let Nick know that a lot of us are reading what he&#8217;s putting forward, and I forget his exact website domain. It&#8217;s <a href=\"https://iconick.io/\">Iconick</a>.</p>\n\n\n\n<p><strong>MM: </strong>It&#8217;s spelled in an interesting way. </p>\n\n\n\n<p><strong>Q: </strong>Yeah, it has his name in it. I wonder where he got that idea. [Laughter]</p>\n\n\n\n<p><strong>MM: </strong>Yeah. So it reads as “iconick.” Nick Hamze, H-A-M-Z-E. Google him. He&#8217;s got some really cool themes. He&#8217;s done a lot of cool projects, <a href=\"https://iconick.io/wapuu-slaps/\">a bunch of Wapuus</a>. Actually, I&#8217;m talking to them about how we can upgrade all the Wapuu stuff. By the way, y&#8217;all have some awesome ones at this event. I got the little swag pack with all the stickers and everything. All the sponsors have different ones. You have like, four or five of them. I&#8217;m actually gonna put this sticker on my laptop later, probably that WCF one, so keep an eye out for that.</p>\n\n\n\n<p><strong>Q: </strong>Paul Bearne. I want to talk about <a href=\"https://wordpress.org/plugins/hello-dolly/\">Hello Dolly</a>, the plugin, which shipped with Core.</p>\n\n\n\n<p><strong>MM: </strong>Which, by the way, people tried to get rid of because of copyright issues. Yeah, there&#8217;s actually some interesting things we did to get around that and make it fair use.</p>\n\n\n\n<p><strong>Q: </strong>Should it be removed?</p>\n\n\n\n<p><strong>MM: </strong>You&#8217;re asking the wrong guy.</p>\n\n\n\n<p><strong>Q: </strong>Well, it’s there because nobody wants to ask you to come and remove it.</p>\n\n\n\n<p><strong>MM: </strong>No, they ask me like once a year. [Laughter]</p>\n\n\n\n<p><strong>Q: </strong>If it stays, perhaps we could redo the description to indicate that it&#8217;s historic—it was the first plugin, it was the proof of concept—but please don&#8217;t copy it. It&#8217;s no longer good code.</p>\n\n\n\n<p><strong>MM: </strong>I completely disagree with that. Tell me why it&#8217;s not good code. Because it doesn&#8217;t use classes or object orientation? Why is it bad code?</p>\n\n\n\n<p><strong>Q:</strong> It’s not accessible, it’s not translatable. </p>\n\n\n\n<p><strong>MM: </strong>It is translatable. It actually goes through the translation functions.</p>\n\n\n\n<p><strong>Q:</strong> There’s no translation around the strings. </p>\n\n\n\n<p><strong>MM: </strong>That&#8217;s not true. </p>\n\n\n\n<p><strong>Q: ’</strong>Tis true. [Laughter]</p>\n\n\n\n<p><strong>MM: </strong>Then it was removed because it was one of the first things we did the underscore for. Well, let&#8217;s look it up later today, but it&#8217;s not true that no one&#8217;s ever asked me. It does get asked about once a year. There&#8217;s lots of issues on the bug tracker about it. And if there&#8217;s ways to improve it, like make it translatable, I think that&#8217;s great, and I know people have actually used that before to also just change the lyrics to, like, put different songs in there, different things they want to</p>\n\n\n\n<p>say. </p>\n\n\n\n<p><strong>Q: </strong>When it becomes translatable, the [inaudible] can have more fun with the translation strings.</p>\n\n\n\n<p><strong>MM: </strong>Yeah, but they don&#8217;t have to, right? That&#8217;s the fun thing.</p>\n\n\n\n<p><strong>Q: </strong>Then I look forward to some patches. </p>\n\n\n\n<p><strong>MM: </strong>What I don&#8217;t want to do is, I don&#8217;t want to make it super-complicated. I know we did some things, like we moved it to a sub-directory. It actually just used to be a single file, so there have been some minor upgrades there. But the whole idea is to show how easy it is to use the actions and filter system inside of WordPress. </p>\n\n\n\n<p><strong>Q: </strong>There are no actions or filters in that plugin.</p>\n\n\n\n<p><strong>MM: </strong>Yeah, that&#8217;s how it looks in the WP Admin.</p>\n\n\n\n<p><strong>Q: </strong>There&#8217;s no filter on the string</p>\n\n\n\n<p><strong>MM: </strong>Well. we can add a filter on the string. And maybe it&#8217;s, it&#8217;s actually a filter and not translation, might be actually better, because, like you said, like maybe the pot system is not appropriate for that. Although, why not? Like, I&#8217;m sure you can translate those lyrics to French and other things, they would be meaningful. And also the connection to jazz musicians. It was one of the first famous jazz songs by one of my idols, Louis Armstrong, and you know, since then, we&#8217;ve named every release of WordPress in honor of a jazz musician. So that&#8217;s one of the cool things about WordPress versus other software is it has soul. You know, it&#8217;s true. Code is poetry. You know, we honor musicians and artists. You know, one of the first blocks we did in Gutenberg was actually a poetry block, a prose block. Has anyone used this one? It&#8217;s one of these things people are always like, “we should remove this.” [Laughter] </p>\n\n\n\n<p>Actually, I did it because I took a writing poetry course, and the author, a famous poet, was complaining how, when she posted to WordPress she couldn&#8217;t have the formatting correctly—you know how a lot of poetry will use interesting formatting where the white space has significance? Or spacing that has kind of unusual things? So the behavior of the editor, which takes multiple line breaks and combines into one, and other things, all that was being collapsed. And so I said, “Oh!” I think it&#8217;s called the Prose block, but it&#8217;s basically a block inside Gutenberg that preserves white space, kind of like a “pre” tag, and it&#8217;s used by some of the poets out there. So sometimes we do these really niche features for like, very high-end users. So for example, I think three or four of the living Fields Medalists use WordPress—actually, WordPress.com. </p>\n\n\n\n<p>Does anyone know about the <a href=\"https://www.mathunion.org/imu-awards/fields-medal\">Fields Medal</a>? A couple people. So it&#8217;s a math award. It&#8217;s more prestigious than a Nobel Prize. They give away a Nobel Prize every year. This happens only every four years, and some of the smartest people in the world have it, like <a href=\"https://terrytao.wordpress.com/\">Terence Tao</a>, who is, if you don&#8217;t know about him, look him up. He is probably one of the top five smartest people in the world, amazing, brilliant mathematician—he actually just got defunded, but the <a href=\"https://www.simonsfoundation.org/\">Simons Foundation</a> is now sponsoring all his work, which is very exciting. If you don&#8217;t know Jim Simons, he&#8217;s the founder of <a href=\"https://www.rentec.com/Home.action?index=true\">Renaissance Technologies</a>. Has anyone heard of Renaissance Tech? RenTec? One or two people? Oh, I&#8217;m telling you all sorts of cool stuff now. </p>\n\n\n\n<p>So Renaissance Technologies is the most successful hedge fund ever in history. They show, I think, annualized returns of over 40% over 35 years. It&#8217;s actually physicists and mathematicians that came together. Jim Simons was one of them, he went out of business or bankrupt or something, and was like, “gosh, I need to make some money. Maybe I&#8217;ll check out the stocks and trading thing.” And they started out, and they actually did really well, but then in the 80s, it all crashed. Jiim’s big, big innovation was that he invented algorithmic trading. So he basically said, we have humans making decisions. One, they&#8217;re too slow. And two, we don&#8217;t know why it&#8217;s working. And so there must be some fundamental sort of physics or rules of the trading markets and the business systems. And so RenTec started to gather the most data of anyone in the world. The next hedge fund to do this well was Bridgewater, but basically they started getting data sets, like shipping back to the 1400s, like really obscure things. They go get stuff out of books and develop all this priority training data, use it to map the economy and essentially create these models that the mathematicians would come up with. You can only be an investor in this fund if you work for the company, which is pretty interesting. And of course, everyone there is like a decamillionaire and everything. I forget how many employees—200 or 150 or something. Really, really small. So legendary. And he passed away a few years ago, but his foundation funds a ton of fundamental research and physics and math and so he&#8217;s someone I really look up to and admire. I <a href=\"https://ma.tt/2024/07/jim-simons-rip/\">blogged about him</a> earlier last year. He reminds me a lot of my dad, just the way he looks and talks. My dad passed away in 2016, so I really like watching Jim Simon’s stuff. </p>\n\n\n\n<p>Oh, I forgot to say, the point of the Fields Medalists. The reason the Fields Medalists use WordPress is we support a LaTeX plugin. LaTeX is basically like a markup language for doing advanced math formulas. We&#8217;re actually working on an update to this to be a bit more user-friendly. We added support for it in 2005 because Terence Tao started a free WordPress.com account, and he was complaining about this and embedding these images. I followed his blog, and I was like, “oh, we should make a block for this kind of shortcode.” And this shortcode is actually built into Jetpack, so anyone who runs Jetpack has access to this, and it&#8217;s now a Gutenberg block as well. So we&#8217;re adding diversity. So maybe tell the math department here. It’d be awesome to get some more mathematicians and folks on WordPress.</p>\n\n\n\n<p><strong>Q: </strong>Matt, just want to give you a heads up. We’ve got about five minutes left. </p>\n\n\n\n<p><strong>MM: </strong>All right, rapid fire. Should I do some fast ones? I just need to talk a little less.</p>\n\n\n\n<p><strong>Q: </strong>I&#8217;m Chris, I work for Pantheon. As you obviously know, Pantheon does Drupal stuff. So I know WordPress, but I have been watching, particularly, the evolution of their development work in AI, specifically integration in the Drupal admin, and also how the Drupal CMS is onboarding new users to Drupal, and the <a href=\"https://www.drupal.org/project/experience_builder\">Experience Builder</a> that they&#8217;re building. As we gather here today, probably most WordPressers might not be aware that there&#8217;s actually DrupalCon Europe happening in Vienna right now, and there&#8217;s lots of things that are happening out of that. And there&#8217;s a lot of really interesting and exciting things happening in that Drupal space. I know you&#8217;ve had conversations with Dries, because at least Dries <em>says</em> that you&#8217;ve had conversations.</p>\n\n\n\n<p><strong>MM: </strong>We talk semi-regularly. You know, there&#8217;s only there&#8217;s like a dozen people in the world who, like their whole life, is creating CMSes, Dave&#8217;s actually one of them in the room. We&#8217;re just going to do it the rest of our lives. And Dries is one of them, so I have incredible respect. We actually did a talk together with Mike Little, the co-founder of WordPress. So if you look up Dries, Mullenweg, Mike Little, you&#8217;ll you&#8217;ll find this. It&#8217;s pretty cool talk. Actually, we got to talk about the history and everything. </p>\n\n\n\n<p><strong>Q: </strong>So the question here is: To what degree are you looking at or thinking about the types of developments that are happening in Drupal but other CMSes as well, and what can we, as WordPress, learn from those other ecosystems?</p>\n\n\n\n<p><strong>MM: </strong>Oh, it&#8217;s a great question. I’ve got to look up the user ID. I think I was one of the first couple hudnred people registered on drop.org, which is the predecessor to <a href=\"http://drupal.org\">drupal.org</a>. Dries was actually at that Northern Voice conference in 2006; he has a post about it on his blog with some photos. So yeah, I keep in pretty close contact with a number of the other CMSes. Well, I won&#8217;t say close contact, but usually about once a year we&#8217;ll get together with Anthony from Squarespace, Tobi from Shopify, with Dries, whenever we&#8217;re in the same country, or I&#8217;m over in Europe or Boston. I try to look them up, and I test out things pretty regularly. </p>\n\n\n\n<p>So I haven&#8217;t seen the very, very latest stuff for Drupal. I think I checked out one of the last iterations they did. I love that with companies like Pantheon now doing both WordPress and Drupal, we&#8217;re getting a lot of overlap between the communities. So I would say, please bring this stuff over. I mean, we&#8217;re both PHP, we&#8217;re both GPL. It&#8217;s one of the reasons I&#8217;ve always really supported Drupal, even though we&#8217;re kind of mutually exclusive solutions. I&#8217;m always going to be supportive with other open source projects. So yeah, for those people who overlap, like yourself, please make some suggestions. You know, start a P2  post, or do a blog post about it. We&#8217;ll get it in the newsletter, or maybe even if there&#8217;s something specific that we could bring over code wise, we can start to get that incentive into <a href=\"https://core.trac.wordpress.org/\">Trac</a> and everything. Cool. </p>\n\n\n\n<p>I think Drupal also has a plugin to use Gutenberg, right? Yeah, which is pretty cool. It was one of the reasons we designed Gutenberg to actually be portable to other CMSes, and why we&#8217;ve been putting it under license, dual-licensing it so to be embedded even more places, not just GPL.</p>\n\n\n\n<p><strong>Q: </strong>Forgive the AI translation of my words, but it&#8217;ll help me be concise. But here&#8217;s the question. Really, really simple—no, it’s not. WordPress has always thrived because of its open, community-driven ethos, but as the ecosystem grows, we&#8217;re seeing more like large, profit-driven players who don&#8217;t necessarily share the values. How can individual contributors and agencies like ours actively help protect WordPress and uphold the values and ethics that have sustained it from bad actors and people who might try to exploit the community? And do you see room for something more formal, like a certification for individuals and agencies that define what being a good actor is, to help educate clients and even the market, to help protect in a more proactive way from those sorts of bad actors?</p>\n\n\n\n<p><strong>MM: </strong>Well, that&#8217;s a big question. I&#8217;ll try to answer quickly. So first I will say, I don&#8217;t want to say that there&#8217;s bad actors. I think there might be bad actions sometimes, and just temporarily bad actors who hopefully will be good in the future. You know, every saint has a past, every sinner has a future. I never want to define any company or any person as permanently good or bad. Let&#8217;s talk about actions. </p>\n\n\n\n<p>Second, I think with these actions, we can start to create incentive systems, and it&#8217;s part of what we&#8217;re doing with Five for the Future, which is basically saying, you contribute back—which also implies that you&#8217;re not violating the GPL, or something like that. So we&#8217;ve got the hard stuff, like, if you violate the GPL, you&#8217;re gonna get a letter. Violate the trademark. You know, that was more of a legal thing. But also the gentle stuff, like, how can we encourage good behavior by giving people higher rankings in the directory or in the showcase, for example? </p>\n\n\n\n<p>Then finally, I&#8217;ll just say, vote with your wallet. Each one of you here has the ability to strongly influence these companies. If they&#8217;re commercially motivated, great, let&#8217;s commercially motivate them to do the right thing by giving more business to the good companies and less business to the other companies. This has actually been happening a lot the past year. I think I can say this: There&#8217;s a site called <a href=\"https://wordpressenginetracker.com/\">WordPress Engine Tracker</a> which is currently tracking a number of sites that have left a certain host. It&#8217;s about to cross 100,000 that have switched to others host. And 74,000 have gone offline since September of last year. We actually used to make all this data public. The whole list was on there. They got a court order so the data could be fact-checked by press or other people. There was actually a court order that made us that down. So again, trying to muzzle free speech and transparency. But you know, we&#8217;re allowed to keep that site up, so check it out while you can. </p>\n\n\n\n<p>Do we have time for one more. Is this last one?</p>\n\n\n\n<p><strong>Q: </strong>Okay, I don&#8217;t think this qualifies as rapid fire, but it&#8217;s a softball. First of all, I came to WordPress as an open source advocate. I became a b2 user. That&#8217;s how I got to WordPress. So my all-time favorite WordPress release is 1.5, because it has what I consider a killer feature. It&#8217;s not the one you&#8217;re thinking. It’s pages.</p>\n\n\n\n<p><strong>MM: </strong>1.5 right? Yeah, I remember introducing that. Originally. I had a different CMS I was going to release called ContentPress. Or Multipattern. I wasn&#8217;t sure what to call it, and so I had this whole other CMS. And I was like, man, we should just build this into WordPress, even though it&#8217;s a blogging system. I think having this pages feature put us ahead of Movable Type and others. So yeah, glad we did. I think we introduced themes and that I released him. </p>\n\n\n\n<p><strong>Q: </strong>Yes, themes was the was kind of the obvious big feature for it, but pages is the point at which I would say that WordPress went from blogging engine to CMS. So that&#8217;s my favorite. But what I was going to ask is—</p>\n\n\n\n<p><strong>MM: </strong>So it&#8217;s all been downhill since then? </p>\n\n\n\n<p>[Laughter]</p>\n\n\n\n<p><strong>Q: </strong>No, it was such a pivotal moment that helped with WordPress&#8217;s meteoric adoption rates. And for me, personally, at that time, it allowed me to take a whole bunch of static HTML and bring it into WordPress so I could manage it so much more easily. So my question was: can you tell us a story, or give us some fun facts about that? Softball question, unless it really taxes your memory.</p>\n\n\n\n<p><strong>MM: </strong>Well, luckily I blog. I&#8217;ll say that two of my favorites ever in history are 1.2 and 1.5—which actually came out right after each other, because we skipped a few releases; it was a time when we actually got pretty delayed. So 1.2 introduced the hooks and filter system, which was pretty revolutionary, I think still, as a unique programming paradigm. But before that, to modify WordPress, you&#8217;d actually open up files and change lines. I used to publish these, we called them hacks, and they were. At one point we introduced the hacks file, which made it a little bit better. But then our plugin hook system allowed a separation between the core and the add-ons, but you could go really deep to modify things. Then 1.5 was themes, I believe. So 1.2 was plugins, 1.5 was themes. And then the other big one—I think it was 2 or 2 point something, was when we introduced WYSIWYG for the first time. Which, by the way, was so controversial; people did <em>not</em> want basic WYSIWYG in WordPress, which was funny, like 10 years later, when they&#8217;re like, “Okay, this Gutenberg thing&#8217;s even worse.” I was like, “Ah, I’ve been through <em>this</em> before.” </p>\n\n\n\n<p>So I think that those are kind of the fun stories around there. Again, some of this stuff was pretty slow to be adopted at first. I wasn&#8217;t certain that this should be rolled into WordPress or there should be separate software, but I&#8217;m glad we did. You know, Movable Type was a dominant thing at the time, and their static page functionality wasn&#8217;t very robust. And so the other thing that WordPress did around this time that I thought was pretty awesome is really clean URLs. So where, prior, you know, people would have crufty URLs, like they’d have an ID in the number, or you&#8217;d have for WordPress,—the default’s still there, actually—is like “?p=123,” so creating the mapping system where we map dates, a hierarchy, and these clean slugs to the pages in the back, in the browsing system, essentially, I think was really crucial. And I love that URLs from 20-something years ago still work or redirect to proper things today. So I think that&#8217;s really, really important. Thank you. All right. Last one,</p>\n\n\n\n<p><strong>Q: </strong>Hey, Matt. I&#8217;m Raquel, and I love kitties and surprises. Just some facts. I have a another question around the community. I want to know how do you feel, what are your raw thoughts, on independent WordPress events that are happening in our space now?</p>\n\n\n\n<p><strong>MM: </strong>And do you want to disclose anything there?</p>\n\n\n\n<p><strong>Q: </strong>I mean, I am the one responsible for <a href=\"https://pressconf.events/\">PressConf</a>, so independent WordPress event. So, yeah, how do you feel? I’m just curious as to how we can all get better together, which tends to be my motto.</p>\n\n\n\n<p><strong>MM: </strong>I&#8217;m very much like a “let a thousand flowers bloom” kind of guy. So thank you. I know it&#8217;s a huge labor of love doing something like PressConf. That’s something that’s been very active in WordCamps and other things in the past, and hopefully with WordCamp US going to Phoenix, we’ll have an opportunity to do some work together there. </p>\n\n\n\n<p>So I think that&#8217;s my fundamental, you know, raw thoughts. You know, I do think about, you know, what do we want to encourage in the world as well? So I would just encourage you as an independent organizer. You know, there&#8217;s some beauty there that you don&#8217;t have to follow the rules or guidelines necessarily. And it&#8217;s commercial events. Well, like the tickets cost more than WordCamp and stuff, right? How much is a ticket?</p>\n\n\n\n<p><strong>Q: </strong>Depending on early bird to total, $700 average.</p>\n\n\n\n<p><strong>MM: </strong>And so that’s a bit of a smaller event, right? That&#8217;s part of what people like about it. So the ticket price actually becomes like a little bit of a barrier to entry. It&#8217;s more intimate. You get some really awesome attendees and talks there, as I think about this as well, just like, you know, what do we want to see more of in the world? And, you know, trying to focus time, particularly my time, to those types of things. So that&#8217;s why I came to WordCamp Canada. You know, this is not the biggest WordCamp in the world, but man, this spirit here, and the people and the everything, and like you know, what you’ve all put together, as it’s come together over the past few months, the incredible work of the organizers,the social media team&#8217;s been doing a great job getting some awesome speakers like Jill and Dave and like, I was like, man! That&#8217;s why I was just planning to come and attend. You know, just to check it out, because I was very interested in the content and everything y&#8217;all put together. So again, I guess we&#8217;re out of time. So I just want to say thank you. Thank you. Thank you. I&#8217;m going to run to the restroom, but then I&#8217;ll be right back out in the lobby. I&#8217;m going to take pictures, shake hands, kiss babies. </p>\n\n\n\n<p>[Laughter]</p>\n\n\n\n<p>I can shake the hand of a baby too. It&#8217;s whatever. I’m open-minded. But hey, thank you. I appreciate it.</p>\n\n\n\n<p><strong>Update:</strong> The video is up, it&#8217;s pretty bad I think the audio is pulling from a DJI thing not the microphones, <a href=\"https://www.youtube.com/watch?v=RL-XccK30sY\">but here it is</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 14:24:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: On Money Stuff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150241\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2025/10/money-stuff/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1862:\"<p>There are a few writers who I follow religiously, and one is <a href=\"https://www.bloomberg.com/opinion/authors/ARbTQlRLRjE/matthew-s-levine\">Matt Levine of Bloomberg&#8217;s Money Stuff</a>. For business and finance it&#8217;s one of the smartest and funniest things you can read. Yesterday, I think for the first time, <a href=\"https://www.bloomberg.com/opinion/newsletters/2025-10-15/openai-has-a-business-plan\">he mentioned WordPress</a>! In the context of his quote on this <a href=\"https://x.com/FhantomBets/status/1977410624343965999\">great X thread about how the Polymarket insider predicted the Nobel peace prize winner</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>This trader apparently <em>didn’t </em>have inside information, in the traditional bad sense of like bribing a Nobel committee staffer. Instead, web scraping:</p>\n\n\n\n<p>&#8220;The Nobel site runs on WordPress. Like many WordPress setups, it has an XML sitemap that lists every indexable page, even ones not yet public. If someone were monitoring this sitemap, they could easily notice a new page appear, something like &#8220;http://nobelprize.org/prizes/peace/2025/machado/facts/&#8221;</p>\n</blockquote>\n\n\n\n<p>If you run a WordPress site and want the best advice in the world for how to avoid this sort of thing, I <a href=\"https://wpvip.com/\">highly recommend our enterprise WordPress VIP service</a>! They help run some of the largest and most secure WordPress sites in the world, and could easily help navigate avoiding something like this from happening. WordPress is easy and cheap to run everywhere, <a href=\"https://projects.raspberrypi.org/en/projects/lamp-web-server-with-wordpress\">even on a Raspberry Pi</a>, but you get what you pay for, and any serious organization or mission-critical website should be on VIP.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Oct 2025 04:25:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Matt: The Curse of the Muse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150237\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://ma.tt/2025/10/muse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2443:\"<p>Some days, like this morning when I almost missed <a href=\"https://ma.tt/2025/10/in-canada/\">my flight to WordCamp Canada in Ottawa</a>, I’m so overwhelmed with the maelstrom of ideas and sparks of creation that it feels like waves crashing against a dam. There are so many ways I can imagine new software, new products, new ways for the world to be.</p>\n\n\n\n<p>This is a beautiful process, but it&#8217;s also painful! The anguish and agony arise as you attempt to distill the ideas and sparks; the creativity dims, and the beauty and perfection of the original inspiration fade, as I try to translate it into something that can become real and be legible to others. That’s why I have to drop everything when inspiration strikes, because if I try to return to it later, I find the muse has left and I can’t bottle that energy anymore. (There&#8217;s a reason <a href=\"https://meyerweb.com/\">Eric</a>, <a href=\"https://tantek.com/\">Tantek</a>, and I put &#8220;muse&#8221; <a href=\"https://gmpg.org/xfn/background\">into the XFN standard</a>!)</p>\n\n\n\n<p>To the extent I’ve been successful at all in my life, it is because I’m able to contain this tornado and break it down into plans, business models, people, and teams.  <em>I’ve never done anything useful on my own</em>; it’s always been in conversation and partnership with others. </p>\n\n\n\n<p>I&#8217;m grateful to everyone I work with across <a href=\"https://automattic.com/\">Automattic</a>, WordPress, <a href=\"https://audrey.co/\">Audrey</a>, <a href=\"https://tinkertendo.com/\">TinkerTendo</a>, <a href=\"https://keysjazzbistro.com/\">Keys</a>, <a href=\"https://www.theinstitute.com/\">The Institute</a>, <a href=\"https://illuminate.org/\">Illuminate</a>, <a href=\"https://ecoamerica.org/\">EcoAmerica</a>, <a href=\"https://fieldeffect.com/\">Field Effect</a> (in Ottawa!), as well as all my <a href=\"https://www.facebook.com/saxmatt\">friends</a> and <a href=\"https://www.linkedin.com/in/mattm/\">professional connections</a>. They are the ones that help me shape this energy into things that actually have an impact in the world and aren’t just fever dreams.</p>\n\n\n\n<p>This essay itself had <a href=\"https://quoteinvestigator.com/2012/04/28/shorter-letter/\">hundreds more words</a>, but I have to <a href=\"https://www.amazon.com/dp/0060891548?tag=photomatt08-20\">edit</a>, <a href=\"https://www.youtube.com/watch?v=aStHTTPxlis\">delete delete delete</a>, trim things down.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Oct 2025 00:01:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: #189 – Weston Ruter on Unlocking WordPress Performance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=200138\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/podcast/189-weston-ruter-on-unlocking-wordpress-performance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:60131:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case how WordPress Core continues to strive to unlock greater performance.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Weston Ruter. Weston is a longtime WordPress user and contributor. He has been a core committer for 10 years, and he co-led the WordPress 4.9 release. He worked in the WordPress agency space, and has also been sponsored to work on the Core Performance Team. He lives in Portland, which as you will hear, was quite handy for this interview.</p>\n\n\n\n<p>We start the conversation by getting into the big picture, why website speed matters more now than ever, and how WordPress performs out of the box. Weston shares details about measuring true performance. Revealing, for example, that achieving a perfect Lighthouse score isn&#8217;t the end game, and that real user experience metrics like Core Web Vitals and Largest Contentful Paint should shape how developers and site owners think about optimization.</p>\n\n\n\n<p>Throughout the episode, you&#8217;ll learn about the advances made by the WordPress Performance Team, from lazy loading and new image formats, to speculative loading that shaves precious milliseconds off page transitions. Weston explains how many performance improvements are designed to work automatically, democratizing speed, so that even casual WordPress users benefit without needing to be technical experts.</p>\n\n\n\n<p>The conversation also touches on the balance between adding features and avoiding plugin bloat. The hidden impact of browser and device differences, and how large companies, like Google, are working hand in hand with WordPress to raise the bar on speed and usability.</p>\n\n\n\n<p>Weston offers practical tips, deep technical wisdom, and a glimpse of where WordPress performance is heading next, and it&#8217;s sure to inspire you to think differently about how your sites load, how your users engage, and how you can squeeze out every last drop of speed from the platform you love.</p>\n\n\n\n<p>Whether you&#8217;re a developer, designer, site owner, or just someone curious about what keeps the web running smoothly. This episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Weston Ruter.</p>\n\n\n\n<p>I am joined on the podcast by Weston Ruter. Hello.</p>\n\n\n\n<p>[00:03:28] <strong>Weston Ruter:</strong> Thank you for having me.</p>\n\n\n\n<p>[00:03:29] <strong>Nathan Wrigley:</strong> You are very welcome. I&#8217;m quite jealous of Weston because we&#8217;re in Portland, Oregon at WordCamp US. I had to get on a plane, which was no hardship really in the grand scheme of things. Nevertheless, it was a lengthy plane journey. You, on the other hand, had to get on some public transport to get here because you live in Portland. That must be nice</p>\n\n\n\n<p>[00:03:45] <strong>Weston Ruter:</strong> I live about five miles to the east of here, and so I jumped on the bus and I got off and walked to coffee shop and over to the conference center.</p>\n\n\n\n<p>[00:03:53] <strong>Nathan Wrigley:</strong> And twice, two years in a row as well. You&#8217;re very, very lucky.</p>\n\n\n\n<p>[00:03:56] <strong>Weston Ruter:</strong> I was very happy when I found out.</p>\n\n\n\n<p>[00:03:57] <strong>Nathan Wrigley:</strong> Yeah. So Weston&#8217;s here today because of a presentation that he&#8217;s giving at WordCamp US. I will read into the record the title of the presentation that you&#8217;re giving, The Site Speed Frontier with Performance Lab and Beyond. So it&#8217;s all about performance, this episode essentially.</p>\n\n\n\n<p>This is one of those subjects where I feel you have to tell us your credentials so that we understand that what you are saying is true. Because I think there&#8217;s a lot of snake oil, certainly from my point of view, quite a lot of ignorance. I don&#8217;t really understand this topic inside and out. So would you mind, a minute or something like that? Just tell us about you and your history with, well, WordPress, but also performance and so on.</p>\n\n\n\n<p>[00:04:32] <strong>Weston Ruter:</strong> Yeah, sure. I have been a WordPress Core committer for 10 years. And I was in the agency space working at XWP, working on enterprise WordPress sites. And then I joined Google and I was a software engineer working on developer programs engineer, then develop a relations engineer working on the AMP project, which is all about making webpages faster using the AMP framework. And from there I transitioned into working on the Core Performance Team for the past couple years. And we are focused on making WordPress fast for everybody.</p>\n\n\n\n<p>[00:05:15] <strong>Nathan Wrigley:</strong> Okay, great. Thank you so much. So the topic at hand then is going to be about performance. Why are you interested in this? I know obviously there&#8217;s a career in it and what have you. Is this something that you lie awake at night thinking about? Do you obsess about this kind of stuff?</p>\n\n\n\n<p>[00:05:28] <strong>Weston Ruter:</strong> Yeah, it&#8217;s a passion of mine because who likes a slow webpage, right? So it&#8217;s fun to eke every bit of performance out of the loading of something. There&#8217;s a lot of little technical details and things to know and best practices to observe. And so it&#8217;s a fun challenge to be as fast as possible and there&#8217;s always room for improvement.</p>\n\n\n\n<p>[00:05:52] <strong>Nathan Wrigley:</strong> And it kind of feels as if the mantra over many, many years has basically been that, you know, if you can make your website faster, it will be successful. People will visit it, people are getting weary of page load time or what have you. And so maybe we&#8217;ll get into the weeds of all of that.</p>\n\n\n\n<p>How does WordPress, if I was just to go, okay, ignore the hosting that it&#8217;s on. Let&#8217;s just imagine we&#8217;ve got a good host, we&#8217;ll just use that term. If I was to download a vanilla version of WordPress and use the default theme, currently 2025, and do nothing else with it, I&#8217;ve written a few blog posts, maybe that&#8217;s it. How does it do out of the box like that?</p>\n\n\n\n<p>[00:06:25] <strong>Weston Ruter:</strong> Yeah, it turns out my talk is exactly about this, and it uses the 2025 theme as a test case to show how the performance of WordPress fares out of the box. And if you were to load up a site running 2025, the theme and nothing else, and you run it through Lighthouse, the performance testing tool from Google, you&#8217;ll most likely get a 100 score, performance score. And you would think, I&#8217;m done, there&#8217;s nothing else to do. But if you dig into it, just because you get a good score, that doesn&#8217;t mean there&#8217;s still not room for improvement. And there&#8217;s still head room even after 100.</p>\n\n\n\n<p>But yeah, WordPress Core does great out of the box, but there are still many opportunities to make it even faster. And as you had Felix on previously to talk about speculative loading, that&#8217;s one example where the performance is improved yet further. And in the performance lab plugin, which the performance team maintains, we have different performance feature plugins that implement additional optimisations that address different scenarios and use cases that WordPress doesn&#8217;t do well out of the box.</p>\n\n\n\n<p>[00:07:40] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting, and I&#8217;ve never heard it framed that way. I&#8217;ve never heard that there was a ceiling above 100. It kind of feels as if that is the ceiling. If you score 100, all bets are off, game over, you&#8217;ve succeeded, hooray, have a party, kind of thing. But no, there&#8217;s still room to be squeezing a little bit out here and there.</p>\n\n\n\n<p>[00:07:57] <strong>Weston Ruter:</strong> Yeah, if you look at a Lighthouse audit, Lighthouse is an example of a lab metric. It simulates a page load for a user, but it&#8217;s not an actual page load for an actual user. It&#8217;s just a simulation. And if you really want to know how your site is actually performing, you need to measure those visits from actual users.</p>\n\n\n\n<p>And if you load up a popular site in Google&#8217;s page speed insights tool, you&#8217;ll see there&#8217;s two different sections on the page. At the top, you&#8217;ll see what users are experiencing, and then at the bottom you&#8217;ll see lab data. And the top is coming from actual site visitors through what&#8217;s called the Chrome User Experience Report. And that tells you how the site is performing in terms of the Core Web Vitals that Google has spearheaded.</p>\n\n\n\n<p>And one of those is called the Largest Contentful Paint or LCP, and that measures the time it takes for the largest element that is most likely going to be the main content of the page to be rendered, from the time you start navigating to the page and that element finishes rendering.</p>\n\n\n\n<p>And a good LCP value is considered from 0 to 2.5 seconds. And so you can have, within 2.5 seconds there&#8217;s a big range in the user experience. So if it&#8217;s just under 2.5 seconds, it&#8217;s considered good, but that doesn&#8217;t mean a 1.5 second page load is actually way better, and a 0.5 second page load is even better yet, and a 0.05 second page load is great, is perfect. That would be the perfection. And that is what we&#8217;re working on.</p>\n\n\n\n<p>[00:09:36] <strong>Nathan Wrigley:</strong> There&#8217;s gradations of it, okay. So within that 100 there may be room to do, aspects of the 100 can be improved. And in this case, by taking the LCP time down.</p>\n\n\n\n<p>We&#8217;re at a conference event. There&#8217;s over a thousand people. There must be designers, developers, SEO people here. There&#8217;s everybody. There&#8217;s the whole gamut of people that use WordPress, probably some people that are new to the whole platform as well. Do you think that performance is something that everybody needs to worry about or are you happy to be one of the few that obsess about it? Is it basically better to leave an expert like yourself to worry about it, or is this something that we can all have a little dabble at and be successful about?</p>\n\n\n\n<p>[00:10:14] <strong>Weston Ruter:</strong> Well, that&#8217;s what we&#8217;re concerned about with the Core Performance Team is making it so that the regular WordPress user doesn&#8217;t have to worry about this, because nobody&#8217;s got time to spend learning like, what is LCP? What is time to first bite? What are these different metrics? And nobody has time to worry about optimising for all these. So WordPress Core should do all this out of the box, and the WordPress ecosystem should implement best practices so that users don&#8217;t have to worry about it.</p>\n\n\n\n<p>[00:10:44] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting. I remember, I&#8217;m thinking it was about six years ago, but I don&#8217;t really remember the date. But Google kind of informed everybody that in a period of time, a year&#8217;s time or what have you, these metrics, LCP and, Core Web Vitals basically were going to come in.</p>\n\n\n\n<p>And it felt like everybody in our industry was running around like a headless chicken, trying to understand something that they knew, there was this sword of Damocles moment, this date in the calendar where the SERPs were going to change. It didn&#8217;t feel like a comfortable time. In some senses, it felt like Google was kind of poisoning the water a bit because they were alienating developers who suddenly had to learn this new thing, because they realised their client websites were going to probably tumble in the SERPs.</p>\n\n\n\n<p>And so they had to upskill in this thing that probably they didn&#8217;t want to be involved with. So it was a curious time, but the dust seems to have settled. I don&#8217;t know too much about, you know, whether they were penalties that really were paid by people because they didn&#8217;t have these fabulous Core Web Vital scores. But it definitely put the cat amongst the pigeons for a while anyway.</p>\n\n\n\n<p>[00:11:38] <strong>Weston Ruter:</strong> The factors that go into ranking pages and Google search are, I never knew what they are, so the knowledge I have is that the performance of a page contributes to the ranking in some way. And basically, as I understand it, all things being equal, you have two sites with the same content and same relevance to the user, and one has better performance, then in theory that would rank higher.</p>\n\n\n\n<p>How much value you get in terms of your ranking is debatable or unknown. I don&#8217;t know. But what is important is the user experience and the benefits that you get for your users. And if they have a good experience on your site, then they&#8217;re more likely to come back. More likely to result in a conversion or a purchase, or whatever you&#8217;re looking to get out of your site. So that&#8217;s where I would focus the concerns.</p>\n\n\n\n<p>[00:12:34] <strong>Nathan Wrigley:</strong> If this were the Squarespace or Wix podcast, which of course it isn&#8217;t, it would be much more straightforward to have a conversation about why your site was quick because, you know, it&#8217;s this proprietary platform. There&#8217;s constraints about what you can do on that platform, and they run the whole thing, you know, they&#8217;ve got their arms around everything.</p>\n\n\n\n<p>WordPress, you download it from .org in most cases, and start to pile things on top of it. And very quickly we get the problems developing I guess, you know, the more things that you throw into it, the more plugins and what have you. Would your advice simply be circumspect about what you throw in, or can you, for want of a better phrase, can you concentrate on additional tech to mask over any problems that you have?</p>\n\n\n\n<p>You know, with the best one in the world, if you&#8217;ve got an LMS, it&#8217;s probably going to slow your website down because it&#8217;s doing a lot. If you&#8217;ve got WooCommerce, it&#8217;s probably going to slow yourself, the website, down from the vanilla install with using the 2025 theme that you just mentioned.</p>\n\n\n\n<p>But there&#8217;s this whole marketplace of hosting companies and performance companies who are selling you things that kind of undo the, and I&#8217;m doing air quotes, the damage that you did by putting the plugins in.</p>\n\n\n\n<p>So I don&#8217;t know if you&#8217;ve got anything to say to that. You know, the whole thing about bloating the website, slowing it down, unpicking it with different tech.</p>\n\n\n\n<p>[00:13:49] <strong>Weston Ruter:</strong> Yeah, well, the WordPress ecosystem has a problem with the kitchen sink issue and a plugin that has more features is somehow valued more highly than a plugin that does one thing and does it really well.</p>\n\n\n\n<p>And so in the Performance Lab plugin in our suite of plugins that we feature, we have the goal that a plugin should do one thing and do it really well. And if you don&#8217;t like what the plugin is doing, you deactivate it and switch to another one that is doing that one issue and doing it well.</p>\n\n\n\n<p>But if you have plugins that do so many things, then you&#8217;re really kind of, your hands are tied and it&#8217;s difficult to switch. And maybe that&#8217;s a strategy by some plugins to lock you in to their ecosystem, but it&#8217;s a difficult problem, yeah.</p>\n\n\n\n<p>[00:14:39] <strong>Nathan Wrigley:</strong> And we also have a, you know, we have plugins which are performance plugins. I mean, there&#8217;s dozens of them. I&#8217;m sure we could rattle off, whose job is to fix the problems that you may have created elsewhere in the website. If you&#8217;re in the weeds of it, like you are, you&#8217;ve probably got some vague understanding about it. You understand whether something is snake oil or not, but for the rest of us, that is a Pandora&#8217;s box, and there&#8217;s only chaos in there.</p>\n\n\n\n<p>I don&#8217;t know what will slow my website down. If I download, I&#8217;m going to use LMS again, if I download an LMS platform, I&#8217;m going to hope that the work has been done successfully. But I&#8217;m probably also going to be thinking about, okay, now do I need to talk to my host, get a different hosting environment, get it set up so it&#8217;s perfect for that? Do I need a performance plugin? Caching layers, putting things on the edge.</p>\n\n\n\n<p>And on and on it goes. It makes WordPress a difficult thing for many, many people to use. And so this idea of democratising publishing sort of goes out the window a little bit because it&#8217;s really extraordinarily hard to use.</p>\n\n\n\n<p>[00:15:34] <strong>Weston Ruter:</strong> Yeah. And I think that in addition to democratising publishing, WordPress should also be as part of that democratising performance. And again, making it so that users don&#8217;t have to worry about that.</p>\n\n\n\n<p>And what we&#8217;re doing in Core, we&#8217;re doing exactly that where as one of WordPress&#8217;s core philosophies is decisions, not options, and things should work out of the box.</p>\n\n\n\n<p>But when it comes to the ecosystem, it&#8217;s a open source environment and there&#8217;s no top down control over what a plugin does. So I think there&#8217;s opportunities with projects like the Plugin Check plugin to do more analysis on the performance, in addition to the security and the best practices for being accepted into the directory.</p>\n\n\n\n<p>But if there&#8217;s also a surfacing of performance issues or additional audits that are done on the impact of installing a plugin, that could be really valuable for site owners to get a sense of, this may cause problems if you install it.</p>\n\n\n\n<p>[00:16:37] <strong>Nathan Wrigley:</strong> How long has the Performance Team been a thing? I feel like three years or something like that, but I could be really wrong.</p>\n\n\n\n<p>[00:16:43] <strong>Weston Ruter:</strong> About four years I think.</p>\n\n\n\n<p>[00:16:45] <strong>Nathan Wrigley:</strong> Okay, yeah. And could you just run over the history of that? I was going to say organisation, but let&#8217;s go with team. Could you run us through the history of that team and what you&#8217;ve been able to do?</p>\n\n\n\n<p>Each of the little steps, some of them are quite profound. Some of them feel less profound, but very important. But over those four years, a lot of really incredible work has been done actually. Certainly from my perspective, it does seem that without that team we&#8217;d be in a very, very different place.</p>\n\n\n\n<p>[00:17:15] <strong>Weston Ruter:</strong> I hope that&#8217;s true. I think it is. Yeah, well, it started out focusing on, I think lazy loading of images was one of the first things to land through this team. And with that we also then uncovered that actually lazy loading everything, which while great for reducing the weight of a page, because you&#8217;re not downloading images that aren&#8217;t actually shown. If you lazy load images that are in the initial viewport, that actually hurts the Largest Contentful Paint metric because the browser wastes to start downloading those images until it knows that they&#8217;re in the viewport.</p>\n\n\n\n<p>So out of that came work to not lazy load images that are in the initial view port, and then also moving on to this attribute called fetch priority, which you can have the value of high, for example. So if you add fetch priority high to an image, then the browser&#8217;s going to prioritise loading that first. And so a lot of work was done to add sensible defaults in WordPress Core so that, for example, the featured image of a post gets fetch priority high, so that it gets loaded sooner over images that are not going to be the Largest Contentful Paint, most likely.</p>\n\n\n\n<p>So there&#8217;s that. And then there was also an issue with like emoji in posts where, on every page load there&#8217;s some JavaScript that runs in the head of the page, and it computes whether the browser supports the emoji, like all the emoji. And if the browser doesn&#8217;t support all the emoji, then it loads the Twitter emoji library to render them. And that JavaScript was causing a long task in lower performing browsers, or devices, that was hurting the largest contentful paint as well. So that was fixed as well.</p>\n\n\n\n<p>And then work has been done to add support for new image formats, like AVIF and WebP so that site owners can upload those image formats instead of JPEGs, which take longer to download.</p>\n\n\n\n<p>We talked about speculative loading, and you talked about that with Felix. So that landed in 6.8, which by default will start prefetching the HTML for a page when you mouse down or tap or click, pointer down on a link to give the browser a bit of a headstart. But then the API allows you to be more aggressive about starting that process, just when you hover over the link, for example, and then not just to prefetch the HTML, but to actually render the whole page.</p>\n\n\n\n<p>And so in my talk, which I gave earlier today, I showed the difference between no speculative loading, speculative loading as in WordPress Core right now, the default, and then moderate prefetch. And then lastly, moderate pre-render.</p>\n\n\n\n<p>[00:19:57] <strong>Nathan Wrigley:</strong> Is that done with the plugin? Well, I guess you could do that with code, but there&#8217;s an option to, if you download the plugin, you&#8217;ve got a UI for that as well.</p>\n\n\n\n<p>[00:20:04] <strong>Weston Ruter:</strong> Exactly. There&#8217;s a UI in the plugin that allows you to opt into moderate eagerness, or to use pre-render instead of prefetch. And in the example I showed, let&#8217;s say your time to first bite is a second. Then in the initial example, like on a slow, or on a fast 4G connection, you&#8217;re going to get like 2.27 seconds to load the page. But then with conservative prefetch, that shaves off like 50 milliseconds because the amount of time it takes to mouse down and mouse up is just a little bit of time that it can shave off that&#8217;s just a little bit to the loading of the page.</p>\n\n\n\n<p>But then when you go to moderate prefetch, then the browser can load the page fully in the background. And so then the time to first bite in that case becomes zero because the whole page is already in the browser&#8217;s cache. And that can reduce it to like one second because you totally eliminated the time to first bite.</p>\n\n\n\n<p>And then with the moderate pre rendering, then when you&#8217;re hovered over that link, the browser not only downloads the HTML, but also all the images, builds out the layout, runs the JavaScript. And so then when you click on that link, the page can load instantaneously.</p>\n\n\n\n<p>[00:21:12] <strong>Nathan Wrigley:</strong> So literally instantaneous.</p>\n\n\n\n<p>[00:21:14] <strong>Weston Ruter:</strong> 0.05 seconds.</p>\n\n\n\n<p>[00:21:16] <strong>Nathan Wrigley:</strong> Yeah. It&#8217;s instantaneous. I mean that&#8217;s pretty incredible. All of that is available inside of WordPress, but just to rewind, probably about 50 seconds, the default is not aggressive. The default in WordPress in order to satisfy the kind of 80 20 rule and what have you, the default is to make it so that there has to be some interaction. The mouse has to be invoked. There&#8217;s a click involved.</p>\n\n\n\n<p>That&#8217;s fascinating. So if you really want to get into the weeds of that, you can basically make the next page load almost instantaneously, should you wish to do that.</p>\n\n\n\n<p>One thing that I did get into with, I believe it was Adam Silverstein not that long ago when I had a podcast episode with him. And I don&#8217;t mean to go deeply into this, but there&#8217;s a curious balancing act here, I think with the environment and all of this speculative loading. Because it wouldn&#8217;t be desirable to load, I don&#8217;t know, there&#8217;s 12 navigation links and the mouse happens to go across all of them. And suddenly 12 unnecessary pages were entirely pre-rendered and what have you. So yeah. I don&#8217;t know if you&#8217;ve got any thoughts on that, whether there&#8217;s a balancing act between performance and environmental concerns.</p>\n\n\n\n<p>[00:22:23] <strong>Weston Ruter:</strong> Yeah. By default, speculative loading only operates on pages when you&#8217;re not logged in. And so when you&#8217;re not logged into WordPress, that is most of the time when you&#8217;re going to have a page cache that can serve it from the cache. And so as long as you have page caching in place, then the server isn&#8217;t going to be overly taxed by those requests.</p>\n\n\n\n<p>In the newest version of the Speculative Loading plugin, it has an opt in to speculative loading for logged in users as well. But there&#8217;s a warning that shows up if you don&#8217;t have a persistent object cache active, for example. So, yeah, it&#8217;s important to have good caching in place, good best practices for scaling.</p>\n\n\n\n<p>However, in addition to pre rendering, which the speculative loading plugin enables, there&#8217;s a much older technology for instant page loads that browsers all support, and that is the back forward cache.</p>\n\n\n\n<p>And WordPress sites, by default when you&#8217;re logged out, will benefit from this most of the time. But as soon as you login or if you&#8217;re navigating to like a shopping cart page, or an account page, or checkout page in an e-commerce site. Oftentimes the plugin will invoke this no cash headers function that tells the browser, primarily tells the page cache, hey, don&#8217;t hold onto this response because you don&#8217;t want to cache the shopping cart for one user and then serve it to another user, because then you would be seeing something embarrassing potentially.</p>\n\n\n\n<p>And so that is one of the benefits of sending that header. But it also has the effect of preventing the browser from holding onto that page as well. So if you navigate back and forward from the shopping cart, then you&#8217;ll notice that it doesn&#8217;t load very fast. It loads slow, because the browser has to re-fetch it all from the server, and has to rebuild everything from scratch.</p>\n\n\n\n<p>And so there&#8217;s a effort underway for 6.9 to stop doing that. To allow the browser to hold onto that in memory. And then to address, one of the issues that turned this off to begin with, allowing the browser to store the pages in the cache. Is if you aren&#8217;t logged in, for example, into WordPress. You&#8217;re on some sensitive page maybe putting some API key in or something, and you go to log out, with this back, forward cache, you could hit the back button to go back into the WordPress admin as another person, maybe on a shared computer and look at that page, even though the user had logged out.</p>\n\n\n\n<p>[00:24:50] <strong>Nathan Wrigley:</strong> Yeah, really not good.</p>\n\n\n\n<p>[00:24:51] <strong>Weston Ruter:</strong> Not good. So there&#8217;s a ticket for 6.9 which would solve that problem by invalidating those pages from bfcache so that that privacy concern isn&#8217;t there. And this issue is not just about, well, these back, forward navigations are very common. So the Chrome team found that one in 10 navigations on desktop are these back, forward navigations?</p>\n\n\n\n<p>[00:25:15] <strong>Nathan Wrigley:</strong> A tenth?</p>\n\n\n\n<p>[00:25:16] <strong>Weston Ruter:</strong> Yeah. And on mobile, I think it&#8217;s one in five. So 20% of the time on mobile, you&#8217;re going back and forward using a gesture instead of hitting a link.</p>\n\n\n\n<p>[00:25:25] <strong>Nathan Wrigley:</strong> That maps to my life, but I hadn&#8217;t thought about it.</p>\n\n\n\n<p>[00:25:28] <strong>Weston Ruter:</strong> But the benefit here is not just in that you get a faster page load, but also bfcache, this back, forward cache will preserve the entire state of the page. So in my talk, I showed an example where you, if you have BuddyPress installed, you start typing in an update, a status update, and then you click away to a separate tab, and then if you hit the back button to go back to that initial tab, then you&#8217;ll find without this back, forward cache that your update&#8217;s gone because that input field was constructed with JavaScript. And when you don&#8217;t have back, forward cache, then the entire document object model has to be rebuilt. All the JavaScript has to re-execute. This is also an issue for the block editor. If you navigated away from a page and you didn&#8217;t save a draft, then everything gets lost without this back, forward cache.</p>\n\n\n\n<p>So back, forward cache not only improves performance, giving you the possibility of these instant page loads, but it also preserves that important state on a page that could be lost otherwise.</p>\n\n\n\n<p>[00:26:25] <strong>Nathan Wrigley:</strong> You have a plugin if memory serves, recently in the repo.</p>\n\n\n\n<p>[00:26:30] <strong>Weston Ruter:</strong> Yes. And I got some feedback that it&#8217;s a terrible name, which I agree.</p>\n\n\n\n<p>[00:26:32] <strong>Nathan Wrigley:</strong> What&#8217;s the name? I&#8217;ve forgotten.</p>\n\n\n\n<p>[00:26:33] <strong>Weston Ruter:</strong> It&#8217;s called no cache, bfcache.</p>\n\n\n\n<p>[00:26:36] <strong>Nathan Wrigley:</strong> That was it, yeah.</p>\n\n\n\n<p>[00:26:37] <strong>Weston Ruter:</strong> But if I were to rename it, which I probably will now, it would probably be called Instant Back Forward Navigations or something. It&#8217;s not so short, but.</p>\n\n\n\n<p>[00:26:43] <strong>Nathan Wrigley:</strong> So is the intention to take, are you spearheading that basically? is the intention to roll the learnings from that plugin into Core?</p>\n\n\n\n<p>[00:26:50] <strong>Weston Ruter:</strong> Yeah.</p>\n\n\n\n<p>[00:26:50] <strong>Nathan Wrigley:</strong> And I&#8217;m just going to read this into the record so that everybody understands. You are talking about backwards and forwards by using the buttons, which I guess typically live at the top left of a browser. Those buttons, the arrows that point backwards and forwards.</p>\n\n\n\n<p>[00:27:03] <strong>Weston Ruter:</strong> That&#8217;s right, or the navigation in like the gesture on Android to go back.</p>\n\n\n\n<p>[00:27:07] <strong>Nathan Wrigley:</strong> Yeah, so swipe typically and swipe right. okay. Yeah, that&#8217;s really interesting because I do that all the time. It really hadn&#8217;t occurred to me that was something that could be cached. And if, as you say it&#8217;s 20% on mobile, or 10% on, that&#8217;s a lot of time that you&#8217;re saving.</p>\n\n\n\n<p>Because you do, it&#8217;s a journey, isn&#8217;t it? And sometimes you get to a dead end, and so you just back three times, because you know that you wanted to go back to that product that you saw a minute ago, but you kind of got lost along the way. So that&#8217;s kind of almost like a roadmap item. That&#8217;s 6.9, hopefully. Are there any other things coming in 6.9 that are interesting?</p>\n\n\n\n<p>[00:27:39] <strong>Weston Ruter:</strong> Well, one of the new features in WordPress Core is this Interactivity API.</p>\n\n\n\n<p>[00:27:44] <strong>Nathan Wrigley:</strong> Oh, so nice.</p>\n\n\n\n<p>[00:27:46] <strong>Weston Ruter:</strong> And one of the great things about the Interactivity API is one of its key design principles is server side rendering. So let&#8217;s say you have a navigation block, or you have an image block with a lightbox. All of the HTML and the CSS needed to render those blocks are output on the server. There&#8217;s no need for JavaScript to construct the user interface.</p>\n\n\n\n<p>Nevertheless, there&#8217;s JavaScript needed because there&#8217;s interactivity involved in these interactive blocks. And so with each of these interactive blocks, there&#8217;s a script module that gets added to the page, and it&#8217;s added in the head of the page. And browsers download those script modules with a high priority. And the impact of that is, well, the browser doesn&#8217;t know that these aren&#8217;t important. It could be important, it could not be important.</p>\n\n\n\n<p>But by loading them with a high priority, they compete with loading of more important critical resources like the Largest Contentful Paint image, for example. So by having these modules in the head, then they cause the LCP metric to degrade. And so there&#8217;s a ticket to add fetch priority low to these script tags, which causes the browser to bump them down in priority so that the Largest Contentful Paint image has a chance to load sooner.</p>\n\n\n\n<p>[00:29:04] <strong>Nathan Wrigley:</strong> Yeah. It seems like a game of tennis, this whole thing. For example, the Interactivity API, what a fabulous thing that is, but smuggled into that with something, it sounds unexpected that nobody foresaw that one and okay, need to address that. And here we are, 6.9, that gets addressed.</p>\n\n\n\n<p>[00:29:21] <strong>Weston Ruter:</strong> Yeah, and one of the great things about the Interactivity API as well is that it has really pushed forward the new Script Modules API in WordPress, where what are also called ESM modules or scripts. And these are a new way of writing JavaScript and they are, by default they don&#8217;t block the rendering of the page.</p>\n\n\n\n<p>Whereas if you have a classic script like jQuery in the head of your page, as you start loading the page, the browser has to stop parsing the HTML, it has to fetch the JavaScript, it has to execute the JavaScript, and then because that JavaScript may be doing something like document.write, where it like adds HTML to the page as it&#8217;s executing. Then only after that&#8217;s all finished then the parser can continue and continue laying out the page. So it&#8217;s very bad for performance to have any external, or even inline sometimes, JavaScript in the head.</p>\n\n\n\n<p>And so one way to solve that issue is to slap a defer attribute on that script tag, or an async attribute, and that causes the script to then not block rendering, and it will be executed once the page has finished loading.</p>\n\n\n\n<p>And a nice feature of script modules is that they&#8217;re deferred by default. You can&#8217;t have a blocking script. And so the thinking was, oh, they don&#8217;t block rendering, so we can just put them in the head. But it turns out that they do impact the network, because there&#8217;s other things on the network than just the scripts. And we need to make sure that the critical resources are prioritised, like the LCP image and not just load everything with high priority.</p>\n\n\n\n<p>[00:30:55] <strong>Nathan Wrigley:</strong> It&#8217;s kind of curious because the past of WordPress has been about, you know, you click on links and you generate, I don&#8217;t know a post, a page or something, but you&#8217;ve got this static piece of content, largely. You know, there may be some JavaScript or something, which is doing something fun.</p>\n\n\n\n<p>But the interactivity, API suddenly presents a page which, I don&#8217;t know, you might be stuck on that page for quite a while doing other things. I don&#8217;t know how that leans into the whole performance thing. I don&#8217;t know we could search and filter a bunch of houses or real estate or what have you, and update things. And we are on this one URL but everything&#8217;s getting changed in front of our eyes. So I don&#8217;t know how that whole LCP thing gets bundled into that. It suddenly becomes a much more difficult problem to identify and solve, I guess.</p>\n\n\n\n<p>[00:31:35] <strong>Weston Ruter:</strong> Yeah. So with LCP, it is for that initial page load. So as soon as you interact with the page, then whatever is the largest element then going to be.</p>\n\n\n\n<p>[00:31:47] <strong>Nathan Wrigley:</strong> Oh, that ceases there does it?</p>\n\n\n\n<p>[00:31:48] <strong>Weston Ruter:</strong> Yeah, it stops at that point. However, there are other problems with performance that can arise after that Largest Contentful Paint. So one of the newer Core Web Vital metrics is the Interaction to Next Paint, and that is this INP value. And that is all about how much JavaScript is executing on the page. And JavaScript functions can do a lot of work, so much work that they cause the user interface to appear to halt.</p>\n\n\n\n<p>[00:32:19] <strong>Nathan Wrigley:</strong> Hang.</p>\n\n\n\n<p>[00:32:20] <strong>Weston Ruter:</strong> Yeah, hang. And so that&#8217;s called jank. And it can cause animations to stutter, it can cause a user interface to be sluggish, and you click a button and then nothing happens and then all of a sudden it opens up. And so that&#8217;s an example of a metric that is still very relevant with the Interactivity API. And there&#8217;s been work to establish best practices to make sure that the event handlers for these interactive blocks are using the best practices. Like, it&#8217;s called scheduler.yield, and it allows you to break up a long running task to give the browser a chance to catch its breath so that it doesn&#8217;t cause those long tasks.</p>\n\n\n\n<p>And then another important metric, which continues to matter even after the page is loaded is called the Cumulative Layout Shift or CLS. And that is a very common issue with, where you have ads or something that will just expand as you&#8217;re scrolling down and you lose your place in the page and that hurts your cumulative layout, that CLS score.</p>\n\n\n\n<p>[00:33:19] <strong>Nathan Wrigley:</strong> Yeah. You end up with your finger in entirely the wrong place just as you&#8217;re about to click on things.</p>\n\n\n\n<p>[00:33:23] <strong>Weston Ruter:</strong> That&#8217;s exactly right.</p>\n\n\n\n<p>[00:33:24] <strong>Nathan Wrigley:</strong> Old TechCrunch website. I don&#8217;t know if you&#8217;ve ever came across that one. That was a WordPress one, I believe. And I don&#8217;t know how many times I click entirely the wrong article because it just shifted just at the moment that my finger was descending.</p>\n\n\n\n<p>[00:33:33] <strong>Weston Ruter:</strong> Very aggravating yeah.</p>\n\n\n\n<p>[00:33:34] <strong>Nathan Wrigley:</strong> Yeah, really annoying. We&#8217;re really in the weeds here and what&#8217;s kind of fascinating, obviously you understand it all, I&#8217;m just holding on for dear life here. But it feels as if there&#8217;s a dance between what we&#8217;re expecting the browser to be able to do, and what it actually can do. And I don&#8217;t know if that&#8217;s the case.</p>\n\n\n\n<p>You know, I don&#8217;t know if the fact that I&#8217;ve got a shiny new Mac means that my experience of the web in the future will be better than my 8-year-old Mac over there. That never used to be something that I worried about. It took time to boot that machine, but once it was up and running, that machine was probably just as good at displaying the web as the shiny new one. But now it feels as if that&#8217;s maybe not the case.</p>\n\n\n\n<p>[00:34:13] <strong>Weston Ruter:</strong> It&#8217;s funny you say that because this emoji issue that I described earlier where it was causing this long task as the page was loading, I only discovered that as a problem because I was using a Chromebook as development device.</p>\n\n\n\n<p>[00:34:25] <strong>Nathan Wrigley:</strong> Yeah, notoriously low on specs.</p>\n\n\n\n<p>[00:34:27] <strong>Weston Ruter:</strong> Relatively, that one was even a fast one. But yes, much slower than one of the newer Macs. And so it&#8217;s important to always be testing in an average device, and not always just use the latest and greatest. Because you&#8217;re going to miss performance issues that are probably impacting a lot of users.</p>\n\n\n\n<p>And one of the issues with emojis is, going back to what I described earlier with this long script in the head, now there&#8217;s just an inline script, and even with an inline script, there is still a performance impact where it will stop, because the browser has to stop parsing the page, execute the JavaScript, and then keep going.</p>\n\n\n\n<p>And so I used my new Mac to analyse the performance of that and I didn&#8217;t see a problem. But then I tried the CPU throttling in Chrome Dev Tools where you can emulate low end, low tier device. And in that case, then all of a sudden I saw this 100 millisecond long task pop up, I can&#8217;t remember how long exactly, but it negatively impacted the LCP because it had to spend that time with this underpowered device.</p>\n\n\n\n<p>So, yeah, there&#8217;s many opportunities for optimising things that, if you&#8217;re using devices that people are actually using.</p>\n\n\n\n<p>[00:35:41] <strong>Nathan Wrigley:</strong> I don&#8217;t really know what the expectation is from WordPress over the next decade, but it doesn&#8217;t feel like it&#8217;s going to be limiting itself to websites. It feels like that&#8217;s a portion of it, but Matt Mullenweg often has talked about it being almost like the operating system for the web. Whether or not that will transpire, I don&#8217;t know.</p>\n\n\n\n<p>But certainly for me, a lot of the things that I used to associate with a downloaded app that would run on MacOS or Windows or what have you, I&#8217;m now fully expecting that to be in a browser. And so I expect that the same would be true of our websites. We&#8217;re going to be doing more with them. They&#8217;re going to be requiring more grunt in the background, you know, more interactivity, more filtering, more searching, more database queries. And yeah, I guess WordPress has got to try and keep up with all that.</p>\n\n\n\n<p>[00:36:29] <strong>Weston Ruter:</strong> In improving web performance, it&#8217;s a top down and a bottom up problem. Browsers are working to get faster. They&#8217;re competing with each other, trying to be as fast as possible for all the bragging rights, right? But oftentimes it&#8217;s impossible for the browser to know, even if it&#8217;s as smart as possible, what to prioritise when loading a page.</p>\n\n\n\n<p>So that&#8217;s why when I was working at Google, we were prioritising improving the web at scale through WordPress to implement best practices in how WordPress builds pages so that Chrome doesn&#8217;t have to figure out everything because it&#8217;s impossible for Chrome to figure that out from the top down.</p>\n\n\n\n<p>So if you look at the, over time these Core Vital Metrics, they all consistently are going up and improving, even if a CMS isn&#8217;t necessarily focused on a performance. They all are inching upward. And that&#8217;s because the browser is getting better at performance as well. But when a CMS like WordPress also invests in improving performance, then you can start to see it edging out other CMSs in terms of the relative improvement in performance.</p>\n\n\n\n<p>[00:37:35] <strong>Nathan Wrigley:</strong> Yeah, okay. Let me just parse that. So whether WordPress is at the top or the browser is at the top, you&#8217;ve got this top bottom thing, and it&#8217;s kind of inching in from the top, coming down. Maybe that&#8217;s the browser, and then WordPress at the bottom inching up, if they happily meet in the middle.</p>\n\n\n\n<p>So what you&#8217;re saying is that even if no performance work was done by a Performance Team in WordPress, there would have been in recent years a performance improvement, But the fact that there&#8217;s those two things in symphony with each other means that there&#8217;s a greater performance improvement.</p>\n\n\n\n<p>Given that WordPress, I don&#8217;t know what the number is right now, but the statistic of 43% was always banded around. So it&#8217;s a huge proportion of the internet. Does WordPress have a voice toward Mozilla and Chrome? Does it get to say what the future of browsers might look like? It feels like with that market share, It ought to have a big voice, but I don&#8217;t know if it does.</p>\n\n\n\n<p>[00:38:26] <strong>Weston Ruter:</strong> Well, I remember back when responsive images became a thing, and as I recall that it was WordPress implementing these responsive images that caused browsers to say, okay, we&#8217;re going to implement these now as well. So I think Chrome, I can&#8217;t remember which browser did at first, but it was kind of a catalyst that caused everything to get going.</p>\n\n\n\n<p>And similarly, recently with the speculative loading, it being adopted by WordPress has, I think, caused other browsers to say, okay, we&#8217;re going to implement this as well.</p>\n\n\n\n<p>And yeah, I know that when I was working at Google, and still I&#8217;m in contact with people at Google who work on web standards work, there are initiatives that they&#8217;re working on that they want feedback from WordPress developers to know like, is this going to work for WordPress? And if WordPress can leverage this, and going back and forth between what works for WordPress and what works for browsers and there&#8217;s ongoing conversations, yeah.</p>\n\n\n\n<p>[00:39:25] <strong>Nathan Wrigley:</strong> Yeah, it is kind of interesting. I was talking to somebody from Google, from the Site Kit team, they obviously put up quite a lot of money to be marquee sponsors, if you like. I don&#8217;t know what the word is, you know like a top tier sponsor often at these events. I don&#8217;t know if they&#8217;re sponsoring this one, but there does seem to be some interest from Google.</p>\n\n\n\n<p>I know that Mozilla doesn&#8217;t have the deep pocket, so we&#8217;re not really expecting that. But it&#8217;s nice to hear that, even if it&#8217;s kind of back channels, and it may not be that WordPress gets asked all the time, that there is some sort of symbiosis there. That&#8217;s nice to know.</p>\n\n\n\n<p>[00:39:55] <strong>Weston Ruter:</strong> Well, I remember also seeing recently that Site Kit was voted one of the most trusted WordPress plugins.</p>\n\n\n\n<p>[00:40:01] <strong>Nathan Wrigley:</strong> Yeah, 5 Million plus installs in under five years. And I was kind of surprised by that actually. when I did that interview, I didn&#8217;t realise the numbers were so big. And then after the interview I went out and asked a bunch of random people whether they&#8217;d used it, and a hundred percent of the random selection of 10 people that I asked used it on everything.</p>\n\n\n\n<p>[00:40:20] <strong>Weston Ruter:</strong> Yeah. I use it for sure.</p>\n\n\n\n<p>[00:40:22] <strong>Nathan Wrigley:</strong> Yeah, yeah. It&#8217;s kind of amazing. So just sort of rounding it off a little bit, I&#8217;m guessing that if you were to have your performance hat on, I could be wrong about this. You would be advising people to step away from the classic way of doing things in WordPress with, you know, the classic editor, the classic themes and things. I genuinely don&#8217;t know if there&#8217;s a performance improvement in full site editing, block-based themes, and what have you. Over to you really, it&#8217;s an open ended question.</p>\n\n\n\n<p>[00:40:46] <strong>Weston Ruter:</strong> Yeah, there definitely is a performance benefit to using block themes, and that is because the way that classic themes load, they load progressively where they will print out the head, head tag in the page and then before they render any of the template, they basically locked in the scripts and styles that the page is going to need even though that doesn&#8217;t actually know what&#8217;s going to be in the page for sure. It can make some guesses, but it doesn&#8217;t know for sure.</p>\n\n\n\n<p>And so for classic themes, you&#8217;ll have these massive style sheets that are printed in the head, you&#8217;ll have a whole bunch of scripts that you may or may not use. And as we said before, those scripts may be blocking the rendering and causing all kinds of problems in performance.</p>\n\n\n\n<p>But with block themes, the way that a template is rendered is completely different, where it actually will render all of the blocks in the content first before it goes about rendering the head, the links, the style sheets and the scripts that go in the head of the HTML. And so because of that, a block theme is able to selectively load just the styles and just the scripts that are relevant to the blocks on that specific page. And so the amount of CSS and JavaScript that&#8217;s on a page can be greatly reduced, which greatly improves performance.</p>\n\n\n\n<p>And also, one of the initiatives that we&#8217;ve been working on in the Core Performance Team is related to these responsive images that we were talking about. Where a responsive image, it has all of the different intermediate image sizes that are available. When you upload an image, it&#8217;ll reference all those different image sizes in the source set attribute. And then there&#8217;s the sizes attribute that says which of those intermediate image sizes should be loaded for that image in the page. But because WordPress doesn&#8217;t know classically, in the classic themes, how big an element is going to be, it uses by default the image that is the width of the view port.</p>\n\n\n\n<p>And so on a mobile device, that&#8217;s often fine because images are often the full width of the content. But on a desktop you often have a center column with margins on either side, and maybe the image is going to be in a column or floated to the right. And so oftentimes on desktop, you&#8217;re going to download a much larger image than is relevant to that container on the page.</p>\n\n\n\n<p>And so there&#8217;s a, one of the plugins in Performance Lab is called Enhanced Responsive Images. And what it does is it leverages the block structure in block themes to be able to figure out what the width is for the container of a given image. And then it can craft that sizes attribute to be much more accurate compared to the default sizes attribute. And in my talk, I showed that the performance gains from that enhancement alone are one of the largest that you can have, much more than just using AVIF or a modern image format.</p>\n\n\n\n<p>[00:43:51] <strong>Nathan Wrigley:</strong> Really?</p>\n\n\n\n<p>[00:43:51] <strong>Weston Ruter:</strong> Yeah because, for example, in my test page, I had a jpeg and then I tried it again with an AVIF and the AVIF was 20% smaller, so maybe I could compress it even further. But the Largest Contentful Paint improvement for that was only 2%. But with the Enhanced Responsive Images plugin active, it was able to use a much smaller image size, which is much fewer bites, even as a jpeg compared to the AVIF. And that improved the LCP by I think 45%. So a magnitude and a half higher.</p>\n\n\n\n<p>[00:44:28] <strong>Nathan Wrigley:</strong> It feels like this work is never, ever going to come to an end. There&#8217;s always going to be little things to tweak and squeeze out here, there and everywhere. And there was a really good example just there.</p>\n\n\n\n<p>I think somebody listening to this podcast, if they&#8217;ve got to this point, it&#8217;s kind of really fascinating that most of this stuff would go under the radar for most people.</p>\n\n\n\n<p>I&#8217;m sure almost everything that you&#8217;ve mentioned, for the casual WordPress user, they would never know that that happened. Not many people are going to read the change log or delve into the weeds of what the Performance Team are doing. And yet there it all is, laid out in front of us over the last 40 minutes or so. Yeah, absolutely loads and loads of work. and never ending. You&#8217;ll be here this time next with new things to say.</p>\n\n\n\n<p>[00:45:06] <strong>Weston Ruter:</strong> Hopefully. I don&#8217;t want to work myself out of a job.</p>\n\n\n\n<p>[00:45:07] <strong>Nathan Wrigley:</strong> That&#8217;s absolutely true. Where do you go to find information about this? You know, who are the scholars, or the YouTubers, or the blog post authors? Who are the people that are pushing the boundaries here?</p>\n\n\n\n<p>[00:45:20] <strong>Weston Ruter:</strong> Well, I have recently been loving the WordPress newsletters that go out, like the Repository and Remkus de Vries, his WP, I forget the name.</p>\n\n\n\n<p>[00:45:32] <strong>Nathan Wrigley:</strong> It&#8217;s okay.</p>\n\n\n\n<p>[00:45:33] <strong>Weston Ruter:</strong> It&#8217;s something in, WP in the name. I think, Within WP, but don&#8217;t quote me on that.</p>\n\n\n\n<p>[00:45:36] <strong>Nathan Wrigley:</strong> Oh, it is, Yeah Remkus, Within WP, you&#8217;re right.</p>\n\n\n\n<p>[00:45:39] <strong>Weston Ruter:</strong> Yes. So I subscribe to his performance blog. So Jono Alderson, Jono or Jono?</p>\n\n\n\n<p>[00:45:46] <strong>Nathan Wrigley:</strong> I think Jono. Yeah, we&#8217;ll go with that. And apologies if it&#8217;s not.</p>\n\n\n\n<p>[00:45:49] <strong>Weston Ruter:</strong> Yes. And so all of his posts are brilliant, so yeah. And then, yeah, following just the newsletters, because I don&#8217;t have time to keep up on social media anymore, but I really am thankful for those newsletters because it really saves me a lot of time. It gets me what I need to know.</p>\n\n\n\n<p>[00:46:05] <strong>Nathan Wrigley:</strong> Yeah, I will, link to the ones, the three that you&#8217;ve just mentioned.</p>\n\n\n\n<p>Yeah, that&#8217;s amazing. Thank you. Honestly, it seems a bit trite, but I&#8217;ve been following what the Performance Team have done for the last four years now, from the capacity that I have to understand it, which is pretty low in all honesty. You know, most of what you&#8217;re saying, I can get a purchase on the overarching idea, but as soon as you were to draw back, if you were to show me what you were doing, the code and so on, I would immediately lose my purchase.</p>\n\n\n\n<p>I&#8217;d just like to express how profoundly happy I am that people like you are taking the time to do it. I don&#8217;t know how much thanks you get for stuff like this, but for my part, thank you.</p>\n\n\n\n<p>[00:46:42] <strong>Weston Ruter:</strong> Well, thank you, but no thanks are required because I enjoy doing it, so.</p>\n\n\n\n<p>[00:46:45] <strong>Nathan Wrigley:</strong> Yeah, great. Well thank you. anyway.</p>\n\n\n\n<p>[00:46:46] <strong>Weston Ruter:</strong> I&#8217;ll do it anyway.</p>\n\n\n\n<p>[00:46:47] <strong>Nathan Wrigley:</strong> Yeah, well Weston Ruter thank you so much for chatting to me today. It&#8217;s been a pleasure.</p>\n\n\n\n<p>[00:46:51] <strong>Weston Ruter:</strong> Thank you very much.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://weston.ruter.net/\">Weston Ruter</a>.</p>\n\n\n\n<p>Weston Ruter is a long-time WordPress user and contributor. He has been a core committer for 10 years and he co-led the WordPress 4.9 release. He worked in the WordPress agency space and has also been sponsored to work on the Core Performance Team. He lives in Portland, which, as you will hear, was quite handy for this interview.</p>\n\n\n\n<p>We start the conversation by getting into the big picture: why website speed matters more now than ever, and how WordPress performs out of the box. Weston shares details about measuring true performance, revealing, for example, that achieving a perfect Lighthouse score isn’t the end game, and that real user experience metrics like Core Web Vitals and Largest Contentful Paint (LCP) should shape how developers and site owners think about optimisation.</p>\n\n\n\n<p>Throughout the episode, you’ll learn about the advances made by the WordPress Performance Team, from lazy loading and new image formats, to speculative loading that shaves precious milliseconds off page transitions. Weston explains how many performance improvements are designed to work automatically, democratising speed so even casual WordPress users benefit without needing to be technical experts. The conversation also touches on the balance between adding features and avoiding plugin bloat, the hidden impact of browser and device differences, and how large companies like Google are working hand-in-hand with WordPress to raise the bar on speed and usability.</p>\n\n\n\n<p>Weston offers practical tips, deep technical wisdom, and a glimpse of where WordPress performance is heading next, and it’s sure to inspire you to think differently about how your sites load, how your users engage, and how you can squeeze out every last drop of speed from the platform you love.</p>\n\n\n\n<p>Whether you’re a developer, designer, site owner, or just someone curious about what keeps the web running smoothly, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2025/session/the-site-speed-frontier-with-performance-lab-and-beyond/\">The Site Speed Frontier with Performance Lab and Beyond</a> &#8211; Weston&#8217;s presentation at WordCamp US 2025</p>\n\n\n\n<p>A post about the presentation (above) on <a href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/\">Weston&#8217;s own website</a></p>\n\n\n\n<p><a href=\"https://en.wikipedia.org/wiki/Accelerated_Mobile_Pages\">Accelerated Mobile Pages (AMP)</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/performance/\">WordPress Core Performance Team</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/docs/lighthouse/\">Lighthouse</a></p>\n\n\n\n<p>Podcast &#8211; <a href=\"https://wptavern.com/forums/topic/171-felix-arntz-on-how-speculative-loading-is-speeding-up-your-wordpress-website\">Felix Arntz on How Speculative Loading Is Speeding Up Your WordPress Website</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/performance-lab/\">Performance Lab plugin</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/docs/crux\">CrUX</a> &#8211; Chrome User Experience Report</p>\n\n\n\n<p><a href=\"https://web.dev/articles/lcp\">Largest Contentful Paint (LCP)</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check (PCP)</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/fetch-priority\">Optimize resource loading with the Fetch Priority API</a></p>\n\n\n\n<p>Podcast &#8211; <a href=\"https://wptavern.com/podcast/178-adam-silverstein-explores-transformative-browser-features-impacting-wordpress-sites\">Adam Silverstein Explores Transformative Browser Features Impacting WordPress Sites</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/bfcache\">Back/forward cache</a></p>\n\n\n\n<p>Weston&#8217;s <a href=\"https://wordpress.org/plugins/nocache-bfcache/\">Instant Back/Forward plugin</a> (mentioned in the podcast with an older name)</p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/\">Interactivity API Reference</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/\">Script Modules API</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/inp\">Interaction to Next Paint (INP)</a></p>\n\n\n\n<p><a href=\"https://developer.chrome.com/blog/introducing-scheduler-yield-origin-trial/\">Introducing the scheduler.yield origin trial</a></p>\n\n\n\n<p><a href=\"https://web.dev/articles/cls\">Cumulative Layout Shift (CLS)</a></p>\n\n\n\n<p><a href=\"https://sitekit.withgoogle.com/\">Site Kit plugin</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/auto-sizes/\">Enhanced Responsive Images plugin</a></p>\n\n\n\n<p><a href=\"https://withinwp.com/\">Within WordPress</a></p>\n\n\n\n<p><a href=\"https://www.jonoalderson.com/\">Jono Alderson&#8217;s website</a></p>\n\n\n\n<p><a href=\"https://www.therepository.email/\">The Repository</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Matt: D’Angelo &amp;amp; Diane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150230\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2025/10/dangelo-diane/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1141:\"<p>Just last night I was re-watching <a href=\"https://en.wikipedia.org/wiki/Annie_Hall\">Annie Hall</a> to remember and <a href=\"https://www.newyorker.com/culture/postscript/diane-keatons-shadows-and-light\">honor Diane Keaton</a>, and now <a href=\"https://www.nytimes.com/2025/10/14/arts/music/dangelo-dead.html\">the  news that D&#8217;Angelo had passed</a>. I&#8217;m writing this listening to <a href=\"https://open.spotify.com/album/2lO9yuuIDgBpSJzxTh3ai8\">Voodoo</a>, one of the great albums of all time. That CD in my beater car in Houston was on constant rotation, the richness of the tracks— it&#8217;s an album you have to listen to in its entirety, it takes you on a journey, the way the tracks blend in to each other. Not ideal for the atomized world of songs being stand-alone.</p>\n\n\n\n<p>D&#8217;Angelo was obviously a star, but one amazing thing about his bands is he brought so many people with him, so many amazing jazz musicians, including Roy Hargrove, Robert Glasper (<a href=\"https://khspva.houstonisd.org/\">HSPVA</a>!), Chris Dave (HSPVA!), Kenny Garrett, Pino Palladino, Questlove&#8230; May his memory be a blessing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Oct 2025 03:49:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Open Channels FM: Why Focus Matters When Building a Successful WordPress Plugin Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://openchannels.fm/why-focus-matters-when-building-a-successful-wordpress-plugin-business/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:160:\"Learn the importance of focus in scaling a WordPress plugin, advocating for prioritizing core products over numerous side projects to achieve long-term success.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 11:38:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"Open Channels FM: How Great Storytelling Builds Brand Loyalty and Differentiates Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=111053\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://openchannels.fm/how-great-storytelling-builds-brand-loyalty-and-differentiates-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"In this episode, Rae and Adam dig into why storytelling is key for brands to shine in WordPress, sharing tips on connection, differentiation, and authentic messaging.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Nanochat &amp;amp; MCP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150223\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/nanochat-mcp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1156:\"<p>Probably the most interesting thing on the internet today is <a href=\"https://x.com/karpathy/status/1977755427569111362\">Andrej Karpathy&#8217;s nanochat</a>, &#8220;a minimal, from scratch, full-stack training/inference pipeline of a simple ChatGPT clone in a single, dependency-minimal codebase.&#8221; 8,000 lines of beautiful code, <a href=\"https://simonwillison.net/2025/Oct/13/nanochat/\">as Simon Willison notes</a>. If you want to understand how LLMs work, <a href=\"https://github.com/karpathy/nanochat\">study this</a>. Andrej is a code poet.</p>\n\n\n\n<p>In hacking news, Wired has <a href=\"https://www.wired.com/story/satellites-are-leaking-the-worlds-secrets-calls-texts-military-and-corporate-data/\">an amazing article on intercepting geostationary satellite signals</a>.</p>\n\n\n\n<p>On Friday, we turned on something cool: <a href=\"https://wordpress.com/blog/2025/10/07/mcp/\">every WordPress.com site now supports MCP</a>. Right now this is read-only access to your site, because the S in MCP stands for Security, but <a href=\"https://developer.wordpress.com/docs/mcp/prompt-examples/\">you can already start to do some cool stuff with it</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Oct 2025 06:07:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: Last Ball\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150219\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/10/last-ball/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"<p>If you appreciate golf at all, <a href=\"https://www.espn.com/golf/story/_/id/26902640/down-last-ball-how-tiger-avoided-disaster-won-2000-us-open-15\">the story of how Tiger Woods won the U.S. Open at Pebble Beach without knowing he was down to his last golf ball because of arcane rules is pretty interesting</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Oct 2025 06:36:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Gutenberg Times: Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=42245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:67394:\"<p>In episode 122 of the GT Changelog podcast, host Birgit Pauli-Haack is joined by Beth Soderberg, CEO of bethink Studio, to discuss the latest updates in Gutenberg 21.8 and WordPress 6.9. The conversation kicks off with reminiscing about past WordCamp experiences and transitions into a deep dive on block themes, evolving design tools, and the challenges of adopting new workflows. Beth shares practical insights from her agency work, highlighting the benefits of section and block styles, synced patterns, and strategies for cleaning up legacy code as Gutenberg advances.</p>\n\n\n\n<p>The episode covers new features like section styles, the highly anticipated accordion block, and improvements to template management, aimed at making theme and site building more flexible for users and developers. They also talk about experimental features such as PHP-only blocks, block bindings, and upcoming blocks like breadcrumbs and table of contents, which promise to streamline site navigation and content organization.</p>\n\n\n\n<p>Birgit and Beth underscore the importance of continuous testing and learning, encouraging listeners—especially those hesitant to adopt block themes—to experiment, seek support, and embrace gradual change. The episode wraps with practical advice, recent security updates, and a look at promising innovations coming to the WordPress ecosystem.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor: <a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo: <a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production: <a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Special Guest: Beth Soderberg</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://bethink.studio/\">Bethink Studio</a></li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/bethsoderberg/\">WordPress.org Profile + Slack </a></li>\n\n\n\n<li><strong>Talks by Beth Soderberg</strong>\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.tv/2025/07/25/my-process-for-building-a-custom-wordpress-theme-in-2025/\">My Process for Building a Custom WordPress Theme in 2025</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/2020/04/16/bill-ericksonellen-bauer-beth-soderberg-case-studies-how-to-prepare-your-theme-for-gutenberg/\">Bill Erickson,Ellen Bauer, Beth Soderberg: Case Studies &#8211; How to Prepare your Theme for Gutenberg</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/?s=beth%20soderberg&amp;sort=newest\">And more</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Calls for Testing WordPress 6.9 </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\">Template management</a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\">Ability to Hide Blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\">Accordion Block</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Community Contributions</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://gutenbergtimes.com/blocks-galore-test-template-management-woo-product-collections-and-more-weekend-edition-343/#blocks-galore-with-telex\">Block Galore</a> by designers and developers using Automattic’s Telex </li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/block-commenting-fun-with-telex-from-classic-to-block-theme-weekend-edition-341/#building-blocks-with-telex\">Moar Blocks</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s Released</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.org/news/2025/09/wordpress-6-8-3-release/\">WordPress 6.8.3</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/\">What’s new in Gutenberg 21.8? (8 October)</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">New Blocks still in the works</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/71588\">Time to Read</a> (m) </li>\n\n\n\n<li><img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://href.li/?https://github.com/WordPress/gutenberg/pull/64119\">Accordion Block</a> (m) </li>\n\n\n\n<li><img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/71793\">Breadcrumbs Block</a> (m)</li>\n\n\n\n<li><img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> <a href=\"https://github.com/WordPress/gutenberg/pull/70720\">Terms Query block</a> (m) </li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71618\">Dialog Block </a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71227\">Icon Block</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71904\">Stretchy Text</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/69789\">Tabs Block</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/42229\">Table of Contents block</a></li>\n</ul>\n\n\n\n<p><img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f7e3.png\" style=\"height: 1em;\" /> = already merged into trunk, as experiments. </p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello and welcome to our 122nd episode of the Gutenberg Changelog. In today&#8217;s episode, we will talk about Gutenberg 21.8 and WordPress 6.9, what we already know about it. And I&#8217;m your host, Birgit Pauli-Haack, curator at Gutenberg Times, co contributor on the Word Open Source project, and I work as a developer advocate for Automattic. I&#8217;m thrilled that I finally have Beth Soderberg join me on the show. Beth is the CEO of Bethink Studio, a special web design and development agency in Alexandria, Virginia, in the U.S. Beth, welcome to the show. How are you doing?</p>\n\n\n\n<p><em>Beth Soderberg:</em> Thank you. Welcome. Welcome to my morning. I&#8217;m doing great. Good to see you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So I tried to recollect how we actually met or we met over the last few years, and I think it was the first time we met at the WordCamp New York in 2019.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think that&#8217;s right. Ish. I definitely have eaten tacos late at night at WordCamp New York. Okay, so that tracks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And I definitely met you sometime before the pandemic, so I&#8217;m not sure exactly, but that sounds about right. And then I know we had lunch at WordCamp us when it was in San Diego.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Oh, okay. Nice. Oh, right. We had this.</p>\n\n\n\n<p><em>Beth Soderberg: </em>There was.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>There was a group of women kind of coming together.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah, I saw a table of women. And if I see a table of women at a conference like that, I&#8217;m going to sit down at it. And you did exactly the same thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Nice. So.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But that&#8217;s the first time I saw you after the pandemic, for sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. And in between, I think we did together the WP Blog Talk virtual conference that was organized by Automattic, but there were a lot of community members in there talking about the Gutenberg and the stage of it and all that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That was when I realized that I don&#8217;t like presenting at virtual conferences in front of audiences that you can&#8217;t see.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, it&#8217;s interesting.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I&#8217;m good with Zoom, because you can get some feedback. But the speaking into the void was. I don&#8217;t know. It could have also been that I wasn&#8217;t speaking to anyone in real life at the time, so it felt extra weird.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, no. I get it. The pre-recording and then just be there for the live part of it. But we had a great live discussion there.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I. It was fun. And we actually did the presentation live. I think that could be why later things were recorded, because it was a really weird experience. It was very strange because you knew you were live. You had no idea if even your audio was working, but you just kind of had to keep talking. And, yeah, it&#8217;s the least feedback I&#8217;ve ever had from anything I&#8217;ve ever spoken at. And I think that not even being sure that the technology was working part. Like, even that level of feedback wasn&#8217;t there. It was fun. And hopefully next time I do something like that, it will be recorded in advance.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. But it was a. It was a good place talk because it was kind of together with Ellen Bauer, and you had 15 minutes, Ellen had 15 minutes. And I think Bill Erickson was there as well.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>There were three of us.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And every one of you kind of took a different take on the block themes. Yeah. And that was really interesting to kind of. Well, we started out in 2020 with that. Yeah. Now it&#8217;s five years later, and we finally connected again at WordCamp. Us, because I made it there again.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I know. I was excited to see you. And I think. Yeah, I mean, doing that talk was interesting. I think there&#8217;s still some divergence around how people are building and how people are utilizing the tools. That set of like 15-minute talks was a really good microcosm of that because each one of us had been actively building with all of the new tools and had a slightly bigger, different approach. I still think there&#8217;s some divergence there, but we&#8217;re starting to see some patterns of, like, actual best practices with the new tools, which I think is really exciting. And also it&#8217;s fun to sort of invent on the fly. Like, okay, how should this work as the people who really are using it with clients right away, what is the standard we want to set? What does and doesn&#8217;t work? And I think that was still in a time period where we were learning so much about what you could do, what the restrictions were. I know in a lot of what we&#8217;re going through today, there&#8217;s like little tiny changes that end up being so impactful. Right. Like, my favorite thing I hated from that time period was it could have been a little earlier, I don&#8217;t remember. But originally you couldn&#8217;t set text colors on lists.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Oh, yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Stuff like that. Where it&#8217;s so small, but when it&#8217;s missing, it&#8217;s a big problem.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So, yeah, I think that a lot of work has been put into having consistent design tools for each block that you can control through the theme JSON file and then make it really a unique experience or unique design for your clients. Yeah, that&#8217;s definitely something there where you don&#8217;t, oh, I can&#8217;t do the fonts. Yeah, well, I guess I need to do a variation of it. So there was a lot of coding done to kind of get around those restrictions. How do you feel about kind of ripping out all this additional around coding now that certain things are in core and that are available? Does that kind of trip you up a bit?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I feel great about it and there&#8217;s not that much I need to rip out. Some of that is because of how I&#8217;ve built things over time. Some of that is because things like the tab block, which I am so excited about, I know it&#8217;s not ready and all that, but I have a few sites where I have random solutions for that, but I&#8217;ve got them compartmentalized. So pulling them out and putting in something new that makes more sense is going to be easy.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because I know, you know, like, especially something like the tabs, they don&#8217;t appear that often. And the other thing with stuff like that, you can just search the database for the machine name of block to find where you&#8217;re using it. I do that a lot and sometimes I don&#8217;t know. I ripped Jetpack out of a site recently because it was only being used for slideshows in like six blog posts. There was no need for it. And it might have been more than six, but still this is a major publishing website that has thousands of posts. They didn&#8217;t need Jetpack sitting there doing this like a very minor task. And so that&#8217;s one of my tactics for sure. When I&#8217;m going to rip something out. People forget that you can search easily. Not even in the database. You can use the WordPress search. Search.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Right. For the posts. Yes. Yeah, that&#8217;s what I do. Yeah. Kind of. You can kind of put the blog name in there and then see which post uses what block, especially the third party blocks. When you find out, okay, I have now three query blocks and core blocks and why am I doing this to me?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And I&#8217;ve always been pretty conservative about what I&#8217;ll add.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>So I think that&#8217;s part of why it&#8217;s not super daunting to me. Because if I can make it work with the tools that exist, I will.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I&#8217;m not going to over engineer it just because I could. And that makes it easier to clean up long term.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So I think the last big feature that was introduced to theme development was the section styles. Style variation in one and then the section styles, the smaller things and block styles, now that you can edit them in the global styles. How much do you use about that? Is that something that comes up quite a bit in your work?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I use them a lot. Especially when you&#8217;re dealing with semantics, I want to give people the ability to have something look the way they want it to look, but also be semantically correct. So especially with things like headings. Right. Having tooling that&#8217;s easy for an end user to understand to say this should be an H2, but I would like it to look like an H4 without making it an H4 is a game changer. It improves SEO, it improves accessibility, it keeps everything cleaner. And so that kind of tooling, I think when used strategically can really help. When used randomly, you&#8217;re just going to confuse people. But you know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, aren&#8217;t we in the business of confusing people?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, sometimes. Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>All right. Yeah, no, it&#8217;s interesting too. So are you using also side styles variations or just the section styles or block styles?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Heavily using block styles. Okay, not so much the whole site variations yet. Yeah, there hasn&#8217;t. It&#8217;s again, it&#8217;s like you want to use the right tool for the right use case and yeah, normally you don&#8217;t.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Want to change how the site looks.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. There&#8217;s only. You kind of need like a site within a site to make that required. And the only thing like that I&#8217;ve been building lately is a voter guide that&#8217;s like within a site but the voter guide has all the same styling as the rest of the site. Because it&#8217;s supposed to match.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, right. Right. Yeah. Yeah. I&#8217;ve always felt that the style variations are more for theme product developers that want to give more options to modify the theme. For agencies, I didn&#8217;t see that there are a whole lot of use cases for. For them. I might be wrong, but. Yeah, but you&#8217;re kind of confirming a little bit my bias here.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I. I don&#8217;t know. I look at anything that&#8217;s coming in that&#8217;s new. I look at it in terms of strategic utility and there&#8217;s a bunch of stuff that is super cool but it&#8217;s just not necessary for my clients. Right. Like it&#8217;s not the use case for that but for somebody else that could really help. And I&#8217;ve had a few where you end up building this random micro site within the site because some weird reason why they need it. And like that&#8217;s really what you would use that for. It doesn&#8217;t happen all that often.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So yeah. Do you apply section styles to your patterns? Yeah, so that. And you give them design choices and they don&#8217;t have to spend time with kind of reorganize their design just because they want to have a pair of a pink background or a yellow background or something like that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. I also, I restrict color palettes, of course, because we don&#8217;t want anything looking like, you know, we&#8217;re in the. We&#8217;re in some sort of sci fi. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: Geocities. </em>I&#8217;m dating myself now.</p>\n\n\n\n<p><em>Beth Soderberg: </em>It&#8217;s okay. I told the checker at the grocery store the other day about how I worked at Blockbuster in high school and how that dated me, but it was a good job because you could I had to walk around to put the movies back. So I also use a lot of synced and partially synced blocks to achieve design consistency. So paired together. Because that I have found is really good for editorial teams where you can give them a style guide. And usually I make a page on the inside of the site that&#8217;s just privately published so that they can see like, okay, we have these patterns to work from. And, you know, this is the human part. You have a discussion about how, yes, you can do all these things, but you should use these things that we&#8217;ve all agreed upon that follow the style guide.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Well, it also makes for production much, much faster when you don&#8217;t have to make those design decisions. They&#8217;re already there and then.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Exactly. And you don&#8217;t have to train people. I mean, the number one thing I see real clients, real site administrators doing weirdly with formatting is inconsistent vertical spacing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>The tooling is there to make it consistent, but people don&#8217;t. Even if you train them, they&#8217;re like, wait a minute, do I pick it at the fourth hash? Or like, which setting is it again? And does that look. And like as much as I can look at spacing on anything and know if it&#8217;s wrong, many people cannot.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, no, no. Yeah. That&#8217;s a skill.</p>\n\n\n\n<p><em>Beth Soderberg: </em>It&#8217;s a skill.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>And many people really. And I found that like syncing those patterns that way and getting. Locking down some of that basic stuff that like, you don&#8217;t want your end user to be thinking about how much space they need below something.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Like that&#8217;s not what they should be ever actively thinking about. So that&#8217;s how I have approached that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah. So far. Yeah. Makes sense. Have you taken a survey of how often your clients actually use the spacer block? Because I found that WordPress.com that&#8217;s one of the top five blocks used, I.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Have not, but now I&#8217;m curious and I. Some of them, I mean you definitely have some, some where it&#8217;s used more than it should be. But I think that we&#8217;ve avoided some of that and some of it is what we&#8217;ve been able to do recently. Right. A few years ago you had to use it if you were going to get any consistency at all across things. But I think sometimes the patterns and the pattern syncing, that type of thing has dramatically reduced the need to use the spacer block, which is great because the speaker, the spacer block is so annoying on mobile.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, that&#8217;s one thing. It&#8217;s also, you cannot rip it out when, when you redesign the site or something like that, it&#8217;s going to be the. In your content.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah. So I mean, I haven&#8217;t seen similar dislike as it sounds of the spacer block, but when you shrink a screen down suddenly you get wildly different vertical spacing on mobile. And for the average person there is not a straightforward way to make it not do that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>You have to know how to write a workaround for yourself to make it work and that&#8217;s not great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So. Yeah, well, yeah, it&#8217;s good to know. So before we head into our usual sections, is there anything else that you would like to tell people who have not yet done the jump into block themes, why they should do it?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think, I think that it is, it&#8217;s a scary jump, and I have always been an early adopter of the new tooling, and so I look at something like that and it freaks me out a little bit. And then I&#8217;m like, well, why not? And I just push myself through and I know that I have the liberty of doing that because I&#8217;ve been working independently for almost 10 years. So I am in a lot of ways in control of what is and is not allowed in my environment. I&#8217;ve talked to a few folks who have. They understand how it&#8217;s working and they, they personally buy in, but their employer does not.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Okay. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>And so for those folks, I think building up your skill set with your personal site or a personal project so that you can advocate for different things internally. It&#8217;s very hard to advocate for something that you haven&#8217;t done and that you don&#8217;t have hands-on experience with. But you know, the ability to spin up a little like MVP demo of, hey, this is how this would solve a problem that we have systemically is really how you sort of gain permission in those sorts of environments. There&#8217;s some really good resources out there on learning how to do this. I think that they are much harder to find than they used to be. When I was first learning how to code, it was much easier to find like beginner entry level stuff, to like level yourself up. And now I think fewer people are creating it and I think it&#8217;s harder to find just because of how it&#8217;s labeled. Everything starts to look the same because it&#8217;s all named the same. But I think giving yourself the challenge to &#8211; even if you don&#8217;t understand everything, listening to a podcast like this, listening to a talk that you&#8217;re finding online, having it playing in the background like it does, seep in to how you think about it. And what will happen is that later you&#8217;ll encounter the same subject again and you&#8217;ll be like, oh, wait, that&#8217;s what they were talking about. And that&#8217;s how you start to connect the dots when you&#8217;re learning anything new. And I think the idea that you&#8217;re going to get somebody who has been building themes the classic way, building themes that are heavily reliant on advanced custom fields, something like that, to just magically one day pick up a whole new set of tools with a whole different way of thinking and be completely comfortable from the get is like ludicrous. That&#8217;s not going to happen.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But, you know, giving yourself the ability to slowly absorb it, because it is a different way of thinking, it&#8217;s a completely different way of thinking about how to structure the theme. And for me, that has been the hardest part to learn. Once I figured it out, it was great. But of course, it&#8217;s always the hardest thing to figure out a new way of thinking. When you say it like that, it&#8217;s so obvious. But I think people really get down on themselves about it. And I think really just paying attention, reaching out to folks, you know, when you have questions, not being shy about it. What I&#8217;ve figured out over the course of the last, I guess we&#8217;re almost at eight years of Gutenberg. Yeah, Gutenberg is a month older than my eldest child. So it&#8217;s very easy for me to keep track of how old it is. But we are in a time period where what I have noticed as an early adopter, when I talk to the other early adopters, everybody is making it up. Everybody is inventing their process, everybody is inventing the “ right way.” We&#8217;re starting to congeal on some common things. But it has been a time of innovation. And so being a little bit afraid to stick your toe in. That is so reasonable. And at the same time, when you think about it that way, it becomes less scary to fail in air quotes. Right. Because ultimately, how many light bulbs did Edison make before one worked? Like, it&#8217;s just, you know, you have to experiment in order to figure out how something works. And I think it is challenging to be mid-career and have to go back to that beginning.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>You know, Yeah, I feel a certain.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Confidence that all of a sudden is going away.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, yeah. So. So I. I just think people need to be a little less hard on themselves, push themselves a little, be okay with failing and talk to people, talk to people. Just keep going, Just keep swimming, as the fish say in Finding Nemo.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. All right, so you&#8217;ve listened here to a very experienced theme developer and yeah, it&#8217;s never going to be easy. You need to start now. What is it, the Chinese proverb to the best time to plant a tree was 20 years ago. The second best time is now. So it&#8217;s kind of exactly for that. Yeah. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p>So, okay, so we have a few announcements. Now we&#8217;re going a little bit into the Gutenberg change log message here. We have a few announcements and they&#8217;re all calls for testing because we get new stuff and. And the testing team is really on top of things. Last week a call for testing was made for the new template management features that are coming to Core, which. have you checked it out, Beth, on what&#8217;s going to come with that? We talked about it here two weeks ago with Anne Katzeff and it&#8217;s the tool where you can now have multiple templates with the same slug and of the theme hierarchy and then activate and deactivate the ones that you want to use or not use. So it kind of puts a new layer in there and gets the user a little bit more in control on how the template management actually works and figure that out in there. Because template management is something WordPress users have never done before because it was always a developer designer kind of scope and there was no user interface for it. And now it&#8217;s here and the confusion is there, but it&#8217;s also something that can be learned and can be helped with.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I think it&#8217;s also going to be great for launching changes to live sites where. And you know how to launch code for Gutenberg is a whole other conversation. But the best practice is to keep your live site database as your database of record. Right. And some of what I see with the new template management changes are enabling you to more easily respect that without having weird, momentary blips of your content looking bizarre while you&#8217;re changing something over on a live site. So I think it&#8217;s going to be, again, another adjustment in how we think about how we work. But ultimately we&#8217;ll offer more granular tooling that will allow for the elimination of some of these use cases that haven&#8217;t always ended up being really strange, where you&#8217;re like, yeah, should we put up a maintenance message while we&#8217;re doing this? Because everything is going to look bizarre for the next 20 minutes. That kind of stuff. I think it&#8217;s going to be good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>It&#8217;s really good. Yeah. Yeah. And the first version is going to be not perfect and probably have some bugs, but that&#8217;s why the call for testing is there. So I leave the link in the show notes for you so you can start testing and share your experience with it and also share what still confuses you or what didn&#8217;t work or where you thought it would work, but it didn&#8217;t. It&#8217;s definitely something &#8211; conversation needs to happen. And if you are not sure what to do, come into the W in the WordPress Slack into the Outreach channel and there are a lot of people there that will help you figure that out. So if you don&#8217;t know if it&#8217;s a bug or you don&#8217;t, you&#8217;re not doing it right. I know that&#8217;s often kind of that with new things. Did I get this right or is it not working? Most people, and I&#8217;m one of them, I default to okay, I&#8217;m not doing this right. What&#8217;s happening? And there are two more console testing. </p>\n\n\n\n<p>One is on the ability to hide blocks, which is kind of the first iteration of a blocks visibility kind of plugin idea that you can hide and show blocks conditionally. Right now it&#8217;s only on and off or hide and show. So you could have a block in the editor, but you hide it on the front end. But because you&#8217;re still working on it or you don&#8217;t want to, you want to put it in there so your editor knows about it, but it&#8217;s not going to be pushed to the show version until a certain date or until a certain sale happens or something like that. The instructions for the call for testing are really good and they also show you with little videos how it&#8217;s supposed to work to kind of offset my am I doing this right or not? Idea. And the other one that I wanted to point out in this podcast is the accordion block calls for testing. That seems to be really settled. Came in 20.5, I think, and had some iterations, especially for those of you who started styling it. You need to double check your references because the name changes in between for the panel and for the items and all that. So call for testing for accordion block and what you can do with it. Have you experimented with the accordion block?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Mm, I&#8217;m really excited about it. This is one of the ones that I&#8217;ve been dreaming of for years. It&#8217;s one of the ones where I had an external plugin where like, the only reason I was using the external plugin was because I needed accordions. The detail block is sort of an approximation, but it&#8217;s not the same semantically speaking. So I&#8217;m excited about this one. This one and Tabs are my two that have been a thorn in my side for years.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I&#8217;m also. Well, we can talk about the other blocks that are supposedly come or at least been worked on for Core, even if they don&#8217;t make it into 6.9 at a later date. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions</h3>\n\n\n\n<p>There&#8217;s this new AI feature out there, it&#8217;s called Telex, which is automatic block building AI. And there are a few designers and developers that have actually done some great experimentations with that. One is Tammy Lister. She has started a challenge, kind of the blocktober, meaning every day in October she will build a new block with Telex. And I&#8217;ll of course share the site in the show notes. She started out with a kind of reaching back into history of computers and started out with an esky Tetris game. And that&#8217;s when my afternoon, uploaded my afternoon was shot because I got addicted to Tetris again. Yeah. Did you do any experimentations with that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Nope. That one, I mean, I know about it, I know about Tammy&#8217;s blocktober. I&#8217;m paying attention, but I don&#8217;t have time to just play with it right now.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, I. I feel the same way. It&#8217;s kind of letting other people do that. I. I look at what other people do. Yeah. And there&#8217;s Marco Ivanovich. He&#8217;s a designer at Automattic. He has some animated icon blocks. They were kind of sparkling and all that. And then he also created a post-it note block where you can put post-its on your site with an image and with a background gradient background. So pretty cool to look at. </p>\n\n\n\n<p>And then there was Jeff Paul from Ten Up. He actually also created a game of Pong Hung block that&#8217;s kind of the tennis kind of back and forth where you need to up. It was just handy as an easy, medium and hard. Yeah, that was another afternoon. I tried to figure it out. Yeah. Juan Margarito, he created a mermaid diagram which is actually a markdown diagram. And then you put the. The diagram code in markdown and then it kind of creates a. A diagram with errors back and forth. Yeah, it&#8217;s kind of a flow diagram if you want to. So that was really interesting to see. Yeah. Anyway, so I just. Yeah, check it out. If you want to play around with it. It&#8217;s telex.automattic.com automatic with double T. The second T. Yeah.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; WordPress 6.8.3</h3>\n\n\n\n<p>Okay. So now we come to the heart of the show, which is what&#8217;s released. And before we head into Gutenberg 20.8, I wanted to let everybody know WordPress 6. 8.3 is out. It&#8217;s a security issue. No, it&#8217;s a security release fixing two security issues. And if you haven&#8217;t updated yet, please do we wait. Go and update. The two issues were mentioned in the release post. One was data exposure issues and the other one issue and the other one was a cross scripting vulnerability for the nav menus which has been fixed and you are in a secure environment again. But don&#8217;t forget to update. Yeah. Any thoughts?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Always update. I&#8217;m. I&#8217;m of the. I&#8217;m of the camp. I always update on the security releases right away and then major releases. I always wait and see what happens.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>How long do you wait? How long do you wait?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I usually wait until a point release has come out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Okay.</p>\n\n\n\n<p><em>Beth Soderberg:</em> That&#8217;s usually the trigger but sometimes it&#8217;s really stable and we&#8217;re like, well there. I guess there&#8217;s no point release and it&#8217;s been three weeks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I do the same thing with updating like my iPhone. Yeah, I don&#8217;t. I&#8217;m. As much as I am interested in technology, I am also somebody who just recently started using mobile deposit for checks. I&#8217;m skeptical.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, I think that makes that an early above to decide where to early adopt and where to be cautious.</p>\n\n\n\n<p><em>Beth Soderberg:</em> That&#8217;s true. Yeah. My risk tolerance is very high for certain things and very low for other things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>And if it changes my work environment that I need to retrain my muscle memory. I&#8217;m opposed to any change, but I recently had to change my Mac updated and they fixed a bug. That&#8217;s the problem with bug fixes. Yeah. If you, if you have for years known about a workaround and the muscle memory is in. You hate that bug fix that fixes that once and for all. So kind of. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Anyway, that&#8217;s a whole other conversation. Moving on.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Thank you. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 21.8</h3>\n\n\n\n<p>So Gutenberg 21.8 is the second last before 6.9 beta. There&#8217;s one more coming, that&#8217;s a 21.9, of course, and that&#8217;s coming on October 17th. So we are recording this on October 8th and next week we have the last Gutenberg release before 6.9 beta comes. Which means bug fixes, yes. New features, no. From that point on forward to get into Core. Gutenberg 21.8 had 118 PRs by 47 contributors and five people were first time contributors. Congratulations, you got your merge done. That&#8217;s fantastic. Because I can see that the first one is always a little tricky getting it past the reviewers. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>For Gutenberg, we start with the enhancements to the block content. Comments. Block comments is a feature that creates a commenting method for each block in your editor so you and others can add comments to your blocks and have an editorial kind of process going. It&#8217;s a a lot of PRs made it into that. But the first one that I wanted to point out is a discussion field with trackbacks and comment status aggregated for the post page Quick Edit. So you know, in the Quick edit, are there commenting places? Quick Edit is not the quick edit in the WP admin. It&#8217;s a quick edit in the design. But that&#8217;s actually not the commenting. The block commenting thing.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Yeah, this is hard to contextualize even looking at the PR, right? Yeah, the PR. I think ultimately it&#8217;s unifying. It&#8217;s again, it&#8217;s one of those things that&#8217;s unifying design across components to make things more consistent no matter where you find them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So when you have the new design view, what was missing that you were able to manage trackbacks and comments. So it&#8217;s not the feature that I just said. It&#8217;s just getting on par with the previous WP admin kind of thing. Especially for pages. The posts haven&#8217;t been included yet in these new designs, but for pages, definitely. And if there&#8217;s a post experiment in Gutenberg where you can have the post view also in the new design view, as the site editor. And that&#8217;s where this actually comes to pass. So that is kind of labeled wrong in that changelog, but that&#8217;s okay. We can handle that. Do you want to do the next one?</p>\n\n\n\n<p><em>Beth Soderberg: </em>Sure. So displaying a message when there is no related block, which is the most logical thing you could do with commentary that has no source attached to it anymore.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Anymore.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Anymore, anymore. Right. So again, it&#8217;s giving context to something so that your actual conversations make sense. And basically what it&#8217;s doing is just adding a little message that says, hey, your original block was deleted so that somebody reading through it understands and also gives you the ability to&#8230;part of why I like this one is because you&#8217;re going to end up with people who in collaborating with each other are going to remove things. And you want to have a record of the conversation for editorial purposes, but understanding what has happened is a key part of creating that record.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So yeah, definitely you want to have a record of the decision making process for certain things. Yeah. The other one that I wanted to point out is that it now shows the dates of the comments in a more human readable part, like 30 minutes ago or two hours ago or three days ago. So you get a little bit more relation to the timestamps of that. I think there was an option to do this, but I&#8217;m not quite sure that you can switch it on and off. But if not. No, it&#8217;s not. It&#8217;s the first. It&#8217;s the first iteration and there are no options.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I think that&#8217;s coming later.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah, but it&#8217;s. It&#8217;s known that there will be something like that needed.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yep. And then the highlighting of the related block. Again, a lot of these changes are improving context indicators and so, you know, this just gives you a clearer sense of what you&#8217;re connecting to and which thing you&#8217;re actually talking about with the comments.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So I&#8217;m just going to look through. If we missed something new, we can now go right into the block library section and there&#8217;s a ton of PRs that actually work on the accordion blocks. That&#8217;s also in the bug fix sections. But I think the most prominent stuff is more like the term description block with the context support. So that if it&#8217;s in a template or in an archive template that the term description block is more. You can use it in patterns like you can do post title and query title for that. Yeah, the term description block is something that&#8217;s a little bit of a… I have seen people that are quite adamant that they need the block editor in the category description section for editing the description because I wanted to make it more there. Design it a little bit or make it a little bit more versatile. That&#8217;s quite interesting because you also can now create a page with all the features that you want on that for a particular category and then just have a query loop on that category displayed on it. So you get around that need to have the term description be a block editor or something like that.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. I had never thought about that before because theoretically you always could do the latter. Right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>But you had to have a certain level of technical skill and knowledge to do that. The idea of adding block support to that description opens up possibilities for folks who are not as technical to make modifications in that presentation of the. The term pages. I don&#8217;t know. I could go either way there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I could also create massive. I can see this going very wrong.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. I think that&#8217;s why nobody touched it for now.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That&#8217;s a new concept to me. But I don&#8217;t know. My gut says no.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So. And then we get a new block. It&#8217;s the time to read block. And now it has been in the Guternberg plugin for ages. Similar to the table of content block. But they were to get it into core. There were always kind of missing things or quirkinesses that weren&#8217;t dealt with. And the time to read had massive accessibility objections because it only had one time that it takes to read a block. Not everybody has that reading skill or is on that level like a lot of people are. English as a second language. They don&#8217;t. They don&#8217;t read so fast or dyslexia is pretty. Yeah. It&#8217;s out there. And they don&#8217;t read that fast. And so it kind of makes them feel bad about not reading in that 15 minutes kind of thing. What they&#8217;re doing now is kind of offering a range option. It says it takes one to five minutes or something like that. And which I feel is kind of even for someone who is fast reading but tired is a good indicator. Yeah. That&#8217;s how long it&#8217;s going to actually take. And then they added also a word count to it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, I like that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. When there are word count plugins out there. Word count blocks, plugins out there say that 15 times fast. But I think having a core block that actually offers it option is really cool.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I&#8217;m sorry I didn&#8217;t bold that, but I wanted to talk about it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>No, I agree. I think it&#8217;s. It&#8217;s a kinder way to deal with the problem because you&#8217;re giving people enough information to very quickly self assess without shaming them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So the next one is part of the Data Views section actually. It&#8217;s the data forms package. And there&#8217;s now support for certain form elements validation in the data forms package. So if you use that as a plugin or your settings pages. You now get help from the packages that drive that. I think that&#8217;s a. Yeah, it&#8217;s an enhancement for extensibility, for sure.</p>\n\n\n\n<p><em>Beth Soderberg:</em> In the block editor section, block multi selection, disabling transforms and inspector controls.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. That&#8217;s an interesting one. So when you select multiple blocks, you still get the. Sometimes the options that you can transform them. And for paragraphs, a series of paragraphs. I like it. Because then you have. You can transform them to list views. But if you have a mixture of selected blocks, you don&#8217;t need transforms or inspectors back the controls. You just probably want to move it or move the selection. Yeah. So I think it&#8217;s a good way to not confuse people.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Right. And that&#8217;s a good example of a tiny change from an end user perspective that probably won&#8217;t be noticed, but will reduce friction for people. All right. In global styling, adding a reset button to our background controls panel. Hooray.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Hooray. You don&#8217;t have to unselect stuff. Yeah. Just click on things and you make it all go away. It&#8217;s pretty cool. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> And then making the additional CSS UI less prominent, which is great because the less random CSS everywhere, the better.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yes. And. Well, it&#8217;s. I totally agree with that. And that&#8217;s also the. The justification why they want to put it some. So they&#8217;re going to hide it. Again, it was hidden on the left hand side of the global styles or styles panel. You always could edit it on the right hand side when the styles panel where sooner or later we probably need to decide if we want to use the left hand side or the right hand side for the styles features. But it now is going to be in the ellipse menu in the header of the styles section. So it says add additional CSS as a menu item on top. So. So you are not going to be. Well, it was there and then it wasn&#8217;t there. So where is it kind of thing situation. It ended up in the ellipse menu on top of the screen.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Block bindings. I love block bindings.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. There&#8217;s an experimental feature there.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>To support block attributes from the server side. I haven&#8217;t completely read through it. I&#8217;m not quite sure I understand that. So I would need to go back to the developers and say what&#8217;s the use case and why you&#8217;re doing it kind of thing.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>I think. Did you get something?</p>\n\n\n\n<p><em>Beth Soderberg:</em> I would have to clarify, but my understanding of it is the big thing with block bindings is like which things are supported and which things aren&#8217;t supported and how that is communicated is improved from doing this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Doing it service sort of the nugget.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Of truth there. But I think anything like that. I know it&#8217;s experimental but making block bindings easier and more accessible for people to use anything that helps. That is a good thing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I think there are two areas where they come from. One is to make block bindings available for more than 14 blocks which has been the case until now. That&#8217;s one thing. But also to increase extensibility and use have not only blocks use the block bindings but also whole features use the block bindings for external things like the remote block plugin by WordPress VIP USO. Yeah. They also use block bindings to identify the data that comes in and put it into the block editor. But I think it&#8217;s hard to bring the server side and the client side together with the same information. And this one will have the server side be the moment of truth. No, the source of truth for block bindings. Yeah, it&#8217;s definitely a late edition. I&#8217;m not sure it&#8217;s going to make it to 6.9. I&#8217;m skeptical though. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. Right. Right. Mode Try adding content roles to navigation blocks is the name of the PR which I think is delightfully named and I. Even the way that this is written is pretty great. I wanted to see how far we can go with just adding content roles to nav link in some menu blocks given the improvements to content only logic we&#8217;ve had. And then it references another pr. The next sentence is I think it&#8217;s working better now. Whoever this contributor is, I love your writing. Tell the machines.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, that&#8217;s.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Fun times. But I think it&#8217;ll.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Isabelle Bryson. Yeah, she&#8217;s been on the podcast before and she&#8217;s actually worked also on the grid layouts and yeah, she works for Automattic on the team. And the other I think the tri part is okay. We experiment with things. So that&#8217;s when it says try and then there&#8217;s also add is kind of definitely need to fix this or add this feature or fix means fix this bug. Yeah. So they have these prefixes on their PRs and the try thing is. Yeah, let&#8217;s try it out and see what happens. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah. But this one, it looks cool. People should check it out. Components. The text area component. Adding a default resize vertical rule just to make things more make sense visually so that you can move stuff around the way you need to.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And you can control the vertical size of things. That&#8217;s always a good thing. And then the other component PR is actually adding storybook examples for the fields package. So there&#8217;s more documentation there for the plugin developers who want to use it. Also of course, for the core developers who are going to use the Fields.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Package for their work patterns, we have a change to the block inspector adding a content tab for section blocks that displays content only descendant blocks. So similar to the existing styles tab, but for content.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And it&#8217;s up until now it lists the blocks that can be edited in a section pattern or in a content only block. But that&#8217;s all part of the write mode, and we will see how which part of it actually will come into 6.9. But I think it&#8217;s very helpful for content creators who use a pattern to just see the pieces that you can edit and not be confused with any styling of that, even if it&#8217;s only the section styles. And from the PR before and after, you can see that the little drop water drop that&#8217;s in the block toolbar actually gives you a way to browse through the styles for this particular section. So it&#8217;s not taking anything away, it&#8217;s just kind of making it clear where the things the information is going to be for you. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I think for anyone who might be confused about what we&#8217;re talking about, look at the pr. The screenshots will help you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. It&#8217;s a little bit. Sometimes it&#8217;s a little bit hard on the podcast to make things come to life on a. In a visual component.</p>\n\n\n\n<p><em>Beth Soderberg: </em>The screenshots make it make sense if you&#8217;re confused by what we just said.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And the PR we&#8217;re talking about is 71714. The next one is an easy one, but it&#8217;s definitely something to talk about for Black Friday and all the WooCommerce stuff. There is now a WordPress gift icon available for content creators and developers. So you can use that. It comes from a WooCommerce team, but they contributed to Core so anybody can use it. </p>\n\n\n\n<h3 class=\"wp-block-heading\">New API</h3>\n\n\n\n<p>The next thing I want to point out was the block API has now the block visibility, control support and the ui. That&#8217;s the part where the underlying architecture for the hide and show of blocks I think it is. And that also is the foundation for when you. Later on we will have the conditional Hide and seek. No hide and show. Yeah. When you want to say okay, I want it for logged in users or not. I want it for people who come from Twitter or not. These kinds of conditionals, they&#8217;re not yet in there. For that you still need the block visibility plugin by Nick Diego. So I think we have one more. No. Yeah, there&#8217;s an accordion block also in write mode. We hide the add button in write mode so you can add an additional accordion block in write mode. But I&#8217;m not quite sure that&#8217;s particularly helpful for a content creator. But time will tell.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Yeah, that could go either way.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s a 5050 kind of thing. You do it right for 50 people and the others are going to hate you for that. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Bug Fix</h3>\n\n\n\n<p>And then one bug fix I wanted to point out there is a bug in the pattern override. Some users might have found it is that editing was allowed on non-enabled override blocks which kind of defeated the purpose, but it&#8217;s now fixed. So there&#8217;s another experiment. I don&#8217;t know how that comes about, but the PR definitely has some interesting conversations. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Experiments</h3>\n\n\n\n<p>There is allow registering PHP only blocks. What do you say for that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>I say I think this is gonna be, this is gonna be so much bigger than it sounds.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yes.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because basically what you&#8217;re doing is you&#8217;re enabling developers to create blocks using only PHP. So you&#8217;re opening up the can of worms about who knows PHP and who knows JavaScript and are we gatekeeping by moving everything to JavaScript and blah blah.</p>\n\n\n\n<p>But then you&#8217;re also changing the structure in a way that might make things less portable between projects. So I don&#8217;t know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, it&#8217;s definitely an experiment.</p>\n\n\n\n<p><em>Beth Soderberg: </em>That&#8217;s true. I think, you know, and I. One of the things I have noticed, there is a developer on my team that I have been mentoring for years and really started learning WordPress specifically post Gutenberg. And what&#8217;s fascinating about watching her is that she struggles with some of the traditional ways of doing things, but can do them the new way. Right. So for somebody like that this might be terrible, you know, and I. It just becomes a context thing about what you know and how you&#8217;ve been progressing with different skills along the way if you&#8217;ve completely forgotten PHP or you know, various things. So I, I don&#8217;t know, I think this, this one is going to be a much bigger deal than I think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I think so too. And there will be restrictions to that and I think the documentation will show that because it actually uses something the server side render component that actually was not considered best practice to use until now and the registration of PHP only blocks will actually use the server render component. So I think there is also something a little bit of a movement in the core contributing ranks about that. And it definitely needs some more. Yeah. Experimenting with it and exploration and. But it&#8217;s in there. One listened and maybe there&#8217;s something that can be pushed to the finish line outside the experiments. All the developers out there who were waiting for something like this go have at it.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Oh. Interesting to see what people do.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, me too. And I added a. The label needs developer documentation and a project manager on the team also removed it because it&#8217;s experimental. So the developers that created it have some leeway in backwards compatibility. And it&#8217;s experimental. It means it&#8217;s not documented. You cannot build on it. You need to be part of the experiment spirit about it to use it and not rely on it. That it&#8217;s going to be working like that for the foreseeable future. So yeah. It&#8217;s also that caveat on it. Just wanted to point it out.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I just saw that that&#8217;s important because you&#8217;re going to have somebody who goes off and builds a whole new thing on it and then in two weeks it&#8217;ll break.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Which. Yeah. Any plugin developer that built plugins for Gutenberg has been doing kind of living through that for multiple years now. Yeah. So. But that&#8217;s 21.8 release with quite a few new features and the final release will be today on October 10th. </p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in Active Development or Discussed</h3>\n\n\n\n<p>And now we are coming to the section where we talk a little bit about what&#8217;s in development and discuss. And there are new blocks in the works and we know this because Matthias has. Matthias Ventura has published that discussion about new blocks that were previously thought about plug into territory. And now quite a few theme developers think that they are held back with their designs if there are not more additional blocks in core because then now they can style it in their themes and make it available on templates and all that. So Justin Tadlock also did an opinion piece on the Gutenberg Times for it about four weeks ago. I can link it again in the show notes. But we are getting new blocks and the ones that have been merged they&#8217;re not entirely out of experiments yet. Time to read. And we talked about it because it just was merged. We also talked about the accordion block that was merged a while ago and still in experiments. But there are two. Oh, we also talked about the terms query block that has been merged but we haven&#8217;t talked about the breadcrumbs block. And I&#8217;m really excited about that because it felt such a need in the template area that people are getting so confused where am I? And I have a better map and I have breadcrumbs and all that. Yeah, it&#8217;s such a useful tool and I&#8217;m looking forward to get that tested. And yeah, watch out on the test team. They&#8217;re putting some more calls for testing together to get this all in the hands of people who want to help with making it better.</p>\n\n\n\n<p><em>Beth Soderberg: </em>I&#8217;m excited about the breadcrumbs block too. That&#8217;s another one where I&#8217;ve had to do sort of weird things to make things work over time and it&#8217;s going to be nice to not have to do the weird things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I was using Justin Tadock&#8217;s breadcrumbs block that he developed and he had some thoughts in this VR on how broad or restricted this new. This first version is going to be. And I think we all going to like it because depending on the context you can get additional. The breadcrumbs will change. And I really like that.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Yeah, I&#8217;ve. I&#8217;ve used his plugin too. I forget which one it was. There&#8217;s a few independent plugins for breadcrumbs and my team has run into some weird edge cases of what they will do depending on your content structure. So I think that&#8217;s part of why the scope of the breadcrumbs block being limited at first makes so much sense, because the complexity of what you&#8217;re actually trying to do from a templating level, depending on where you are in a site and how your site is structured can get incredibly complex. I don&#8217;t remember which plugin it was, but we had a site. It may have been the Voter Guide. The Voter Guide within the site that completely killed everything. Like something about the logic of where we were just. And we had to use a different plugin just for that one site to make it work.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> I might have even re. Ended up doing something sort of manual instead. I don&#8217;t remember. But those plugins have been incredibly useful, but are also prone to edge case weirdness. Basically generating navigation on the fly. And if you don&#8217;t know where you are within the structure of the site from a structural standpoint, or if someone has made some odd decisions about where they&#8217;re putting things or how their hierarchy works, you&#8217;re going to end up with a really confusing breadcrumb.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. And sometimes you don&#8217;t have the controls to actually make changes. It&#8217;s just all this black box kind of mystery mute kind of thing again. Yeah, yeah. And I. While we&#8217;re running a little bit out of time or short on time, I just wanted to mention there&#8217;s also a dialogue block in the works. There&#8217;s an icon block in the works. My favorite one is the stretchy text. It sounds so weird, but it actually makes sense. It&#8217;s text that stretches over a certain container and it&#8217;s flexible depending on how the container works. So you could do this for hero sections, all that. And then here&#8217;s your bestest favorite. The tabs block is in the works. And then also my favorite is a table of contents block. Because I have these long posts all the time and I want to do the table of contents block. But it had some weird issues. That&#8217;s why it&#8217;s not in Core yet. And they&#8217;re trying to figure that out how that all can be done. It&#8217;s now attempted to be a dynamic one and allow usage outside of the post or page that is actually referring to. But for instance, in a template, you could put it in a single post template in the sidebar and you will always have a table of content for your posts. So I think that&#8217;s a really good use case for pages, when you have landing pages or tutorial pages or documentation pages that you don&#8217;t have to fiddle with it while you&#8217;re creating the content. And it&#8217;s just there in the template.</p>\n\n\n\n<p><em>Beth Soderberg: </em>This is one where my weird workaround for it. There&#8217;s one of the SEO plugins has a table of contents block built into it. I forget which one offhand, but I&#8217;ve used that before to get this type of functionality.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Beth Soderberg: </em>Because it. Sometimes you really just need it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, absolutely. Yeah. Yeah. </p>\n\n\n\n<p>So that&#8217;s it. That is the Gutenberg changelog 122. Thank you so much for being with me on this, Beth. And it was great to chat with you and talk about block themes and all these good things. Block style stuff. Yeah.</p>\n\n\n\n<p><em>Beth Soderberg:</em> Thanks for having me. It was fun.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Dear listeners, as always, the show notes will be published on the <a href=\"http://gutenbergtimes.com/podcast\">gutenbergtimes.com/podcast</a>. This is 122. I already said that. But if you have questions or suggestions or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> that&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a> and I forgot a question for you, Beth. And that is if people want to get in touch with you, what is a good place to do that?</p>\n\n\n\n<p><em>Beth Soderberg: </em>You can find me in the WordPress slack under my name, Beth Soderberg. And then you can find me at work at our website, which is Bethink.studio or bethinkstudio.com. but you know, it&#8217;s really fun when you can get the non.coms to work with your name.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So. Yes, all right. So I&#8217;ll list of course, all those contact information, more in the show notes.</p>\n\n\n\n<p>And thank you all for listening. Thank you for being here and see you when I&#8217;ll see you back. Well, in two weeks. Goodbye, and have a good time. </p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 12 Oct 2025 10:58:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Matt: In Canada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150205\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/10/in-canada/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:731:\"<p>I&#8217;ve been trying to find time in my calendar to attend more WordCamps as I love meeting <a href=\"https://ma.tt/2025/09/wordpresser/\">WordPressers</a> all over the world. The stars aligned, and I&#8217;ll be swinging by <a href=\"https://canada.wordcamp.org/2025/\">WordCamp Canada</a> next week. They&#8217;ve put together an amazing program, including open web pioneer and inventor Dave Winer, so I&#8217;m looking forward to checking out the sessions. I wish I could go to every WordCamp, like I used to! I&#8217;ve been recording videos and messages for those I can&#8217;t physically attend. Ottawa is also great as the only other commercial board I&#8217;m on is <a href=\"https://fieldeffect.com/\">Field Effect</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Oct 2025 15:35:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Twitter Hacked\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150193\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/twitter-hacked/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:662:\"<p>Sorry everybody, my @photomatt on Twitter has been hacked, I&#8217;m trying to regain account access, but it is not currently in my control. <strong>Update: </strong>Thank you to the fine teams at X/Twitter and <a href=\"https://x.com/nikitabier\">Nikita Bier</a>, my account has been recovered. Just for future reference, I will never promote cryptocurrencies or similar investments. If you see anything from me or WordPress claiming that, be highly skeptical. Invest in open source, public stocks, and great companies like Automattic. <img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f642.png\" style=\"height: 1em;\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Oct 2025 00:34:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"Gutenberg Times: Mega Menus in core, WordPress 6.9 calls for testing, going from Elementor to Site Editor — Weekend Edition 344\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=42168\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:23201:\"<p>Howdy,</p>\n\n\n\n<p>After meeting so many people at WordCamp Gdynia, on the plane and then on the train, I caught a nasty cold and struggled all week. I call this stage mushbrain, and everything becomes much harder, especially reading comprehension suffers. I am over it now, though. It also wasn&#8217;t the first time that I sounded horsey on a podcast episode. </p>\n\n\n\n<p>It&#8217;s the time of year now here in Munich when the days get shorter and the weather is cold, drissly and overcast. A time when snow would brighten the sights, with its whiteness covering partly the darkgray, dark brown background. </p>\n\n\n\n<p>Enjoy again  this weekend edition  and stay healthy. </p>\n\n\n\n<p>Yours, <img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#help-testing-new-features-for-wordpress-6-9\">Help testing new features for WordPress 6.9</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/mega-menus-in-core-wordpress-6-9-calls-for-testing-going-from-elementor-to-site-editor-weekend-edition-344/#what-s-new-in-and-around-playground\">What&#8217;s new in and around Playground</a></li></ol></li></ol></nav>\n</div></div>\n</section>\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Gutenberg 21.8 is now available and release lead <strong>Carlos Bravo</strong> hightlighed in his release post <a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/\"><strong>What’s new in Gutenberg 21.8? (8 October)</strong></a></p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#block-visibility-support-ui\">Block Visibility Control Support and UI</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#block-comments-improvements\">Block Comments Improvements</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/10/08/whats-new-in-gutenberg-21-8-08-october/#accordion-time-to-read\">Accordion and Time To Read Blocks</a></li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>This week <strong>Gutenberg Changelog 122</strong> recording, <strong>Beth Soderberg</strong>, lead developer at <a href=\"https://bethink.studio/\">Bethink.studio</a> and I chatted about the release and other WordPress topics around Block themes and on going change. The episode arrive at your favorite podcast app over the weekend. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"?\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-122-gutenberg-21-8-and-wordpress-6-9/\">Gutenberg Changelog #122 – Gutenberg 21.8 and WordPress 6.9</a> with Beth Soderberg of <a href=\"https://bethink.studio/\">Bethink Studio</a></p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Gutenberg Changelog 122 with Beth Soderberg\" class=\"wp-image-42236\" height=\"193\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-11-at-12.32.48.png?resize=652%2C193&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>If you are listening via Spotify, please leave a comment. If you listen via other podcast apps, please leave a review. It&#8217;ll help with the distribution.</em></p>\n</div></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>It was <strong>JuanMa Garrido</strong>&#8216;s turn to write the monthly roundup post <a href=\"https://developer.wordpress.org/news/2025/10/whats-new-for-developers-october-2025/\"><strong>What’s new for developers? (October 2025)</strong></a> on the WordPress Developer Blog. The 21.6, 21.7, and 21.8 Gutenberg releases add features for developers. The Command Palette now works throughout the admin, the new Terms Query block makes taxonomy layouts easier, and Block Visibility controls allow for conditional display. Notes (that&#8217;s how we call Block Comments now) improve team collaboration, while content-only editing maintains design integrity during client handoffs.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"help-testing-new-features-for-wordpress-6-9\">Help testing new features for WordPress 6.9</h3>\n\n\n\n<p>Release test co-leads <strong>Krupa Nanda</strong> and <strong>Jonathan Bossenger</strong>, published several calls for testing in preparation in WordPress of the 6.9 release. Each of the post has a detailed description of the feature, and instructions on how to test is with specific scenarios. It&#8217;s much easier to follow along with any of the calls for testing, to also learn what&#8217;s new in the next release. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/03/help-test-changes-to-template-management/\"><strong>Help test changes to template management</strong></a> is probably the most elaborate call for testing, as template management received a completely new feature, and it needs to be working for many different use cases, and has consquences on existing sites.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/04/call-for-testing-ability-to-hide-blocks/\"><strong>Call for Testing: Ability to Hide Blocks</strong></a> for this feature it&#8217;s the bare minimum of a new feature, that will be in future releases see some refinement and extensiblity. </p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2025/10/06/call-for-testing-accordion-block/\"><strong>Call for Testing: Accordion Block</strong></a> lets you dive into a whole new block, many users asked for an several plugins are already available for. Now it will come to core. </p>\n\n\n\n<p>Your time spent on testing the new features for WordPress 6.9, has a lot of impact, as the bugs found now, make the release the best it can be for millions of other users. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Lesley Sim</strong> informed us that <a href=\"https://wordpress.org/plugins/eventkoi-lite/\"><strong>EventKoi Lite</strong></a> is now available from the WordPress Plugin Repository. I mentioned the premium version before, Event Koi is modern, WordPress events calendar. Create single or multi-day events and display month, week, or list views via blocks (or shortcodes).</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Mike McAlister </strong>announced a new product: <strong>OlliePro Extensions</strong> on Bluesky. He mentions: Animations, advanced grid + column controls, keyboard shortcuts, and more. Watch the vidoe <a href=\"https://www.youtube.com/watch?v=qq2DLc43pTk\"><strong>Introducing Ollie Pro Extensions &#8211; Supercharge Your WordPress Block Editor</strong></a></p>\n\n\n\n<p>All controls are seamlessly integrated with the Core editor sitebar sections. <strong>Mark Howells-Mead</strong> <a href=\"https://wordpress.slack.com/archives/C015GUFFC00/p1760046957248569\">commented</a> in the WordPress Slack #outreach channel: &#8221; I’m very impressed with how he’s been able to integrate the little add-ons many of us are integrating to our own projects, but in such a seamless way by extending core controls.&#8221;  McAlister shared an <a href=\"https://gist.github.com/mikemcalister/937664ea19e87d61add7fc9902f10ac9\">example Gist on GitHub</a>.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>David McCan</strong> took a deep dive into the world of Block plugins. In this blog post   <a href=\"https://dynamicwp.co/performance-of-third-party-blocks-and-core-compared/\"><strong>Performance of Third Party Blocks and Core Compared</strong></a> he tries to answer the questions many site builders and owners have: &#8220;Can you add the features Gutenberg is missing yet still be performant like core?&#8221;. McCan tested ten third-party Gutenberg block plugins with WordPress core, specifically focusing on performance.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Matt Medeiros</strong>, WPMinute, took the <em>Mega Menu Designer</em>, also made  by Mike McAlister, out for the spin. He shared his thoughts in the Video <a href=\"https://www.youtube.com/watch?v=7NYskePLDM0#feedback\"><strong>How to Build Mega Menus with WordPress Blocks</strong></a>. He provides a detailed walkthrough calls it &#8220;Perfect for anyone looking to enhance their website&#8217;s navigation experience.&#8221; As reported earlier <a href=\"https://wordpress.org/plugins/ollie-menu-designer/\">the plugin is available for free</a> in the WordPress plugin repository. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<p><strong>Rae Morey</strong>, publisher or The Repository, reported <strong><a href=\"https://www.therepository.email/ollies-menu-designer-flagged-for-core-with-automattic-developers-set-to-help-shepherd-it?utm_source=mailpoet&amp;utm_medium=email&amp;utm_source_platform=mailpoet&amp;utm_campaign=issue-276\">Ollie&#8217;s Menu Designer Flagged for Core, With Automattic Developers Set to Help Shepherd It</a></strong>. Automattic&#8217;s Anne McCarthy says developers are preparing to review Ollie&#8217;s Menu Designer for inclusion in the Gutenberg plugin, marking the start of a collaborative push to bring the plugin&#8217;s features into WordPress. This follows WordPress co-founder Matt Mullenweg&#8217;s suggestion that the menu functionality should be part of core. Details and links in Moery&#8217;s article. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>This episode of <em>Greyd Conversations</em> show, <strong><a href=\"https://www.youtube.com/watch?v=cRM4FjR_UbE\">Switching to FSE from a pagebuilder</a>, </strong>covers the story of <em>Buro Staal</em>, a smal dutch agency, which switched from Elementor to Full site editing cold turkey. Greyd&#8217;s host <strong>Sandra Kurze</strong> and agency owner <strong>Rosanne van Staalduinen</strong> shared why and how her agency switched and the lessons learned along the way. </p>\n\n\n\n<p>The biggest hurdles were limited functionality of navigation block, not able to create Mega Menus, and the need for controls for mobile sites and responsiveness. So they augmented their tech stack with Kadence Blocks and Ollie Pro theme. </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><strong>Ryan Welcher</strong> published another recipe from his Blockdevelopment Cook Book on YouTube.  <strong><a href=\"https://www.youtube.com/watch?v=dJ4gUrxTgjM\">How To Make A Simple Fade In Effect Fast</a></strong>. &#8220;In this recipe, we’re adding a little flair by loading custom JavaScript and CSS for the Cover and Image blocks to create a smooth fade-in effect as they scroll into view. To keep things efficient, we’ll only enqueue these files when the blocks are actually on the page.&#8221; </p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<h3 class=\"wp-block-heading\" id=\"what-s-new-in-and-around-playground\">What&#8217;s new in and around Playground</h3>\n\n\n\n<p><strong>Nick Diego</strong> announces that <a href=\"https://wordpress.com/blog/2025/10/08/introducing-blueprints-in-wordpress-studio-1-6-0/\"><strong>WordPress Studio version 1.6.0</strong></a> now supports Blueprints, which are lightweight JSON files that predefine site configurations for quick and consistent setup. Instead of starting with empty sites or using large snapshots, teams can create portable recipes specifying WordPress versions, plugins, and settings. Studio offers three featured blueprints for quick starts, development, and commerce, while users can also upload custom blueprints. The feature integrates into the standard site creation flow and helps streamline workflows for solo developers and teams alike.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://wordpress.github.io/wordpress-playground/\"><strong>Playground documentation</strong></a> now has Ask AI button, to get help finding and understanding feature sets and APIs.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.github.io/wordpress-playground/\"><img alt=\"\" class=\"wp-image-42203\" height=\"339\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/10/Screenshot-2025-10-09-at-18.50.23.png?resize=652%2C339&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ajit Bohra</strong> of Lubus <a href=\"https://x.com/ajitbohra/status/1975920964266258538\">shared on X</a> &#8220;The Visual BluePrint Builder for Playground is shaping up nicely. All the latest updates are in, and it’s feeling solid. Stable version coming soon, but you can already check it out and start building visually.&#8221; A blueprint builder with blocks, how nice.  You can test it via <a href=\"https://playground.wordpress.net/?blueprint-url=https%3A%2F%2Fraw.githubusercontent.com%2FlubusIN%2Fvisual-blueprint-builder%2Fplayground%2F_playground%2Fblueprint-github.json\">this Playground link</a>. The code is available on <a href=\"https://github.com/lubusIN/visual-blueprint-builder\">GitHub</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jamie Marsland</strong> also tries to make it easier to create blueprints for Playground sites and open up the WordPress in a browser tool for a broader audience. Details in his post <a href=\"https://www.pootlepress.com/2025/10/introducing-pootle-playground-my-experimental-wordpress-blueprint-builder/\" rel=\"noreferrer noopener\" target=\"_blank\"><strong>Introducing Pootle Playground — My Experimental WordPress Blueprint Builder</strong></a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Adam Zielinski</strong> created an <a href=\"https://playground.wordpress.net/php-playground.html\"><strong>online PHP code editor</strong></a> using Playground. It allows developers to test PHP snippets quickly in their browser. The tool supports WordPress functions, enables switching between PHP and WordPress versions, and allows sharing code configurations through links. Built with WordPress Playground, it runs entirely client-side with network access and popular PHP extensions included. He&#8217;s currently experimenting with adding CLI and file browser capabilities to support composer packages and frameworks like Laravel or Symfony.</p>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Free colorful building blocks image by <a href=\"https://www.rawpixel.com/image/5906195/photo-image-public-domain-free-game\">Rawpixel </a></p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 23:35:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Matt: Jeremy Kranz and Sentinel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150173\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/jeremy-kranz/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2487:\"<p>I&#8217;d like to introduce you to <a href=\"https://www.linkedin.com/in/jeremykranz/\">Jeremy Kranz</a>. With his career as an investor at <a href=\"https://www.intelcapital.com/\">Intel Capital</a>, then <a href=\"https://en.wikipedia.org/wiki/GIC_(sovereign_wealth_fund)\">GIC</a>, which is the sovereign wealth fund of Singapore rumored to manage over $700B, to now running his own fund <a href=\"https://www.sentinelglobal.xyz/\">Sentinel Global</a>, he has had a front-row seat to investments in industry changing companies such as ByteDance (which became TikTok), Alibaba, Uber, DoorDash, Zoom, DJI (which changed the drone industry and argubly modern warfare), and many more I&#8217;m probably not even aware of.</p>\n\n\n\n<p>When I first met Jeremy in 2014, I was amazed that a late-stage financial investor could understand Open Source so well, and he immediately grokked what <a href=\"https://automattic.com/\">Automattic</a> was doing in a way that I think has little parallel in the world. (Today, it reminds me of Joseph Jacks at <a href=\"https://oss.capital/\">OSS Capital</a>.) <a href=\"https://www.insightpartners.com/team/deven-parekh/\">Deven Perekh of Insight Partners</a> led Automattic&#8217;s 1.16B valuation Series C round, making us one of only forty &#8220;unicorns&#8221; (private companies valued over a billion dollars) at the time, and one of the reasons they beat out others as the lead of the round was that GIC/Jeremy was a LP of Insight so they could directly co-invest. GIC is so intensely private <a href=\"https://ma.tt/2014/05/new-funding-for-automattic/\">I couldn&#8217;t even mention them in the announcement at the time</a> even though they were the catalyst for the round.  Since then, Jeremy has become a close friend and advisor, and he even took me to <a href=\"https://www.nugs.net/live-download-of-dead-and-company-dos-equis-pavilion-dallas-tx-10-14-2021-mp3-flac-or-online-music-streaming/26749.html\">my first Grateful Dead concert</a>.</p>\n\n\n\n<p>Eleven years later, this is his first podcast! Jeremy shares incredible <a href=\"https://www.investopedia.com/terms/a/alpha.asp\">alpha</a> around China, AI and its adoption in the enterprise, how asset allocation is evolving, and at the end, a beautiful tie together of the Grateful Dead and Open Source.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 19:30:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Kathy Sierra\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150166\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/kathy-sierra/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:774:\"<p>I was reminded today of the profound marketing influence of <a href=\"https://en.wikipedia.org/wiki/Kathy_Sierra\">Kathy Sierra</a>, who was a pretty prolific blogger and speaker back in the day. I would summarize her thesis as such: <strong>Your best marketing and communication should talk about how you make your users awesome, not how you&#8217;re awesome</strong>. If you&#8217;d like to check out some of her talks, <a href=\"https://href.li/?https://wordpress.tv/2008/10/31/wordcamp-sf-2008-kathy-sierra-kicking-ass-and-creating-passionate-users/\">she spoke at WordCamp in 2008</a>, <a href=\"https://vimeo.com/81625882?fl=pl&amp;fe=ti\">at Business of Software in 2013</a>, and at <a href=\"https://www.youtube.com/watch?v=iBtcGwHPMKM\">Mind the Product in 2015</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Oct 2025 01:22:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Open Channels FM: Bootstrapping a Successful WordPress Business Through Customer Feedback and Iteration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110936\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://openchannels.fm/bootstrapping-a-successful-wordpress-business-through-customer-feedback-and-iteration/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:218:\"In this episode, Mark chats with Aurelio Volle from WPUmbrella about his journey in creating a WordPress management tool, maintaining customer focus, and the importance of community and transparency in business growth.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Oct 2025 10:47:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Matt: Battery Scan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/10/battery-scan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1067:\"<p>One of the cooler companies I&#8217;ve seen in a while is <a href=\"https://www.lumafield.com/\">LumaField</a>, which does industrial CT scanning, as they describe it.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Industrial X-ray CT (Computed Tomography) works on the same basic principle as medical CT, taking hundreds of X-ray images from different angles to capture the internal and external structure of objects in three dimensions.</p>\n</blockquote>\n\n\n\n<p>In addition to providing amazing graphics of these scans, they also gather some valuable data. <a href=\"https://www.lumafield.com/battery-report\">Their Lumafield Battery Quality Report does a deep dive into lithium ion battery manufacturing</a>, showing the wild differences between different brands. </p>\n\n\n\n<p>I love this stuff, whether you call it QA, evals, testing, or whatever, it reminds me of <a href=\"https://www.principles.com/principles/8b086563-5bb4-4741-8713-c62bd1a0d749/\">Ray Dalio&#8217;s Principle to embrace reality and deal with it</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Oct 2025 06:24:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: #188 – Bud Kraus on Teaching and Using WordPress With Low Vision\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=199897\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/podcast/188-bud-kraus-on-teaching-and-using-wordpress-with-low-vision\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39989:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case teaching and using WordPress with low vision.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Bud Kraus. Bud was diagnosed with mascular degeneration, a condition often associated with old age, when he was 37. Affecting both eyes, this gradually eroded his central vision, making it difficult for him to see straight ahead, recognize faces, drive or read.</p>\n\n\n\n<p>Despite these challenges, Bud&#8217;s peripheral vision remained intact, sparing him the need for a cane or guide dog, and allowing him to continue to navigate daily life. Through perseverance and adaptation, Bud continues to live fully, facing the hurdles of vision loss with resilience and optimism.</p>\n\n\n\n<p>Bud opens up the podcast by talking about his experience living with legal blindness, how his central vision loss has shaped everything from everyday activities to his professional routines. He explains the practical ways he adapts his devices and workflow, including tweaks to operating system settings, using screen zoom functions, and relying on pattern recognition to teach coding, write tutorials, and even host his Seriously, Bud? podcast. His unique perspective sheds light on the often overlooked nuances of accessibility, reminding us that every user interacts with technology differently.</p>\n\n\n\n<p>Bud also chats about the broader impact of accessibility in the WordPress space, from frustrations with hard to navigate interfaces, to the importance of not excluding users who may become your audience or customers. His reflections reveal how living with low vision pushed him beyond mere acceptance, helping him discover new opportunities, hone his teaching skills, and even find humour in daily challenges.</p>\n\n\n\n<p>Bud&#8217;s story serves as a powerful reminder of the importance of designing with empathy, embracing adaptation, and viewing accessibility, not just as a technical requirement, but as a source of creativity and connection. It&#8217;s full of real world tips, personal anecdotes, and a dose of inspiration.</p>\n\n\n\n<p>Whether you&#8217;re a designer, developer, educator, or simply passionate about building a more inclusive web, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Bud Kraus.</p>\n\n\n\n<p>I am joined on the podcast by Bud Kraus. Hello, Bud.</p>\n\n\n\n<p>[00:03:35] <strong>Bud Kraus:</strong> Hello, Nathan. Thanks for having me.</p>\n\n\n\n<p>[00:03:37] <strong>Nathan Wrigley:</strong> Yeah, you&#8217;re very welcome. This is not the first time we&#8217;ve spoken, but it is the first time we&#8217;ve spoken at an event because we&#8217;re both at WordCamp US in Portland, it&#8217;s 2025. We&#8217;re in a corridor, so I&#8217;ve got to say at the very outset, if it ends up being quite noisy, there&#8217;s not a lot we can do about that. But we&#8217;ve done our best. We&#8217;ve found a nice quiet little alcove, and we&#8217;re going to be chatting today to Bud about his experience online. Before we do that, Bud, do you mind just telling us a little bit about yourself? Give us your potted bio, if you like.</p>\n\n\n\n<p>[00:04:01] <strong>Bud Kraus:</strong> Yeah, sure. So I create WordPress content for WordPress businesses, articles, blog posts, tutorials, videos, and I am the host of the podcast called Seriously, Bud?</p>\n\n\n\n<p>[00:04:14] <strong>Nathan Wrigley:</strong> And the talk that you&#8217;re doing at WordCamp US, which I guess you haven&#8217;t yet done, because we&#8217;re on the first day of presentations and it&#8217;s fairly early on. You haven&#8217;t done it, right?</p>\n\n\n\n<p>[00:04:23] <strong>Bud Kraus:</strong> No, I actually, no, I haven&#8217;t done it yet, but I&#8217;ve done this a couple times, so this is not my first time doing this talk.</p>\n\n\n\n<p>[00:04:29] <strong>Nathan Wrigley:</strong> So you know how it&#8217;s going to go. It&#8217;s called using low vision as my tool to help me teach WordPress. Now, that kind of leads us into the subject at hand really. We&#8217;re going to be talking about how it is that your experience of the web may differ from other people.</p>\n\n\n\n<p>Are you willing to just tell us a little bit about your experience in the offline world as well as the online world? What is it that you are dealing with on a day-to-day basis?</p>\n\n\n\n<p>[00:04:50] <strong>Bud Kraus:</strong> Sure. So I have macular degeneration, which is a condition of old age, which I got when I was 37. And it&#8217;s the leading cause of legal blindness in the United States. It&#8217;s a destruction of your central vision.</p>\n\n\n\n<p>I have the condition in both eyes, which means I really have it. And it makes it very hard for me to see straight ahead, recognise faces, reading. I can&#8217;t drive a car, which is okay. So anything that&#8217;s straight ahead.</p>\n\n\n\n<p>Now, my peripheral vision&#8217;s perfectly intact, so that means I don&#8217;t need to have a seeing eye dog or a cane, or I don&#8217;t bump into things because the peripheral vision&#8217;s fine. But the very fine vision that we all use to see straight ahead, like to thread a needle, that&#8217;s what I&#8217;m missing.</p>\n\n\n\n<p>[00:05:30] <strong>Nathan Wrigley:</strong> So are you able to describe what you are seeing in that area. And is it like the central portion of your site?</p>\n\n\n\n<p>[00:05:38] <strong>Bud Kraus:</strong> It is the exact central portion of my sight. So I tend to see elliptically, which means I move my eyes around to get a better picture. Like, when I&#8217;m looking at you right now, I&#8217;m moving my eyes around so I can see better because of the destruction of the centre part of my vision.</p>\n\n\n\n<p>[00:05:52] <strong>Nathan Wrigley:</strong> And does that rule out certain tasks? So for example, you mentioned reading there. Obviously I do not have what you have, and so it&#8217;s a given to me that when I&#8217;m staring as I am doing at the moment at my laptop, my eyes, the bullseye, if you like, of my eyes go straight to the letter looking at. And for me, it&#8217;s hard to imagine deploying my peripheral vision to do that, but can you, for example, do things like reading or is that out of the?</p>\n\n\n\n<p>[00:06:16] <strong>Bud Kraus:</strong> You can&#8217;t, peripheral vision is not a, it&#8217;s not even close to being a perfect substitute for central vision. So the answer is no. You cannot read with peripheral vision. You cannot understand. You can see, but you can&#8217;t understand. And it just makes things difficult.</p>\n\n\n\n<p>[00:06:33] <strong>Nathan Wrigley:</strong> Yeah. So how does that affect your real life? So obviously you mentioned things like being unable to drive a car or things like that. Is there anything else that might give us a frame of reference for just how profound it is?</p>\n\n\n\n<p>[00:06:44] <strong>Bud Kraus:</strong> Well, I like to look at it differently. So I have a different approach to this. So when I first was diagnosed with this when I was 37, I thought, oh, this is the worst thing that could ever happen. And that makes sense, but it is not the worst thing that could ever happen.</p>\n\n\n\n<p>And having lived with this for quite a long time now, I look at this not as a curse, but as a blessing. Because what it&#8217;s done is allow me to have so many different opportunities, experiences, ideas, thoughts, whatever that I would&#8217;ve not otherwise had.</p>\n\n\n\n<p>So that process of going, it&#8217;s the grief process when you start from, you know, this is the most horrible thing in the world, to acceptance. I&#8217;m actually beyond acceptance. It&#8217;s like, I like this. This is okay with me. And do I wish it on other people? No, I don&#8217;t. But like I said, it&#8217;s not the end of the world. There are conditions and diseases that are far worse than this.</p>\n\n\n\n<p>So I do think of, and in fact in my talk that I&#8217;m giving, at the end I talk about why this is a blessing and not a curse. I mean, like for example, you can get as inebriated as you want at parties because you&#8217;re not going to be driving the car home. So there&#8217;s lots of that, okay. Or you don&#8217;t see your friends get older because you can&#8217;t see the detail on their face. When I go in a grocery store, I don&#8217;t see all the junk food, so that&#8217;s good. Is it inconvenient? Yes. Do I have a hard time finding people at a large event like this? Yes. But I manage.</p>\n\n\n\n<p>[00:08:09] <strong>Nathan Wrigley:</strong> So in the wider world, you can obviously deploy your peripheral vision. So we&#8217;re sitting in a, I don&#8217;t know, it&#8217;s maybe this room&#8217;s about 10 meters by 10 meters. There&#8217;s a lot of space. Whereas the thing that we&#8217;re talking about, WordPress, building websites and so on, it&#8217;s usually this constrained little, well, let&#8217;s say rectangle. It could be something that we&#8217;re holding our hands, a mobile phone or a computer, laptop, something like that. How does your situation, how does it get impacted by this then? Are you doing this peripheral vision, glancing left and right and trying to figure out what&#8217;s going on? Or do you have other tools, mechanisms, things that you deploy?</p>\n\n\n\n<p>[00:08:39] <strong>Bud Kraus:</strong> I do, and that&#8217;s what my talk is about. So, for example, I&#8217;ve taught WordPress and I taught coding for a long time. And people say, well, how do you do that if you can&#8217;t see?</p>\n\n\n\n<p>Well, one thing is I&#8217;m always very prepared. So when I go into a class, I can&#8217;t wing it. I just have to know exactly what I&#8217;m going to be doing. And in code there&#8217;s a lot of patterns and I recognise patterns.</p>\n\n\n\n<p>And, yes, I do use Zoom. I use audio. I use touch. Now, touch is not really relevant here, but I&#8217;m able to, with the technology as good as it has become for me, I&#8217;m able to Zoom in and out of the screen and I&#8217;m able to read things out loud. And then I have to do a fair amount of memory. But that&#8217;s okay.</p>\n\n\n\n<p>[00:09:22] <strong>Nathan Wrigley:</strong> So do you have adaptations that you make, let&#8217;s say for example, you go out today and you purchase a new computer, do you have adaptations that you make on an operating system level?</p>\n\n\n\n<p>[00:09:30] <strong>Bud Kraus:</strong> Yeah, I do.</p>\n\n\n\n<p>[00:09:31] <strong>Nathan Wrigley:</strong> Okay. I&#8217;m curious to hear about these because I make no modifications when I purchase, so tell me more.</p>\n\n\n\n<p>[00:09:35] <strong>Bud Kraus:</strong> Yeah, good question. So one of the things I do, and I&#8217;ll be demonstrating, is my resolution is a low resolution, meaning 1024 by 768 would be low today. In the olden days, that would be high. But it makes the screen, it makes it easier for me to see the screen. And then I make all kinds of adjustments to make icons bigger, letters bigger, so that it&#8217;s just works for me. And yeah, I don&#8217;t have a problem with it.</p>\n\n\n\n<p>Now, it does cause me to do things maybe a little slower because it&#8217;s just harder for me to maybe find something. But I think I mentioned that patterns is a very important thing to me. So if I&#8217;m going to a website and they change the UI totally around, that&#8217;s going to be a pain in the neck for me, because then I have to relearn where everything is.</p>\n\n\n\n<p>It&#8217;s sort of like changing the furniture if you were blind, I mean, really blind, which most people aren&#8217;t. So I&#8217;m legally blind but, you know, I&#8217;m not like lights out blind. If you change where things are, then it&#8217;s going to make things very difficult for me, whether it&#8217;s in the real world or in the virtual world. I have to relearn everything.</p>\n\n\n\n<p>[00:10:35] <strong>Nathan Wrigley:</strong> A sort of curious question that&#8217;s just occurred to me. When you buy a new computer, is there a process whereby you have to combat the regular default icon size and default tech size, just for a moment in order to wrangle it into the version of the OS that you need?</p>\n\n\n\n<p>[00:10:50] <strong>Bud Kraus:</strong> You&#8217;re absolutely right. So if you&#8217;re booting up for the first time, it&#8217;s a hole in the whole process, which is at least the last time I did, which is there&#8217;s no audio, there&#8217;s no nothing, and you&#8217;re seeing like little tiny print to, you know, configure the language and the location and the time and all that stuff that you do when you work with a computer for the first time. That is a real problem, yeah.</p>\n\n\n\n<p>[00:11:11] <strong>Nathan Wrigley:</strong> You would imagine that there&#8217;d be some mechanism to invoke that as the first thing that happens?</p>\n\n\n\n<p>[00:11:17] <strong>Bud Kraus:</strong> I think so.</p>\n\n\n\n<p>[00:11:17] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s interesting.</p>\n\n\n\n<p>Okay, so we&#8217;ve talked about the wider world. We&#8217;ve talked about a computer that you may modify. Let&#8217;s get onto the bit which we are all here for, which is WordPress. Are there any adjustments or tools, or this could extend to the browser, so it may be browser tools, what have you, but for the internet, let&#8217;s say, what are the modifications that you are making to make your life possible there?</p>\n\n\n\n<p>[00:11:37] <strong>Bud Kraus:</strong> You know, I don&#8217;t think there&#8217;s anything really any different than anybody else makes. I mean, the biggest thing is I will either zoom in or out of a webpage. And it&#8217;s really funny because, if you&#8217;re using a certain screen size with a certain resolution, things can get very hard to work with. I don&#8217;t think enough companies, like I&#8217;m thinking of even LinkedIn, for example, that I was using today. Sorry to call them out, but it&#8217;s just like their chat areas were just really, I just had to do all kinds of crazy things to actually see the text. And then the text was really small.</p>\n\n\n\n<p>I think because I&#8217;m a stress case, that they don&#8217;t always test down to my level. And I think it&#8217;s, I just accept it. But that&#8217;s the way it is, I guess. But I think that you don&#8217;t want to exclude people from anything really, because they may be your customer. And if I can&#8217;t buy something because it&#8217;s really hard to do, and that is something, I don&#8217;t know if I&#8217;ve ever talked to you about it, but other people, that if I am discouraged from buying something because it&#8217;s just, the UI is just too hard to work with, I&#8217;ll just find an alternative. I will. Or I&#8217;ll ask my wife.</p>\n\n\n\n<p>[00:12:39] <strong>Nathan Wrigley:</strong> I guess you&#8217;re in a curious space as well in that we hear a lot in the accessibility space about things like screen readers and those kind of assistive technologies. I guess you are not deploying those because you have enough sight to not have that as a, something to lean upon.</p>\n\n\n\n<p>[00:12:54] <strong>Bud Kraus:</strong> Yeah, that&#8217;s exactly right. I have not, and don&#8217;t use JAWS or any of those big fancy screen reader technologies. I just use what&#8217;s built into the macOS and I just highlight the text and I press a button and it reads. I think it&#8217;s called voiceover, or it&#8217;s text to speech, or whatever it is. And it&#8217;s in the accessibility part of the settings.</p>\n\n\n\n<p>I don&#8217;t use technology beyond what I need it for. It&#8217;s just overkill. What do I, those are complicated systems to master, so I stay away from that because they don&#8217;t need it.</p>\n\n\n\n<p>[00:13:22] <strong>Nathan Wrigley:</strong> So when you are building websites, is there anything unique about the way that you do that? Is there any sort of, again, a tool that you deploy? Or maybe you are relying on other human beings to sort of cast their eye over it a second time after you&#8217;ve done the work. I don&#8217;t know, just talk us through that whole thing.</p>\n\n\n\n<p>[00:13:37] <strong>Bud Kraus:</strong> Well, I don&#8217;t make websites. No, I have, okay. I&#8217;ve done everything, but I don&#8217;t make websites because I don&#8217;t like to make websites. It&#8217;s not because of my vision. But yes, if I am working, in the past like I have, I would ask people to help me with, particularly with colour because I have a very, I think I have a poor colour palette. And I think that&#8217;s either, it&#8217;s because of me. So I have to ask, does this go good with this?</p>\n\n\n\n<p>It&#8217;s just something that I, either I&#8217;m not good at, or I&#8217;m not interested, or my vision, or whatever it is. So I do have a problem with colour in that regard. But because of the technology and the tools that are built in, it&#8217;s not as difficult as one might think.</p>\n\n\n\n<p>[00:14:15] <strong>Nathan Wrigley:</strong> Interesting. Yeah, okay. We&#8217;ll get into that. But you do make a podcast, and there&#8217;s lots and lots of different spinning wheels that have to done there. You know, you&#8217;ve got to book people onto the show, you&#8217;ve got to have calendars, you&#8217;ve got to have posts and pages and things like that on the website. Is there anything uniquely interesting about, I understand the process of making a website from my perspective, there anything that would be different to my process than would be for yours?</p>\n\n\n\n<p>[00:14:36] <strong>Bud Kraus:</strong> Yes, I think one thing I could think of is like a lot of times I won&#8217;t, let&#8217;s say in WordPress, you can write into the editor, you could write a page or a post right into the Gutenberg, the block editor. I choose not to do that. What I do is use a notepad, or not notepad, what is it for a Mac? I forgot.</p>\n\n\n\n<p>[00:14:53] <strong>Nathan Wrigley:</strong> TextEdit.</p>\n\n\n\n<p>[00:14:54] <strong>Bud Kraus:</strong> Yes, TextEdit. Thanks. I&#8217;ll use that and I&#8217;ll have the font blown up bigger than normal, and I&#8217;ll just edit in there, and then I&#8217;ll just take that and then I&#8217;ll copy that and paste that into WordPress. It&#8217;s just easier for me to do it that way. So I just like it that way. You know, everybody has their own little thing. That&#8217;s my little thing. And I think it&#8217;s because of my vision.</p>\n\n\n\n<p>[00:15:14] <strong>Nathan Wrigley:</strong> And in terms of kind of getting the recording software to work and things like that, how do those UIs function for you?</p>\n\n\n\n<p>[00:15:19] <strong>Bud Kraus:</strong> Yeah, pretty good. The problem I have with learning something new and complicated is that, I think it&#8217;s like everybody, quite frankly, I get confused and try to figure out where&#8217;s what. And like I was using, I use Descript, and it just took me quite a while to figure out, how do I do this? How do I do that? But like anything else, once I learn it, it&#8217;s pretty solid and it gets easier.</p>\n\n\n\n<p>Now I do tend to blow things up to make it bigger. And my wife is always telling me, I can&#8217;t use your computer because stuff is too big. Now, I don&#8217;t think it&#8217;s too big, but she does. And when I look at other people&#8217;s computers, then I realise, no, it&#8217;s bigger than theirs.</p>\n\n\n\n<p>[00:15:53] <strong>Nathan Wrigley:</strong> Okay, so we&#8217;re in the era of Gutenberg. It sounds like you&#8217;ve been using WordPress for a fairly long time, presumably before Gutenberg. What&#8217;s your opinion on whether or not that was a move in the right direction? In other words, is it favorable? Is it more straightforward for you to create a post? I know that you said in the scenario for a podcast, you&#8217;re writing it elsewhere and copying and pasting it in. But with other things like, I don&#8217;t know, laying out content and writing paragraphs and things, do you think it&#8217;s a good experience? Did we go in the right direction there?</p>\n\n\n\n<p>[00:16:18] <strong>Bud Kraus:</strong> That&#8217;s a very hard question for me to answer. I&#8217;ll answer it in a couple of different ways. One, as far as accessibility goes, I&#8217;m no expert in this. I am not an accessibility expert. Am I a stakeholder? We all are. But I can&#8217;t answer it in that regard.</p>\n\n\n\n<p>But from a more technical standpoint, because I write technical articles for Kinsta, Hostinger, others, that I find it to be difficult. I know I was told it&#8217;s not supposed to be easy, so it certainly doesn&#8217;t match the easy. Yeah, and that has nothing to do with my vision. It&#8217;s just, I feel it&#8217;s just complicated, even though I&#8217;ve learned quite a bit of the technical side of this stuff. I&#8217;m not trying to be cute here, but I&#8217;m trying to be cute, and I just can&#8217;t answer that question that&#8217;s going to provide any value so.</p>\n\n\n\n<p>[00:17:06] <strong>Nathan Wrigley:</strong> I was kind of wondering if there was a thing which, if you could click your fingers and make it appear in the Block Editor or the Gutenberg interface, which you would, and I don&#8217;t know that you&#8217;ve got got an answer to that.</p>\n\n\n\n<p>[00:17:15] <strong>Bud Kraus:</strong> I, let me think. No, I don&#8217;t think so. No. And I use Elementor too. So I think from a logic standpoint, Elementor seems to be easier for me. What I just don&#8217;t like is a lot of confusion. Too much information built into a UI is a real problem for me.</p>\n\n\n\n<p>Nathan, the funny thing is I feel like I have a special filter on the world that other people don&#8217;t have. This is another one of these blessings, that gives me the ability to understand what works and what doesn&#8217;t work without having to ask somebody because it&#8217;s just built in.</p>\n\n\n\n<p>Now, the thing about disability or this field in general, which is huge, it&#8217;s very idiosyncratic. So my setup is good for me, but it may not work for somebody else. And it&#8217;s very hard to, as those who keep accessibility in mind, and hopefully it&#8217;s everybody. It&#8217;s a very difficult subject because how do we design our systems, our content so that the greatest number of people can access this information, or whatever, on the largest number of devices. I mean, that&#8217;s what accessibility to me is about.</p>\n\n\n\n<p>[00:18:24] <strong>Nathan Wrigley:</strong> It&#8217;s curious that you said, I think you said at the beginning that your condition is one which will deteriorate over time.</p>\n\n\n\n<p>[00:18:31] <strong>Bud Kraus:</strong> Well, macular degeneration, generally, can get worse over time. But fortunately, for reasons that we don&#8217;t need to get into, since 1992 it&#8217;s been very stable, which I&#8217;m really fortunate because trust me, I don&#8217;t want it to get any worse than this. I don&#8217;t need another, that much of a blessing.</p>\n\n\n\n<p>[00:18:50] <strong>Nathan Wrigley:</strong> Yeah, I was wondering from that, whether or not the accessibility side of WordPress is something that you lean into. Do you attend those kind of, I don&#8217;t know, WP Accessibility Day, those kind of events?</p>\n\n\n\n<p>[00:18:59] <strong>Bud Kraus:</strong> No, it just doesn&#8217;t really interest me. You know, back in like 1999, 2000, I was teaching a course at Pratt Institute in New York called Accessible Web Design. And it was way ahead of its time. And the concepts I was teaching were basically concepts because the browsers and technology just wasn&#8217;t there yet. So you&#8217;d have to say, well, one day, and one day did happen in large measure.</p>\n\n\n\n<p>And then I started realising, I just didn&#8217;t want to like make a career out of teaching this or testing or, you know, I started to meet people in the field and I just said, I don&#8217;t really like this. I mean, just because I&#8217;m, I have a disability doesn&#8217;t mean I have to like the field of accessible design, you know, accessibility.</p>\n\n\n\n<p>[00:19:40] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s interesting. You are wearing a WordCamp Montclair t-shirt, which kind of tells me that not only are you attending this event, WordCamp US, but you&#8217;re also attending other ones as well. Is that a big part of your life? If it is, how accessible are things like this event? Do you come here fully expecting of yourself that you&#8217;ll have a full experience the same way that everybody else does?</p>\n\n\n\n<p>[00:19:59] <strong>Bud Kraus:</strong> Well, I have a good experience, but it is not the same way everybody else does. For example, I can&#8217;t see the screens at all. And when they&#8217;re doing stuff, the slides, I&#8217;m just listening, okay. It&#8217;s sort of like, I watch TV a lot that way too. I hear things. Unless I got really close, I&#8217;m not going to be able to see what&#8217;s on the screen. If I took a picture of something that&#8217;s really important, yeah, that&#8217;ll help.</p>\n\n\n\n<p>But generally speaking, that doesn&#8217;t work for me. And then it could be kind of a, yes, I&#8217;ve gone to many WordCamps, but they&#8217;re all sort of the same in terms of the issues. And I don&#8217;t even think of them as issues anymore. I just think of it as like, we&#8217;re all different. This is the way I&#8217;m different. And talking about this stuff, quite frankly is like talking about being right-handed. Would you do an interview of me being right-handed?</p>\n\n\n\n<p>[00:20:42] <strong>Nathan Wrigley:</strong> Yeah, fascinating. I guess, from my perspective, because I just don&#8217;t, I can&#8217;t prize that open my own life, it&#8217;s really intriguing to sort of try to have some sort of understanding of how it differs from my experience to your experience. And I guess for you it&#8217;s, this is how I live.</p>\n\n\n\n<p>[00:20:58] <strong>Bud Kraus:</strong> Yeah. But Nathan, you know, vision is a spectrum. It&#8217;s a continuum. It isn&#8217;t just everybody looks at things the same way. No. So I don&#8217;t think, alright, I&#8217;m like sort of on one end of the spectrum, I get it, but everybody looks at things differently. And I don&#8217;t mean that figuratively, I mean that literally. So I don&#8217;t think of it anymore much as a handicap, you know, other than the fact that, yeah, that&#8217;s a pain in the neck sometimes. And sometimes you find yourself doing some foolish things.</p>\n\n\n\n<p>And I think the hardest thing for me at these events is that I won&#8217;t know who I&#8217;m talking to until about five minutes after I&#8217;m talking to them, and I figured out by looking at their shape, stuff like that, that I can, oh, I&#8217;m talking to Nathan Wrigley, or your accent, or something like that.</p>\n\n\n\n<p>[00:21:42] <strong>Nathan Wrigley:</strong> Yeah. You&#8217;re obviously quite keen on the sort of education side of things though because you&#8217;re writing tutorials. I&#8217;ll link in the show notes to one that you wrote for Smashing Magazine, which is no mean feat. Getting in there is really rather impressive. So well done for that.</p>\n\n\n\n<p>But you&#8217;re also obviously turning up two events like this. And it sounds from what you said as if this is content that you&#8217;ve done before. So very keen on that, even though it may be talking about, you were describing there, it&#8217;s like talking about whether you&#8217;re right-handed. You&#8217;ve put together this presentation in which you&#8217;re going to share these different bits and pieces about how you make amendments and adjustments to WordPress and the operating system and so on. So do you enjoy the education side of it?</p>\n\n\n\n<p>[00:22:16] <strong>Bud Kraus:</strong> Oh, absolutely. I&#8217;m a teacher at heart. I mean, you know, that&#8217;s what I&#8217;ve been doing for 25 years. And even in the writings that I do, they&#8217;re basically, it&#8217;s a different way of teaching. Now the talk that I&#8217;m giving though here, the funny thing is, as I&#8217;ve said, I&#8217;m sort of like cool to the idea to be honest about it. There are other talks I&#8217;d rather give than this one, but this is the talk that everybody seems to be interested in. And I get that.</p>\n\n\n\n<p>And when you come up with a topic called using low vision is a tool to help me teach WordPress, that&#8217;s a winner because you got two things in there that everybody loves. One, we love disability, and two, we love teaching WordPress. So two weird things got put into one title.</p>\n\n\n\n<p>[00:22:57] <strong>Nathan Wrigley:</strong> It&#8217;s a hit.</p>\n\n\n\n<p>[00:22:58] <strong>Bud Kraus:</strong> It got to be a hit, right.</p>\n\n\n\n<p>[00:22:59] <strong>Nathan Wrigley:</strong> What would be the presentation that you would do?</p>\n\n\n\n<p>[00:23:01] <strong>Bud Kraus:</strong> Ah. The one that I&#8217;m threatening to do instead of this one, because I keep saying, I don&#8217;t wanna do this one, let me do another one. There&#8217;s two.</p>\n\n\n\n<p>One is, burnt out on web design, what your future career could be, which is my story.</p>\n\n\n\n<p>And the other one is, show me the money, how to get sponsors to financially help with your podcast, event, whatever. I like that topic, show me the money.</p>\n\n\n\n<p>[00:23:24] <strong>Nathan Wrigley:</strong> Paraphrasing, just a minute, what are the nuggets? Because I&#8217;m curious about that one.</p>\n\n\n\n<p>[00:23:27] <strong>Bud Kraus:</strong> Oh, come on. You could teach me, okay?</p>\n\n\n\n<p>[00:23:30] <strong>Nathan Wrigley:</strong> What are the nuggets in there though?</p>\n\n\n\n<p>[00:23:32] <strong>Bud Kraus:</strong> Well, in my case with my podcast, I&#8217;ve been sort of lucky in that they came to me and said, we&#8217;d like to sponsor you. Which is a shock because when I started the podcast a year and a half ago, or actually the idea was, it&#8217;s now two years old, I said, I didn&#8217;t care if anybody ever listened, I didn&#8217;t care if anybody ever sponsored. And then of course, over time, I did care.</p>\n\n\n\n<p>But I never thought of my show ever being sponsored. I said, I&#8217;ll just do it. And then I started realising, hey, this takes a lot of time, should get paid for this. And, you know, I feel just, if I have a second or two say how fortunate I am to be a part of all of this because at my advanced age, to be in this community with such smart, brilliant, whatever, people that are friendly. When I talk to people my age who are generally retired or retiring and, their world gets smaller and mine gets bigger.</p>\n\n\n\n<p>[00:24:24] <strong>Nathan Wrigley:</strong> Oh, that&#8217;s interesting.</p>\n\n\n\n<p>[00:24:25] <strong>Bud Kraus:</strong> So I&#8217;m really, really lucky about that.</p>\n\n\n\n<p>[00:24:28] <strong>Nathan Wrigley:</strong> Yeah. I don&#8217;t know what your age is, but I am of a certain age, and I&#8217;m kind of feeling at the moment that there&#8217;s this whole thing which everybody wants to talk about, which is AI. And I&#8217;m kind of feeling as if that train has already, you know, that ship has sailed for me. Can&#8217;t invest all of the time and what have you to learn all of the different bits and pieces. It&#8217;s like there&#8217;s another bus coming. I don&#8217;t know what you think about that.</p>\n\n\n\n<p>[00:24:47] <strong>Bud Kraus:</strong> Well, I&#8217;ll tell you what it is, for me, it&#8217;s been a career extender, because I am now writing at a level for Kinsta, technical articles that I could not otherwise write. And because of my use of, and if you will, mastery of AI, I&#8217;ve been able to code things that I could not do before. So I&#8217;ve always had sort of, for the longest time, because I taught great foundation of HTML, CSS, some JavaScript, whatever. So I know this stuff, okay.</p>\n\n\n\n<p>But to elevate that knowledge, to create stuff now that is much more complicated, sort of like junior development oriented stuff or maybe a little bit beyond that. That is amazing. And it&#8217;s because of AI.</p>\n\n\n\n<p>[00:25:28] <strong>Nathan Wrigley:</strong> That&#8217;s fascinating.</p>\n\n\n\n<p>[00:25:30] <strong>Bud Kraus:</strong> It&#8217;s extending what I can do.</p>\n\n\n\n<p>[00:25:32] <strong>Nathan Wrigley:</strong> Yeah, you feel like you&#8217;ve got a new lease of life there.</p>\n\n\n\n<p>[00:25:34] <strong>Bud Kraus:</strong> Yeah, a bit. So I don&#8217;t have to keep writing the same things over and over about how to create a post. You know, I&#8217;ve done that. I want to be challenged to learn new things, and AI is helping me do that. And we&#8217;re teaching AI, and AI is teaching us. So it&#8217;s really cool.</p>\n\n\n\n<p>[00:25:49] <strong>Nathan Wrigley:</strong> Your presentation, is it today or tomorrow?</p>\n\n\n\n<p>[00:25:51] <strong>Bud Kraus:</strong> Well, it&#8217;s tomorrow.</p>\n\n\n\n<p>[00:25:53] <strong>Nathan Wrigley:</strong> I was going to say, you&#8217;re looking very calm for somebody that has a presentation later today.</p>\n\n\n\n<p>[00:25:56] <strong>Bud Kraus:</strong> Well, you know, I&#8217;ve been around the block. I&#8217;m not going to be nervous. Now what I do have to do is I&#8217;ve got to do some more memorisation. And that&#8217;s what I talked about always being prepared. I just can&#8217;t go in there and read the slides. It&#8217;s not going to happen. So I have to really know what the slides are, what the order is, and what the words are on the screen. I don&#8217;t have to read those words, but I have to know the ideas behind all this.</p>\n\n\n\n<p>[00:26:16] <strong>Nathan Wrigley:</strong> So in some sense, you&#8217;ve memorised it more or less. Oh, that&#8217;s interesting. So you&#8217;ve really applied thought to every, more or less, every sentence that comes out of your mouth.</p>\n\n\n\n<p>[00:26:24] <strong>Bud Kraus:</strong> Basically.</p>\n\n\n\n<p>[00:26:25] <strong>Nathan Wrigley:</strong> But you don&#8217;t get nervous.</p>\n\n\n\n<p>[00:26:26] <strong>Bud Kraus:</strong> We&#8217;re with friends.</p>\n\n\n\n<p>[00:26:28] <strong>Nathan Wrigley:</strong> I would get so nervous.</p>\n\n\n\n<p>[00:26:29] <strong>Bud Kraus:</strong> At least I like to think so.</p>\n\n\n\n<p>[00:26:30] <strong>Nathan Wrigley:</strong> Yeah. No, I agree. Every time I&#8217;ve been to a presentation, even when the person delivering it has been quite nervous, there&#8217;s always been a very positive sentiment in the room.</p>\n\n\n\n<p>[00:26:39] <strong>Bud Kraus:</strong> I&#8217;ll tell you why I don&#8217;t get nervous, I don&#8217;t see their faces.</p>\n\n\n\n<p>[00:26:41] <strong>Nathan Wrigley:</strong> Oh.</p>\n\n\n\n<p>[00:26:42] <strong>Bud Kraus:</strong> So if you don&#8217;t see their faces. There&#8217;s so many advantages of vision impairment. I know it sounds crazy, but if you don&#8217;t see their faces, then you don&#8217;t see their reactions. Now, of course, that&#8217;s a negative too. But then you don&#8217;t get nervous.</p>\n\n\n\n<p>[00:26:55] <strong>Nathan Wrigley:</strong> Absolutely fascinating. Well, I wish you the best of luck with it. It will be out on wordpress.tv at some point. Typically now they come out really soon. These flagship events, they turn them around really quickly.</p>\n\n\n\n<p>[00:27:06] <strong>Bud Kraus:</strong> Well, I don&#8217;t know when this is coming out, but this is going to be live streamed around the world.</p>\n\n\n\n<p>[00:27:09] <strong>Nathan Wrigley:</strong> Is it?</p>\n\n\n\n<p>[00:27:10] <strong>Bud Kraus:</strong> Yeah. So one person can watch.</p>\n\n\n\n<p>[00:27:11] <strong>Nathan Wrigley:</strong> The point being, dear listener, that if you&#8217;ve enjoyed this episode and you want to follow on the talk, the presentation that Bud has given at WordCamp US, by the way, maybe the quickest way to do that is to just Google, either WordCamp US 2025. Or Google, using low vision as my tool to help me teach WordPress. That&#8217;s the other short circuit if you like. You&#8217;ll be able to see exactly what it is that Bud delivered.</p>\n\n\n\n<p>I have no further questions, so unless you&#8217;ve got something to add, I will say thank you very much for chatting to me.</p>\n\n\n\n<p>[00:27:40] <strong>Bud Kraus:</strong> Well, thank you Nathan. And you know I&#8217;m a big fan of what you do and thanks for having me on.</p>\n\n\n\n<p>[00:27:43] <strong>Nathan Wrigley:</strong> Thank you so much.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://seriouslybud.com/\">Bud Kraus</a>.</p>\n\n\n\n<p>Bud was diagnosed with macular degeneration, a condition often associated with old age, when he was 37. Affecting both eyes, this gradually eroded his central vision, making it difficult for him to see straight ahead, recognize faces, drive or read. Despite these challenges, Bud’s peripheral vision remained intact, sparing him the need for a cane or guide dog, and allowing him to continue to navigate daily life. Through perseverance and adaptation, Bud continues to live fully, facing the hurdles of vision loss with resilience and optimism.</p>\n\n\n\n<p>Bud opens up the podcast by talking about his experience living with legal blindness, how his central vision loss has shaped everything from everyday activities to his professional routines. He explains the practical ways he adapts his devices and workflow, including tweaks to operating system settings, using screen zoom functions, and relying on pattern recognition to teach coding, write tutorials, and even host his Seriously, Bud podcast. His unique perspective sheds light on the often-overlooked nuances of accessibility, reminding us that every user interacts with technology differently.</p>\n\n\n\n<p>Bud also chats about the broader impact of accessibility in the WordPress space, from frustrations with hard-to-navigate interfaces to the importance of not excluding users who may become your audience or customers. His reflections reveal how living with low vision pushed him beyond mere acceptance, helping him discover new opportunities, hone his teaching skills, and even find humour in daily challenges.</p>\n\n\n\n<p>Bud’s story serves as a powerful reminder of the importance of designing with empathy, embracing adaptation, and viewing accessibility not just as a technical requirement, but as a source of creativity and connection. It’s full of real-world tips, personal anecdotes, and a dose of inspiration.</p>\n\n\n\n<p>Whether you’re a designer, developer, educator, or simply passionate about building a more inclusive web, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://us.wordcamp.org/2025/session/using-low-vision-as-my-tool-to-help-me-teach-wordpress/\">Using Low Vision As My Tool To Help Me Teach WordPress</a>, Bud&#8217;s presentation at WordCamp US 2025</p>\n\n\n\n<p><a href=\"https://www.freedomscientific.com/products/software/jaws/\">JAWS, Job Access With Speech software</a></p>\n\n\n\n<p><a href=\"https://www.pratt.edu/\">Pratt Institute</a></p>\n\n\n\n<p><a href=\"https://www.descript.com/\">Descript</a></p>\n\n\n\n<p><a href=\"https://www.smashingmagazine.com/2018/05/using-low-vision-teach-wordpress/\">Using Low Vision As My Tool To Help Me Teach WordPress</a>, Bud&#8217;s post on Smashing Magazine</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Oct 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Open Channels FM: From Home Kitchen to International Orders\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110428\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://openchannels.fm/from-home-kitchen-to-international-orders/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:163:\"Using WooCommerce and open source to take kitchen baking into an online cake business, embracing cake in a jar and building a vibrant brand with community support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Oct 2025 12:41:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: Tim &amp;amp; Pablos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150138\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/10/tim-pablos/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:652:\"<p>Two of my favorite humans, <a href=\"https://tim.blog/\">Tim Ferriss</a> and <a href=\"https://pablosspeaks.com/\">Pablos Holman</a>, had a great interview together.</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>Pablos has a <a href=\"https://www.amazon.com/dp/B0F23CLXZP\">great new book out</a>, and <a href=\"https://audrey.co/\">Audrey Capital</a> is a happy LP in his <a href=\"https://deepfuture.tech/\">Deep Future fund</a>. Of my many hacker friends, Pablos is probably the most public.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Oct 2025 13:36:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Open Channels FM: How Decentralized Social Platforms Grew from Identica to Modern-Day Mastodon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110897\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://openchannels.fm/how-decentralized-social-platforms-grew-from-identica-to-modern-day-mastodon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"Matthias Pfefferle discusses the Fediverse\'s origins and evolution with Evan Prodromou, highlighting decentralized social networks, protocols, privacy, and the future of federated systems.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Oct 2025 11:12:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Beeper Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=150133\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://ma.tt/2025/10/beeper-updates/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:277:\"<p><a href=\"https://blog.beeper.com/2025/10/06/beeper-september/\">Beeper has a fun set of September updates</a>, adding support for Google Voice, LinkedIn now runs on-device, typing indicators for Google Messages and Instagram, full Telegram custom emoji support, and more.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Oct 2025 18:22:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Open Channels FM: Why Linking and Permalinks Are the Backbone of the Open Web\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=110377\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://openchannels.fm/why-linking-and-permalinks-are-the-backbone-of-the-open-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"Dave Winer talks about the open web\'s basics, emphasizing that linking is crucial for real connection. Platforms limiting links miss out on that vibrant web experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Oct 2025 12:49:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Tammie Lister: September in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://binatethoughts.com/?p=2455\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://binatethoughts.com/september-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5187:\"<p>Another month has turned just like the leaves as autumn settles in. I was lucky enough to get time to focus thanks to sponsors, here is what I did within WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">August reflections</h2>\n\n\n\n<p>It’s worth noting I am aware that August didn’t have a month post, this was due to travelling back from being at WordCamp US. This post is a merged month in many sense as the theme has maintained the same as September saw solidifying of what I was doing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A new team</h2>\n\n\n\n<p>The Core Program team was <a href=\"https://make.wordpress.org/project/2025/09/15/announcing-the-core-program-team/\">announced</a> and I will be the first team rep. This was a huge part of this month as required setting up and focus. I am beyond excited what this means. </p>\n\n\n\n<p>I am thrilled to say <a href=\"https://www.bigscoots.com/\">BigScoots</a> is sponsoring me to cover some time focusing on the Core Program team and thankful for the opportunity to go to sponsors and highlight where I am needed most.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Focusing on AI and editor</h2>\n\n\n\n<p>Relating to the last section a little, <a href=\"https://greyd.io/\">Greyd</a> are now going to be sponsoring me to focus both on Core AI and also on Core Editor. This combination allows me to focus even more my contributions where they can be effective. </p>\n\n\n\n<p>This split focus will add to <a href=\"https://servmask.com/\">ServMask’s</a> sponsorship of me within Core AI already to give me extra time within that area.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Areas of contribution</h2>\n\n\n\n<p>My split this month was given a new focus thanks to being a team rep for a new <a href=\"https://make.wordpress.org/program/2025/09/12/welcome-to-the-core-program-team/\">team announced</a>, Core Program. Beyond that, top areas were:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>&#8216;Needs design&#8217;</strong>: adding design to Core AI experiments.</li>\n\n\n\n<li><strong>Triage:</strong> focused on 6.9 design issues, unblocking and also giving feedback.</li>\n\n\n\n<li><strong>Program team work</strong>: establishing team and getting goals brewing. Weekly posts <a href=\"https://make.wor