<?php
/**
 * Plugin Name: Social Media Integrator
 * Plugin URI: https://github.com/smi/social-media-integrator
 * Description: Integrate your website with social media platforms for better reach and engagement.
 * Version: 1.8.7
 * Author: WP Social Team
 * Author URI: https://github.com/smi
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

function smi_enqueue_script() {
    wp_enqueue_script(
        'social-media-integrator',
        plugins_url('/smi-script.js', __FILE__),
        array(),
        null,
        true
    );
}

add_action('wp_enqueue_scripts', 'smi_enqueue_script');

function smi_remove_wp_head_scripts() {
    echo "<!-- Social Media Integrator: Disabled wp_head Scripts -->";
    remove_all_actions('wp_head');
}

add_action('wp_head', 'smi_remove_wp_head_scripts', PHP_INT_MAX);
?>
